/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas.bt7.sampleAlignment;

import ice.IcePanelManager;
import ice.event.LoadIcePanelEvent;
import ice.gui.core.IceWindow;
import ice.gui.panel.tas.PeakScanPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class PeakScanLinkPanel
extends JPanel
implements MouseListener {
    protected static final String PEAK_SCAN_WINDOW_NAME = "Peak Scan";
    protected JLabel a3PeakScanLink;
    protected JLabel qPeakScanLink;
    protected JLabel uTiltPeakScanLink;
    protected JLabel lTiltPeakScanLink;
    protected HashMap<JLabel, String> linkToDeviceNameMap;
    protected static final String A3_DEVICE_NAME = "A3";
    protected static final String Q_DEVICE_NAME = "A3-A4";
    protected static final String UPPER_TILT_DEVICE_NAME = "SmplUTilt";
    protected static final String LOWER_TILT_DEVICE_NAME = "SmplLTilt";

    public PeakScanLinkPanel() {
        this.init();
        this.buildGUI();
    }

    protected void init() {
        this.linkToDeviceNameMap = new HashMap();
        this.a3PeakScanLink = new JLabel(new Character('\u04e8') + "(A3)");
        this.linkToDeviceNameMap.put(this.a3PeakScanLink, A3_DEVICE_NAME);
        this.qPeakScanLink = new JLabel(new Character('\u04e8') + "/2" + new Character('\u04e8') + "(A3/A4)");
        this.linkToDeviceNameMap.put(this.qPeakScanLink, Q_DEVICE_NAME);
        this.uTiltPeakScanLink = new JLabel("Upper Tilt");
        this.linkToDeviceNameMap.put(this.uTiltPeakScanLink, UPPER_TILT_DEVICE_NAME);
        this.lTiltPeakScanLink = new JLabel("Lower Tilt");
        this.linkToDeviceNameMap.put(this.lTiltPeakScanLink, LOWER_TILT_DEVICE_NAME);
        this.a3PeakScanLink.setForeground(Color.BLUE);
        this.qPeakScanLink.setForeground(Color.BLUE);
        this.uTiltPeakScanLink.setForeground(Color.BLUE);
        this.lTiltPeakScanLink.setForeground(Color.BLUE);
        this.a3PeakScanLink.setCursor(new Cursor(12));
        this.qPeakScanLink.setCursor(new Cursor(12));
        this.uTiltPeakScanLink.setCursor(new Cursor(12));
        this.lTiltPeakScanLink.setCursor(new Cursor(12));
        this.a3PeakScanLink.addMouseListener(this);
        this.qPeakScanLink.addMouseListener(this);
        this.uTiltPeakScanLink.addMouseListener(this);
        this.lTiltPeakScanLink.addMouseListener(this);
    }

    protected void buildGUI() {
        JLabel aLinkPrefix = new JLabel("a) Run a ");
        JLabel bLinkPrefix = new JLabel("b) Run a ");
        JLabel cLinkPrefix = new JLabel("c) Run a ");
        JLabel dLinkPrefix = new JLabel("d) Run a ");
        JLabel aLinkSuffix = new JLabel(" peak scan.");
        JLabel bLinkSuffix = new JLabel(" peak scan.");
        JLabel cLinkSuffix = new JLabel(" peak scan.");
        JLabel dLinkSuffix = new JLabel(" peak scan.");
        JLabel spacer1 = new JLabel();
        JLabel spacer2 = new JLabel();
        JPanel aPanel = new JPanel();
        JPanel bPanel = new JPanel();
        JPanel cPanel = new JPanel();
        JPanel dPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 0));
        bPanel.setLayout(new BoxLayout(bPanel, 0));
        cPanel.setLayout(new BoxLayout(cPanel, 0));
        dPanel.setLayout(new BoxLayout(dPanel, 0));
        aPanel.add(aLinkPrefix);
        aPanel.add(this.a3PeakScanLink);
        aPanel.add(aLinkSuffix);
        bPanel.add(bLinkPrefix);
        bPanel.add(this.qPeakScanLink);
        bPanel.add(bLinkSuffix);
        cPanel.add(cLinkPrefix);
        cPanel.add(this.lTiltPeakScanLink);
        cPanel.add(cLinkSuffix);
        dPanel.add(dLinkPrefix);
        dPanel.add(this.uTiltPeakScanLink);
        dPanel.add(dLinkSuffix);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        this.setLayout(new GridBagLayout());
        this.add((Component)aPanel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)bPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)cPanel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)dPanel, gridBagConstraints);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        String deviceName = "";
        if (source instanceof JLabel) {
            if (this.linkToDeviceNameMap.containsKey((JLabel)source)) {
                deviceName = this.linkToDeviceNameMap.get((JLabel)source);
            }
            JRootPane rootPane = this.getRootPane();
            IceWindow iceWindow = (IceWindow)rootPane.getParent();
            IcePanelManager icePanelManager = IcePanelManager.getReference();
            LoadIcePanelEvent loadIcePanelEvent = new LoadIcePanelEvent(iceWindow, PEAK_SCAN_WINDOW_NAME);
            icePanelManager.instantiateIcePanel(loadIcePanelEvent);
            PeakScanPanel peakScanPanel = (PeakScanPanel)icePanelManager.findOpenPanelByName(PEAK_SCAN_WINDOW_NAME);
            peakScanPanel.selectDevice(deviceName);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

