/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas;

import ice.Controller;
import ice.Global;
import ice.data.InstalledDevice;
import ice.event.LoadPeakScanEvent;
import ice.event.LoadPeakScanListener;
import ice.event.SampleAlignmentModeSwitchEvent;
import ice.event.SampleAlignmentModeSwitchListener;
import ice.event.SamplePropertyChangedEvent;
import ice.event.SamplePropertyChangedListener;
import ice.event.communication.AngleCalcEvent;
import ice.event.communication.AngleCalcListener;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.exceptions.IcePanelException;
import ice.gui.tas.BaseSampleAlignmentPanel;
import ice.gui.tas.bt7.sampleAlignment.PeakScanLinkPanel;
import ice.gui.tas.bt7.sampleAlignment.ubMatrix.OrientationPanel;
import ice.swing.Bag;
import ice.swing.DeviceValueLabel;
import ice.util.I18N;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public abstract class TASBaseSampleAlignmentPanel
extends BaseSampleAlignmentPanel
implements ChangeListener,
AngleCalcListener,
ActionListener,
SamplePropertyChangedListener {
    protected static Logger logger = Logger.getLogger("WidgetLogger.AlignLogger");
    protected static final int fieldLength = 5;
    protected InstalledDevice initialEnergy;
    protected InstalledDevice finalEnergy;
    protected InstalledDevice A3;
    protected InstalledDevice A4;
    protected JTextField energyTargetField;
    protected JTextField energyJogField;
    protected JTextField a3TargetField;
    protected JTextField a3JogField;
    protected ICEListenerList<SampleAlignmentModeSwitchListener, SampleAlignmentModeSwitchEvent> modeListeners;
    private ICEListenerList<LoadPeakScanListener, LoadPeakScanEvent> loadPeakScanListeners;
    protected JTextField h1Field;
    protected JTextField k1Field;
    protected JTextField l1Field;
    protected JTextField h2Field;
    protected JTextField k2Field;
    protected JTextField l2Field;
    protected JButton hklApplyBtn;
    protected JButton hklResetBtn;
    protected JTextField targetHField;
    protected JTextField targetKField;
    protected JTextField targetLField;
    protected AngleCalculator ac;
    protected JButton driveA4Btn;
    protected JButton driveQBtn;
    protected JLabel calculatedA4Label;
    protected JLabel calculatedA3Label;
    protected DriveA4Action driveA4Action;
    protected DriveQAction driveQAction;
    protected UpdateSampleFields usf;
    protected Vector<Component> tabOrder;
    private Controller controller;

    protected void buildBT7BaseSampleAlignmentPanel() {
        this.h1Field = new JTextField(5);
        this.k1Field = new JTextField(5);
        this.l1Field = new JTextField(5);
        this.h2Field = new JTextField(5);
        this.k2Field = new JTextField(5);
        this.l2Field = new JTextField(5);
        this.hklApplyBtn = new JButton(new PlaneApplyAction());
        this.hklResetBtn = new JButton(new PlaneResetAction());
        this.targetHField = new JTextField(5);
        this.targetKField = new JTextField(5);
        this.targetLField = new JTextField(5);
        this.driveA4Btn = new JButton(this.driveA4Action);
        this.driveQBtn = new JButton(this.driveQAction);
        this.calculatedA4Label = new JLabel("N/A");
        this.calculatedA3Label = new JLabel("N/A");
        this.usf = new UpdateSampleFields();
        this.tabOrder = new Vector();
        this.ac = new AngleCalculator();
        this.targetHField.getDocument().addDocumentListener(this.ac);
        this.targetKField.getDocument().addDocumentListener(this.ac);
        this.targetLField.getDocument().addDocumentListener(this.ac);
        DeviceListener dl = new DeviceListener();
        if (this.initialEnergy != null) {
            try {
                this.initialEnergy.addValueChangeListener(dl);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("TASBaseSampleAlignment.buildBT7BaseSampleAlignmentPanel " + e);
            }
        }
        if (this.finalEnergy != null) {
            try {
                this.finalEnergy.addValueChangeListener(dl);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("TASBaseSampleAlignment.buildBT7BaseSampleAlignmentPanel " + e);
            }
        }
    }

    protected void initBT7BaseSampleAlignmentPanel() {
        this.controller = Controller.getReference();
        this.sample = this.controller.getSample();
        this.initialEnergy = this.controller.getFirstDevice("Ei");
        this.finalEnergy = this.controller.getFirstDevice("Ef");
        this.A3 = this.controller.getFirstDevice("A3");
        this.A4 = this.controller.getFirstDevice("A4");
        this.sendManager = this.controller.getSendManager();
        this.driveA4Action = new DriveA4Action();
        this.driveQAction = new DriveQAction();
        try {
            this.sample.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("TASBaseSampleAlignmentPanel.initBT7BaseSampleAlighmentPanel can't add listener " + e);
        }
        this.energyTargetField = this.initialEnergy == null ? new JTextField("N/A") : new JTextField(this.initialEnergy.getCurrValue());
        this.energyJogField = new JTextField("0.1");
        this.a3TargetField = this.A3 == null ? new JTextField("N/A") : new JTextField(this.A3.getCurrValue());
        this.a3JogField = new JTextField("0.1");
        this.modeListeners = new ICEListenerList();
        this.loadPeakScanListeners = new ICEListenerList();
    }

    public boolean addModeListener(SampleAlignmentModeSwitchListener samsl) {
        boolean returnValue = true;
        try {
            this.modeListeners.addListener(samsl);
        }
        catch (ICEListenerListExceptionBase e) {
            returnValue = false;
        }
        return returnValue;
    }

    public boolean removeModeListener(SampleAlignmentModeSwitchListener samsl) {
        return this.modeListeners.removeListener(samsl);
    }

    protected JPanel createSetupPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        OrientationPanel orientationPanel = new OrientationPanel();
        panel.add((Component)orientationPanel, constraints.cell(x, y).fillx());
        this.createLatticePanel();
        panel.add((Component)this.createPlanePanel(), constraints.cell(x, ++y).fillx());
        return panel;
    }

    protected JPanel createLatticePanel() {
        JLabel instructionsLabel = new JLabel("<html>Input the lattice constants and angles that describe the structure of the <br>crystal lattice for your sample.  Approximate lattice spacings can be <br>entered and later refined after scanning 2" + new Character('\u04e8') + ".  For reference: " + new Character('\u03b1') + " is the angle <br>between a and b, " + new Character('\u03b2') + " is " + "the angle between b and c, and " + new Character('\u03b3') + " is the angle <br>between c and a.</html>");
        JLabel aLabel = new JLabel("a:");
        JLabel bLabel = new JLabel("b:");
        JLabel cLabel = new JLabel("c:");
        JLabel aUnitLabel = new JLabel(Global.degreeSign());
        JLabel bUnitLabel = new JLabel(Global.degreeSign());
        JLabel cUnitLabel = new JLabel(Global.degreeSign());
        JLabel alphaLabel = new JLabel(new Character('\u03b1') + ":");
        JLabel betaLabel = new JLabel(new Character('\u03b2') + ":");
        JLabel gammaLabel = new JLabel(new Character('\u03b3') + ":");
        JLabel alphaUnitLabel = new JLabel(Global.degreeSign());
        JLabel betaUnitLabel = new JLabel(Global.degreeSign());
        JLabel gammaUnitLabel = new JLabel(Global.degreeSign());
        JPanel panel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        int maxCols = 11;
        Insets insets = constraints.insets;
        Insets unitInsets = new Insets(insets.top, 0, insets.bottom, insets.right * 2);
        Insets labelInsets = new Insets(insets.top, insets.left, insets.bottom, 0);
        Insets fieldInsets = new Insets(insets.top, 0, insets.bottom, 0);
        Insets btnInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right * 2);
        panel.add((Component)instructionsLabel, constraints.cell(x, y).colspan(maxCols));
        panel.add((Component)new JLabel(""), constraints.cell(x, ++y));
        panel.add((Component)aLabel, constraints.cell(++x, y).inset(labelInsets));
        panel.add((Component)this.aField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)aUnitLabel, constraints.cell(++x, y).inset(unitInsets));
        panel.add((Component)bLabel, constraints.cell(++x, y).inset(labelInsets));
        panel.add((Component)this.bField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)bUnitLabel, constraints.cell(++x, y).inset(unitInsets));
        panel.add((Component)cLabel, constraints.cell(++x, y).inset(labelInsets));
        panel.add((Component)this.cField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)cUnitLabel, constraints.cell(++x, y).inset(unitInsets));
        x = 0;
        panel.add((Component)new JLabel(""), constraints.cell(x, ++y));
        x = 1;
        panel.add((Component)alphaLabel, constraints.cell(x, ++y).inset(labelInsets));
        panel.add((Component)this.alphaField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)alphaUnitLabel, constraints.cell(++x, y).inset(unitInsets));
        panel.add((Component)betaLabel, constraints.cell(++x, y).inset(labelInsets));
        panel.add((Component)this.betaField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)betaUnitLabel, constraints.cell(++x, y).inset(unitInsets));
        panel.add((Component)gammaLabel, constraints.cell(++x, y).inset(labelInsets));
        panel.add((Component)this.gammaField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)gammaUnitLabel, constraints.cell(++x, y).inset(unitInsets));
        panel.add((Component)new JLabel(""), constraints.cell(x, ++y));
        x = maxCols - 1;
        y -= 3;
        x = maxCols - 2;
        panel.add((Component)new JLabel(""), constraints.cell(x, ++y).fillx());
        this.tabOrder.add(this.aField);
        this.tabOrder.add(this.bField);
        this.tabOrder.add(this.cField);
        this.tabOrder.add(this.alphaField);
        this.tabOrder.add(this.betaField);
        this.tabOrder.add(this.gammaField);
        this.tabOrder.add(this.h1Field);
        MyFocusTraversalPolicy focusPolicy = new MyFocusTraversalPolicy(this.tabOrder);
        panel.setFocusTraversalPolicy(focusPolicy);
        panel.setFocusCycleRoot(true);
        return panel;
    }

    protected JPanel createPlanePanel() {
        JLabel instructionsLabel = new JLabel("<html>Enter two non-colinear reciprocal lattice vectors to define the scattering <br>plane.</html>");
        JLabel h1Label = new JLabel("h1:");
        JLabel k1Label = new JLabel("k1:");
        JLabel l1Label = new JLabel("l1:");
        JLabel h2Label = new JLabel("h2:");
        JLabel k2Label = new JLabel("k2:");
        JLabel l2Label = new JLabel("l2:");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Scattering Plane Definitions"));
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        int maxCols = 9;
        Insets insets = constraints.insets;
        Insets labelInsets = new Insets(insets.top, insets.left, insets.bottom, 0);
        Insets btnInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right * 2);
        panel.add((Component)instructionsLabel, constraints.cell(x, y).colspan(maxCols));
        panel.add((Component)h1Label, constraints.cell(++x, ++y).inset(labelInsets));
        panel.add((Component)this.h1Field, constraints.cell(++x, y));
        panel.add((Component)k1Label, constraints.cell(++x, y));
        panel.add((Component)this.k1Field, constraints.cell(++x, y));
        panel.add((Component)l1Label, constraints.cell(++x, y));
        panel.add((Component)this.l1Field, constraints.cell(++x, y));
        x = 0;
        panel.add((Component)new JLabel(""), constraints.cell(x, ++y));
        x = 1;
        panel.add((Component)h2Label, constraints.cell(x, ++y).inset(labelInsets));
        panel.add((Component)this.h2Field, constraints.cell(++x, y));
        panel.add((Component)k2Label, constraints.cell(++x, y));
        panel.add((Component)this.k2Field, constraints.cell(++x, y));
        panel.add((Component)l2Label, constraints.cell(++x, y));
        panel.add((Component)this.l2Field, constraints.cell(++x, y));
        x = 0;
        panel.add((Component)new JLabel(""), constraints.cell(x, ++y));
        x = maxCols - 1;
        panel.add((Component)this.hklApplyBtn, constraints.cell(x, y -= 3).rowspan(2).inset(btnInsets));
        panel.add((Component)this.hklResetBtn, constraints.cell(x, ++y).rowspan(2));
        x = maxCols - 2;
        panel.add((Component)new JLabel(""), constraints.cell(x, y).fillx());
        this.tabOrder.add(this.k1Field);
        this.tabOrder.add(this.l1Field);
        this.tabOrder.add(this.h2Field);
        this.tabOrder.add(this.k2Field);
        this.tabOrder.add(this.l2Field);
        this.tabOrder.add(this.hklApplyBtn);
        this.tabOrder.add(this.hklResetBtn);
        this.tabOrder.add(this.energyTargetField);
        MyFocusTraversalPolicy focusPolicy = new MyFocusTraversalPolicy(this.tabOrder);
        panel.setFocusTraversalPolicy(focusPolicy);
        panel.setFocusCycleRoot(true);
        return panel;
    }

    protected JPanel createCalcPanelRow() {
        JLabel a4Label = new JLabel("2" + new Character('\u04e8') + "(A4):");
        JLabel a3Label = new JLabel(new Character('\u04e8') + "(A3):");
        JPanel calcPanel = new JPanel(new GridBagLayout());
        calcPanel.setBorder(BorderFactory.createTitledBorder("Calculated Angular Alignment Position"));
        calcPanel.setLayout(new BoxLayout(calcPanel, 0));
        calcPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        calcPanel.add(a4Label);
        calcPanel.add(this.calculatedA4Label);
        calcPanel.add(Box.createRigidArea(new Dimension(90, 0)));
        calcPanel.add(a3Label);
        calcPanel.add(this.calculatedA3Label);
        calcPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        JPanel panel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        panel.add((Component)new JLabel(""), constraints.cell(x, y).fillx());
        panel.add((Component)calcPanel, constraints.cell(++x, y));
        return panel;
    }

    protected PeakScanLinkPanel createLinkPanel() {
        PeakScanLinkPanel pslp = new PeakScanLinkPanel();
        this.addMouseListener(pslp);
        return new PeakScanLinkPanel();
    }

    protected JPanel createMovePanel() {
        JButton energyGoBtn = new JButton(I18N.getString("goMessage"));
        JButton energyMinusBtn = new JButton(I18N.getString("minus"));
        JButton energyPlusBtn = new JButton(I18N.getString("plus"));
        JButton a3GoBtn = new JButton(I18N.getString("goMessage"));
        JButton a3MinusBtn = new JButton(I18N.getString("minus"));
        JButton a3PlusBtn = new JButton(I18N.getString("plus"));
        if (this.initialEnergy == null) {
            this.energyTargetField.setEditable(false);
            this.energyJogField.setEditable(false);
            energyGoBtn.setEnabled(false);
            energyMinusBtn.setEnabled(false);
            energyPlusBtn.setEnabled(false);
        }
        if (this.A3 == null) {
            this.a3TargetField.setEditable(false);
            this.a3JogField.setEditable(false);
            a3GoBtn.setEnabled(false);
            a3MinusBtn.setEnabled(false);
            a3PlusBtn.setEnabled(false);
        }
        energyGoBtn.setActionCommand("energyGo");
        energyMinusBtn.setActionCommand("energyMinus");
        energyPlusBtn.setActionCommand("energyPlus");
        energyGoBtn.addActionListener(this);
        energyMinusBtn.addActionListener(this);
        energyPlusBtn.addActionListener(this);
        a3GoBtn.setActionCommand("a3Go");
        a3MinusBtn.setActionCommand("a3Minus");
        a3PlusBtn.setActionCommand("a3Plus");
        a3GoBtn.addActionListener(this);
        a3MinusBtn.addActionListener(this);
        a3PlusBtn.addActionListener(this);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("Move Devices"));
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        int maxRows = 3;
        int maxCols = 10;
        panel.add((Component)new JLabel("Device"), constraints.cell(x, y));
        panel.add((Component)new JLabel(""), constraints.cell(++x, y).fillx());
        panel.add((Component)new JLabel("Current\nPosition"), constraints.cell(++x, y));
        panel.add((Component)new JLabel(""), constraints.cell(++x, y).fillx());
        panel.add((Component)new JLabel("Target\nPosition"), constraints.cell(++x, y));
        panel.add((Component)new JLabel(""), constraints.cell(++x, y));
        panel.add((Component)new JLabel(""), constraints.cell(++x, y).fillx());
        panel.add((Component)new JLabel(""), constraints.cell(++x, y));
        panel.add((Component)new JLabel("Jog Step"), constraints.cell(++x, y));
        panel.add((Component)new JLabel(""), constraints.cell(++x, y));
        x = 0;
        panel.add((Component)new JLabel("Ei"), constraints.cell(x, ++y));
        panel.add((Component)new DeviceValueLabel(this.initialEnergy), constraints.cell(x += 2, y));
        panel.add((Component)this.energyTargetField, constraints.cell(x += 2, y));
        panel.add((Component)energyGoBtn, constraints.cell(++x, y));
        panel.add((Component)energyMinusBtn, constraints.cell(x += 2, y));
        panel.add((Component)this.energyJogField, constraints.cell(++x, y));
        panel.add((Component)energyPlusBtn, constraints.cell(++x, y));
        x = 0;
        panel.add((Component)new JLabel("A3"), constraints.cell(x, ++y));
        panel.add((Component)new DeviceValueLabel(this.A3), constraints.cell(x += 2, y));
        panel.add((Component)this.a3TargetField, constraints.cell(x += 2, y));
        panel.add((Component)a3GoBtn, constraints.cell(++x, y));
        panel.add((Component)a3MinusBtn, constraints.cell(x += 2, y));
        panel.add((Component)this.a3JogField, constraints.cell(++x, y));
        panel.add((Component)a3PlusBtn, constraints.cell(++x, y));
        this.tabOrder.add(energyGoBtn);
        this.tabOrder.add(energyMinusBtn);
        this.tabOrder.add(this.energyJogField);
        this.tabOrder.add(energyPlusBtn);
        this.tabOrder.add(this.a3TargetField);
        this.tabOrder.add(a3GoBtn);
        this.tabOrder.add(a3MinusBtn);
        this.tabOrder.add(this.a3JogField);
        this.tabOrder.add(a3PlusBtn);
        this.tabOrder.add(this.targetHField);
        MyFocusTraversalPolicy focusPolicy = new MyFocusTraversalPolicy(this.tabOrder);
        panel.setFocusTraversalPolicy(focusPolicy);
        panel.setFocusCycleRoot(true);
        return panel;
    }

    @Override
    public void actionPerformed(AngleCalcEvent ace) {
        logger.debug("Updating angles");
        double calculatedA3 = ace.getAngleValueFor(2);
        double calculatedA4 = ace.getAngleValueFor(3);
        boolean A3Error = false;
        boolean A4Error = false;
        if (calculatedA3 < this.A3.getLowerLimit() || calculatedA3 > this.A3.getUpperLimit()) {
            A3Error = true;
        }
        if (calculatedA4 < this.A4.getLowerLimit() || calculatedA4 > this.A4.getUpperLimit()) {
            A4Error = true;
        }
        SwingUtilities.invokeLater(new UpdateAngleCalcFields(calculatedA3, calculatedA4));
        if (A3Error || A4Error) {
            String messagePrefix = "Calcualated value for ";
            String messageSuffix = " outside of its limit range!";
            String devices = "";
            if (A3Error) {
                devices = "A3";
                if (A4Error) {
                    devices = String.valueOf(devices) + " and A4";
                    messageSuffix = " outside of their limit ranges!";
                }
            } else {
                devices = "A4";
            }
            final String message = String.valueOf(messagePrefix) + devices + messageSuffix;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    System.out.println("appending...");
                    TASBaseSampleAlignmentPanel.this.appendErrorMessage(TASBaseSampleAlignmentPanel.this.a3TargetField, message);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TASBaseSampleAlignmentPanel.this.removeErrorMessage(TASBaseSampleAlignmentPanel.this.a3TargetField);
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = "move ";
        String actionCmd = ae.getActionCommand();
        if (actionCmd.equals("energyGo")) {
            cmd = cmd.concat(String.valueOf(this.initialEnergy.getName()) + " " + this.energyTargetField.getText());
        } else if (actionCmd.equals("energyMinus")) {
            cmd = cmd.concat(String.valueOf(this.initialEnergy.getName()) + " -" + this.energyJogField.getText() + " " + this.finalEnergy.getName() + " -" + this.energyJogField.getText() + " -relative");
        } else if (actionCmd.equals("energyPlus")) {
            cmd = cmd.concat(String.valueOf(this.initialEnergy.getName()) + " " + this.energyJogField.getText() + " " + this.finalEnergy.getName() + " " + this.energyJogField.getText() + " -relative");
        } else if (actionCmd.equals("a3Go")) {
            cmd = cmd.concat("A3 " + this.a3TargetField.getText());
        } else if (actionCmd.equals("a3Minus")) {
            cmd = cmd.concat("A3 -" + this.a3JogField.getText() + " -relative");
        } else if (actionCmd.equals("a3Plus")) {
            cmd = cmd.concat("A3 " + this.a3JogField.getText() + " -relative");
        } else {
            logger.error("Unknown command (" + actionCmd + ").  Ignoring.");
            return;
        }
        this.sendManager.addMessage(cmd, true);
    }

    @Override
    public synchronized void stateChanged(ChangeEvent ce) {
        if (ce.getSource() != this.sample) {
            return;
        }
        SwingUtilities.invokeLater(this.usf);
    }

    public void addPeakScanListener(LoadPeakScanListener psl) throws ICEListenerListExceptionBase {
        this.loadPeakScanListeners.addListener(psl);
    }

    public void recalculateAngles() {
        logger.debug("recalc");
        if (this.initialEnergy == null || this.finalEnergy == null) {
            logger.error("Necessary energy value not present (Ei or Ef).  Forced to cancel calculation.");
            return;
        }
        logger.debug("Ei: " + this.initialEnergy.getCurrValue());
        logger.debug("Ef: set to Ei -> is really " + this.finalEnergy.getCurrValue());
        try {
            double targetH = Double.valueOf(this.targetHField.getText());
            double targetK = Double.valueOf(this.targetKField.getText());
            double targetL = Double.valueOf(this.targetLField.getText());
            double energyTransfer = 0.0;
            this.sendManager.addMessage("ask calcA3A4fromHKL instrument action angles " + energyTransfer + " i " + this.initialEnergy.getCurrValue() + " " + targetH + " " + targetK + " " + targetL, false);
        }
        catch (NumberFormatException nfe) {
            logger.error("Invalid input for target HKL or energy value.  Cancelling.");
            this.calculatedA3Label.setText("N/A");
            this.calculatedA4Label.setText("N/A");
        }
    }

    @Override
    public void actionPerformed(SamplePropertyChangedEvent pce) {
        super.actionPerformed(pce);
        this.recalculateAngles();
    }

    protected class AngleCalculator
    implements DocumentListener {
        protected AngleCalculator() {
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            logger.debug("insert: " + de.getDocument());
            TASBaseSampleAlignmentPanel.this.recalculateAngles();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            logger.debug("remove: " + de.getDocument());
            TASBaseSampleAlignmentPanel.this.recalculateAngles();
        }
    }

    protected class DeviceListener
    implements DeviceValueChangedListener {
        protected DeviceListener() {
        }

        @Override
        public void actionPerformed(DeviceValueChangedEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("currValue")) {
                TASBaseSampleAlignmentPanel.this.recalculateAngles();
            }
        }
    }

    protected class DriveA4Action
    extends AbstractAction {
        public DriveA4Action() {
            this.putValue("Name", "Drive A4");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                double A4 = Double.parseDouble(TASBaseSampleAlignmentPanel.this.calculatedA4Label.getText());
                TASBaseSampleAlignmentPanel.this.sendManager.addMessage("move A4 " + A4, true);
            }
            catch (NumberFormatException nfe) {
                logger.error("Invalid number for A4.  Ignoring operation.", nfe);
            }
        }
    }

    protected class DriveQAction
    extends AbstractAction {
        public DriveQAction() {
            this.putValue("Name", "Drive Q (A3/A4)");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                double A3 = Double.parseDouble(TASBaseSampleAlignmentPanel.this.calculatedA3Label.getText());
                double A4 = Double.parseDouble(TASBaseSampleAlignmentPanel.this.calculatedA4Label.getText());
                TASBaseSampleAlignmentPanel.this.sendManager.addMessage("move A3 " + A3 + " A4 " + A4, true);
            }
            catch (NumberFormatException nfe) {
                logger.error("Invalid number for A3/A4.  Ignoring operation.", nfe);
            }
        }
    }

    protected class LatticeApplyAction
    extends AbstractAction {
        public LatticeApplyAction() {
            this.putValue("Name", "Apply");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                double a = Double.parseDouble(TASBaseSampleAlignmentPanel.this.aField.getText());
                double b = Double.parseDouble(TASBaseSampleAlignmentPanel.this.bField.getText());
                double c = Double.parseDouble(TASBaseSampleAlignmentPanel.this.cField.getText());
                double alpha = Double.parseDouble(TASBaseSampleAlignmentPanel.this.alphaField.getText());
                double beta = Double.parseDouble(TASBaseSampleAlignmentPanel.this.betaField.getText());
                double gamma = Double.parseDouble(TASBaseSampleAlignmentPanel.this.gammaField.getText());
                StringBuilder commandBuilder = new StringBuilder("sample setlattice");
                commandBuilder.append(" -a ");
                commandBuilder.append(a);
                commandBuilder.append(" -b ");
                commandBuilder.append(b);
                commandBuilder.append(" -c ");
                commandBuilder.append(c);
                commandBuilder.append(" -alpha ");
                commandBuilder.append(alpha);
                commandBuilder.append(" -beta ");
                commandBuilder.append(beta);
                commandBuilder.append(" -gamma ");
                commandBuilder.append(gamma);
                TASBaseSampleAlignmentPanel.this.sendManager.addMessage(commandBuilder.toString());
            }
            catch (NumberFormatException nfe) {
                logger.error("Invalid number in text field:", nfe);
            }
        }
    }

    protected class LatticeResetAction
    extends AbstractAction {
        public LatticeResetAction() {
            this.putValue("Name", "Reset");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TASBaseSampleAlignmentPanel.this.aField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getA()));
            TASBaseSampleAlignmentPanel.this.bField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getB()));
            TASBaseSampleAlignmentPanel.this.cField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getC()));
            TASBaseSampleAlignmentPanel.this.alphaField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getAlpha()));
            TASBaseSampleAlignmentPanel.this.betaField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getBeta()));
            TASBaseSampleAlignmentPanel.this.gammaField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getGamma()));
        }
    }

    public class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order;

        public MyFocusTraversalPolicy(Vector<Component> order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int index = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(index);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int index = this.order.indexOf(aComponent) - 1;
            if (index < 0) {
                index = this.order.size() - 1;
            }
            return this.order.get(index);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.firstElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.firstElement();
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }
    }

    protected class PlaneApplyAction
    extends AbstractAction {
        public PlaneApplyAction() {
            this.putValue("Name", "Apply");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                double h1 = Double.parseDouble(TASBaseSampleAlignmentPanel.this.h1Field.getText());
                double k1 = Double.parseDouble(TASBaseSampleAlignmentPanel.this.k1Field.getText());
                double l1 = Double.parseDouble(TASBaseSampleAlignmentPanel.this.l1Field.getText());
                double h2 = Double.parseDouble(TASBaseSampleAlignmentPanel.this.h2Field.getText());
                double k2 = Double.parseDouble(TASBaseSampleAlignmentPanel.this.k2Field.getText());
                double l2 = Double.parseDouble(TASBaseSampleAlignmentPanel.this.l2Field.getText());
                TASBaseSampleAlignmentPanel.this.sendManager.addMessage("sample setOrient " + h1 + " " + k1 + " " + l1 + " " + h2 + " " + k2 + " " + l2);
            }
            catch (NumberFormatException nfe) {
                logger.error("Invalid number in hkl fields:" + nfe);
            }
        }
    }

    protected class PlaneResetAction
    extends AbstractAction {
        public PlaneResetAction() {
            this.putValue("Name", "Reset");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TASBaseSampleAlignmentPanel.this.h1Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getH1()));
            TASBaseSampleAlignmentPanel.this.k1Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getK1()));
            TASBaseSampleAlignmentPanel.this.l1Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getL1()));
            TASBaseSampleAlignmentPanel.this.h2Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getH2()));
            TASBaseSampleAlignmentPanel.this.k2Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getK2()));
            TASBaseSampleAlignmentPanel.this.l2Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getL2()));
        }
    }

    protected class UpdateAngleCalcFields
    implements Runnable {
        private double newA3;
        private double newA4;

        public UpdateAngleCalcFields(double newA3, double newA4) {
            this.newA3 = newA3;
            this.newA4 = newA4;
        }

        @Override
        public void run() {
            TASBaseSampleAlignmentPanel.this.calculatedA3Label.setText(String.valueOf(this.newA3));
            TASBaseSampleAlignmentPanel.this.calculatedA4Label.setText(String.valueOf(this.newA4));
        }
    }

    protected class UpdateSampleFields
    implements Runnable {
        protected UpdateSampleFields() {
        }

        @Override
        public void run() {
            TASBaseSampleAlignmentPanel.this.aField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getA()));
            TASBaseSampleAlignmentPanel.this.bField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getB()));
            TASBaseSampleAlignmentPanel.this.cField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getC()));
            TASBaseSampleAlignmentPanel.this.alphaField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getAlpha()));
            TASBaseSampleAlignmentPanel.this.betaField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getBeta()));
            TASBaseSampleAlignmentPanel.this.gammaField.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getGamma()));
            TASBaseSampleAlignmentPanel.this.h1Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getH1()));
            TASBaseSampleAlignmentPanel.this.k1Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getK1()));
            TASBaseSampleAlignmentPanel.this.l1Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getL1()));
            TASBaseSampleAlignmentPanel.this.h2Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getH2()));
            TASBaseSampleAlignmentPanel.this.k2Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getK2()));
            TASBaseSampleAlignmentPanel.this.l2Field.setText(String.valueOf(TASBaseSampleAlignmentPanel.this.sample.getL2()));
        }
    }
}

