/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.tas;

import ice.Controller;
import ice.FileClassLoader;
import ice.Global;
import ice.communication.CommunicationManager;
import ice.communication.SendQueueManager;
import ice.data.InstalledDevice;
import ice.data.Sample;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.communication.DataMessageEvent;
import ice.event.communication.DataMessageListener;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.event.communication.FitResultEvent;
import ice.event.communication.FitResultListener;
import ice.exceptions.ICECommandComboBoxException;
import ice.exceptions.IcePanelException;
import ice.gui.core.ICECommandComboBox;
import ice.gui.core.IcePanelDataLoader;
import ice.gui.core.PlotPanel;
import ice.gui.core.rangeClasses.DeviceValue.HKLDeviceValue;
import ice.swing.Bag;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import ptolemy.plot.Plot;

public class PeakScanPanel
extends PlotPanel
implements DataMessageListener,
DeviceValueChangedListener,
ActionListener,
DeviceListListener,
FitResultListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.PeakScanLogger");
    private SendQueueManager sendManager;
    private ResourceBundle rb;
    private String oldDevice;
    private HashMap<String, String> prevValues;
    private InstalledDevice A1;
    private InstalledDevice A2;
    private InstalledDevice A3;
    private InstalledDevice A4;
    private InstalledDevice A5;
    private InstalledDevice A6;
    private ArrayList<InstalledDevice> allDevices;
    private Sample sample;
    private JComboBox deviceCB;
    private DefaultComboBoxModel deviceCBModel;
    private JTextField rangeField;
    private JLabel rangeUnitLabel;
    private JTextField peakToleranceField;
    private JLabel peakToleranceUnitLabel;
    private JTextField stepSizeField;
    private JLabel stepSizeUnitLabel;
    private JTextField durationField;
    private JComboBox countTypeCB;
    private JCheckBox acceptCheckBox;
    private Plot plot;
    private JComboBox displayCB;
    private ICECommandComboBox fitFuncTypeCB;
    private JLabel redefineDeviceLabel;
    private JTextField redefineDeviceField;
    private JLabel backgroundValueLabel;
    private JLabel heightValueLabel;
    private JLabel positionValueLabel;
    private JLabel widthValueLabel;
    private InstalledDevice deviceOfInterest;
    private static final String yName = "DATA";
    private ArrayList<Double> xPoints;
    private ArrayList<Double> yPoints;
    private FindPeakAction findPeakAction;
    private MoveToFitAction moveToFitAction;
    private RedefineDeviceAction redefineDeviceAction;
    private JLabel fitResultLabel;
    private JTextField conversionField;
    private JLabel newValueLabel;
    private JCheckBox aCB;
    private JCheckBox bCB;
    private JCheckBox cCB;
    private RedefineLatticeParamsAction redefineLatticeAction;
    private JCheckBox useHklCB;
    private HKLDeviceValue hklPreset;
    private JComponent hklPresetComponent;
    private JLabel useHklLabel;
    private PeakScanDeviceListener deviceListener;
    private String instrumentName;
    private Controller controller;

    public PeakScanPanel() throws IcePanelException {
        super("Peak Scan");
    }

    @Override
    protected void init() {
        this.controller = Controller.getReference();
        ArrayList<InstalledDevice> devices = this.controller.getDeviceList();
        this.allDevices = new ArrayList<InstalledDevice>(devices);
        this.A1 = this.controller.getFirstDevice("A1");
        this.A2 = this.controller.getFirstDevice("A2");
        this.A3 = this.controller.getFirstDevice("A3");
        this.A4 = this.controller.getFirstDevice("A4");
        this.A5 = this.controller.getFirstDevice("A5");
        this.A6 = this.controller.getFirstDevice("A6");
        this.sendManager = this.controller.getSendManager();
        this.sample = this.controller.getSample();
        this.instrumentName = this.controller.getInstrument().getName();
        this.rb = ResourceBundle.getBundle("peakScanDefaults", Locale.getDefault(), new FileClassLoader());
        this.prevValues = new HashMap();
        for (InstalledDevice device : this.allDevices) {
            if (device == null) continue;
            try {
                device.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e1) {
                logger.error("PeakScanPanel.init " + e1);
            }
        }
        this.xPoints = new ArrayList();
        this.yPoints = new ArrayList();
        this.findPeakAction = new FindPeakAction();
        this.moveToFitAction = new MoveToFitAction();
        this.redefineDeviceAction = new RedefineDeviceAction();
        this.deviceCBModel = new DefaultComboBoxModel();
        this.updateDeviceComboBox();
        this.deviceCB = new JComboBox(this.deviceCBModel);
        this.deviceCB.setRenderer(new PeakScanListCellRenderer());
        this.deviceCB.addActionListener(this);
        this.rangeField = new JTextField();
        this.rangeField.setColumns(6);
        this.rangeUnitLabel = new JLabel(Global.degreeSign());
        this.peakToleranceField = new JTextField();
        this.peakToleranceField.setEnabled(false);
        this.peakToleranceField.setColumns(6);
        this.peakToleranceUnitLabel = new JLabel(Global.degreeSign());
        this.stepSizeField = new JTextField(6);
        this.stepSizeUnitLabel = new JLabel(Global.degreeSign());
        this.durationField = new JTextField(6);
        String[] countTypes = new String[]{"Monitor", "Time"};
        this.countTypeCB = new JComboBox<String>(countTypes);
        this.acceptCheckBox = new JCheckBox("Accept Fit Result");
        this.acceptCheckBox.addItemListener(new AcceptCheckBoxListener());
        this.plot = new Plot();
        this.plot.setMarksStyle("dots", 0);
        this.plot.setMarksStyle("none", 1);
        this.plot.setBackground(Color.WHITE);
        this.plot.setXRange(0.0, 1.0);
        this.plot.setYRange(0.0, 1.0);
        String key = String.valueOf(this.instrumentName) + ".livedata.panel.counter";
        ArrayList<String> displayTypes = IcePanelDataLoader.getValues(key);
        this.displayCB = new JComboBox<Object>(displayTypes.toArray());
        String[] fitDisplayNames = new String[]{"Gauss w/ Flat", "Gauss w/ Linear", "Gauss w/ Quadratic"};
        String[] fitCommandName = new String[]{"-func Gauss", "-func GaussLinear", "-func GaussQuadratic"};
        try {
            this.fitFuncTypeCB = new ICECommandComboBox(fitDisplayNames, fitCommandName);
        }
        catch (ICECommandComboBoxException e) {
            logger.fatal(e.toString());
        }
        this.redefineDeviceLabel = new JLabel("N/A");
        this.redefineDeviceField = new JTextField(6);
        this.fitResultLabel = new JLabel("N/A");
        this.conversionField = new JTextField();
        this.newValueLabel = new JLabel("N/A");
        this.aCB = new JCheckBox("a");
        this.bCB = new JCheckBox("b");
        this.cCB = new JCheckBox("c");
        this.redefineLatticeAction = new RedefineLatticeParamsAction();
        this.aCB.addItemListener(this.redefineLatticeAction);
        this.bCB.addItemListener(this.redefineLatticeAction);
        this.cCB.addItemListener(this.redefineLatticeAction);
        this.conversionField.getDocument().addDocumentListener(new ConversionFieldListener());
        new ValidNumberChecker(this.rangeField, "Range");
        new ValidNumberChecker(this.peakToleranceField, "Tolerance");
        new ValidNumberChecker(this.stepSizeField, "Step Size");
        new ValidNumberChecker(this.durationField, "Duration");
        this.deviceListener = this.A3 != null ? new PeakScanDeviceListener(this.A3) : new PeakScanDeviceListener(this.A1);
        new RedefineDeviceChecker();
        this.useHklCB = new JCheckBox();
        this.useHklCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeakScanPanel.this.toggleUseHKL();
            }
        });
        this.hklPreset = new HKLDeviceValue();
        this.useHklLabel = new JLabel("Start at initial HKL location?");
        this.backgroundValueLabel = new JLabel("N/A");
        this.heightValueLabel = new JLabel("N/A");
        this.positionValueLabel = new JLabel("N/A");
        this.widthValueLabel = new JLabel("N/A");
        CommunicationManager comManager = this.controller.getCommMgr();
        this.controller.addDeviceListListener(this);
        try {
            comManager.addDataMessageListener(this);
            comManager.addFitResultListener(this);
        }
        catch (ICEListenerListExceptionBase e1) {
            logger.error("PeakScanPanel.init could not add listener " + e1);
        }
    }

    private void toggleUseHKL() {
        this.hklPresetComponent.setEnabled(this.useHklCB.isSelected());
    }

    private JPanel createFitParamPanel() {
        JLabel backgroundNameLabel = new JLabel("Background:");
        JLabel heightNameLabel = new JLabel("Height");
        JLabel positionNameLabel = new JLabel("Position:");
        JLabel widthNameLabel = new JLabel("Width:");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("Fit Parameters"));
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        panel.add((Component)backgroundNameLabel, constraints.cell(x, y));
        panel.add((Component)this.backgroundValueLabel, constraints.cell(++x, y));
        panel.add((Component)positionNameLabel, constraints.cell(++x, y));
        panel.add((Component)this.positionValueLabel, constraints.cell(++x, y));
        x = 0;
        panel.add((Component)heightNameLabel, constraints.cell(x, ++y));
        panel.add((Component)this.heightValueLabel, constraints.cell(++x, y));
        panel.add((Component)widthNameLabel, constraints.cell(++x, y));
        panel.add((Component)this.widthValueLabel, constraints.cell(++x, y));
        return panel;
    }

    private void updateDeviceComboBox() {
        this.deviceCBModel.removeAllElements();
        for (InstalledDevice device : this.allDevices) {
            if (device.getType() == InstalledDevice.Type.counter) continue;
            this.deviceCBModel.addElement(device);
        }
        if (this.A1 != null && this.A2 != null) {
            this.deviceCBModel.insertElementAt(new DevicePair(this.A2, this.A1), 0);
        }
        if (this.A5 != null && this.A6 != null) {
            this.deviceCBModel.insertElementAt(new DevicePair(this.A6, this.A5), 0);
        }
        if (this.A3 != null && this.A4 != null) {
            this.deviceCBModel.insertElementAt(new DevicePair(this.A4, this.A3), 0);
        }
    }

    @Override
    public void buildGUI() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        this.add((Component)this.createPeakScanPanel(), constraints);
        ++constraints.gridy;
        constraints.fill = 0;
        constraints.ipadx = 60;
        this.add((Component)new JButton(this.findPeakAction), constraints);
        ++constraints.gridy;
        constraints.fill = 2;
        this.add((Component)this.createFitParamPanel(), constraints);
        constraints.fill = 2;
        ++constraints.gridy;
        this.add((Component)this.createPlotPanel(), constraints);
        constraints.fill = 2;
        ++constraints.gridy;
        this.add((Component)this.createBottomPanel(), constraints);
        this.initState();
    }

    private void initState() {
        this.conversionField.setText("1");
        this.redefineLatticeAction.setEnabled(false);
        int size = this.deviceCBModel.getSize();
        this.deviceCB.setSelectedIndex(0);
        this.sendManager.addMessage("ask GETFITRESULTS getnewlattice", true);
    }

    private JPanel createPeakScanPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("Peak Scan"));
        GridBagConstraints templateConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0);
        JPanel rangePanel = new JPanel();
        JPanel tolerancePanel = new JPanel();
        JPanel stepSizePanel = new JPanel();
        templateConstraints.gridx = 0;
        templateConstraints.gridy = 0;
        panel.add((Component)new JLabel("Device"), templateConstraints);
        templateConstraints.gridx = 1;
        templateConstraints.gridy = 0;
        panel.add((Component)this.deviceCB, templateConstraints);
        templateConstraints.gridx = 2;
        templateConstraints.gridy = 0;
        panel.add((Component)new JLabel("Duration"), templateConstraints);
        templateConstraints.gridx = 3;
        templateConstraints.gridy = 0;
        panel.add((Component)this.durationField, templateConstraints);
        templateConstraints.gridx = 5;
        templateConstraints.gridy = 0;
        panel.add((Component)this.acceptCheckBox, templateConstraints);
        templateConstraints.insets = new Insets(20, 0, 0, 0);
        templateConstraints.gridx = 0;
        templateConstraints.gridy = 1;
        panel.add((Component)new JLabel("Range"), templateConstraints);
        templateConstraints.gridx = 1;
        templateConstraints.gridy = 1;
        rangePanel.setLayout(new FlowLayout(0, 0, 0));
        rangePanel.add(this.rangeField);
        this.rangeUnitLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        rangePanel.add(this.rangeUnitLabel);
        panel.add((Component)rangePanel, templateConstraints);
        templateConstraints.gridx = 2;
        templateConstraints.gridy = 1;
        panel.add((Component)new JLabel("Count Against"), templateConstraints);
        templateConstraints.gridx = 3;
        templateConstraints.gridy = 1;
        panel.add((Component)this.countTypeCB, templateConstraints);
        templateConstraints.gridx = 4;
        templateConstraints.gridy = 1;
        panel.add((Component)new JLabel("Tolerance"), templateConstraints);
        templateConstraints.gridx = 5;
        templateConstraints.gridy = 1;
        tolerancePanel.setLayout(new FlowLayout(0, 0, 0));
        tolerancePanel.add(this.peakToleranceField);
        this.peakToleranceUnitLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        tolerancePanel.add(this.peakToleranceUnitLabel);
        panel.add((Component)tolerancePanel, templateConstraints);
        templateConstraints.gridx = 0;
        templateConstraints.gridy = 2;
        panel.add((Component)new JLabel("Step Size"), templateConstraints);
        templateConstraints.gridx = 1;
        templateConstraints.gridy = 2;
        stepSizePanel.setLayout(new FlowLayout(0, 0, 0));
        stepSizePanel.add(this.stepSizeField);
        this.stepSizeUnitLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        stepSizePanel.add(this.stepSizeUnitLabel);
        panel.add((Component)stepSizePanel, templateConstraints);
        templateConstraints.gridx = 2;
        templateConstraints.gridy = 2;
        panel.add((Component)new JLabel("Data to Display"), templateConstraints);
        templateConstraints.gridx = 3;
        templateConstraints.gridy = 2;
        panel.add((Component)this.displayCB, templateConstraints);
        templateConstraints.gridx = 4;
        templateConstraints.gridy = 2;
        panel.add((Component)new JLabel("Fitting Function"), templateConstraints);
        templateConstraints.gridx = 5;
        templateConstraints.gridy = 2;
        panel.add((Component)this.fitFuncTypeCB, templateConstraints);
        templateConstraints.gridx = 0;
        templateConstraints.gridy = 3;
        JPanel useHkl = new JPanel();
        useHkl.add(this.useHklCB);
        useHkl.add(this.useHklLabel);
        panel.add((Component)useHkl, templateConstraints);
        templateConstraints.gridx = 1;
        templateConstraints.gridy = 3;
        this.hklPresetComponent = this.hklPreset.getControl();
        this.hklPresetComponent.setEnabled(false);
        panel.add((Component)this.hklPresetComponent, templateConstraints);
        return panel;
    }

    private JPanel createPlotPanel() {
        JPanel column1 = new JPanel();
        column1.setBorder(new TitledBorder("Fit Parameters"));
        column1.setLayout(new BoxLayout(column1, 1));
        JPanel panel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        boolean maxRows = true;
        int maxCols = 2;
        panel.add((Component)this.plot, constraints.cell(x, y).fillboth());
        ++y;
        return panel;
    }

    private JPanel createBottomPanel() {
        JButton redefineBtn = new JButton(this.redefineDeviceAction);
        JButton moveCenterFitBtn = new JButton(this.moveToFitAction);
        JLabel redefinePrefixLabel = new JLabel("Redefine ");
        JLabel redefineSuffixLabel = new JLabel(" to:");
        JPanel panel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        int maxRows = 2;
        int maxCols = 7;
        panel.add((Component)moveCenterFitBtn, constraints.cell(x, y));
        panel.add((Component)new JLabel(""), constraints.cell(++x, y).fillx());
        panel.add((Component)redefinePrefixLabel, constraints.cell(++x, y));
        panel.add((Component)this.redefineDeviceLabel, constraints.cell(++x, y));
        panel.add((Component)redefineSuffixLabel, constraints.cell(++x, y));
        panel.add((Component)this.redefineDeviceField, constraints.cell(++x, y));
        panel.add((Component)redefineBtn, constraints.cell(++x, y));
        x = 0;
        panel.add((Component)this.createLatticePanel(), constraints.cell(x, ++y).colspan(7));
        return panel;
    }

    private JPanel createLatticePanel() {
        JPanel col1 = new JPanel(new GridBagLayout());
        JLabel resultLabel = new JLabel("Fit Result from Last A4 Peak Scan");
        JLabel conversionLabel = new JLabel("Conversion");
        JLabel newValue2Label = new JLabel("New Value");
        JLabel multiplyLabel = new JLabel("X");
        JLabel equalLabel = new JLabel("=");
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        int maxRows = 2;
        int maxCols = 5;
        col1.add((Component)resultLabel, constraints.cell(x, y));
        col1.add((Component)new JLabel(""), constraints.cell(++x, y));
        col1.add((Component)conversionLabel, constraints.cell(++x, y));
        col1.add((Component)new JLabel(""), constraints.cell(++x, y));
        col1.add((Component)newValue2Label, constraints.cell(++x, y));
        x = 0;
        col1.add((Component)this.fitResultLabel, constraints.cell(x, ++y));
        col1.add((Component)multiplyLabel, constraints.cell(++x, y));
        col1.add((Component)this.conversionField, constraints.cell(++x, y));
        col1.add((Component)equalLabel, constraints.cell(++x, y));
        col1.add((Component)this.newValueLabel, constraints.cell(++x, y));
        JPanel col2 = new JPanel(new GridBagLayout());
        col2.setBorder(new TitledBorder(""));
        JLabel instructionLabel = new JLabel("<HTML>\"Fit result (i.e. d-spacing) from last A3-A4 (or A4) scan\"<BR> will be updated after peak scan is finished.  The fit result (i. e. d-spacing) <BR> after modified by conversion constant will yields \"New Value\".<BR>Redefine selected lattice parameter (selected by check boxes)<BR> to the \"new value\" by clicking on \"redefine lattice parameters\" .<BR>This allows to redefine lattice parameter automatically<BR> in command queue after a A3-A4 scan.</HTML>");
        JButton redefineLatticeBtn = new JButton(this.redefineLatticeAction);
        Bag constraints2 = new Bag();
        int x2 = 0;
        int y2 = 0;
        int maxRows2 = 2;
        int maxCols2 = 4;
        col2.add((Component)instructionLabel, constraints2.cell(x2, y2).colspan(maxCols2));
        col2.add((Component)this.aCB, constraints2.cell(x2, ++y2));
        col2.add((Component)this.bCB, constraints2.cell(++x2, y2));
        col2.add((Component)this.cCB, constraints2.cell(++x2, y2));
        col2.add((Component)redefineLatticeBtn, constraints2.cell(++x2, y2));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("New Lattice Values"));
        Bag constraints3 = new Bag();
        int x3 = 0;
        int y3 = 0;
        panel.add((Component)col1, constraints3.cell(x3, y3).colspan(1));
        panel.add((Component)col2, constraints3.cell(++x3, y3).colspan(1));
        return panel;
    }

    @Override
    public synchronized void selectDevice(String deviceName) {
        ComboBoxModel model = this.deviceCB.getModel();
        int size = model.getSize();
        int i = 0;
        while (i < size) {
            Object obj = model.getElementAt(i);
            if (obj instanceof InstalledDevice && ((InstalledDevice)obj).getName().equals(deviceName)) {
                this.deviceCB.setSelectedItem(obj);
                return;
            }
            if (obj instanceof DevicePair) {
                DevicePair dp = (DevicePair)obj;
                String match = String.valueOf(dp.getDependentDevice().getName()) + "-" + dp.getIndependentDevice().getName();
                logger.debug(String.valueOf(deviceName) + " vs " + match);
                if (deviceName.equals(match)) {
                    this.deviceCB.setSelectedItem(obj);
                }
            }
            ++i;
        }
        logger.error("Unable to find device requested.  Aborting.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(DataMessageEvent dme) {
        logger.debug("new message data: " + dme.getPointNum());
        if (dme.hasFinished()) {
            return;
        }
        if (dme.isNewStart()) {
            if (dme.getScanType() != DataMessageEvent.ScanType.FINDPEAK) {
                return;
            }
            logger.debug("resetting graph");
            this.xPoints.clear();
            this.yPoints.clear();
            String deviceUnits = Global.degreeSign();
            String deviceName = "N/A";
            try {
                String interest = "";
                ArrayList<String> devices = dme.getDevices();
                String firstDeviceName = dme.getDevices().get(0);
                String secondDeviceName = dme.getDevices().get(1);
                interest = firstDeviceName.equalsIgnoreCase("A1") && secondDeviceName.equalsIgnoreCase("A2") ? "A2" : (firstDeviceName.equalsIgnoreCase("A3") && secondDeviceName.equalsIgnoreCase("A4") ? "A4" : (firstDeviceName.equalsIgnoreCase("A5") && secondDeviceName.equalsIgnoreCase("A6") ? "A6" : firstDeviceName));
                ArrayList<InstalledDevice> arrayList = this.allDevices;
                synchronized (arrayList) {
                    for (InstalledDevice tempDevice : this.allDevices) {
                        if (!tempDevice.getName().equals(interest)) continue;
                        this.deviceOfInterest = tempDevice;
                        deviceUnits = tempDevice.getUnits();
                        deviceName = this.deviceOfInterest.getName();
                    }
                }
            }
            catch (IndexOutOfBoundsException ioobe) {
                logger.error("XPeek data has no devices.  This shouldn't happen, ever.");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PeakScanPanel.this.backgroundValueLabel.setText("N/A");
                    PeakScanPanel.this.heightValueLabel.setText("N/A");
                    PeakScanPanel.this.positionValueLabel.setText("N/A");
                    PeakScanPanel.this.widthValueLabel.setText("N/A");
                }
            });
            PlotPanel.ResetGraph rg = new PlotPanel.ResetGraph(this.plot, "File: " + dme.getFilename(), String.valueOf(deviceName) + "(" + deviceUnits + ")", String.valueOf(this.displayCB.getSelectedItem().toString()) + " Counts");
            SwingUtilities.invokeLater(rg);
        } else if (dme.hasFitData()) {
            try {
                logger.debug("fitting data.  First point: " + this.xPoints.get(0) + ", last point: " + this.xPoints.get(this.xPoints.size() - 1) + ", numPoints: " + this.xPoints.size() * 2);
                this.plotGaussian(this.xPoints.get(0), this.xPoints.get(this.xPoints.size() - 1), this.xPoints.size() * 2, dme.getFitPoints());
                final ArrayList<Double> fitPoints = dme.getFitPoints();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PeakScanPanel.this.backgroundValueLabel.setText(((Double)fitPoints.get(0)).toString());
                        PeakScanPanel.this.heightValueLabel.setText(((Double)fitPoints.get(3)).toString());
                        PeakScanPanel.this.positionValueLabel.setText(((Double)fitPoints.get(4)).toString());
                        PeakScanPanel.this.widthValueLabel.setText(((Double)fitPoints.get(5)).toString());
                    }
                });
                logger.debug("last point");
                if (this.deviceOfInterest != null || this.deviceOfInterest.getName().toUpperCase().equals("A4")) {
                    this.sendManager.addMessage("ask GETFITRESULTS getnewlattice", true);
                }
            }
            catch (IndexOutOfBoundsException ioobe) {
                logger.error("xPoints or fitResults isn't a proper array.  This shouldn't happen!", ioobe);
            }
        } else if (!dme.hasFitData()) {
            if (this.deviceOfInterest != null) {
                Map<String, Double> pointMap = dme.getPointMap();
                Object[] set = pointMap.keySet().toArray();
                Double xPoint = pointMap.get(this.deviceOfInterest.getName());
                Double yPoint = pointMap.get(yName);
                if (xPoint != null && yPoint != null) {
                    this.xPoints.add(xPoint);
                    this.yPoints.add(yPoint);
                    this.plotPoint(xPoint, yPoint);
                } else {
                    logger.error("Unable to get X or Y point.");
                }
            } else {
                logger.debug("No device of interest.  Ignoring xpeek point.");
            }
        }
    }

    private synchronized void plotPoint(double x, double y) {
        PlotPanel.PlotPoint plotPoint = new PlotPanel.PlotPoint(this.plot, 0, x, y, false, y - Math.sqrt(y), y + Math.sqrt(y), true);
        SwingUtilities.invokeLater(plotPoint);
    }

    private void setRedefineLatticeButtonEnabledState() {
        try {
            float conversionFieldAsFloat = Float.parseFloat(this.conversionField.getText());
            if ((double)conversionFieldAsFloat == -1.0) {
                this.redefineLatticeAction.setEnabled(false);
                return;
            }
        }
        catch (NumberFormatException e) {
            this.redefineLatticeAction.setEnabled(false);
            return;
        }
        if (this.aCB.isSelected() || this.bCB.isSelected() || this.cCB.isSelected()) {
            this.redefineLatticeAction.setEnabled(true);
        } else {
            this.redefineLatticeAction.setEnabled(false);
        }
    }

    private void setToleranceFieldEnabledState() {
        InstalledDevice selectedInstalledDevice;
        Object deviceObject = this.deviceCBModel.getSelectedItem();
        if (deviceObject instanceof InstalledDevice) {
            selectedInstalledDevice = (InstalledDevice)this.deviceCBModel.getSelectedItem();
        } else if (deviceObject instanceof DevicePair) {
            DevicePair selectedDevicePair = (DevicePair)this.deviceCBModel.getSelectedItem();
            selectedInstalledDevice = selectedDevicePair.getDependentDevice();
        } else {
            this.peakToleranceField.setEnabled(false);
            return;
        }
        String deviceName = selectedInstalledDevice.getRealName();
        if (this.acceptCheckBox.isSelected() && deviceName.toUpperCase().equals("SMPLTHETA")) {
            this.peakToleranceField.setEnabled(true);
        } else {
            this.peakToleranceField.setEnabled(false);
        }
    }

    private void setNewValueLabelCalculatedText() {
        Double newValue;
        try {
            double fitResult = Double.parseDouble(this.fitResultLabel.getText());
            double conversionValue = Double.parseDouble(this.conversionField.getText());
            newValue = fitResult * conversionValue;
        }
        catch (NumberFormatException e) {
            newValue = null;
        }
        if (newValue != null) {
            this.newValueLabel.setText(newValue.toString());
            this.setRedefineLatticeButtonEnabledState();
        } else {
            this.newValueLabel.setText("N/A");
            this.setRedefineLatticeButtonEnabledState();
        }
    }

    @Override
    public synchronized void actionPerformed(DeviceValueChangedEvent pce) {
        DevicePair dp;
        Object source;
        Object obj = this.deviceCB.getSelectedItem();
        if (obj == (source = pce.getSource()) && pce.getPropertyName().equals("fixed")) {
            this.determineFindPeakState((InstalledDevice)obj);
        } else if (obj instanceof DevicePair && (source == (dp = (DevicePair)obj).getDependentDevice() || source == dp.getIndependentDevice())) {
            this.determineFindPeakState(dp);
        }
    }

    private void determineFindPeakState(InstalledDevice device) {
        this.findPeakAction.setEnabled(!device.isFixed());
        if (device.isFixed()) {
            this.deviceCB.setForeground(Color.gray);
        } else {
            this.deviceCB.setForeground(Color.black);
        }
    }

    private void determineFindPeakState(DevicePair dp) {
        this.findPeakAction.setEnabled(!dp.getIndependentDevice().isFixed() && !dp.getDependentDevice().isFixed());
        if (dp.getIndependentDevice().isFixed() || dp.getDependentDevice().isFixed()) {
            this.deviceCB.setForeground(Color.gray);
        } else {
            this.deviceCB.setForeground(Color.black);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.storeInputValues();
        this.loadInputValues();
        if (this.deviceCB.getSelectedItem() == null) {
            return;
        }
        this.oldDevice = this.deviceCB.getSelectedItem().toString();
        String units = "";
        if (ae.getSource() == this.deviceCB) {
            Object obj = this.deviceCB.getSelectedItem();
            if (obj instanceof InstalledDevice) {
                units = ((InstalledDevice)obj).getUnits();
                this.deviceListener.changeDeviceAssociation((InstalledDevice)obj);
                this.determineFindPeakState((InstalledDevice)obj);
            } else if (obj instanceof DevicePair) {
                units = ((DevicePair)obj).getIndependentDevice().getUnits();
                this.deviceListener.changeDeviceAssociation(((DevicePair)obj).getIndependentDevice());
                this.determineFindPeakState((DevicePair)obj);
            }
            if (units.equalsIgnoreCase("deg") || units.equalsIgnoreCase("degrees")) {
                units = Global.degreeSign();
            } else if (units.equalsIgnoreCase("None")) {
                units = "";
            }
            this.rangeUnitLabel.setText(units);
            this.peakToleranceUnitLabel.setText(units);
            this.stepSizeUnitLabel.setText(units);
            this.setToleranceFieldEnabledState();
        }
    }

    private void storeInputValues() {
        this.prevValues.put(String.valueOf(this.oldDevice) + "-range", this.rangeField.getText());
        this.prevValues.put(String.valueOf(this.oldDevice) + "-peakTolerance", this.peakToleranceField.getText());
        this.prevValues.put(String.valueOf(this.oldDevice) + "-step", this.stepSizeField.getText());
        this.prevValues.put(String.valueOf(this.oldDevice) + "-duration", this.durationField.getText());
        this.prevValues.put(String.valueOf(this.oldDevice) + "-counter", this.countTypeCB.getSelectedItem().toString());
        if (this.displayCB.getSelectedItem() != null) {
            this.prevValues.put(String.valueOf(this.oldDevice) + "-display", this.displayCB.getSelectedItem().toString());
        } else {
            logger.error("displayCB.getSelectedItem() is null");
        }
    }

    private void loadInputValues() {
        String value = null;
        logger.debug("size: " + this.prevValues.keySet().size());
        if (this.deviceCB.getSelectedItem() == null) {
            this.rangeField.setText("");
            this.peakToleranceField.setText("");
            this.stepSizeField.setText("");
            this.durationField.setText("");
            return;
        }
        value = this.prevValues.get(String.valueOf(this.deviceCB.getSelectedItem().toString()) + "-range");
        if (value == null) {
            try {
                value = this.rb.getString("range." + this.deviceCB.getSelectedItem().toString());
            }
            catch (MissingResourceException mre) {
                try {
                    value = this.rb.getString("range.default");
                }
                catch (MissingResourceException mre2) {
                    value = "";
                }
            }
        }
        this.rangeField.setText(value);
        value = this.prevValues.get(String.valueOf(this.deviceCB.getSelectedItem().toString()) + "-peakToleranceField");
        if (value == null) {
            try {
                value = this.rb.getString("peakTolerance." + this.deviceCB.getSelectedItem().toString());
            }
            catch (MissingResourceException mre) {
                try {
                    value = this.rb.getString("peakTolerance.default");
                }
                catch (MissingResourceException mre2) {
                    value = "";
                }
            }
        }
        this.peakToleranceField.setText(value);
        value = this.prevValues.get(String.valueOf(this.deviceCB.getSelectedItem().toString()) + "-step");
        if (value == null) {
            try {
                value = this.rb.getString("step." + this.deviceCB.getSelectedItem().toString());
            }
            catch (MissingResourceException mre) {
                try {
                    value = this.rb.getString("step.default");
                }
                catch (MissingResourceException mre2) {
                    value = "";
                }
            }
        }
        this.stepSizeField.setText(value);
        value = this.prevValues.get(String.valueOf(this.deviceCB.getSelectedItem().toString()) + "-duration");
        if (value == null) {
            try {
                value = this.rb.getString("duration." + this.deviceCB.getSelectedItem().toString());
            }
            catch (MissingResourceException mre) {
                try {
                    value = this.rb.getString("duration.default");
                }
                catch (MissingResourceException mre2) {
                    value = "";
                }
            }
        }
        this.durationField.setText(value);
        value = this.prevValues.get(String.valueOf(this.deviceCB.getSelectedItem().toString()) + "-counter");
        if (value == null) {
            try {
                value = this.rb.getString("counter." + this.deviceCB.getSelectedItem().toString());
            }
            catch (MissingResourceException mre) {
                try {
                    value = this.rb.getString("counter.default");
                }
                catch (MissingResourceException mre2) {
                    value = "";
                }
            }
        }
        int countTypeCount = this.countTypeCB.getItemCount();
        int i = 0;
        while (i < countTypeCount) {
            if (value.equals(this.countTypeCB.getItemAt(i))) {
                this.countTypeCB.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        value = this.prevValues.get(String.valueOf(this.deviceCB.getSelectedItem().toString()) + "-display");
        if (value == null) {
            try {
                value = this.rb.getString("display." + this.deviceCB.getSelectedItem().toString());
            }
            catch (MissingResourceException mre) {
                value = "";
            }
        }
        int displayCount = this.displayCB.getItemCount();
        int i2 = 0;
        while (i2 < displayCount) {
            if (value.equals(this.displayCB.getItemAt(i2))) {
                this.displayCB.setSelectedIndex(i2);
                break;
            }
            ++i2;
        }
    }

    private void plotGaussian(double startPoint, double endPoint, int numPoints, ArrayList<Double> fitPoints) {
        double stepSize = (endPoint - startPoint) / (double)numPoints;
        double i = startPoint;
        while (i < endPoint) {
            SwingUtilities.invokeLater(new PlotPanel.PlotPoint(this.plot, 1, i, this.getGaussianPoint(fitPoints, i), true, true));
            i += stepSize;
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        this.allDevices = dle.getNewList();
        this.updateDeviceComboBox();
    }

    private void checkScanValidity() {
        try {
            InstalledDevice device;
            Object obj = this.deviceCB.getSelectedItem();
            if (obj instanceof InstalledDevice) {
                device = (InstalledDevice)obj;
            } else if (obj instanceof DevicePair) {
                device = ((DevicePair)obj).getIndependentDevice();
            } else {
                return;
            }
            double range = Double.parseDouble(this.rangeField.getText());
            double stepSize = Double.parseDouble(this.stepSizeField.getText());
            int numPoints = (int)(range / Math.abs(stepSize) + 1.0);
            double startPoint = Double.parseDouble(device.getCurrValue()) - stepSize * (double)(numPoints - 1) / 2.0;
            double finalPoint = startPoint + stepSize * (double)(numPoints - 1);
            logger.debug("start point: " + startPoint);
            logger.debug("final point: " + finalPoint);
            if (startPoint < device.getLowerLimit() || finalPoint > device.getUpperLimit()) {
                this.appendWarningMessage(this.rangeField, "Scan range outside of device limits.");
            } else {
                this.removeWarningMessage(this.rangeField);
            }
        }
        catch (NumberFormatException nfe) {
            logger.error("Invalid number in peak scan field: ", nfe);
        }
    }

    @Override
    public void actionPerformed(FitResultEvent fre) {
        SwingUtilities.invokeLater(new SetFitLabel(String.valueOf(fre.getFitResult())));
        SwingUtilities.invokeLater(new EnableDisableConversionField(true));
    }

    private class AcceptCheckBoxListener
    implements ItemListener {
        private AcceptCheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            PeakScanPanel.this.setToleranceFieldEnabledState();
        }
    }

    private class ConversionFieldListener
    implements DocumentListener {
        private Double newValue = null;

        private ConversionFieldListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            PeakScanPanel.this.setNewValueLabelCalculatedText();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            PeakScanPanel.this.setNewValueLabelCalculatedText();
        }
    }

    private class DevicePair {
        private InstalledDevice independentDevice;
        private InstalledDevice dependentDevice;

        public DevicePair(InstalledDevice independentDevice, InstalledDevice dependentDevice) {
            this.independentDevice = independentDevice;
            this.dependentDevice = dependentDevice;
        }

        public String toString() {
            return String.valueOf(this.dependentDevice.getName()) + "-" + this.independentDevice.getName();
        }

        public InstalledDevice getDependentDevice() {
            return this.dependentDevice;
        }

        public InstalledDevice getIndependentDevice() {
            return this.independentDevice;
        }
    }

    private class EnableDisableConversionField
    implements Runnable {
        private boolean enable;

        public EnableDisableConversionField(boolean enable) {
            this.enable = enable;
        }

        @Override
        public void run() {
            PeakScanPanel.this.conversionField.setEnabled(this.enable);
        }
    }

    private class FindPeakAction
    extends AbstractAction {
        public FindPeakAction() {
            this.putValue("Name", "Find Peak!");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object device = PeakScanPanel.this.deviceCB.getSelectedItem();
            String cmd = "findpeak ";
            String deviceName = null;
            String fitFuncCommandString = "";
            try {
                double range = Double.parseDouble(PeakScanPanel.this.rangeField.getText());
                double stepSize = Double.parseDouble(PeakScanPanel.this.stepSizeField.getText());
                double duration = Double.parseDouble(PeakScanPanel.this.durationField.getText());
                String selectedCounter = (String)PeakScanPanel.this.displayCB.getSelectedItem();
                if (selectedCounter.equals("Mon")) {
                    selectedCounter = "Monitor";
                }
                Double peakTolerance = PeakScanPanel.this.peakToleranceField.isEnabled() && !PeakScanPanel.this.peakToleranceField.getText().equals("") ? Double.valueOf(Double.parseDouble(PeakScanPanel.this.peakToleranceField.getText())) : null;
                if (device instanceof InstalledDevice) {
                    deviceName = ((InstalledDevice)device).getName();
                    cmd = String.valueOf(cmd) + deviceName + " " + range + " " + stepSize + " " + PeakScanPanel.this.countTypeCB.getSelectedItem() + " " + duration + " " + selectedCounter;
                } else if (device instanceof DevicePair) {
                    DevicePair dp = (DevicePair)device;
                    deviceName = dp.getIndependentDevice().getName();
                    String dependentDevice = dp.getDependentDevice().getName();
                    cmd = String.valueOf(cmd) + deviceName + " " + range + " " + stepSize + " " + PeakScanPanel.this.countTypeCB.getSelectedItem() + " " + duration + " " + selectedCounter + " -bragg " + dependentDevice;
                } else {
                    logger.debug("Error, invalid device type selected.  Not a Device or String.  Aborting.");
                    return;
                }
                if (PeakScanPanel.this.acceptCheckBox.isSelected()) {
                    cmd = String.valueOf(cmd) + " -accept";
                    if (peakTolerance != null) {
                        cmd = String.valueOf(cmd) + " -t ";
                        cmd = String.valueOf(cmd) + peakTolerance.toString();
                    }
                }
                fitFuncCommandString = PeakScanPanel.this.fitFuncTypeCB.getCommandString();
                cmd = String.valueOf(cmd) + " " + fitFuncCommandString;
                if (deviceName.equals("A3") || deviceName.equals("A5")) {
                    new SetRedefineDeviceLabelText(deviceName).run();
                    PeakScanPanel.this.redefineDeviceAction.setEnabled(true);
                } else {
                    new SetRedefineDeviceLabelText("N/A").run();
                    PeakScanPanel.this.redefineDeviceAction.setEnabled(false);
                }
                if (PeakScanPanel.this.useHklCB.isSelected()) {
                    cmd = String.valueOf(cmd) + " -hkl " + String.valueOf(PeakScanPanel.this.hklPreset.getH()) + " " + String.valueOf(PeakScanPanel.this.hklPreset.getK()) + " " + String.valueOf(PeakScanPanel.this.hklPreset.getL());
                }
                PeakScanPanel.this.sendManager.addMessage(cmd);
            }
            catch (NumberFormatException nfe) {
                logger.error("Invalid number given.  Aborting and notifying user.");
                this.determineErrorCause(nfe);
            }
        }

        private void determineErrorCause(NumberFormatException nfe) {
            NumberFormat nf = NumberFormat.getInstance();
            String invalidField = "";
            if (nf.parseObject(PeakScanPanel.this.rangeField.getText(), new ParsePosition(0)) == null) {
                invalidField = "range";
            } else if (PeakScanPanel.this.peakToleranceField.isEnabled() && nf.parseObject(PeakScanPanel.this.peakToleranceField.getText(), new ParsePosition(0)) == null) {
                invalidField = "peak tolerance";
            } else if (nf.parseObject(PeakScanPanel.this.stepSizeField.getText(), new ParsePosition(0)) == null) {
                invalidField = "step size";
            } else if (nf.parseObject(PeakScanPanel.this.durationField.getText(), new ParsePosition(0)) == null) {
                invalidField = "duration";
            }
            String message = new String("Invalid number value for " + invalidField + ".");
            PeakScanPanel.this.throwErrorDialog("Invalid number", message);
        }
    }

    private class MoveToFitAction
    extends AbstractAction {
        public MoveToFitAction() {
            this.putValue("Name", "Move To Fit");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            PeakScanPanel.this.sendManager.addMessage("AcceptFindPeak", true);
        }
    }

    public class PeakScanDeviceListener
    implements DeviceValueChangedListener {
        private InstalledDevice device;

        public PeakScanDeviceListener(InstalledDevice device) {
            this.device = device;
            if (device != null) {
                try {
                    this.device.addValueChangeListener(this);
                }
                catch (ICEListenerListExceptionBase e) {
                    logger.error("PeakScanPanel.DeviceLisetner " + e);
                }
            }
        }

        public void changeDeviceAssociation(InstalledDevice device) {
            if (this.device != null) {
                this.device.removeValueChangeListener(this);
            }
            this.device = device;
            if (device != null) {
                try {
                    this.device.addValueChangeListener(this);
                }
                catch (ICEListenerListExceptionBase e) {
                    logger.error("PeakScanPanel.DeviceLisetner.changeDeviceAssociation " + e);
                }
            }
        }

        @Override
        public void actionPerformed(DeviceValueChangedEvent evt) {
            if (evt.getSource() == this.device && evt.getPropertyName().equals("currValue")) {
                PeakScanPanel.this.checkScanValidity();
            }
        }
    }

    private class PeakScanListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public PeakScanListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.setText("");
                this.setBackground(Color.white);
                return this;
            }
            this.setText(value.toString());
            this.setBackground(isSelected ? list.getSelectionBackground() : Color.white);
            if (value instanceof InstalledDevice && ((InstalledDevice)value).isFixed()) {
                this.setForeground(Color.gray);
            } else if (value instanceof DevicePair && (((DevicePair)value).getIndependentDevice().isFixed() || ((DevicePair)value).getDependentDevice().isFixed())) {
                this.setForeground(Color.gray);
            } else {
                this.setForeground(isSelected ? Color.white : Color.black);
            }
            return this;
        }
    }

    private class RedefineDeviceAction
    extends AbstractAction {
        public RedefineDeviceAction() {
            this.putValue("Name", "Redefine");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                double newValue = Double.parseDouble(PeakScanPanel.this.redefineDeviceField.getText());
                String message = "device set " + PeakScanPanel.this.redefineDeviceLabel.getText() + " " + newValue;
                PeakScanPanel.this.sendManager.addMessage(message, true);
            }
            catch (NumberFormatException nfe) {
                PeakScanPanel.this.throwErrorDialog("Invalid Number", "Please enter a valid number for redefinining " + PeakScanPanel.this.redefineDeviceLabel.getText() + ".");
            }
        }
    }

    private class RedefineDeviceChecker
    extends ValidNumberChecker {
        public RedefineDeviceChecker() {
            super(PeakScanPanel.this.redefineDeviceField, "Redefine Device");
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            this.checkValidity();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            this.checkValidity();
        }

        private void checkValidity() {
            boolean error;
            String message;
            block8: {
                if (PeakScanPanel.this.redefineDeviceField.getText().length() == 0) {
                    PeakScanPanel.this.removeErrorMessage(PeakScanPanel.this.redefineDeviceField);
                    return;
                }
                message = "";
                error = false;
                try {
                    double newValue = Double.parseDouble(PeakScanPanel.this.redefineDeviceField.getText());
                    try {
                        if (PeakScanPanel.this.deviceOfInterest != null && (newValue < PeakScanPanel.this.deviceOfInterest.getLowerLimit() || newValue > PeakScanPanel.this.deviceOfInterest.getUpperLimit())) {
                            error = true;
                            message = "Value outside of device's limits!";
                        }
                    }
                    catch (NullPointerException npe) {
                        logger.error("Redefine device null.  Ignoring.", npe);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (PeakScanPanel.this.errorMessages.containsKey(PeakScanPanel.this.redefineDeviceField)) break block8;
                    error = true;
                    message = "Invalid number for Redefine Device field!";
                }
            }
            if (error) {
                PeakScanPanel.this.appendErrorMessage(PeakScanPanel.this.redefineDeviceField, message);
            } else {
                PeakScanPanel.this.removeErrorMessage(PeakScanPanel.this.redefineDeviceField);
            }
        }
    }

    private class RedefineLatticeParamsAction
    extends AbstractAction
    implements ItemListener {
        public RedefineLatticeParamsAction() {
            super("Redefine Lattice Parameters");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            StringBuffer commandBuffer = new StringBuffer("CorrectLattice");
            commandBuffer.append(" ");
            commandBuffer.append(PeakScanPanel.this.conversionField.getText());
            if (PeakScanPanel.this.aCB.isSelected()) {
                commandBuffer.append(" -a");
            }
            if (PeakScanPanel.this.bCB.isSelected()) {
                commandBuffer.append(" -b");
            }
            if (PeakScanPanel.this.cCB.isSelected()) {
                commandBuffer.append(" -c");
            }
            String commandString = commandBuffer.toString();
            PeakScanPanel.this.sendManager.addMessage(commandString, true);
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            PeakScanPanel.this.setRedefineLatticeButtonEnabledState();
        }
    }

    private class SetFitLabel
    implements Runnable {
        private String fitValue;

        public SetFitLabel(String fitValue) {
            this.fitValue = fitValue;
        }

        @Override
        public void run() {
            try {
                float fitValueAsFloat = Float.valueOf(this.fitValue).floatValue();
                if ((double)fitValueAsFloat == -1.0) {
                    PeakScanPanel.this.fitResultLabel.setText("N/A");
                } else {
                    PeakScanPanel.this.fitResultLabel.setText(this.fitValue);
                }
            }
            catch (NumberFormatException e) {
                PeakScanPanel.this.fitResultLabel.setText("N/A");
            }
            PeakScanPanel.this.setNewValueLabelCalculatedText();
        }
    }

    private class SetRedefineDeviceLabelText
    implements Runnable {
        private String text;

        public SetRedefineDeviceLabelText(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            PeakScanPanel.this.redefineDeviceLabel.setText(this.text);
        }
    }

    protected class ValidNumberChecker
    implements DocumentListener {
        private JTextField textField;
        private String compName;

        public ValidNumberChecker(JTextField textField, String compName) {
            this.textField = textField;
            this.compName = compName;
            textField.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            if (this.checkNumberValidity()) {
                PeakScanPanel.this.checkScanValidity();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            if (this.checkNumberValidity()) {
                PeakScanPanel.this.checkScanValidity();
            }
        }

        protected boolean checkNumberValidity() {
            if (this.textField.getText().length() == 0) {
                PeakScanPanel.this.removeErrorMessage(this.textField);
                return true;
            }
            try {
                Double.parseDouble(this.textField.getText());
                PeakScanPanel.this.removeErrorMessage(this.textField);
                return true;
            }
            catch (NumberFormatException nfe) {
                if (!PeakScanPanel.this.errorMessages.containsKey(this.textField)) {
                    PeakScanPanel.this.appendErrorMessage(this.textField, "Invalid number for " + this.compName + " field!");
                }
                return false;
            }
        }
    }
}

