/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels.autodata;

import ice.IcePanelManager;
import ice.event.IceClientErrorEvent;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceDialog;
import ice.gui.panel.sans.data.SansScan;
import ice.gui.panel.sans.subpanels.autodata.RunListTable;
import ice.gui.panel.sans.subpanels.autodata.RunPropertiesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.JFrame;

public class RunPropertiesDialog
extends IceDialog {
    private static final String TITLE_KEY = "Run Properties";
    private static final long serialVersionUID = 1L;
    private static RunPropertiesDialog instance;
    private RunPropertiesPanel controlPanel;
    private RunListTable tableControl;

    private RunPropertiesDialog(Frame arg0, RunListTable control) throws HeadlessException, IcePanelException {
        super(arg0);
        this.init(control);
    }

    private void init(RunListTable control) throws IcePanelException {
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.controlPanel = new RunPropertiesPanel();
        this.add((Component)this.controlPanel, "Center");
        this.tableControl = control;
        this.pack();
    }

    private void populateFields(SansScan scan) {
        this.controlPanel.populateFields(scan);
    }

    public static RunPropertiesDialog getInstance(JFrame parent, SansScan scan, RunListTable tableControl) {
        if (instance == null) {
            try {
                instance = new RunPropertiesDialog((Frame)parent, tableControl);
            }
            catch (HeadlessException e) {
                e.printStackTrace();
            }
            catch (IcePanelException e) {
                IceClientErrorEvent event = new IceClientErrorEvent(parent, e);
                IcePanelManager panelManager = IcePanelManager.getReference();
                panelManager.notifyIceClientErrorListeners(event);
            }
        }
        if (instance != null) {
            instance.centerOnParent();
            instance.populateFields(scan);
            instance.setVisible(true);
        }
        return instance;
    }

    public static RunPropertiesDialog getInstance() {
        return instance;
    }

    public void loadPrevScan(int selBuffer) {
        SansScan prevScan = this.tableControl.getPrevScan(selBuffer);
        instance.populateFields(prevScan);
    }

    public void loadNextScan(int selBuffer) {
        SansScan nextScan = this.tableControl.getNextScan(selBuffer);
        instance.populateFields(nextScan);
    }
}

