/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels.autodata;

import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.actions.SansButtonAction;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.subpanels.autodata.RangeDialog;
import ice.swing.buttons.KeyResponseButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class RangePanel
extends SansIcePanel {
    private static final String title = "Please select a range of runs.";
    private static final String close = "Cancel";
    private KeyResponseButton actionButton;
    private KeyResponseButton cancelButton;
    private JTextField lowTextField;
    private JTextField highTextField;
    private JLabel fromLabel;
    private JLabel toLabel;
    private JTable runListTable;
    private RangeDialog parent;

    public RangePanel(RangeDialog parent, JTable table) throws IcePanelException {
        super(title, title);
        this.parent = parent;
        this.runListTable = table;
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(600, 300));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int y = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, gridBagConstraints);
        this.fromLabel.setText("runs");
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.fromLabel, gridBagConstraints);
        this.lowTextField.setText("0");
        this.lowTextField.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = y;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.lowTextField, gridBagConstraints);
        this.toLabel.setText("through");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = y;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.toLabel, gridBagConstraints);
        this.highTextField.setText("0");
        this.highTextField.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.highTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        this.add((Component)this.actionButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        this.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.gridwidth = 4;
        this.add((Component)this.helpPanel, gridBagConstraints);
    }

    public void listenToButtons(ActionListener l) {
        this.actionButton.addActionListener(l);
        this.cancelButton.addActionListener(l);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.helpPanel = new HelpPanel();
        this.actionButton = new KeyResponseButton();
        this.cancelButton = new KeyResponseButton(close, close, 27);
        this.lowTextField = new JTextField();
        this.highTextField = new JTextField();
        this.fromLabel = new JLabel();
        this.toLabel = new JLabel();
        this.lowTextField.addFocusListener(new RangeFocusListener());
    }

    public void populateRangePanel(int low, int high, SansButtonAction action) {
        this.lowTextField.setText(String.valueOf(low));
        this.highTextField.setText(String.valueOf(high));
        Integer keyStroke = action.getKeyStroke();
        String name = action.getName();
        if (keyStroke != -1) {
            this.actionButton.bindKey(name, keyStroke);
        }
        action.setRangePanel(this);
        this.actionButton.setText(name);
        ActionListener[] actionListenerArray = this.actionButton.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener l = actionListenerArray[n2];
            this.actionButton.removeActionListener(l);
            ++n2;
        }
        this.actionButton.addActionListener(action);
        this.actionButton.requestFocusInWindow();
    }

    public void setLowRangeValue(int low) {
        this.lowTextField.setText(String.valueOf(low));
    }

    public String getLowRangeValue() {
        return this.lowTextField.getText();
    }

    public void setHighRangleValue(int high) {
        this.highTextField.setText(String.valueOf(high));
    }

    public String getHighRangeValue() {
        return this.highTextField.getText();
    }

    public JTable getRunListTable() {
        return this.runListTable;
    }

    @Override
    public void updateDeviceControls() {
    }

    private class RangeFocusListener
    implements FocusListener {
        private RangeFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            int to;
            String fromValue = RangePanel.this.lowTextField.getText();
            int from = Integer.valueOf(fromValue);
            if (from > (to = Integer.valueOf(RangePanel.this.highTextField.getText()).intValue())) {
                RangePanel.this.highTextField.setText(fromValue);
            }
        }
    }
}

