/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels.autodata;

import ice.event.DeviceListListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.FilePrefixSansScanDeviceControlPanel;
import ice.gui.panel.sans.controls.SampleLabelSansScanDeviceControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.SansScanDeviceComboBoxControlPanel;
import ice.gui.panel.sans.controls.SansScanDeviceControlPanel;
import ice.gui.panel.sans.controls.SansScanDeviceDoubleControlPanel;
import ice.gui.panel.sans.controls.SansScanTempDeviceControPanel;
import ice.gui.panel.sans.controls.buttons.PatchPropertiesButtonControlPanel;
import ice.gui.panel.sans.data.SansScan;
import ice.gui.panel.sans.subpanels.autodata.RunPropertiesPanel;

public class PatchPropertiesPanel
extends RunPropertiesPanel
implements DeviceListListener {
    private static final String title = "PATCH RUN PROPERTIES";
    private String start;
    private String end;

    public PatchPropertiesPanel() throws IcePanelException {
        super(title);
    }

    public void setBufferRange(String start, String end) {
        this.clearPanel();
        this.start = start;
        this.end = end;
        this.runBuffer.setText("Run Buffers " + start + " through " + end);
    }

    @Override
    protected void instanciateControls() {
        this.sampleLabel = new SampleLabelSansScanDeviceControlPanel("Sample Label", "Comment");
        this.filePrefix = new FilePrefixSansScanDeviceControlPanel("File Prefix", "FileName");
        this.sampleThick = new SansScanDeviceDoubleControlPanel("Sample Thickness", "Thk", SansScan.DeviceType.sample);
        this.sampleTrans = new SansScanDeviceDoubleControlPanel("Sample Transmission", "Trans", SansScan.DeviceType.sample);
        this.countIntTime = new SansScanDeviceDoubleControlPanel("Counting Interval Time", "Counts");
        this.countIntvls = new SansScanDeviceDoubleControlPanel("No. of Count Intevals", "Prefac");
        this.samplePos = new SansScanDeviceDoubleControlPanel("Sample Position", "SamplePosition", SansScan.DeviceType.angle);
        this.huberPos = new SansScanDeviceDoubleControlPanel("Huber Position", "HuberTranslation", SansScan.DeviceType.angle);
        this.sampleRot = new SansScanDeviceDoubleControlPanel("Sample Rotation", "SampleRotation", SansScan.DeviceType.angle);
        this.huberRot = new SansScanDeviceDoubleControlPanel("Huber Rotation", "HuberRotation", SansScan.DeviceType.angle);
        this.tempSetPt = new SansScanTempDeviceControPanel("Temp. Set Point", "Temp", SansScan.DeviceType.angle);
        this.tempSetPt.setScanName("Temp");
        this.tempSetPtErr = new SansScanDeviceDoubleControlPanel("Temp. Set Point Error ", "Temp Tolerance", SansScan.DeviceType.preset_temp_tol);
        this.tempHoldTime = new SansScanDeviceDoubleControlPanel("Temp. Hold Time (min)", "HoldTime");
        this.tempTimeOut = new SansScanDeviceDoubleControlPanel("Temp. Timeout (min)", "Temp Timeout", SansScan.DeviceType.preset_temp_timeout);
        ((SansScanTempDeviceControPanel)this.tempSetPt).addPropertyControl(this.tempSetPtErr);
        ((SansScanTempDeviceControPanel)this.tempSetPt).addPropertyControl(this.tempHoldTime);
        ((SansScanTempDeviceControPanel)this.tempSetPt).addPropertyControl(this.tempTimeOut);
        this.configureTemperatureControl();
        this.magneticField = new SansScanDeviceDoubleControlPanel("Magnetic Field (Units)", "MagField", SansScan.DeviceType.angle);
        this.configureCurrentMagnetControl();
        this.magnetCurrent = new SansScanDeviceDoubleControlPanel("Magnet Current (Amps)", "LMC", SansScan.DeviceType.angle);
        this.magnetCurrent.setSaveToScan(false);
        this.rheoPulses = new SansScanDeviceDoubleControlPanel("Rheometer Pulses", "RheoPulses");
        this.waveLength = new SansScanDeviceDoubleControlPanel("Neutron Wavelength", "Wavelength", SansScan.DeviceType.angle);
        this.waveLSpread = new SansScanDeviceDoubleControlPanel("Wavelength Spread", "WavelengthSpread", SansScan.DeviceType.angle);
        this.flipper = new SansScanDeviceComboBoxControlPanel("Flipper", "Flipper", SansScan.DeviceType.angle);
        this.flipperHorizCurrent = new SansScanDeviceDoubleControlPanel("Horiz. Current", "FlipperHorizCurrent", SansScan.DeviceType.angle);
        this.flipperVertCurrent = new SansScanDeviceDoubleControlPanel("Vert. Current", "FlipperVertCurrent", SansScan.DeviceType.angle);
        this.atten = new SansScanDeviceComboBoxControlPanel("Attenuators", "Attenuator", SansScan.DeviceType.angle);
        this.detDist = new SansScanDeviceDoubleControlPanel("Detector Distance", "DetectorPos", SansScan.DeviceType.angle);
        this.detOff = new SansScanDeviceDoubleControlPanel("Detector Offset", "DetectorOffset", SansScan.DeviceType.angle);
        this.bmStp = new SansScanDeviceComboBoxControlPanel("Beam Stop Size", "BeamStop", SansScan.DeviceType.angle);
        this.bmStpX = new SansScanDeviceDoubleControlPanel("Beam Stop X Position", "BeamStopX", SansScan.DeviceType.angle);
        this.bmStpY = new SansScanDeviceDoubleControlPanel("Beam Stop Y Position", "BeamStopY", SansScan.DeviceType.angle);
        this.bmCtrX = new SansScanDeviceDoubleControlPanel("Beam Center X Position", "BeamCenterX", SansScan.DeviceType.angle);
        this.bmCtrY = new SansScanDeviceDoubleControlPanel("Beam Center Y Position", "BeamCenterY", SansScan.DeviceType.angle);
    }

    @Override
    public String getScanDescription() {
        String scan = "";
        String delim = ",";
        for (SansDeviceControlPanel control : this.controls) {
            SansScanDeviceControlPanel scanControl;
            if (!(control instanceof SansScanDeviceControlPanel) || !(scanControl = (SansScanDeviceControlPanel)control).isSaveToScan() || scanControl.isDisabled() || control.isFixed()) continue;
            String prefix = "";
            SansScan.DeviceType type = control.getDeviceType();
            String deviceValue = scanControl.getCurrentValue();
            if (deviceValue.equals("")) continue;
            String deviceName = scanControl.getScanName();
            switch (type) {
                case angle: {
                    prefix = "Angle=" + deviceName + "=";
                    break;
                }
                case preset_temp_timeout: {
                    prefix = "PresetDevicesProperties=Temp timeout ";
                    break;
                }
                case preset_temp_tol: {
                    prefix = "PresetDevicesProperties=Temp tolerance ";
                    break;
                }
                case sample: {
                    prefix = "Sample=" + deviceName + "=";
                    break;
                }
                case other: {
                    prefix = String.valueOf(deviceName) + "=";
                }
            }
            String value = "";
            if (deviceName.equals("Temp Timeout")) {
                Double timeout = Double.valueOf(deviceValue) * 60.0;
                value = String.valueOf(prefix) + timeout.toString();
            } else if (deviceName.equals("GuideTable")) {
                if (!deviceValue.equals("0")) {
                    String guides = "";
                    value = String.valueOf(prefix) + deviceValue + guides;
                } else {
                    value = String.valueOf(prefix) + deviceValue;
                }
            } else {
                value = !((deviceValue = deviceValue.replaceAll("\"", "\\\\\"")).indexOf("\n") < 0 && deviceValue.indexOf(" ") < 0 && deviceValue.indexOf(":") < 0 || deviceValue.startsWith("\"") && deviceValue.endsWith("\"")) ? String.valueOf(prefix) + "\"" + deviceValue + "\"" : String.valueOf(prefix) + deviceValue;
            }
            scan = String.valueOf(scan) + value + delim;
        }
        int index = scan.lastIndexOf(44);
        if (index != -1) {
            scan = scan.substring(0, index);
        }
        return scan;
    }

    @Override
    protected void init() {
        super.init();
        this.buttonPanel = new PatchPropertiesButtonControlPanel(this);
        for (SansDeviceControlPanel control : this.controls) {
            if (!(control instanceof SansScanDeviceComboBoxControlPanel)) continue;
            SansScanDeviceComboBoxControlPanel comboControl = (SansScanDeviceComboBoxControlPanel)control;
            comboControl.addItem("");
        }
    }

    public String getStartRange() {
        return this.start;
    }

    public String getEndRange() {
        return this.end;
    }

    @Override
    public void clearPanel() {
        for (SansDeviceControlPanel sansControl : this.controls) {
            if (sansControl.isFixed() || sansControl.isDisabled()) continue;
            sansControl.setCurrentValue("");
        }
    }
}

