/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.DeviceAddCommand;
import ice.commands.DeviceDestroyCommand;
import ice.commands.DeviceSetPropertyCommand;
import ice.commands.MoveCommand;
import ice.communication.SendQueueManager;
import ice.data.AvailableEnvDevice;
import ice.data.AvailableMagnetDevice;
import ice.data.AvailableMiscDevice;
import ice.data.AvailablePressureDevice;
import ice.data.AvailableTempDevice;
import ice.data.InstalledDevice;
import ice.data.InstalledEnvDevice;
import ice.data.InstalledMagnetDevice;
import ice.event.AvailableDeviceEvent;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.NumberOutOfRangeListener;
import ice.event.communication.AvailableDeviceListListener;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.event.communication.EmptyDocumentListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.controls.SansDeviceComboBoxControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlDoubleNoScalePanel;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.buttons.SampleMagneticFieldButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.subpanels.SansPanelController;
import ice.gui.panel.sans.swing.SANSDecimalFormattedTextField;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class SampleMagneticField
extends SansIcePanel
implements ActionListener,
KeyListener,
DeviceListListener,
AvailableDeviceListListener,
DeviceValueChangedListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("ErrorLogger");
    public static final String SANS_MAGNET_ALIAS = "MagField";
    private static final String MAGNET_PANEL_TITLE = "Sample Magnetic Field";
    public static final String PROPERTY_MAXMAGFIELD = "POSSOFTLIMIT";
    public static final String PROPERTY_MINMAGFIELD = "NEGSOFTLIMIT";
    public static final String DUMMYMAG_NAME = "DUMMYMAGNET";
    public static final String SET_ACTION = "SET_ACTION";
    protected static final String NA_ITEM_TEXT = "NA";
    protected static final String NA_DEVICE_NAME = "DummyMagnet";
    protected static final String MAGNETIC_FIELD_CONTROL_NAME = "Magnetic Field";
    public static final String NOT_ATTACHED_LABEL = "ERR No Magnet Dev Set";
    public static final String NOT_ATTACHED_ERROR = "There is no magnet device set as the standard magnet device (MagField).";
    protected List<AvailableMagnetDevice> availableDeviceList;
    protected MagnetDeviceSelectionPanel currentMagnetDeviceSelectionPanel;
    protected SansDeviceComboBoxControlPanel persistenceMode;
    protected SansDeviceControlDoubleNoScalePanel magneticFieldValuePanel;
    protected SansDeviceControlDoubleNoScalePanel magPosLimitPanel;
    protected SansDeviceControlDoubleNoScalePanel magNegLimitPanel;
    protected String rememberCurrentSelection;
    protected InstalledDevice currentMagnetDevice;
    protected String currentMagnetDeviceName;
    private SampleMagneticFieldButtonControlPanel buttonPanel;

    public SampleMagneticField() throws IcePanelException {
        super(SANS_MAGNET_ALIAS, MAGNET_PANEL_TITLE);
    }

    public SampleMagneticField(String panelName, String panelTitle) throws IcePanelException {
        super(panelName, panelTitle);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.anchor = 18;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.currentMagnetDeviceSelectionPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.anchor = 18;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.magneticFieldValuePanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.anchor = 18;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.magPosLimitPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.anchor = 18;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.magNegLimitPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.anchor = 18;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.persistenceMode, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.buttonPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.readButtonHintFromHelpPreferenceFile(this);
        this.readPanelHintsFromPreferenceFile();
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.helpPanel = new HelpPanel();
        this.buttonPanel = new SampleMagneticFieldButtonControlPanel(this);
        this.buttonPanel.enableF17Move(false);
        this.buttonPanel.addActionListener(this);
        String[] persistenceItems = new String[]{"", "Yes", "No"};
        this.currentMagnetDeviceSelectionPanel = new MagnetDeviceSelectionPanel("Current Magnet", SANS_MAGNET_ALIAS, true);
        this.persistenceMode = new SansDeviceComboBoxControlPanel("Persistence mode", SANS_MAGNET_ALIAS, false);
        this.persistenceMode.addItems(persistenceItems);
        this.magneticFieldValuePanel = new SansDeviceControlDoubleNoScalePanel(MAGNETIC_FIELD_CONTROL_NAME, SANS_MAGNET_ALIAS, false);
        this.magneticFieldValuePanel.listenToTargetEmptyDocumentEvent(this);
        this.magPosLimitPanel = new SansDeviceControlDoubleNoScalePanel("Maximum Magnetic field", SANS_MAGNET_ALIAS, false);
        this.magNegLimitPanel = new SansDeviceControlDoubleNoScalePanel("Minimum Magnetic field", SANS_MAGNET_ALIAS, false);
        Controller controller = null;
        SendQueueManager sendManager = null;
        controller = Controller.getReference();
        try {
            controller.getCommMgr().addAvailableDeviceListListener(this.currentMagnetDeviceSelectionPanel);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("Error adding device list listener.", e);
        }
        sendManager = controller.getSendManager();
        controller.getDeviceListeners().add(this);
        this.findCurrentMagnetDevicesByAlias();
        sendManager.addMessage("ask GETAVAILABLEDEVICEDEFAULTS getdevicedefaults magnet", false);
        sendManager.addMessage("ask GETAVAILABLEDEVICEDEFAULTS getdevicedefaults electromagnet", false);
        this.buildGUI();
        this.readControlKeysFromHelpPreferenceFile();
    }

    @Override
    public void documentChanged(EmptyDocumentListener.EmptyDocumentEvent e) {
        super.documentChanged(e);
        SANSDecimalFormattedTextField textField = (SANSDecimalFormattedTextField)e.getSource();
        SansDeviceControlDoubleNoScalePanel parent = (SansDeviceControlDoubleNoScalePanel)textField.getParent();
        String name = parent.getControlName();
        EmptyDocumentListener.EmptyDocumentState state = e.getState();
        NumberOutOfRangeListener.NumberRange inRange = NumberOutOfRangeListener.NumberRange.IN_RANGE;
        boolean buttonOn = false;
        if (state == EmptyDocumentListener.EmptyDocumentState.FORMATTING) {
            return;
        }
        inRange = textField.inRange();
        boolean bl = buttonOn = state == EmptyDocumentListener.EmptyDocumentState.HAS_TEXT && inRange != NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE;
        if (name != null && name.equals(MAGNETIC_FIELD_CONTROL_NAME)) {
            this.buttonPanel.enableF17Move(buttonOn);
        }
    }

    protected void findCurrentMagnetDevicesByAlias() {
        Controller controller = Controller.getReference();
        InstalledDevice currMagDevice = controller.getDeviceParent(SANS_MAGNET_ALIAS);
        this.currentMagnetDeviceName = currMagDevice != null ? currMagDevice.getRealName() : null;
        if (currMagDevice != null && this.currentMagnetDeviceName != null && this.currentMagnetDeviceName.equalsIgnoreCase(DUMMYMAG_NAME)) {
            if (currMagDevice instanceof InstalledMagnetDevice) {
                if (this.currentMagnetDevice != null && this.currentMagnetDevice != currMagDevice) {
                    this.stopListeningForDeviceErrors(this.currentMagnetDeviceName);
                    this.currentMagnetDevice.removeValueChangeListener(this);
                }
                this.currentMagnetDevice = (InstalledMagnetDevice)currMagDevice;
                this.listenForDeviceErrors(this.currentMagnetDeviceName);
                this.errorPanel.clearErrors();
                if (this.currentMagnetDevice.isBroken().booleanValue()) {
                    this.setValuesFrom(null);
                } else {
                    this.setValuesFrom(this.currentMagnetDevice);
                }
                this.setInputControlsEnabled(false);
                this.currentMagnetDeviceSelectionPanel.setCurrentValue(NA_ITEM_TEXT);
            } else {
                if (this.currentMagnetDevice != null && this.currentMagnetDevice != currMagDevice) {
                    this.stopListeningForDeviceErrors(this.currentMagnetDeviceName);
                    if (this.currentMagnetDevice != null) {
                        this.currentMagnetDevice.removeValueChangeListener(this);
                    }
                }
                this.currentMagnetDevice = null;
                this.listenForDeviceErrors(this.currentMagnetDeviceName);
                this.errorPanel.clearErrors();
                this.setValuesFrom(null);
                this.setInputControlsEnabled(false);
                this.currentMagnetDeviceSelectionPanel.setCurrentValue(NA_ITEM_TEXT);
            }
        } else if (currMagDevice != null && controller.getDevice(this.currentMagnetDeviceName).getType() == InstalledDevice.Type.environment) {
            if (this.currentMagnetDevice != null && this.currentMagnetDevice != controller.getDevice(this.currentMagnetDeviceName)) {
                this.currentMagnetDevice.removeValueChangeListener(this);
                this.stopListeningForDeviceErrors(this.currentMagnetDeviceName);
            }
            this.currentMagnetDevice = controller.getDevice(this.currentMagnetDeviceName);
            this.errorPanel.clearErrors();
            try {
                this.currentMagnetDevice.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("Error adding value change listener to magnet controller.", e);
                this.errorPanel.setError(e.getMessage());
            }
            this.listenForDeviceErrors(this.currentMagnetDeviceName);
            if (this.currentMagnetDevice.isBroken().booleanValue()) {
                this.setValuesFrom(null);
                this.setInputControlsEnabled(false);
            } else {
                this.setValuesFrom(this.currentMagnetDevice);
                this.setInputControlsEnabled(true);
            }
        } else if (this.currentMagnetDeviceName != null && this.currentMagnetDeviceName.equalsIgnoreCase(DUMMYMAG_NAME)) {
            if (this.currentMagnetDevice != null) {
                this.currentMagnetDevice.removeValueChangeListener(this);
                this.stopListeningForDeviceErrors(this.currentMagnetDeviceName);
            }
            this.currentMagnetDevice = null;
            this.setInputControlsEnabled(false);
            this.errorPanel.clearErrors();
            this.listenForDeviceErrors(this.currentMagnetDeviceName);
            this.currentMagnetDeviceSelectionPanel.setCurrentValue(NA_ITEM_TEXT);
        } else {
            if (this.currentMagnetDevice != null) {
                this.currentMagnetDevice.removeValueChangeListener(this);
                this.stopListeningForDeviceErrors(this.currentMagnetDeviceName);
            }
            this.currentMagnetDevice = null;
            this.setInputControlsEnabled(false);
            this.errorPanel.clearErrors();
            this.currentMagnetDeviceSelectionPanel.setCurrentValue(NOT_ATTACHED_LABEL);
            this.errorPanel.appendError(NOT_ATTACHED_ERROR);
            this.setValuesFrom(null);
            this.setInputControlsEnabled(false);
        }
    }

    protected void setInputControlsEnabled(boolean enabled) {
        this.magneticFieldValuePanel.setEnabled(enabled);
        this.magPosLimitPanel.setEnabled(enabled);
        this.magNegLimitPanel.setEnabled(enabled);
        if (!enabled) {
            this.magneticFieldValuePanel.setTargetValue("");
            this.persistenceMode.setTargetValue("");
        }
    }

    protected void setValuesFrom(InstalledDevice theDevice) {
        String deviceName = "";
        String currentValue = "";
        String units = "";
        String persistanceMode = "";
        String upperLimit = "";
        String lowerLimit = "";
        boolean persistenceFlag = false;
        if (theDevice != null) {
            deviceName = theDevice.getRealName();
            currentValue = theDevice.getCurrValue();
            units = theDevice.getUnits();
            upperLimit = String.valueOf(theDevice.getUpperLimit());
            lowerLimit = String.valueOf(theDevice.getLowerLimit());
            if (theDevice instanceof InstalledMagnetDevice && theDevice.getName() != DUMMYMAG_NAME) {
                persistenceFlag = ((InstalledMagnetDevice)theDevice).isMagnetPSFlag();
                Boolean mode = ((InstalledMagnetDevice)theDevice).isPersistenceMode();
                String string = persistanceMode = mode != false ? "Yes" : "No";
                if (persistenceFlag) {
                    this.persistenceMode.setEnabled(true);
                } else {
                    this.persistenceMode.setEnabled(false);
                }
            } else if (theDevice instanceof InstalledEnvDevice && theDevice.getName() != DUMMYMAG_NAME) {
                this.setInputControlsEnabled(true);
                this.persistenceMode.setEnabled(false);
            } else {
                this.setInputControlsEnabled(false);
                this.persistenceMode.setEnabled(false);
            }
        } else {
            this.setInputControlsEnabled(false);
            this.persistenceMode.setEnabled(false);
        }
        this.currentMagnetDeviceSelectionPanel.setCurrentValue(deviceName);
        this.magneticFieldValuePanel.setCurrentValue(currentValue);
        this.magneticFieldValuePanel.setCurrentUnits(units);
        this.magneticFieldValuePanel.setTargetUnits(units);
        this.magPosLimitPanel.setCurrentValue(upperLimit);
        this.magPosLimitPanel.setCurrentUnits(units);
        this.magPosLimitPanel.setTargetUnits(units);
        this.magNegLimitPanel.setCurrentValue(lowerLimit);
        this.magNegLimitPanel.setCurrentUnits(units);
        this.magNegLimitPanel.setTargetUnits(units);
        this.persistenceMode.setCurrentValue(persistanceMode);
        if (currentValue.equals("")) {
            KeyListener[] keyListeners;
            KeyListener[] keyListenerArray = keyListeners = this.getTargetsKeyListeners();
            int n = keyListeners.length;
            int n2 = 0;
            while (n2 < n) {
                KeyListener l = keyListenerArray[n2];
                if (l instanceof SampleMagneticField) {
                    KeyEvent e = new KeyEvent(this, 0, 0L, 0, 0, 'a');
                    l.keyReleased(e);
                }
                ++n2;
            }
        }
    }

    protected void moveMagController() {
        block12: {
            if (this.currentMagnetDevice == null) {
                return;
            }
            MoveCommand moveCommand = null;
            String magField = null;
            String upperLimit = null;
            String lowerLimit = null;
            String persistenceMode = null;
            magField = this.magneticFieldValuePanel.getTargetValue();
            upperLimit = this.magPosLimitPanel.getTargetValue();
            lowerLimit = this.magNegLimitPanel.getTargetValue();
            persistenceMode = this.persistenceMode.getTargetValue();
            if (this.currentMagnetDevice.getRealName() != null) {
                boolean succeeded = false;
                try {
                    try {
                        Hashtable<String, String> properties = new Hashtable<String, String>();
                        if (magField == null || magField.equals("")) break block12;
                        try {
                            double newPosition = Double.parseDouble(magField);
                            properties.put("posSoftLimit", upperLimit);
                            properties.put("negSoftLimit", lowerLimit);
                            if (this.currentMagnetDevice instanceof InstalledMagnetDevice && ((InstalledMagnetDevice)this.currentMagnetDevice).isMagnetPSFlag()) {
                                properties.put("persistenceMode", persistenceMode);
                            }
                            String value = null;
                            Set keys = null;
                            keys = properties.keySet();
                            for (String key : keys) {
                                value = (String)properties.get(key);
                                if (value == null || value.equals("")) continue;
                                DeviceSetPropertyCommand deviceSetPropertyCommand = new DeviceSetPropertyCommand(this.currentMagnetDevice.getRealName(), key, value);
                                deviceSetPropertyCommand.runAsynchronous();
                                boolean bl = succeeded = !deviceSetPropertyCommand.isError() && deviceSetPropertyCommand.isSuccess();
                                if (succeeded) continue;
                                this.errorPanel.setError(deviceSetPropertyCommand.getResponse());
                            }
                            properties = null;
                            moveCommand = new MoveCommand(this.currentMagnetDevice.getRealName(), newPosition, properties);
                            moveCommand.runAsynchronous();
                            boolean bl = succeeded = !moveCommand.isError() && moveCommand.isSuccess();
                            if (!succeeded) {
                                this.errorPanel.setError(moveCommand.getResponse());
                            }
                        }
                        catch (NumberFormatException e) {
                            this.errorPanel.setError("Internal ICE error: " + e.toString());
                        }
                    }
                    catch (NoClientAPIInstanceException e) {
                        this.errorPanel.setError("Internal ICE error: " + e.toString());
                        this.clearTargets();
                        this.buttonPanel.enableF17Move(false);
                    }
                }
                finally {
                    this.clearTargets();
                    this.buttonPanel.enableF17Move(false);
                }
            }
        }
    }

    public void clearTargets() {
        this.magneticFieldValuePanel.setTargetValue("");
        this.magPosLimitPanel.setTargetValue("");
        this.magNegLimitPanel.setTargetValue("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = null;
        source = e.getSource();
        if (source instanceof JButton) {
            String actionCommand = null;
            actionCommand = e.getActionCommand();
            this.findCurrentMagnetDevicesByAlias();
            if (actionCommand.equalsIgnoreCase("MOVETOTARGET")) {
                this.moveMagController();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        String targetTemp = null;
        boolean disableMoveButton = false;
        targetTemp = this.magneticFieldValuePanel.getTargetValue();
        disableMoveButton = (targetTemp = targetTemp.trim()) == null || targetTemp.equals("");
        this.buttonPanel.enableF17Move(!disableMoveButton);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public KeyListener[] getTargetsKeyListeners() {
        KeyListener[] keyListeners = null;
        keyListeners = this.magneticFieldValuePanel.getTargetsKeyListeners();
        return keyListeners;
    }

    @Override
    public void updateDeviceControls() {
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        this.findCurrentMagnetDevicesByAlias();
    }

    public void readControlKeysFromHelpPreferenceFile() {
        Component[] components;
        if (SansPanelController.writeHelpKeys) {
            return;
        }
        Component[] componentArray = components = this.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof SansDeviceControlPanel) {
                SansDeviceControlPanel control = (SansDeviceControlPanel)comp;
                control.readHintsFromPreferenceFile();
            }
            ++n2;
        }
    }

    public void receiveAvailableMagnetDevices(List<AvailableMagnetDevice> devices) {
    }

    public void receiveAvailableOtherDevices(List<AvailableMiscDevice> devices) {
    }

    public void receiveAvailablePressureDevices(List<AvailablePressureDevice> devices) {
    }

    public void receiveAvailableTempDevices(List<AvailableTempDevice> devices) {
    }

    @Override
    public void actionPerformed(AvailableDeviceEvent availableDeviceEvent) {
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent dvce) {
        this.findCurrentMagnetDevicesByAlias();
    }

    @Override
    public boolean requestFocusInIceWindow() {
        this.findCurrentMagnetDevicesByAlias();
        return true;
    }

    protected class MagnetDeviceSelectionPanel
    extends SansDeviceComboBoxControlPanel
    implements ActionListener,
    AvailableDeviceListListener {
        private static final long serialVersionUID = 1L;
        protected JButton setButton;
        protected List<String> magDevNameList;

        public MagnetDeviceSelectionPanel(String name, String deviceName, boolean showFixed) {
            super(name, deviceName, showFixed);
            this.magDevNameList = new ArrayList<String>();
        }

        public MagnetDeviceSelectionPanel(String name, String deviceName, String units) {
            super(name, deviceName, units);
            this.magDevNameList = new ArrayList<String>();
        }

        public MagnetDeviceSelectionPanel(String name, String deviceName) {
            super(name, deviceName);
            this.magDevNameList = new ArrayList<String>();
        }

        @Override
        protected void init() {
            super.init();
            this.setButton = new JButton("Set");
            this.setButton.setActionCommand(SampleMagneticField.SET_ACTION);
            this.setButton.addActionListener(this);
        }

        @Override
        public void buildGUI() {
            super.buildGUI();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(10, 0, 0, 10);
            this.add((Component)this.setButton, gridBagConstraints);
        }

        public void changeDevice() {
            String currDevice;
            String targetDevice = this.getTargetValue();
            if (targetDevice.equalsIgnoreCase(SampleMagneticField.NA_ITEM_TEXT)) {
                targetDevice = SampleMagneticField.DUMMYMAG_NAME;
            }
            if ((currDevice = this.getCurrentValue()).equalsIgnoreCase(SampleMagneticField.NA_ITEM_TEXT)) {
                currDevice = SampleMagneticField.DUMMYMAG_NAME;
            }
            if (Controller.getReference().getDevice(targetDevice) == null) {
                if (currDevice != null && !currDevice.equals("")) {
                    this.removeMagnetDeviceFromServer(currDevice);
                }
                if (!(targetDevice != null && (targetDevice.equalsIgnoreCase(SampleMagneticField.NA_ITEM_TEXT) || targetDevice.equalsIgnoreCase(SampleMagneticField.DUMMYMAG_NAME)) || targetDevice == null || targetDevice.equals(""))) {
                    this.addMagnetDeviceToServer(targetDevice, true);
                }
            } else {
                if (!currDevice.equalsIgnoreCase(targetDevice) && currDevice != null && !currDevice.equals("")) {
                    this.removeMagnetDeviceFromServer(currDevice);
                }
                try {
                    DeviceAddCommand deviceAddCommand = new DeviceAddCommand(SampleMagneticField.SANS_MAGNET_ALIAS, targetDevice);
                    deviceAddCommand.runSynchronous();
                    SampleMagneticField.this.findCurrentMagnetDevicesByAlias();
                }
                catch (NoClientAPIInstanceException e) {
                    logger.error("Error adding magnet alias.", e);
                }
                catch (ICEListenerListExceptionBase e) {
                    logger.error("Error adding magnet alias.", e);
                }
            }
            this.setTargetValue("");
            SampleMagneticField.this.findCurrentMagnetDevicesByAlias();
        }

        protected void addMagnetDeviceToServer(String deviceName, boolean makeAlias) {
            DeviceAddCommand deviceAddCommand = null;
            try {
                String aliasName = makeAlias ? SampleMagneticField.SANS_MAGNET_ALIAS : null;
                deviceAddCommand = new DeviceAddCommand(deviceName, DeviceAddCommand.DeviceType.ENV, null, null, null, null, false, aliasName);
                deviceAddCommand.runAsynchronous();
                if (deviceAddCommand.isError()) {
                    String responseString = null;
                    responseString = deviceAddCommand.getResponse();
                    throw new Exception(responseString);
                }
                this.fixedBox.setEnabled(true);
            }
            catch (Exception e) {
                SampleMagneticField.this.errorPanel.setError(e.getMessage());
                logger.error("Error adding magnet device to server", e);
            }
        }

        protected void addNAMagnetDeviceToServer() {
            DeviceAddCommand deviceAddCommand = null;
            try {
                String aliasName = SampleMagneticField.SANS_MAGNET_ALIAS;
                deviceAddCommand = new DeviceAddCommand(SampleMagneticField.NA_DEVICE_NAME, DeviceAddCommand.DeviceType.Placeholder, null, null, null, null, false, aliasName);
                deviceAddCommand.runAsynchronous();
                if (deviceAddCommand.isError()) {
                    String responseString = null;
                    responseString = deviceAddCommand.getResponse();
                    throw new Exception(responseString);
                }
                this.fixedBox.setEnabled(true);
            }
            catch (Exception e) {
                SampleMagneticField.this.errorPanel.setError(e.getMessage());
                logger.error("Error adding magnet device to server", e);
            }
        }

        protected void removeMagnetDeviceFromServer(String deviceName) {
            DeviceDestroyCommand deviceDestroyCommand = null;
            try {
                deviceDestroyCommand = new DeviceDestroyCommand(deviceName);
                deviceDestroyCommand.runAsynchronous();
                this.fixedBox.setEnabled(false);
                this.fixedBox.setSelected(false);
                if (deviceDestroyCommand.isError()) {
                    String responseString = null;
                    responseString = deviceDestroyCommand.getResponse();
                    throw new Exception(responseString);
                }
            }
            catch (Exception e) {
                SampleMagneticField.this.errorPanel.setError(e.getMessage());
                logger.error("Error removing magnet device from server", e);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand;
            Object source = e.getSource();
            if (source == this.setButton && (actionCommand = e.getActionCommand()).equals(SampleMagneticField.SET_ACTION)) {
                this.changeDevice();
            }
        }

        @Override
        public void setCurrentValue(String value) {
            if (value.equals("")) {
                SampleMagneticField.this.setInputControlsEnabled(false);
            } else {
                SampleMagneticField.this.setInputControlsEnabled(true);
            }
            super.setCurrentValue(value);
        }

        @Override
        public void actionPerformed(AvailableDeviceEvent availableDeviceEvent) {
            List theList = availableDeviceEvent.getDeviceList();
            boolean listChanged = false;
            switch (availableDeviceEvent.getTheType()) {
                case MAGNET: {
                    for (AvailableEnvDevice dev : theList) {
                        if (this.magDevNameList.contains(dev.getName()) || dev.getName().equalsIgnoreCase(SampleMagneticField.DUMMYMAG_NAME)) continue;
                        this.magDevNameList.add(dev.getName());
                        listChanged = true;
                    }
                    break;
                }
                case ELECTROMAGNET: {
                    for (AvailableEnvDevice dev : theList) {
                        if (this.magDevNameList.contains(dev.getName()) || dev.getName() == null || dev.getName().equalsIgnoreCase(SampleMagneticField.DUMMYMAG_NAME)) continue;
                        this.magDevNameList.add(dev.getName());
                        listChanged = true;
                    }
                    break;
                }
            }
            if (listChanged) {
                this.removeAllItems();
                this.addItem(SampleMagneticField.NA_ITEM_TEXT);
                this.addItems(this.magDevNameList);
            }
        }
    }
}

