/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.commands.DeviceSetPropertyCommand;
import ice.commands.MoveCommand;
import ice.data.Device;
import ice.data.InstalledMiscDevice;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.gui.panel.sans.controls.SansDeviceComboBoxControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlDoubleNoScalePanel;
import ice.gui.panel.sans.subpanels.MagneticPanel;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyListener;
import org.apache.log4j.Logger;

public class RegularMagnetPanel
extends MagneticPanel
implements DeviceValueChangedListener {
    private static Logger logger = Logger.getLogger("ErrorLogger.RegularMagnetPanel");
    protected SansDeviceControlDoubleNoScalePanel maxCurrent;
    protected SansDeviceComboBoxControlPanel unitsComboBox;
    public static final String DEVICE_NAME = "SANSMagnetVoltage";
    private static final String[] ALLOWED_UNITS = new String[]{"", "VOLTS", "TTT"};
    public static final String magField = "MagField";
    public static final String manget_property = "LASTMAGNETCURRENT";

    public RegularMagnetPanel() {
        this.init();
    }

    protected void init() {
        Controller controller = null;
        String currValue = "";
        String units = "N/A";
        controller = Controller.getReference();
        InstalledMiscDevice magVoltage = (InstalledMiscDevice)controller.getFirstDevice(DEVICE_NAME);
        this.maxCurrent = new SansDeviceControlDoubleNoScalePanel("Maximum Current (Amps)", DEVICE_NAME, true);
        if (magVoltage != null) {
            try {
                magVoltage.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("ErrorHandler").error("RegularMagentPanel.init" + e);
            }
            currValue = magVoltage.getCurrValue();
            units = magVoltage.getUnits();
        }
        if (currValue == null) {
            currValue = "";
        }
        this.maxCurrent.setCurrentValue(currValue);
        this.unitsComboBox = new SansDeviceComboBoxControlPanel("Units", DEVICE_NAME, false);
        this.unitsComboBox.addItems(ALLOWED_UNITS);
        if (units == null || units.equals("")) {
            units = "N/A";
        }
        this.unitsComboBox.setCurrentValue(units);
        this.buildGUI();
    }

    protected void buildGUI() {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.maxCurrent, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.unitsComboBox, gridBagConstraints);
        this.unitsComboBox.setEnabled(false);
        this.readControlKeysFromHelpPreferenceFile();
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent evt) {
        Object source = evt.getSource();
        if (source instanceof InstalledMiscDevice) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equalsIgnoreCase("currValue")) {
                String value = (String)evt.getNewValue();
                if (value == null) {
                    value = "";
                }
                this.maxCurrent.setCurrentValue(value);
            } else if (propertyName.equalsIgnoreCase("fixed")) {
                Boolean value = (Boolean)evt.getNewValue();
                if (value == null) {
                    value = false;
                }
                this.maxCurrent.setFixed(value);
            } else if (propertyName.equalsIgnoreCase(Device.unitsFieldName)) {
                String value = (String)evt.getNewValue();
                if (value == null || value.equals("")) {
                    value = "N/A";
                }
                this.unitsComboBox.setCurrentValue(value);
            }
        }
    }

    @Override
    public KeyListener[] getTargetsKeyListeners() {
        KeyListener[] keyListeners = null;
        keyListeners = this.maxCurrent.getTargetsKeyListeners();
        return keyListeners;
    }

    @Override
    public void addTargetsKeyListeners(KeyListener[] keyListeners) {
        this.maxCurrent.addTargetsKeyListeners(keyListeners);
    }

    @Override
    public void addKeyListenerToTarget(KeyListener l) {
        this.maxCurrent.addKeyListenerToTarget(l);
    }

    @Override
    public void removeKeyListenerFromTarget(KeyListener l) {
        this.maxCurrent.removeKeyListenerFromTarget(l);
    }

    @Override
    public void removeTargetKeyListeners() {
        this.maxCurrent.removeTargetKeyListeners();
    }

    @Override
    public String getTargetValue() {
        String returnValue = "";
        returnValue = this.maxCurrent.getTargetValue();
        return returnValue;
    }

    @Override
    public void preformMove() {
        MoveCommand moveCommand = null;
        try {
            try {
                String targetValue = this.maxCurrent.getTargetValue();
                Double value = null;
                DeviceSetPropertyCommand deviceSetPropertyCommand = null;
                if (targetValue != null && !targetValue.equals("")) {
                    boolean succeeded = false;
                    value = Double.parseDouble(targetValue);
                    moveCommand = new MoveCommand(DEVICE_NAME, value);
                    moveCommand.runAsynchronous();
                    boolean bl = succeeded = !moveCommand.isError() && moveCommand.isSuccess();
                    if (!succeeded) {
                        throw new Exception(moveCommand.getResponse());
                    }
                    targetValue = this.unitsComboBox.getTargetValue();
                    if (targetValue != null && !targetValue.equals("") && !targetValue.equalsIgnoreCase("N/A")) {
                        deviceSetPropertyCommand = new DeviceSetPropertyCommand(DEVICE_NAME, Device.unitsFieldName, targetValue);
                        deviceSetPropertyCommand.runAsynchronous();
                        boolean bl2 = succeeded = !deviceSetPropertyCommand.isError() && deviceSetPropertyCommand.isSuccess();
                        if (!succeeded) {
                            throw new Exception(deviceSetPropertyCommand.getResponse());
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.debug(e.toString());
                this.maxCurrent.setTargetValue("");
            }
        }
        finally {
            this.maxCurrent.setTargetValue("");
        }
    }

    @Override
    public void setIcePanelAsParent() {
        this.maxCurrent.setControlParent();
    }
}

