/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.composite;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.data.InstalledEnvDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.gui.panel.sans.communication.FixDeviceActionListener;
import ice.gui.panel.sans.controls.JSansCheckBox;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.composite.SansDeviceDefaultPropertyControl;
import ice.gui.panel.sans.controls.composite.SansDevicePropertyControl;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SansDeviceWithPropertiesControl
extends SansDeviceControlPanel
implements DeviceListListener {
    private static final long serialVersionUID = -6948467868037495977L;
    protected JLabel deviceNameLabel;
    protected JSansCheckBox fixedCheckBox;
    protected GridBagConstraints gridBagConstraints;
    private HashMap<String, SansDevicePropertyControl> propList;
    protected static final Color deviceBackgroundColor = new Color(232, 224, 224);

    public SansDeviceWithPropertiesControl(String name, String deviceName, boolean showFixed) {
        super(name, deviceName, showFixed);
    }

    @Override
    protected void init() {
        super.init();
        this.deviceNameLabel = new JLabel(this.controlName);
        this.fixedCheckBox = new JSansCheckBox("Fixed");
        this.fixedCheckBox.addActionListener(new FixDeviceActionListener(this));
        this.propList = null;
        Controller controller = Controller.getReference();
        controller.getDeviceListeners().add(this);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.setBackground(deviceBackgroundColor);
        this.fixedCheckBox.setBackground(deviceBackgroundColor);
        this.deviceNameLabel.setFont(new Font("SansSarif", 1, 11));
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridwidth = 6;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.deviceNameLabel, this.gridBagConstraints);
        if (this.showFixed) {
            this.fixedCheckBox.setText("Fixed");
            this.gridBagConstraints = new GridBagConstraints();
            this.gridBagConstraints.anchor = 13;
            this.gridBagConstraints.gridx = 5;
            this.gridBagConstraints.gridy = 0;
            this.gridBagConstraints.insets = new Insets(5, 0, 5, 5);
            this.add((Component)this.fixedCheckBox, this.gridBagConstraints);
        }
        this.addDeviceProperties();
    }

    @Override
    public String getCurrentValue() {
        return null;
    }

    @Override
    public String getTargetValue() {
        return null;
    }

    @Override
    public void setCurrentValue(String value) {
    }

    @Override
    public void setTargetValue(String value) {
    }

    public void addDeviceProperty(SansDevicePropertyControl propControl) {
        if (this.propList == null) {
            this.propList = new HashMap();
        }
        this.propList.put(propControl.getPropertyName(), propControl);
        int y = this.getCurrentRow();
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.gridwidth = 6;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = y;
        this.add((Component)propControl, this.gridBagConstraints);
    }

    public void addDeviceCurrentValueProperty() {
        if (this.propList == null) {
            this.propList = new HashMap();
        }
        int y = this.getCurrentRow();
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.gridwidth = 6;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = y;
        SansDeviceDefaultPropertyControl property = new SansDeviceDefaultPropertyControl(this.controlName);
        this.propList.put(property.getPropertyName(), property);
        this.add((Component)property, this.gridBagConstraints);
    }

    protected JTextField instantiateDeviceField() {
        return new JTextField();
    }

    public int getCurrentRow() {
        if (this.propList == null) {
            return -1;
        }
        return this.propList.size();
    }

    public void addDeviceProperties() {
        Controller controller = Controller.getReference();
        InstalledDevice foundDevice = controller.getFirstDevice(this.deviceName);
        if (foundDevice != null) {
            try {
                foundDevice.addValueChangeListener(this);
                boolean isFixed = foundDevice.isFixed();
                this.setFixed(isFixed);
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("ErrorLogger").error("FlipperPanel.updateDeviceControls " + e);
            }
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void setFixed(boolean fixed) {
        super.setFixed(fixed);
        boolean checkBoxSelected = this.fixedCheckBox.isSelected();
        if (fixed != checkBoxSelected) {
            this.fixedCheckBox.setSelected(fixed);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            components[i].setEnabled(enabled);
            ++i;
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        SansDevicePropertyControl prop;
        int i;
        Component[] components2;
        List<InstalledDevice> installedDevices = null;
        String alias2 = null;
        String realName = null;
        installedDevices = dle.getDevicesRemoved();
        for (InstalledDevice removeMe : installedDevices) {
            if (!(removeMe instanceof InstalledEnvDevice)) continue;
            alias2 = removeMe.getAlias();
            realName = removeMe.getRealName();
            if (realName == null || !realName.equalsIgnoreCase(this.deviceName)) continue;
            this.setFixed(false);
            removeMe.removeValueChangeListener(this);
            this.setEnabled(false);
            components2 = this.getComponents();
            i = 0;
            while (i < components2.length) {
                if (components2[i] instanceof SansDevicePropertyControl) {
                    prop = (SansDevicePropertyControl)components2[i];
                    removeMe.removeValueChangeListener(prop);
                }
                ++i;
            }
        }
        installedDevices = dle.getDevicesAdded();
        for (InstalledDevice addMe : installedDevices) {
            if (!(addMe instanceof InstalledEnvDevice)) continue;
            alias2 = addMe.getAlias();
            realName = addMe.getRealName();
            if (realName == null || !realName.equalsIgnoreCase(this.deviceName)) continue;
            try {
                addMe.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase components2) {
                // empty catch block
            }
            this.setEnabled(true);
            this.setFixed(addMe.isFixed());
            components2 = this.getComponents();
            i = 0;
            while (i < components2.length) {
                if (components2[i] instanceof SansDevicePropertyControl) {
                    prop = (SansDevicePropertyControl)components2[i];
                    try {
                        addMe.addValueChangeListener(prop);
                        prop.addDeviceProperties();
                    }
                    catch (ICEListenerListExceptionBase e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void readHintsFromPreferenceFile() {
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof SansDevicePropertyControl) {
                ((SansDevicePropertyControl)components[i]).readButtonHintsFromPreferenceFile();
            }
            ++i;
        }
    }
}

