/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.buttons;

import ice.gui.core.GenericIcePanel;
import ice.gui.panel.sans.actions.CloseRunPropertiesDialogAction;
import ice.gui.panel.sans.actions.scans.BackAction;
import ice.gui.panel.sans.actions.scans.ForwardAction;
import ice.gui.panel.sans.actions.scans.PrevMenuAction;
import ice.gui.panel.sans.controls.buttons.PropertiesButtonControlPanel;
import ice.gui.panel.sans.subpanels.autodata.RunPropertiesPanel;
import ice.swing.buttons.KeyResponseButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class RunPropertiesButtonControlPanel
extends PropertiesButtonControlPanel {
    private KeyResponseButton backBtn;
    private KeyResponseButton forwardBtn;
    private KeyResponseButton prevMenuBtn;
    private KeyResponseButton cancelBtn;
    private RunPropertiesPanel propPanel;
    private static final String back = "F11: Back";
    private static final String forward = "F13: Forward";
    private static final String prevMenu = "F20: Previous Menu";
    private static final String cancel = "Cancel";

    public RunPropertiesButtonControlPanel(GenericIcePanel parentPanel) {
        super(parentPanel);
    }

    @Override
    protected void init(GenericIcePanel panel) {
        super.init(panel);
        this.propPanel = (RunPropertiesPanel)panel;
        this.forwardBtn = new KeyResponseButton(forward, forward, 116);
        this.addToDoNotEnableDisableOnIdleOrBusy(this.forwardBtn);
        this.backBtn = new KeyResponseButton(back, back, 114);
        this.addToDoNotEnableDisableOnIdleOrBusy(this.backBtn);
        this.cancelBtn = new KeyResponseButton(cancel, cancel, 27);
        this.addToDoNotEnableDisableOnIdleOrBusy(this.cancelBtn);
        this.prevMenuBtn = new KeyResponseButton(prevMenu, prevMenu, 123);
        this.addToDoNotEnableDisableOnIdleOrBusy(this.prevMenuBtn);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        InputMap inputMap = this.getInputMap(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String hint = "Back";
        BackAction backAction = new BackAction(back, hint);
        backAction.setPropertyPanel(this.propPanel);
        this.backBtn.setAction(backAction);
        inputMap.put(KeyStroke.getKeyStroke(114, 0), back);
        this.getActionMap().put(back, backAction);
        this.backBtn.setHorizontalAlignment(2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.backBtn, gridBagConstraints);
        hint = "Forward";
        ForwardAction forwardAction = new ForwardAction(forward, hint);
        forwardAction.setPropertyPanel(this.propPanel);
        inputMap.put(KeyStroke.getKeyStroke(116, 0), forward);
        this.getActionMap().put(forward, forwardAction);
        this.forwardBtn.setAction(forwardAction);
        this.forwardBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.forwardBtn, gridBagConstraints);
        hint = "Previous Menu";
        PrevMenuAction prevMenuAction = new PrevMenuAction(prevMenu, hint);
        prevMenuAction.setPropertyPanel(this.propPanel);
        inputMap.put(KeyStroke.getKeyStroke(123, 0), prevMenu);
        this.getActionMap().put(prevMenu, prevMenuAction);
        this.prevMenuBtn.setAction(prevMenuAction);
        this.prevMenuBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.prevMenuBtn, gridBagConstraints);
        hint = cancel;
        CloseRunPropertiesDialogAction cancelAction = new CloseRunPropertiesDialogAction(cancel, hint);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancel);
        this.getActionMap().put(cancel, cancelAction);
        this.cancelBtn.setAction(cancelAction);
        this.cancelBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.cancelBtn, gridBagConstraints);
        this.readButtonHintsFromPreferenceFile();
    }

    @Override
    public void enableNavigationButtons(boolean enable) {
        this.backBtn.setEnabled(enable);
        this.forwardBtn.setEnabled(enable);
        this.prevMenuBtn.setEnabled(enable);
    }

    @Override
    public boolean isButtonStateEnabled() {
        return this.prevMenuBtn.isEnabled();
    }
}

