/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.buttons;

import ice.gui.core.GenericIcePanel;
import ice.gui.panel.sans.actions.ClosePatchPropertiesDialogAction;
import ice.gui.panel.sans.actions.scans.PatchRunsAction;
import ice.gui.panel.sans.controls.buttons.PropertiesButtonControlPanel;
import ice.gui.panel.sans.subpanels.autodata.PatchPropertiesPanel;
import ice.swing.buttons.KeyResponseButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.InputMap;

public class PatchPropertiesButtonControlPanel
extends PropertiesButtonControlPanel {
    private KeyResponseButton patchBtn;
    private KeyResponseButton cancelBtn;
    private PatchPropertiesPanel propPanel;
    private static final String patch = "F20: Patch";
    private static final String cancel = "Cancel";

    public PatchPropertiesButtonControlPanel(GenericIcePanel parentPanel) {
        super(parentPanel);
    }

    @Override
    protected void init(GenericIcePanel panel) {
        super.init(panel);
        this.propPanel = (PatchPropertiesPanel)panel;
        this.cancelBtn = new KeyResponseButton(cancel, cancel, 27);
        this.addToDoNotEnableDisableOnIdleOrBusy(this.cancelBtn);
        this.patchBtn = new KeyResponseButton(patch, patch, 123);
        this.addToDoNotEnableDisableOnIdleOrBusy(this.patchBtn);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        InputMap inputMap = this.getInputMap(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String hint = "Patch";
        PatchRunsAction patchAction = new PatchRunsAction(patch, 123, this.propPanel);
        this.patchBtn.addActionListener(patchAction);
        this.patchBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.patchBtn, gridBagConstraints);
        hint = cancel;
        ClosePatchPropertiesDialogAction cancelAction = new ClosePatchPropertiesDialogAction(cancel, "hint");
        this.cancelBtn.addActionListener(cancelAction);
        this.cancelBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.cancelBtn, gridBagConstraints);
    }

    @Override
    public void enableNavigationButtons(boolean enable) {
        this.patchBtn.setEnabled(enable);
        this.cancelBtn.setEnabled(enable);
    }

    @Override
    public boolean isButtonStateEnabled() {
        return this.patchBtn.isEnabled();
    }
}

