/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.Controller;
import ice.communication.SendQueueManager;
import ice.data.AvailableMagnetDevice;
import ice.data.AvailableMiscDevice;
import ice.data.AvailablePressureDevice;
import ice.data.AvailableTempDevice;
import ice.data.InstalledTempDevice;
import ice.event.AvailableDeviceEvent;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.communication.AvailableDeviceListListener;
import ice.gui.panel.sans.communication.ChangeTempControllerMenuItemsChangedListener;
import ice.gui.panel.sans.communication.TempDeviceChangedListener;
import ice.gui.panel.sans.controls.SansDeviceControlComboBoxPanel;
import ice.gui.panel.sans.events.SansInputControlFocusListener;
import ice.swing.FillFromComboBox;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TemperatureDeviceChangerControlPanel
extends SansDeviceControlComboBoxPanel
implements ActionListener,
ChangeTempControllerMenuItemsChangedListener,
TempDeviceChangedListener {
    private static final long serialVersionUID = 1L;
    public static final String SET_ACTION = "Set";
    private static Logger logger = Logger.getLogger("ErrorLogger");
    protected JButton setButton;

    public TemperatureDeviceChangerControlPanel() {
        super("Temperature Device", "Temp", false);
    }

    @Override
    protected void init() {
        super.init();
        this.targetComboBox = new TemperatureDeviceSelectionComboBox();
        ((TemperatureDeviceSelectionComboBox)this.targetComboBox).addChangeTempControllerMenuItemsChangedListener(this);
        this.targetComboBox.addFocusListener(new SansInputControlFocusListener());
    }

    @Override
    protected void buildGUI() {
        super.buildGUI();
        this.currentField.setPreferredSize(new Dimension(180, 20));
        this.targetComboBox.setPreferredSize(new Dimension(180, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.setButton = new JButton(SET_ACTION);
        this.add((Component)this.setButton, gridBagConstraints);
    }

    public String getTargetTempController() {
        String returnValue = null;
        returnValue = this.getTargetValue();
        return returnValue;
    }

    @Override
    public String getCurrentValue() {
        String returnValue = null;
        returnValue = super.getCurrentValue();
        if (returnValue != null && returnValue.equalsIgnoreCase("N/A")) {
            returnValue = "DUMMYTEMP";
        }
        return returnValue;
    }

    @Override
    public String getTargetValue() {
        String returnValue = null;
        returnValue = (String)this.targetComboBox.getSelectedItem();
        if (returnValue.equalsIgnoreCase("N/A")) {
            returnValue = "DUMMYTEMP";
        }
        return returnValue;
    }

    @Override
    public void setCurrentValue(String value) {
        if (value.equalsIgnoreCase("DUMMYTEMP")) {
            value = "N/A";
        }
        super.setCurrentValue(value);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.setButton.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.setButton.removeActionListener(listener);
        ((TemperatureDeviceSelectionComboBox)this.targetComboBox).removeActionListener(listener);
    }

    public void addChangeTempControllerMenuItemsChangedListener(ChangeTempControllerMenuItemsChangedListener listener) {
        ((TemperatureDeviceSelectionComboBox)this.targetComboBox).addChangeTempControllerMenuItemsChangedListener(listener);
    }

    public void removeChangeTempControllerMenuItemsChangedListener(ChangeTempControllerMenuItemsChangedListener listener) {
        ((TemperatureDeviceSelectionComboBox)this.targetComboBox).removeChangeTempControllerMenuItemsChangedListener(listener);
    }

    @Override
    public void tempControllerMenuItemsChanged(TemperatureDeviceSelectionComboBox temperatureDeviceSelectionComboBox) {
    }

    @Override
    public void tempDeviceChanged(TempDeviceChangedListener.TempDeviceChangedEvent aEvent) {
        TempDeviceChangedListener.EventType eventType = TempDeviceChangedListener.EventType.UNDEFINED;
        InstalledTempDevice theDevice = null;
        ActionListener[] actionListeners = null;
        String name = null;
        eventType = aEvent.getEventType();
        theDevice = aEvent.getTheDevice();
        if (theDevice != null && !(name = theDevice.getRealName()).equalsIgnoreCase("BLUEBOXTEMPERATURE")) {
            switch (eventType) {
                case ADDED: {
                    this.setCurrentValue(name);
                    break;
                }
                case REMOVED: {
                    this.setCurrentValue("N/A");
                    break;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public class TemperatureDeviceSelectionComboBox
    extends FillFromComboBox
    implements DeviceListListener,
    AvailableDeviceListListener {
        public static final String N_A_MENU_LABEL = "N/A";
        public static final String DUMMY_TEMP_MENU_LABEL_UPPER_CASE = "DUMMYTEMP";
        public static final String BLUE_BOX_TEMPERATURE_LABEL_UPPER_CASE = "BLUEBOXTEMPERATURE";
        protected String rememberCurrentSelection;
        protected List<AvailableTempDevice> availableDeviceList;
        protected ArrayList<ChangeTempControllerMenuItemsChangedListener> tempControllerMenuItemsChanged;
        protected Hashtable<String, String> dontDisplayLabels;

        @Override
        protected void init() {
            Controller controller = null;
            SendQueueManager sendManager = null;
            this.rememberCurrentSelection = N_A_MENU_LABEL;
            this.tempControllerMenuItemsChanged = new ArrayList();
            this.dontDisplayLabels = new Hashtable();
            this.dontDisplayLabels.put(DUMMY_TEMP_MENU_LABEL_UPPER_CASE, "");
            this.dontDisplayLabels.put(BLUE_BOX_TEMPERATURE_LABEL_UPPER_CASE, "");
            controller = Controller.getReference();
            try {
                controller.getCommMgr().addAvailableDeviceListListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("TemperatureDeviceChangerControl.init " + e);
            }
            sendManager = controller.getSendManager();
            controller.getDeviceListeners().add(this);
            sendManager.addMessage("ask GETAVAILABLEDEVICEDEFAULTS getdevicedefaults temperature", false);
            super.init();
        }

        public void addChangeTempControllerMenuItemsChangedListener(ChangeTempControllerMenuItemsChangedListener listener) {
            this.tempControllerMenuItemsChanged.add(listener);
        }

        public void removeChangeTempControllerMenuItemsChangedListener(ChangeTempControllerMenuItemsChangedListener listener) {
            this.tempControllerMenuItemsChanged.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyChangeTempControllerMenuItemsChangedListener() {
            TemperatureDeviceSelectionComboBox temperatureDeviceSelectionComboBox = this;
            synchronized (temperatureDeviceSelectionComboBox) {
                if (this.tempControllerMenuItemsChanged != null) {
                    for (ChangeTempControllerMenuItemsChangedListener listener : this.tempControllerMenuItemsChanged) {
                        listener.tempControllerMenuItemsChanged(this);
                    }
                }
            }
        }

        @Override
        public void setSelectedItem(Object item) {
            if (((String)item).equalsIgnoreCase("DummyTemp")) {
                item = N_A_MENU_LABEL;
            }
            this.rememberCurrentSelection = (String)item;
            super.setSelectedItem(item);
        }

        @Override
        public Object getSelectedItem() {
            Object returnValue = null;
            returnValue = super.getSelectedItem();
            return returnValue;
        }

        protected ActionListener[] removeAllActionListeners() {
            ActionListener[] actionListeners = null;
            ActionListener[] actionListenerArray = actionListeners = this.getActionListeners();
            int n = actionListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener listener = actionListenerArray[n2];
                this.removeActionListener(listener);
                ++n2;
            }
            return actionListeners;
        }

        protected void addActionListeners(ActionListener[] listeners) {
            ActionListener[] actionListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener listener = actionListenerArray[n2];
                this.addActionListener(listener);
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void FillFrom() {
            ActionListener[] actionListeners = null;
            TemperatureDeviceSelectionComboBox temperatureDeviceSelectionComboBox = this;
            synchronized (temperatureDeviceSelectionComboBox) {
                actionListeners = this.removeAllActionListeners();
                this.removeAllItems();
                if (this.availableDeviceList != null && this.availableDeviceList.size() > 0) {
                    this.addItem(N_A_MENU_LABEL);
                    for (AvailableTempDevice tempDevice : this.availableDeviceList) {
                        boolean hasKey = false;
                        String name = null;
                        name = tempDevice.toString().toUpperCase();
                        hasKey = this.dontDisplayLabels.containsKey(name);
                        if (hasKey) continue;
                        this.addItem(tempDevice.getName());
                    }
                    this.setEnabled(true);
                    this.setSelectedItem(this.rememberCurrentSelection);
                } else {
                    this.setEnabled(false);
                }
                this.notifyChangeTempControllerMenuItemsChangedListener();
                this.addActionListeners(actionListeners);
                if (this.getItemCount() > 0) {
                    this.setSelectedItem(this.rememberCurrentSelection);
                }
            }
        }

        @Override
        public void deviceListUpdated(DeviceListEvent dle) {
            this.FillFrom();
        }

        @Override
        public void actionPerformed(AvailableDeviceEvent availableDeviceEvent) {
            AvailableDeviceEvent.Type theType = availableDeviceEvent.getTheType();
            List theList = availableDeviceEvent.getDeviceList();
            switch (theType) {
                case MAGNET: {
                    this.receiveAvailableMagnetDevices(theList);
                    break;
                }
                case OTHER: {
                    this.receiveAvailableOtherDevices(theList);
                    break;
                }
                case TEMP: {
                    this.receiveAvailableTempDevices(theList);
                    break;
                }
                case PRESSURE: {
                    this.receiveAvailablePressureDevices(theList);
                }
            }
        }

        public void receiveAvailableTempDevices(List<AvailableTempDevice> devices) {
            this.availableDeviceList = devices;
            this.FillFrom();
        }

        public void receiveAvailableMagnetDevices(List<AvailableMagnetDevice> devices) {
        }

        public void receiveAvailableOtherDevices(List<AvailableMiscDevice> devices) {
        }

        public void receiveAvailablePressureDevices(List<AvailablePressureDevice> devices) {
        }

        @Override
        public void setSelectedIndex(int anIndex) {
            super.setSelectedIndex(anIndex);
            this.rememberCurrentSelection = (String)this.getSelectedItem();
        }
    }
}

