/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.data.SansScan;
import ice.gui.panel.sans.events.SansInputControlFocusListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SansDeviceSimpleComboBoxControlPanel
extends SansDeviceControlPanel {
    protected JComboBox currentComboBox;
    private JLabel deviceLabel;
    private JLabel unitCurrentLabel;
    private DefaultComboBoxModel boxModel;

    public SansDeviceSimpleComboBoxControlPanel(String name, String deviceName) {
        super(name, deviceName);
    }

    public SansDeviceSimpleComboBoxControlPanel(String name, String deviceName, String units) {
        super(name, deviceName, units);
    }

    public SansDeviceSimpleComboBoxControlPanel(String name, String deviceName, SansScan.DeviceType type) {
        super(name, deviceName, type);
    }

    @Override
    protected void init() {
        super.init();
        this.currentComboBox = new JComboBox();
        this.deviceLabel = new JLabel();
        this.unitCurrentLabel = new JLabel();
        this.boxModel = new DefaultComboBoxModel();
        this.currentComboBox.setModel(this.boxModel);
        this.boxModel.addElement("");
        this.currentComboBox.setSelectedIndex(0);
        this.currentComboBox.addFocusListener(new SansInputControlFocusListener());
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.deviceLabel.setText(this.controlName);
        this.deviceLabel.setPreferredSize(new Dimension(34, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.deviceLabel, gridBagConstraints);
        this.currentComboBox.setEditable(true);
        this.currentComboBox.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.currentComboBox, gridBagConstraints);
        this.unitCurrentLabel.setText(this.units);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
    }

    @Override
    public String getCurrentValue() {
        String currentValue = (String)this.currentComboBox.getSelectedItem();
        return currentValue;
    }

    @Override
    public void setCurrentValue(String value) {
        this.boxModel.setSelectedItem(value);
    }

    public JLabel getDeviceLabel() {
        return this.deviceLabel;
    }

    public JLabel getUnitCurrentLabel() {
        return this.unitCurrentLabel;
    }

    @Override
    public String getTargetValue() {
        return null;
    }

    @Override
    public void setTargetValue(String value) {
    }

    public void addItem(String string) {
        this.boxModel.addElement(string);
    }
}

