/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.gui.panel.sans.communication.FixDeviceActionListener;
import ice.gui.panel.sans.controls.JSansCheckBox;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.events.SansInputControlFocusListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SansDeviceControlComboBoxPanel
extends SansDeviceControlPanel {
    private JLabel currentLabel;
    protected JTextField currentField;
    private JLabel targetLabel;
    protected JComboBox targetComboBox;
    private JCheckBox fixedBox;
    private JLabel deviceLabel;
    private JLabel unitCurrentLabel;
    private JLabel unitTargetLabel;

    public SansDeviceControlComboBoxPanel(String name, String deviceName) {
        super(name, deviceName);
    }

    public SansDeviceControlComboBoxPanel(String name, String deviceName, boolean showFixed) {
        super(name, deviceName, showFixed);
    }

    public SansDeviceControlComboBoxPanel(String name, String deviceName, String units) {
        super(name, deviceName, units);
    }

    public void addTargetItem(String item) {
        this.targetComboBox.addItem(item);
    }

    public void removeTargetItem(String item) {
        this.targetComboBox.removeItem(item);
    }

    @Override
    protected void init() {
        super.init();
        this.currentLabel = new JLabel();
        this.currentField = new JTextField();
        this.targetLabel = new JLabel();
        this.targetComboBox = new JComboBox();
        this.fixedBox = new JSansCheckBox();
        this.deviceLabel = new JLabel();
        this.unitCurrentLabel = new JLabel();
        this.unitTargetLabel = new JLabel();
        this.fixedBox.addActionListener(new FixDeviceActionListener(this));
        this.targetComboBox.addFocusListener(new SansInputControlFocusListener());
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.deviceLabel.setText(this.controlName);
        this.deviceLabel.setPreferredSize(new Dimension(140, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.deviceLabel, gridBagConstraints);
        this.currentLabel.setText("Current");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.currentLabel, gridBagConstraints);
        this.currentField.setEditable(false);
        this.currentField.setText("");
        this.currentField.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.currentField, gridBagConstraints);
        if (this.showFixed) {
            this.fixedBox.setText("Fixed");
            this.fixedBox.addActionListener(new FixDeviceActionListener(this));
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            this.add((Component)this.fixedBox, gridBagConstraints);
        }
        gridBagConstraints.anchor = 17;
        this.targetLabel.setText("Target");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.targetLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.targetComboBox, gridBagConstraints);
        this.unitCurrentLabel.setText(this.units);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.unitCurrentLabel, gridBagConstraints);
        this.unitTargetLabel.setText(this.units);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.unitTargetLabel, gridBagConstraints);
    }

    @Override
    public String getCurrentValue() {
        String currentValue = this.currentField.getText();
        return currentValue;
    }

    @Override
    public String getTargetValue() {
        String targetValue = this.targetComboBox.getSelectedItem().toString();
        return targetValue;
    }

    @Override
    public void setCurrentValue(String value) {
        this.currentField.setText(value);
    }

    @Override
    public void setTargetValue(String value) {
        this.targetComboBox.setSelectedItem(value);
    }

    @Override
    public void setFixed(boolean isFixed) {
        super.setFixed(isFixed);
        this.fixedBox.setSelected(isFixed);
    }

    public JLabel getCurrentLabel() {
        return this.currentLabel;
    }

    public JLabel getDeviceLabel() {
        return this.deviceLabel;
    }

    public JCheckBox getFixedBox() {
        return this.fixedBox;
    }

    public JComboBox getTargetComboBox() {
        return this.targetComboBox;
    }

    public JLabel getTargetLabel() {
        return this.targetLabel;
    }

    public JLabel getUnitCurrentLabel() {
        return this.unitCurrentLabel;
    }

    public JLabel getUnitTargetLabel() {
        return this.unitTargetLabel;
    }

    public JTextField getCurrentField() {
        return this.currentField;
    }

    public void addActionListener(ActionListener action) {
        this.targetComboBox.addActionListener(action);
    }
}

