/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.Controller;
import ice.data.tas.bt7.Instrument;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.gui.core.GenericIcePanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.subpanels.SansPanelController;
import ice.util.HelpPropertiesManager;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class SansButtonPanelControl
extends JPanel
implements InstrumentValueChangedListener,
ActionListener {
    protected Hashtable<JButton, Boolean> buttonStates;
    protected Vector<JButton> ignoreUs;
    protected boolean hasBeenTurnedOff;
    public Vector<JButton> clearsErrors;
    protected GenericIcePanel parent;

    public SansButtonPanelControl(GenericIcePanel parentPanel) {
        this.init(parentPanel);
        this.buildGUI();
        this.setButtonState();
    }

    protected void buildGUI() {
    }

    protected void init(GenericIcePanel panel) {
        Controller controller = null;
        Instrument instrument = null;
        this.clearsErrors = new Vector();
        controller = Controller.getReference();
        instrument = controller.getInstrument();
        try {
            instrument.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("SansButtonPanelControl.init " + e);
        }
        this.buttonStates = new Hashtable();
        this.ignoreUs = new Vector();
        this.hasBeenTurnedOff = false;
        this.parent = panel;
    }

    public void addToDoNotEnableDisableOnIdleOrBusy(JButton ignoreMe) {
        this.ignoreUs.add(ignoreMe);
    }

    public void removeFromDoNotEnableDisableOnIdleOrBusy(JButton ignoreMe) {
        this.ignoreUs.remove(ignoreMe);
    }

    @Override
    public synchronized void actionPerformed(InstrumentValueChangedEvent evt) {
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("state")) {
            Instrument.State instrumentState = (Instrument.State)((Object)evt.getNewValue());
            Instrument.State oldState = (Instrument.State)((Object)evt.getOldValue());
            Component[] components = this.getComponents();
            boolean state = false;
            if (instrumentState != oldState) {
                switch (instrumentState) {
                    case scan: 
                    case unknown: {
                        break;
                    }
                    case busy: {
                        if (this.hasBeenTurnedOff) break;
                        this.hasBeenTurnedOff = true;
                        Component[] componentArray = components;
                        int n = components.length;
                        int n2 = 0;
                        while (n2 < n) {
                            boolean ignoreMe;
                            Component component = componentArray[n2];
                            if (component instanceof JButton && !(ignoreMe = this.ignoreUs.contains(component))) {
                                state = ((JButton)component).isEnabled();
                                this.buttonStates.put((JButton)component, state);
                                ((JButton)component).setEnabled(false);
                            }
                            ++n2;
                        }
                        break;
                    }
                    case idle: {
                        this.hasBeenTurnedOff = false;
                        Component[] componentArray = components;
                        int n = components.length;
                        int n3 = 0;
                        while (n3 < n) {
                            boolean ignoreMe;
                            Component component = componentArray[n3];
                            if (component instanceof JButton && !(ignoreMe = this.ignoreUs.contains(component))) {
                                Boolean savedState = false;
                                savedState = this.buttonStates.get((JButton)component);
                                ((JButton)component).setEnabled(savedState);
                            }
                            ++n3;
                        }
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        if (comp instanceof JButton) {
            boolean theState = false;
            theState = ((JButton)comp).isEnabled();
            this.buttonStates.put((JButton)comp, theState);
        }
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof JButton) {
            boolean theState = false;
            theState = ((JButton)comp).isEnabled();
            this.buttonStates.put((JButton)comp, theState);
        }
        return super.add(comp);
    }

    public SansIcePanel getSansIcePanelParent() {
        SansIcePanel returnValue = null;
        Container parent = null;
        parent = this;
        while (!((parent = this.getParent()) instanceof SansIcePanel) && parent != null) {
        }
        returnValue = (SansIcePanel)parent;
        return returnValue;
    }

    public void addToClearsErrors(JButton button) {
        this.clearsErrors.add(button);
        button.addActionListener(this);
    }

    public void stopClearingErrors(JButton button) {
        this.clearsErrors.remove(button);
        button.remove(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SansIcePanel parent;
        boolean clearsErrors;
        Object source = e.getSource();
        if (source instanceof JButton && (clearsErrors = this.clearsErrors.contains(source)) && (parent = this.getSansIcePanelParent()) != null) {
            parent.clearErrors();
        }
    }

    public void writeKeysToHelpPreferenceFile(SansIcePanel parent) {
        Component[] components;
        if (!SansPanelController.writeHelpKeys) {
            return;
        }
        Component[] componentArray = components = this.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof JButton) {
                JButton button = (JButton)comp;
                String buttonName = button.getText().replace(" ", "");
                buttonName = buttonName.replace(":", "");
                String key = String.valueOf(parent.getClass().getName()) + "." + button.getClass().getSimpleName() + "." + buttonName + ".hint";
                try {
                    HelpPropertiesManager.initPreferenceString(key);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public void readButtonHintsFromPreferenceFile() {
        Component[] components;
        Component[] componentArray = components = this.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof JButton) {
                JButton button = (JButton)comp;
                String buttonName = button.getText().replace(" ", "");
                buttonName = buttonName.replace(":", "");
                String key = String.valueOf(this.parent.getClass().getName()) + "." + button.getClass().getSimpleName() + "." + buttonName + ".hint";
                String hint = HelpPropertiesManager.getPreferenceString(key);
                if (!hint.equals("undefined")) {
                    button.setToolTipText(hint);
                }
            }
            ++n2;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components;
        super.setEnabled(enabled);
        Component[] componentArray = components = this.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JButton) {
                ((JButton)component).setEnabled(enabled);
            }
            ++n2;
        }
    }

    public void setButtonState() {
        Component[] components = this.getComponents();
        Controller controller = Controller.getReference();
        Instrument instrument = controller.getInstrument();
        Instrument.State instrumentState = instrument.getState();
        boolean buttonState = false;
        switch (instrumentState) {
            case scan: 
            case unknown: {
                break;
            }
            case busy: {
                Component[] componentArray = components;
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean ignoreMe;
                    Component component = componentArray[n2];
                    if (component instanceof JButton && !(ignoreMe = this.ignoreUs.contains(component))) {
                        buttonState = ((JButton)component).isEnabled();
                        this.buttonStates.put((JButton)component, buttonState);
                        ((JButton)component).setEnabled(false);
                    }
                    ++n2;
                }
                break;
            }
        }
    }
}

