/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.actions;

import ice.gui.panel.sans.actions.SansButtonAction;
import ice.gui.panel.sans.communication.SansCommandResponseEvent;
import ice.gui.panel.sans.communication.SansCommandResponseListener;
import ice.gui.panel.sans.subpanels.SansCommandManager;
import ice.gui.panel.sans.subpanels.autodata.RunListTable;
import ice.gui.panel.sans.subpanels.autodata.SansTableModel;
import ice.util.ConversionUtilities;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class PrintRunListAction
extends SansButtonAction
implements SansCommandResponseListener {
    private static Logger logger = Logger.getLogger("ErrorLogger");
    private SansTableModel tableModel;
    private RunListTable table;
    public static final String howlongTag = "howlong";
    public static final String dateTag = "date";
    private String date;
    private String howlong;
    String header = "Date: ";
    String footer = "Total counting time is ";

    public PrintRunListAction(String name, int keyStroke, RunListTable table) {
        super(name, keyStroke);
        this.table = table;
        this.clearParams();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int from = Integer.valueOf(this.rangePanel.getLowRangeValue());
        int to = Integer.valueOf(this.rangePanel.getHighRangeValue());
        try {
            String message = "print date -v";
            SansCommandManager.takeImmediateAction(message, dateTag, this);
            message = "scan howlong " + from + " " + to + " -s -v";
            SansCommandManager.takeImmediateAction(message, howlongTag, this);
        }
        catch (Exception e) {
            logger.error("client api error", e.getCause());
        }
    }

    @Override
    public void actionPerformed(SansCommandResponseEvent e) {
        String tag = e.getTag();
        if (tag.equals(dateTag)) {
            try {
                this.date = (String)e.getSource();
            }
            catch (Exception ex) {
                logger.error("error getting response" + e);
            }
        } else if (tag.equals(howlongTag)) {
            try {
                String value = (String)e.getSource();
                Double timeInSec = Double.valueOf(value);
                this.header = String.valueOf(this.header) + value;
                this.footer = String.valueOf(this.footer) + timeInSec + " sec";
                if (timeInSec.intValue() > 60) {
                    String timeInHrs = ConversionUtilities.convertSecondsToDays(timeInSec);
                    this.footer = String.valueOf(this.footer) + "or " + timeInHrs;
                }
                this.howlong = this.footer;
            }
            catch (Exception ex) {
                logger.error("error getting response" + e);
            }
        }
        if (this.date != null && this.howlong != null) {
            int from = Integer.valueOf(this.rangePanel.getLowRangeValue());
            int to = Integer.valueOf(this.rangePanel.getHighRangeValue());
            this.table.print(from, to, this.header, this.footer);
            this.clearParams();
        }
    }

    private void clearParams() {
        this.date = null;
        this.howlong = null;
        this.header = "Date: ";
        this.footer = "Total counting time is ";
    }
}

