/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel;

import ice.Controller;
import ice.IconManager;
import ice.data.InstalledDevice;
import ice.data.InstalledEnvDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceViewPanel;
import ice.swing.Bag;
import ice.swing.DeviceNameLabel;
import ice.swing.DeviceValueLabel;
import ice.swing.RememberDecisionDialog;
import ice.swing.actions.IceMenuAction;
import ice.swing.buttons.TwoStateImageButton;
import ice.util.FileManager;
import ice.util.PreferencesManager;
import ice.util.StructuredDeviceList.DeviceNode;
import ice.util.StructuredDeviceList.StructuredDeviceList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DeviceStatusPanel
extends IceViewPanel
implements DeviceListListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.StatusLogger");
    private ArrayList<InstalledDevice> allDevices;
    private ArrayList<InstalledDevice> displayDevices;
    private JPanel mainPanel;
    private CustomizeAction customizeAction;
    private CustomizeWindow customizeWindow;
    private DefaultListModel currModel;
    private HashMap<String, IceMenuAction> actionList;
    private Controller controller;
    private FileManager fileManager;

    public DeviceStatusPanel() throws IcePanelException {
        super("Device Status");
    }

    @Override
    protected void init() {
        this.setName("Device Status");
        ArrayList<Object> devices = new ArrayList();
        this.controller = Controller.getReference();
        this.fileManager = FileManager.getInstance();
        devices = this.controller.getDeviceList();
        this.allDevices = new ArrayList(devices);
        this.displayDevices = this.createDisplayDevices();
        this.customizeAction = new CustomizeAction("Customize...");
        this.actionList = new HashMap();
        this.actionList.put("Customize...", this.customizeAction);
        this.customizeWindow = new CustomizeWindow();
        this.controller.getDeviceListeners().add(this);
    }

    @Override
    protected void buildGUI() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.buildMainPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "North");
    }

    public ArrayList<String> getDisplayedDeviceNames() {
        ArrayList<String> deviceNames = new ArrayList<String>();
        Iterator<InstalledDevice> iterator = this.displayDevices.iterator();
        while (iterator.hasNext()) {
            deviceNames.add(iterator.next().getName());
        }
        return deviceNames;
    }

    @Override
    public IceMenuAction getIceMenuAction(String actionName) {
        IceMenuAction action = this.actionList.get(actionName);
        if (action == null) {
            return new IceMenuAction(actionName);
        }
        return action;
    }

    public void loadConfigWindow() {
        if (!this.customizeWindow.isVisible()) {
            this.customizeWindow.setLocationRelativeTo(this);
            this.customizeWindow.setVisible(true);
        } else {
            this.customizeWindow.requestFocus();
        }
    }

    protected static GridBagConstraints getStarterGridBagConstraints() {
        GridBagConstraints gridBagConstraints = null;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        return gridBagConstraints;
    }

    protected void addChildToEnd(DeviceRow theDeviceToAdd) {
        Component[] components = null;
        components = this.mainPanel.getComponents();
        if (components != null) {
            this.addChildAt(theDeviceToAdd, components.length);
        }
    }

    protected DeviceRow findChildByIndex(int index) {
        DeviceRow thePanel = null;
        Component[] components = null;
        components = this.mainPanel.getComponents();
        if (index > -1 && index < components.length) {
            GridBagLayout gridBagLayout = null;
            DeviceRow tempPanel = null;
            GridBagConstraints gridBagConstraints = null;
            gridBagLayout = (GridBagLayout)this.mainPanel.getLayout();
            int i = 0;
            while (i < components.length) {
                tempPanel = (DeviceRow)components[i];
                gridBagConstraints = gridBagLayout.getConstraints(tempPanel);
                if (gridBagConstraints.gridy == index) {
                    thePanel = tempPanel;
                    break;
                }
                ++i;
            }
        }
        return thePanel;
    }

    protected void moveChildDown(int index) {
        int numberOfComponents = -1;
        numberOfComponents = this.mainPanel.getComponentCount();
        if (index < numberOfComponents) {
            int indexBelow = -1;
            DeviceRow theDevice = null;
            DeviceRow deviceBelow = null;
            GridBagLayout gridBagLayout = null;
            GridBagConstraints gridBagConstraints = null;
            GridBagConstraints gridBagConstraintsBelow = null;
            indexBelow = index + 1;
            theDevice = this.findChildByIndex(index);
            deviceBelow = this.findChildByIndex(indexBelow);
            gridBagLayout = (GridBagLayout)this.mainPanel.getLayout();
            gridBagConstraints = gridBagLayout.getConstraints(theDevice);
            gridBagConstraintsBelow = gridBagLayout.getConstraints(deviceBelow);
            gridBagLayout.invalidateLayout(this.mainPanel);
            this.mainPanel.remove(theDevice);
            this.mainPanel.remove(deviceBelow);
            gridBagLayout.invalidateLayout(this.mainPanel);
            this.mainPanel.add((Component)theDevice, gridBagConstraintsBelow);
            this.mainPanel.add((Component)deviceBelow, gridBagConstraints);
            gridBagLayout.invalidateLayout(this.mainPanel);
            this.grabFocus();
            this.repaint();
        }
    }

    protected void moveChildUp(int index) {
        if (index > 0) {
            int indexAbove = -1;
            DeviceRow theDevice = null;
            DeviceRow deviceAbove = null;
            GridBagLayout gridBagLayout = null;
            GridBagConstraints gridBagConstraints = null;
            GridBagConstraints gridBagConstraintsAbove = null;
            indexAbove = index - 1;
            theDevice = this.findChildByIndex(index);
            deviceAbove = this.findChildByIndex(indexAbove);
            gridBagLayout = (GridBagLayout)this.mainPanel.getLayout();
            gridBagConstraints = gridBagLayout.getConstraints(theDevice);
            gridBagConstraintsAbove = gridBagLayout.getConstraints(deviceAbove);
            gridBagLayout.invalidateLayout(this.mainPanel);
            this.mainPanel.remove(theDevice);
            this.mainPanel.remove(deviceAbove);
            gridBagLayout.invalidateLayout(this.mainPanel);
            this.mainPanel.add((Component)theDevice, gridBagConstraintsAbove);
            this.mainPanel.add((Component)deviceAbove, gridBagConstraints);
            gridBagLayout.invalidateLayout(this.mainPanel);
            this.grabFocus();
            this.repaint();
        }
    }

    protected void removeChildFromPanel(InstalledDevice installedDevice) {
        Component[] components = null;
        DeviceRow deviceRow = null;
        InstalledDevice deviceRowInstalledDevice = null;
        if (installedDevice != null) {
            components = this.mainPanel.getComponents();
            int i = 0;
            while (i < components.length) {
                deviceRow = (DeviceRow)components[i];
                if (deviceRow != null && (deviceRowInstalledDevice = deviceRow.getInstalledDevice()) != null && deviceRowInstalledDevice.equals(installedDevice)) {
                    this.removeChildFromPanel(i);
                    break;
                }
                ++i;
            }
        }
    }

    protected void removeChildFromPanel(int index) {
        Component[] components = null;
        components = this.mainPanel.getComponents();
        if (components != null && index > -1 && index < components.length) {
            DeviceRow deviceToRemove = null;
            deviceToRemove = this.findChildByIndex(index);
            if (deviceToRemove != null) {
                DeviceRow deviceRow = null;
                GridBagConstraints gridBagConstraints = null;
                GridBagLayout gridBagLayout = null;
                gridBagLayout = (GridBagLayout)this.mainPanel.getLayout();
                gridBagConstraints = gridBagLayout.getConstraints(deviceToRemove);
                int i = 0;
                while (i < components.length) {
                    deviceRow = (DeviceRow)components[i];
                    gridBagConstraints = gridBagLayout.getConstraints(deviceRow);
                    if (gridBagConstraints.gridy > index) {
                        --gridBagConstraints.gridy;
                        gridBagLayout.setConstraints(deviceRow, gridBagConstraints);
                    }
                    ++i;
                }
                this.mainPanel.remove(index);
                this.grabFocus();
                this.repaint();
            }
        }
    }

    protected void addChildAt(DeviceRow theDeviceToAdd, int index) {
        if (theDeviceToAdd != null) {
            Component[] components = null;
            DeviceRow deviceRow = null;
            GridBagLayout gridBagLayout = null;
            GridBagConstraints gridBagConstraints = null;
            components = this.mainPanel.getComponents();
            if (components != null && index > -1 && index < components.length) {
                gridBagLayout = (GridBagLayout)this.mainPanel.getLayout();
                int i = 0;
                while (i < components.length) {
                    deviceRow = (DeviceRow)components[i];
                    gridBagConstraints = gridBagLayout.getConstraints(deviceRow);
                    if (gridBagConstraints.gridy >= index) {
                        ++gridBagConstraints.gridy;
                        gridBagLayout.setConstraints(deviceRow, gridBagConstraints);
                    }
                    ++i;
                }
                gridBagConstraints.gridy = index;
                this.mainPanel.add((Component)theDeviceToAdd, gridBagConstraints);
            } else {
                gridBagLayout = (GridBagLayout)this.mainPanel.getLayout();
                gridBagConstraints = DeviceStatusPanel.getStarterGridBagConstraints();
                gridBagConstraints.gridy = components.length;
                this.mainPanel.add((Component)theDeviceToAdd, gridBagConstraints);
            }
            this.mainPanel.grabFocus();
            this.mainPanel.repaint();
        }
    }

    private void buildMainPanel() {
        Iterator<InstalledDevice> iterator = null;
        InstalledDevice installedDevice = null;
        DeviceRow deviceRow = null;
        StructuredDeviceList structuredDeviceList = null;
        structuredDeviceList = StructuredDeviceList.getInstance();
        iterator = this.displayDevices.iterator();
        String deviceName = null;
        DeviceNode deviceNode = null;
        int i = 0;
        while (iterator.hasNext()) {
            installedDevice = iterator.next();
            deviceName = installedDevice.getRealNameButReturnAliasIfCounter();
            deviceNode = structuredDeviceList.getNodeByName(deviceName);
            deviceRow = new DeviceRow(deviceNode);
            this.addChildAt(deviceRow, i);
            ++i;
        }
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        logger.debug("device list updated.");
        ArrayList<InstalledDevice> devicesAdded = dle.getDevicesAdded();
        StructuredDeviceList structuredDeviceList = null;
        String deviceName = null;
        structuredDeviceList = StructuredDeviceList.getInstance();
        if (devicesAdded.size() > 0) {
            String autoAdd = PreferencesManager.getPreferenceString("deviceStatus.autoAddNewDevices");
            Iterator<InstalledDevice> addIterator = devicesAdded.iterator();
            int i = 0;
            while (addIterator.hasNext()) {
                InstalledDevice nodesDevice;
                InstalledDevice deviceToAdd = addIterator.next();
                deviceName = deviceToAdd.getRealNameButReturnAliasIfCounter();
                DeviceNode deviceNode = structuredDeviceList.getNodeByName(deviceName);
                if (deviceNode == null) {
                    ArrayList<InstalledDevice> addDevice = new ArrayList<InstalledDevice>();
                    addDevice.add(deviceToAdd);
                    structuredDeviceList.fillInInstalledDevices(addDevice);
                    deviceNode = structuredDeviceList.getNodeByName(deviceName);
                } else if (deviceToAdd instanceof InstalledEnvDevice && ((nodesDevice = deviceNode.getInstalledDevice()) == null || !nodesDevice.equals(deviceToAdd))) {
                    deviceNode.setInstalledDevice(deviceToAdd);
                }
                if (!(deviceToAdd.getName().equalsIgnoreCase("filtertrans") || deviceToAdd.getName().equalsIgnoreCase("premonocollimator") || deviceToAdd.getName().equalsIgnoreCase("pmcoll"))) {
                    DeviceRow deviceRow = null;
                    this.currModel.addElement(deviceToAdd);
                    this.displayDevices.add(deviceToAdd);
                    deviceRow = new DeviceRow(deviceNode);
                    this.addChildToEnd(deviceRow);
                }
                ++i;
            }
        }
        for (InstalledDevice deviceToRemove : dle.getDevicesRemoved()) {
            while (this.currModel.removeElement(deviceToRemove)) {
            }
            this.removeChildFromPanel(deviceToRemove);
            while (this.displayDevices.remove(deviceToRemove)) {
            }
        }
        this.allDevices = dle.getNewList();
        logger.debug("size: " + this.allDevices.size());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceStatusPanel.this.customizeWindow.resetAllModel();
            }
        });
    }

    private ArrayList<InstalledDevice> createDisplayDevices() {
        ArrayList<String> deviceNamesToDisplay;
        try {
            deviceNamesToDisplay = this.fileManager.getStatusDevicesToDisplay();
        }
        catch (IOException ioe) {
            logger.fatal("Error: unable to read the devices to display in status window.");
            return null;
        }
        logger.debug("device names to display: " + deviceNamesToDisplay.size());
        ArrayList<InstalledDevice> statusDevices = new ArrayList<InstalledDevice>();
        int i = 0;
        while (i < deviceNamesToDisplay.size()) {
            InstalledDevice device;
            String tmpDeviceName = deviceNamesToDisplay.get(i);
            if (!(tmpDeviceName.equalsIgnoreCase("premonocollimator") || tmpDeviceName.equalsIgnoreCase("pmcoll") || tmpDeviceName.equalsIgnoreCase("filtertrans") || (device = this.controller.getFirstDevice(tmpDeviceName)) == null)) {
                statusDevices.add(device);
            }
            ++i;
        }
        return statusDevices;
    }

    @Override
    public void saveSettings() {
        FileManager fileManager = FileManager.getInstance();
        try {
            fileManager.saveStatusDevices(this.getDisplayedDeviceNames());
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    private class CustomizeAction
    extends IceMenuAction {
        public CustomizeAction(String actionName) {
            super(actionName);
            this.putValue("MnemonicKey", new Integer(85));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DeviceStatusPanel.this.loadConfigWindow();
        }
    }

    private class CustomizeWindow
    extends JFrame {
        private JList currList;
        private JList allList;
        private DefaultListModel allModel;

        public CustomizeWindow() {
            DeviceStatusPanel.this.currModel = new DefaultListModel();
            Iterator currIterator = DeviceStatusPanel.this.displayDevices.iterator();
            while (currIterator.hasNext()) {
                DeviceStatusPanel.this.currModel.addElement(currIterator.next());
            }
            this.currList = new JList(DeviceStatusPanel.this.currModel);
            this.currList.setSelectionMode(2);
            this.allModel = new DefaultListModel();
            Iterator allIterator = DeviceStatusPanel.this.allDevices.iterator();
            while (allIterator.hasNext()) {
                this.allModel.addElement(allIterator.next());
            }
            this.allList = new JList(this.allModel);
            this.buildGUI();
        }

        public void buildGUI() {
            this.setTitle("Customize Layout - Device Status");
            this.setName("Customize Layout - Device Status");
            this.setResizable(false);
            JLabel currLabel = new JLabel("Curent");
            JLabel allLabel = new JLabel("All Devices");
            JButton addBtn = new JButton(new AddAction());
            JButton moveUpBtn = new JButton(new MoveUpAction());
            JButton moveDownBtn = new JButton(new MoveDownAction());
            JButton removeBtn = new JButton(new RemoveAction());
            JPanel panel = (JPanel)this.getContentPane();
            panel.setLayout(new GridBagLayout());
            Bag constraints = new Bag();
            int x = 0;
            int y = 0;
            JScrollPane currScroller = new JScrollPane(this.currList, 22, 31);
            JScrollPane allScroller = new JScrollPane(this.allList, 22, 31);
            this.add((Component)currLabel, constraints.cell(x, y));
            this.add((Component)currScroller, constraints.cell(x, ++y).rowspan(4));
            this.add((Component)allLabel, constraints.cell(x += 2, --y));
            this.add((Component)allScroller, constraints.cell(x, ++y).rowspan(4));
            this.add((Component)addBtn, constraints.cell(--x, y));
            this.add((Component)moveUpBtn, constraints.cell(x, ++y));
            this.add((Component)moveDownBtn, constraints.cell(x, ++y));
            this.add((Component)removeBtn, constraints.cell(x, ++y));
            this.pack();
            currScroller.setPreferredSize(new Dimension(allScroller.getSize().width, allScroller.getSize().height));
            this.pack();
        }

        public void resetAllModel() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int index = CustomizeWindow.this.allList.getSelectedIndex();
                    CustomizeWindow.this.allModel.removeAllElements();
                    Iterator iterator = DeviceStatusPanel.this.allDevices.iterator();
                    while (iterator.hasNext()) {
                        CustomizeWindow.this.allModel.addElement(iterator.next());
                    }
                    CustomizeWindow.this.allList.invalidate();
                    CustomizeWindow.this.allList.setSelectedIndex(index);
                    CustomizeWindow.this.allList.ensureIndexIsVisible(index);
                }
            });
        }

        private class AddAction
        extends AbstractAction {
            public AddAction() {
                this.putValue("Name", "<-- Add");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                int[] currIndices = CustomizeWindow.this.currList.getSelectedIndices();
                int[] allIndices = CustomizeWindow.this.allList.getSelectedIndices();
                int currIndex = -1;
                if (currIndices.length != 0) {
                    currIndex = currIndices[currIndices.length - 1];
                }
                int length = allIndices.length;
                ArrayList<InstalledDevice> devicesToAdd = new ArrayList<InstalledDevice>();
                int i = 0;
                while (i < length) {
                    devicesToAdd.add((InstalledDevice)CustomizeWindow.this.allModel.getElementAt(allIndices[i]));
                    ++i;
                }
                String duplicationPref = PreferencesManager.getPreferenceString("deviceStatus.allowDuplicateDevices");
                if (!duplicationPref.equalsIgnoreCase("yes")) {
                    ArrayList<InstalledDevice> duplicateDevices = new ArrayList<InstalledDevice>();
                    int i2 = 0;
                    while (i2 < length) {
                        if (DeviceStatusPanel.this.currModel.contains(devicesToAdd.get(i2))) {
                            duplicateDevices.add((InstalledDevice)devicesToAdd.get(i2));
                        }
                        ++i2;
                    }
                    if (duplicateDevices.size() > 0) {
                        if (duplicationPref.equalsIgnoreCase("no")) {
                            i2 = 0;
                            while (i2 < duplicateDevices.size()) {
                                int index = devicesToAdd.indexOf(duplicateDevices.get(i2));
                                devicesToAdd.remove(index);
                                ++i2;
                            }
                        } else {
                            String body;
                            EnumSet<RememberDecisionDialog.Decision> decision;
                            String devices = "";
                            Iterator duplicateIterator = duplicateDevices.iterator();
                            while (duplicateIterator.hasNext()) {
                                devices = String.valueOf(devices) + duplicateIterator.next() + ", ";
                            }
                            devices = devices.substring(0, devices.length() - 2);
                            String devicesToken = "Devices ";
                            String stativeVerbToken = " are ";
                            String articleToken = " them?";
                            if (duplicateDevices.size() == 1) {
                                devicesToken = "Device ";
                                stativeVerbToken = " is ";
                                articleToken = " it?";
                            }
                            if ((decision = RememberDecisionDialog.showDialog(null, "Confirm Add", body = String.valueOf(devicesToken) + devices + stativeVerbToken + "already being displayed.  Do you want to add" + articleToken, RememberDecisionDialog.DialogType.YesNoCancel)).contains((Object)RememberDecisionDialog.Decision.Remember)) {
                                try {
                                    if (decision.contains((Object)RememberDecisionDialog.Decision.Yes)) {
                                        PreferencesManager.setPreferenceString("deviceStatus.allowDuplicateDevices", "yes");
                                    } else if (decision.contains((Object)RememberDecisionDialog.Decision.No)) {
                                        PreferencesManager.setPreferenceString("deviceStatus.allowDuplicateDevices", "no");
                                    }
                                }
                                catch (IOException ioe) {
                                    logger.error("Unable to set user's preferences.", ioe);
                                }
                            }
                            if (decision.contains((Object)RememberDecisionDialog.Decision.No)) {
                                logger.debug("decision was no.  Removing devices");
                                int i3 = 0;
                                while (i3 < duplicateDevices.size()) {
                                    int index = devicesToAdd.indexOf(duplicateDevices.get(i3));
                                    devicesToAdd.remove(index);
                                    ++i3;
                                }
                            }
                            if (decision.contains((Object)RememberDecisionDialog.Decision.Cancel)) {
                                return;
                            }
                        }
                    }
                }
                DeviceRow deviceRow = null;
                StructuredDeviceList structuredDeviceList = null;
                DeviceNode deviceNode = null;
                String deviceName = null;
                structuredDeviceList = StructuredDeviceList.getInstance();
                int i4 = 0;
                while (i4 < devicesToAdd.size()) {
                    InstalledDevice deviceToAdd = (InstalledDevice)devicesToAdd.get(i4);
                    deviceName = deviceToAdd.getRealNameButReturnAliasIfCounter();
                    deviceNode = structuredDeviceList.getNodeByName(deviceName);
                    if (deviceNode != null) {
                        InstalledDevice deviceNodeDevice = deviceNode.getInstalledDevice();
                        if (deviceNodeDevice == null) {
                            deviceNode.setInstalledDevice(deviceToAdd);
                        }
                        if (currIndex != -1) {
                            DeviceStatusPanel.this.currModel.insertElementAt(deviceToAdd, i4 + currIndex + 1);
                            DeviceStatusPanel.this.displayDevices.add(i4 + currIndex + 1, deviceToAdd);
                            deviceRow = new DeviceRow(deviceNode);
                            DeviceStatusPanel.this.addChildAt(deviceRow, i4 + currIndex + 1);
                        } else {
                            DeviceStatusPanel.this.currModel.addElement(deviceToAdd);
                            DeviceStatusPanel.this.displayDevices.add(deviceToAdd);
                            deviceRow = new DeviceRow(deviceNode);
                            DeviceStatusPanel.this.addChildToEnd(deviceRow);
                        }
                    }
                    ++i4;
                }
                DeviceStatusPanel.this.customizeWindow.requestFocus(true);
            }
        }

        private class MoveDownAction
        extends AbstractAction {
            public MoveDownAction() {
                this.putValue("Name", "Move Down");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                int[] currIndices = CustomizeWindow.this.currList.getSelectedIndices();
                int[] selectionIndices = new int[currIndices.length];
                int length = currIndices.length;
                int i = length - 1;
                while (i >= 0) {
                    int currIndex = currIndices[i];
                    if (currIndex + 1 == DeviceStatusPanel.this.currModel.size()) {
                        selectionIndices[i] = currIndex;
                    } else {
                        InstalledDevice deviceToMove = (InstalledDevice)DeviceStatusPanel.this.currModel.remove(currIndex);
                        DeviceStatusPanel.this.displayDevices.remove(currIndex);
                        DeviceStatusPanel.this.currModel.insertElementAt(deviceToMove, currIndex + 1);
                        selectionIndices[i] = currIndex + 1;
                        DeviceStatusPanel.this.displayDevices.add(currIndex + 1, deviceToMove);
                        DeviceStatusPanel.this.moveChildDown(currIndex);
                    }
                    --i;
                }
                CustomizeWindow.this.currList.setSelectedIndices(selectionIndices);
                if (selectionIndices.length != 0) {
                    CustomizeWindow.this.currList.ensureIndexIsVisible(selectionIndices[selectionIndices.length - 1]);
                }
                DeviceStatusPanel.this.customizeWindow.requestFocus(true);
            }
        }

        private class MoveUpAction
        extends AbstractAction {
            public MoveUpAction() {
                this.putValue("Name", "Move Up");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                int[] currIndices = CustomizeWindow.this.currList.getSelectedIndices();
                int[] selectionIndices = new int[currIndices.length];
                int length = currIndices.length;
                int i = 0;
                while (i < length) {
                    int currIndex = currIndices[i];
                    if (currIndex == 0) {
                        selectionIndices[i] = currIndex;
                    } else {
                        InstalledDevice deviceToMove = (InstalledDevice)DeviceStatusPanel.this.currModel.remove(currIndex);
                        DeviceStatusPanel.this.displayDevices.remove(currIndex);
                        DeviceStatusPanel.this.currModel.insertElementAt(deviceToMove, currIndex - 1);
                        selectionIndices[i] = currIndex - 1;
                        DeviceStatusPanel.this.displayDevices.add(currIndex - 1, deviceToMove);
                        DeviceStatusPanel.this.moveChildUp(currIndex);
                    }
                    ++i;
                }
                CustomizeWindow.this.currList.setSelectedIndices(selectionIndices);
                if (selectionIndices.length != 0) {
                    CustomizeWindow.this.currList.ensureIndexIsVisible(selectionIndices[0]);
                }
                DeviceStatusPanel.this.customizeWindow.requestFocus(true);
            }
        }

        private class RemoveAction
        extends AbstractAction {
            public RemoveAction() {
                this.putValue("Name", "Remove");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                int[] currIndices = CustomizeWindow.this.currList.getSelectedIndices();
                int length = currIndices.length;
                int i = length - 1;
                while (i >= 0) {
                    int currIndex = currIndices[i];
                    DeviceStatusPanel.this.currModel.remove(currIndex);
                    DeviceStatusPanel.this.displayDevices.remove(currIndex);
                    DeviceStatusPanel.this.removeChildFromPanel(currIndex);
                    --i;
                }
                DeviceStatusPanel.this.customizeWindow.requestFocus(true);
            }
        }
    }

    public class DeviceRow
    extends JPanel {
        protected JPanel devicePanel = null;
        protected JPanel childPanel = null;
        protected GridBagConstraints childPanelGridBagConstraints = null;
        protected InstalledDevice installedDevice = null;
        private SizePanelButton sizePanelButton = null;

        public DeviceRow(DeviceNode deviceNode) {
            this.init(deviceNode);
        }

        protected void init(DeviceNode deviceNode) {
            if (deviceNode != null) {
                this.installedDevice = deviceNode.getInstalledDevice();
                GridBagConstraints gridBagConstraints = null;
                GridBagLayout gridBagLayout = null;
                Object tempName = null;
                this.installedDevice = this.installedDevice;
                gridBagConstraints = new GridBagConstraints();
                gridBagLayout = new GridBagLayout();
                this.setLayout(gridBagLayout);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(0, 0, 3, 0);
                gridBagConstraints.fill = 3;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridx = 0;
                this.devicePanel = new JPanel();
                gridBagLayout = new GridBagLayout();
                this.devicePanel.setLayout(gridBagLayout);
                this.add((Component)this.devicePanel, gridBagConstraints);
                gridBagConstraints.gridy = 1;
                this.childPanel = new JPanel();
                gridBagLayout = new GridBagLayout();
                this.childPanel.setLayout(gridBagLayout);
                this.add((Component)this.childPanel, gridBagConstraints);
                this.childPanelGridBagConstraints = new GridBagConstraints();
                this.childPanelGridBagConstraints.anchor = 18;
                this.childPanelGridBagConstraints.gridx = 0;
                this.childPanelGridBagConstraints.gridy = -1;
                this.childPanelGridBagConstraints.insets = new Insets(1, 25, 1, 5);
                this.childPanelGridBagConstraints.fill = 1;
                this.childPanelGridBagConstraints.weightx = 100.0;
                this.childPanelGridBagConstraints.weighty = 0.0;
                this.setVisible(false);
                this.childPanel.setVisible(false);
                this.devicePanel.setVisible(false);
                if (this.installedDevice != null) {
                    this.setVisible(true);
                    this.devicePanel.setVisible(true);
                    this.buildGUI(deviceNode);
                }
            }
        }

        protected void buildGUI(DeviceNode deviceNode2) {
            GridBagConstraints gridBagConstraints = null;
            DeviceNameLabel deviceNameLabel = null;
            DeviceValueLabel deviceValueLabel = null;
            InstalledDevice installedDevice = null;
            if (deviceNode2 != null) {
                installedDevice = deviceNode2.getInstalledDevice();
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(0, 0, 3, 0);
                gridBagConstraints.fill = 3;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridx = 0;
                this.sizePanelButton = new SizePanelButton();
                gridBagConstraints.gridx = 0;
                this.devicePanel.add((Component)this.sizePanelButton, gridBagConstraints);
                deviceNameLabel = new DeviceNameLabel(installedDevice);
                deviceNameLabel.setHorizontalAlignment(2);
                gridBagConstraints.gridx = 1;
                this.devicePanel.add((Component)deviceNameLabel, gridBagConstraints);
                deviceValueLabel = new DeviceValueLabel(installedDevice);
                gridBagConstraints.gridx = 2;
                this.devicePanel.add((Component)deviceValueLabel, gridBagConstraints);
                ArrayList<DeviceNode> children = null;
                Iterator<DeviceNode> iterator = null;
                Object aChild = null;
                DeviceRow newChild = null;
                children = deviceNode2.getChildren();
                for (DeviceNode deviceNode2 : children) {
                    newChild = new DeviceRow(deviceNode2);
                    this.addChild(newChild);
                }
            }
        }

        protected void showChildPanel() {
            this.childPanel.setVisible(true);
        }

        protected void hideChildPanel() {
            this.childPanel.setVisible(false);
        }

        protected void enableChildPanel() {
            this.sizePanelButton.setEnabled(true);
        }

        protected void addChild(DeviceRow deviceRow) {
            if (deviceRow != null) {
                ++this.childPanelGridBagConstraints.gridy;
                this.childPanel.add((Component)deviceRow, this.childPanelGridBagConstraints);
                this.enableChildPanel();
            }
        }

        public InstalledDevice getInstalledDevice() {
            return this.installedDevice;
        }

        public class SizePanelButton
        extends TwoStateImageButton {
            private static final long serialVersionUID = 1L;
            protected ImageIcon deativatedImage;

            public SizePanelButton() {
                super(IconManager.getIcon("downShade.normal"), IconManager.getIcon("downShade.rollover"), IconManager.getIcon("downShade.pressed"), IconManager.getIcon("upShade.normal"), IconManager.getIcon("upShade.rollover"), IconManager.getIcon("upShade.pressed"));
                this.deativatedImage = null;
                this.setEnabled(false);
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.activeImage = enabled ? this.normalImage : this.deativatedImage;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                TwoStateImageButton.StateEnum theState = null;
                boolean viewChildren = false;
                theState = this.getState();
                if (theState == TwoStateImageButton.StateEnum.STATEONE) {
                    DeviceRow.this.hideChildPanel();
                } else {
                    DeviceRow.this.showChildPanel();
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                if (this.isEnabled()) {
                    super.mouseEntered(me);
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                if (this.isEnabled()) {
                    super.mouseExited(arg0);
                }
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                if (this.isEnabled()) {
                    super.mouseMoved(me);
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (this.isEnabled()) {
                    super.mousePressed(me);
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (this.isEnabled()) {
                    super.mouseReleased(me);
                }
            }
        }
    }
}

