/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.rangeClasses.DeviceValue;

import ice.gui.core.rangeClasses.DeviceValue.DeviceValue;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import org.apache.log4j.Logger;

public class IntegerDeviceValue
extends DeviceValue {
    private static Logger logger = Logger.getLogger("ScanOperation.FloatDeviceValue");
    protected int value;
    protected int minimum = Integer.MIN_VALUE;
    protected int maximum = Integer.MAX_VALUE;
    public static final int DEFAULTWIDTH = 20;
    protected NumberFormat intFormat = NumberFormat.getIntegerInstance();

    public IntegerDeviceValue(int value) {
        this.value = value;
        this.valid = true;
    }

    public IntegerDeviceValue(String value) {
        this.parseString(value);
    }

    @Override
    public boolean parseString(String value) {
        try {
            this.value = Integer.valueOf(value);
            this.valid = true;
            return true;
        }
        catch (NumberFormatException e) {
            this.valid = false;
            return false;
        }
    }

    @Override
    public Object getValue() {
        return new Double(this.value);
    }

    public void setValue(int newValue) {
        this.value = newValue;
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.value);
    }

    @Override
    public String getErrorText() {
        if (this.validateData()) {
            return "";
        }
        return "Invalid";
    }

    @Override
    public JComponent getControl() {
        this.intFormat.setMaximumIntegerDigits(20);
        return new JFormattedTextField(this.intFormat);
    }
}

