/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.controls.serverFileView;

import ice.data.IceFile;
import ice.gui.core.controls.serverFileView.ServerFileView;
import ice.gui.core.controls.serverFileView.ServerFolderView;
import ice.gui.core.controls.serverFileView.communication.FileSelectionChangedListener;
import ice.gui.core.controls.serverFileView.communication.FileSelectionDoubleClickListener;
import java.awt.Component;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ServerFileSelectionView
extends JSplitPane
implements TreeSelectionListener,
FileSelectionDoubleClickListener {
    protected ServerFolderView serverFolderView = null;
    protected ServerFileView serverFileView = null;
    protected ServerFolderView.ViewTypes viewType = null;

    public ServerFileSelectionView(ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) {
        this.init(viewType, defaultFolder);
    }

    private ServerFileSelectionView(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
    }

    private ServerFileSelectionView(int newOrientation, boolean newContinuousLayout) {
        super(newOrientation, newContinuousLayout);
    }

    private ServerFileSelectionView(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
    }

    private ServerFileSelectionView(int newOrientation) {
        super(newOrientation);
    }

    protected void init(ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) {
        this.viewType = viewType;
        this.buildGUI(defaultFolder);
    }

    protected void buildGUI(ServerFolderView.ValidServerFolders defaultFolder) {
        this.serverFolderView = new ServerFolderView(this.viewType, defaultFolder);
        this.serverFolderView.addTreeSelectionListener(this);
        this.serverFileView = new ServerFileView();
        this.serverFileView.addFileSelectionDoubleClickListener(this);
        this.setOrientation(1);
        this.setLeftComponent(this.serverFolderView);
        this.setRightComponent(this.serverFileView);
    }

    public void listenToFolderValueChange(TreeSelectionListener listener) {
        this.serverFolderView.addTreeSelectionListener(listener);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        IceFile selectedFolder = null;
        selectedFolder = this.serverFolderView.getSelectedFolder();
        if (selectedFolder != null) {
            this.serverFileView.setIceFolderToView(selectedFolder);
        }
    }

    @Override
    public void fileSelectionDoubleClick(Object theFileClickedOn) {
    }

    public void addFileSelectionDoubleClickListner(FileSelectionDoubleClickListener theListener) {
        this.serverFileView.addFileSelectionDoubleClickListener(theListener);
    }

    public void removeFileSelectionDoubleClickListener(FileSelectionDoubleClickListener theListener) {
        this.serverFileView.removeFileSelectionDoubleClickListener(theListener);
    }

    public void addFileSelectionChangedListener(FileSelectionChangedListener theListener) {
        this.serverFileView.addFileSelectionChangedListener(theListener);
    }

    public void removeFileSelectionChangedListener(FileSelectionChangedListener theListener) {
        if (theListener != null) {
            this.serverFileView.removeFileSelectionChangedListener(theListener);
        }
    }

    public IceFile getCurrentSelectedFolder() {
        IceFile returnValue = null;
        returnValue = this.serverFolderView.getSelectedFolder();
        return returnValue;
    }

    public Object getCurrentSelectedItem() {
        Object iceFile = null;
        iceFile = this.serverFileView.getSelectedIceItem();
        return iceFile;
    }

    public void setFilter(String regex) {
        this.serverFileView.setFilter(regex);
    }
}

