/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import ice.exceptions.IcePanelException;
import ice.gui.core.GenericIcePanel;
import org.apache.log4j.Logger;

public abstract class IceViewPanel
extends GenericIcePanel {
    private static final long serialVersionUID = -7639161368336403333L;
    private static final Logger logger = Logger.getLogger("ErrorLogger.IceViewPanel");

    protected IceViewPanel() throws IcePanelException {
        this.processIcePanel();
    }

    protected IceViewPanel(String name) throws IcePanelException {
        super(name);
        this.processIcePanel();
    }

    public void processIcePanel() throws IcePanelException {
        try {
            this.init();
            this.buildGUI();
        }
        catch (Exception e) {
            logger.error("cannot load ice panel" + e.getMessage());
            this.handleIcePanelException(this.getName(), e);
        }
    }

    protected abstract void buildGUI();

    protected abstract void init();
}

