/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IFitData;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.ITree;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class FitData {
    private static final Logger logger = Logger.getLogger("WidgetLogger.LiveDataLogger");
    static IAnalysisFactory anaFactory = IAnalysisFactory.create();
    static ITree tree = anaFactory.createTreeFactory().create();
    static IDataPointSetFactory pointFactory = anaFactory.createDataPointSetFactory(tree);
    static IFunctionFactory funcFactory = anaFactory.createFunctionFactory(tree);
    static IFitFactory fitFactory = anaFactory.createFitFactory();
    static IFitter fitter = fitFactory.createFitter("LS");
    static IDataPointSet dataPointSet = pointFactory.create("dataPointSet", "two dimensional IDataPointSet", 2);
    static ArrayList<Double> xFitData = null;
    static ArrayList<Double> yFitData = null;

    public static void calculateFitPoints(double[] xValues, double[] yValues, String fitOption) {
        String modelType = "G + " + fitOption;
        IFunction gaussFunction = funcFactory.createFunctionByName("guass", modelType);
        xFitData = new ArrayList();
        yFitData = new ArrayList();
        try {
            int i = 0;
            while (i < yValues.length) {
                dataPointSet.addPoint();
                dataPointSet.point(i).coordinate(0).setValue(xValues[i]);
                dataPointSet.point(i).coordinate(1).setValue(yValues[i]);
                dataPointSet.point(i).coordinate(1).setErrorPlus(Math.sqrt(yValues[i]));
                dataPointSet.point(i).coordinate(1).setErrorMinus(Math.sqrt(yValues[i]));
                ++i;
            }
        }
        catch (Exception exp) {
            logger.error("Cannot create dataPointSet... aborting", exp);
        }
        IFitData data = fitFactory.createFitData();
        data.create1DConnection(dataPointSet, 0, 1);
        double maxY = Double.MIN_VALUE;
        double maxX = Double.MIN_VALUE;
        try {
            Arrays.sort(yValues);
            maxY = yValues[yValues.length - 1];
            int i = 0;
            while (i < yValues.length) {
                if (dataPointSet.point(i).coordinate(1).value() == maxY) {
                    maxX = xValues[i];
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error("Error setting maxY or maxX ... setting both to 1", e);
            maxY = 1.0;
            maxY = 1.0;
        }
        gaussFunction.setParameter("amplitude", maxY);
        gaussFunction.setParameter("mean", maxX);
        gaussFunction.setParameter("sigma", 100.0);
        try {
            double[] x;
            IFitResult fittedResult = fitter.fit(data, gaussFunction);
            IFunction fittedFunction = fittedResult.fittedFunction();
            Arrays.sort(xValues);
            double min = xValues[0];
            double max = xValues[xValues.length - 1];
            double step = Math.abs((max - min) / 100.0);
            double count = min;
            while (count < max) {
                x = new double[]{count};
                count += step;
                yFitData.add(fittedFunction.value(x));
                xFitData.add(x[0]);
            }
            x = new double[]{max};
            yFitData.add(fittedFunction.value(x));
            xFitData.add(x[0]);
        }
        catch (RuntimeException e) {
            logger.error("Unable to perform Gaussian Fit", e);
        }
        catch (Exception e) {
            logger.error("Unable to perform Gaussian Fit", e);
        }
    }

    public static ArrayList<Double> getXFitPoints() {
        return xFitData;
    }

    public static ArrayList<Double> getYFitPoints() {
        return yFitData;
    }

    public static ArrayList<Double> toDoubleArrayList(double[] array) {
        ArrayList<Double> list = new ArrayList<Double>();
        int i = 0;
        while (i < array.length) {
            list.add(new Double(array[i]));
            ++i;
        }
        return list;
    }
}

