/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.clientAPI.MessageQueue;

public class QueueCommand {
    private final MessageQueue<String> resultsQueue = new MessageQueue();
    private final MessageQueue<String> errorQueue = new MessageQueue();
    private long id;
    private String commandString;
    private State state;
    private Double estimatedTime;

    public QueueCommand(long id, String commandString) {
        this.id = id;
        this.commandString = commandString;
        this.state = State.unknown;
    }

    public QueueCommand(long id, String commandString, State state) {
        this.id = id;
        this.commandString = commandString;
        this.state = state;
    }

    public QueueCommand(long id, String commandString, State state, Double estimatedTime) {
        this.id = id;
        this.commandString = commandString;
        this.state = state;
        this.estimatedTime = estimatedTime;
    }

    public String getCommandString() {
        return this.commandString;
    }

    public long getID() {
        return this.id;
    }

    public Double getEstimatedTime() {
        return this.estimatedTime;
    }

    public String toString() {
        return String.valueOf(this.id) + ":" + this.commandString;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean isCurrent() {
        return this.state == State.current;
    }

    public boolean isPast() {
        return this.state == State.past;
    }

    public boolean isFuture() {
        return this.state == State.future;
    }

    public MessageQueue<String> getResultsQueue() {
        return this.resultsQueue;
    }

    public MessageQueue<String> getErrorQueue() {
        return this.errorQueue;
    }

    public static enum State {
        past,
        current,
        future,
        unknown;

    }
}

