/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.data.QueueCommand;
import ice.data.tas.bt7.Instrument;
import ice.event.QueueChangedEvent;
import ice.event.QueueChangedListener;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Queue {
    private static Logger logger = Logger.getLogger("DataLogger.QueueLogger");
    private static int PAST_COMMAND_SIZE = 5;
    private List<QueueCommand> pastCommands;
    private QueueCommand currCommand;
    private String currOwner;
    private List<QueueCommand> futureCommands;
    private ICEListenerList<QueueChangedListener, QueueChangedEvent> changeListeners;
    Instrument instrument;

    public Queue(Instrument instrument) {
        this.instrument = instrument;
        this.pastCommands = new Vector<QueueCommand>();
        this.currCommand = null;
        this.currOwner = null;
        this.futureCommands = new Vector<QueueCommand>();
        this.changeListeners = new ICEListenerList();
    }

    public synchronized QueueCommand getCurrCommand() {
        return this.currCommand;
    }

    public synchronized List<QueueCommand> getFutureCommands() {
        return this.futureCommands;
    }

    public synchronized List<QueueCommand> getPastCommands() {
        return this.pastCommands;
    }

    public synchronized void removeCommand(QueueCommand cmd) {
        if (this.pastCommands.remove(cmd)) {
            this.notifyChangeListeners();
        } else if (this.currCommand == cmd) {
            this.currCommand = null;
            this.currOwner = null;
            this.notifyChangeListeners();
        } else if (this.futureCommands.remove(cmd)) {
            this.notifyChangeListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateCommands(QueueCommand newCurrCommand, String newCurrOwner, ArrayList<QueueCommand> newFutureCommands) {
        this.currOwner = newCurrOwner;
        logger.debug("updating queue.  curr cmd: " + newCurrCommand);
        if (newCurrCommand != null) {
            int index = -1;
            boolean found = false;
            index = 0;
            while (index < this.futureCommands.size()) {
                logger.debug(String.valueOf(newCurrCommand.getID()) + " vs " + this.futureCommands.get(index).getID());
                if (newCurrCommand.getID() == this.futureCommands.get(index).getID()) {
                    found = true;
                    break;
                }
                ++index;
            }
            logger.debug("index: " + index);
            if (index >= 0 && found) {
                int i = 0;
                while (i < index) {
                    QueueCommand cmd = this.futureCommands.get(i);
                    logger.debug("adding " + cmd.getID());
                    cmd.setState(QueueCommand.State.past);
                    this.pastCommands.add(cmd);
                    ++i;
                }
            }
        }
        if (this.currCommand != null && (newCurrCommand == null || this.currCommand.getID() != newCurrCommand.getID())) {
            this.currCommand.setState(QueueCommand.State.past);
            this.pastCommands.add(this.currCommand);
        }
        int startIndex = Math.max(this.pastCommands.size() - PAST_COMMAND_SIZE, 0);
        int endIndex = Math.max(this.pastCommands.size(), 0);
        this.pastCommands = new Vector<QueueCommand>(this.pastCommands.subList(startIndex, endIndex));
        this.futureCommands = new Vector<QueueCommand>(newFutureCommands);
        this.currCommand = newCurrCommand;
        this.notifyChangeListeners();
        List<QueueCommand> list = this.pastCommands;
        synchronized (list) {
            this.pastCommands.notifyAll();
        }
    }

    public synchronized void clearPast() {
        this.pastCommands.clear();
        this.notifyChangeListeners();
    }

    public boolean addChangeListener(QueueChangedListener cl) throws ICEListenerListExceptionBase {
        this.changeListeners.addListener(cl);
        return true;
    }

    public boolean removeChangeListener(QueueChangedListener cl) {
        return this.changeListeners.removeListener(cl);
    }

    private void notifyChangeListeners() {
        QueueChangedEvent event = new QueueChangedEvent(this);
        this.changeListeners.notifyListeners(event);
    }

    public String getCurrOwner() {
        return this.currOwner;
    }

    public void setCurrOwner(String currOwner) {
        this.currOwner = currOwner;
        this.notifyChangeListeners();
    }

    public double getEstimatedCompletionTime() {
        double totalTime = 0.0;
        if (this.currCommand != null) {
            totalTime += this.currCommand.getEstimatedTime().doubleValue();
        }
        Iterator<QueueCommand> iterator = this.futureCommands.iterator();
        while (iterator.hasNext()) {
            totalTime += iterator.next().getEstimatedTime().doubleValue();
        }
        return totalTime;
    }

    public boolean isCommandInFutureCommands(long commandId) {
        for (QueueCommand c : this.futureCommands) {
            if (c.getID() != commandId) continue;
            return true;
        }
        return false;
    }

    public boolean isCommandInPastCommands(long commandId) {
        for (QueueCommand c : this.pastCommands) {
            if (c.getID() != commandId) continue;
            return true;
        }
        return false;
    }

    public boolean isCommandQueuedOrRunning(long commandId) {
        return this.currCommand != null && this.currCommand.getID() == commandId || this.isCommandInFutureCommands(commandId);
    }

    public boolean isCommandQueuedRunningOrPast(long commandId) {
        return this.currCommand != null && this.currCommand.getID() == commandId || this.isCommandInFutureCommands(commandId) || this.isCommandInPastCommands(commandId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnCommandId(long commandId) {
        long timeout = 2000L;
        boolean timeoutHasPassed = false;
        while (!this.isCommandQueuedRunningOrPast(commandId) && !timeoutHasPassed) {
            try {
                this.pastCommands.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeoutHasPassed = true;
        }
        while (this.isCommandQueuedOrRunning(commandId)) {
            try {
                List<QueueCommand> list = this.pastCommands;
                synchronized (list) {
                    this.pastCommands.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

