/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.data.IceFile;
import ice.data.IceFileType;
import ice.data.IcePanelInfo;
import ice.data.Resource;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceEditPanel;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;

public class IceWindowInfo {
    private Point position;
    private Dimension size;
    private ArrayList<IcePanelInfo> panelInfoList;

    public IceWindowInfo(Point position, Dimension size, ArrayList<GenericIcePanel> panels) {
        this.position = position;
        this.size = size;
        this.buildIcePanelInfoList(panels);
    }

    public IceWindowInfo() {
        this.position = new Point(0, 0);
        this.size = new Dimension(500, 500);
        this.panelInfoList = new ArrayList();
    }

    public Dimension getDimension() {
        return this.size;
    }

    public void setDimension(Dimension size) {
        this.size = size;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point point) {
        this.position = point;
    }

    public ArrayList<IcePanelInfo> getIcePanelInfoList() {
        return this.panelInfoList;
    }

    public void setPanelInfoList(ArrayList<IcePanelInfo> panelList) {
        this.panelInfoList = panelList;
    }

    public void buildIcePanelInfoList(ArrayList<GenericIcePanel> panels) {
        this.panelInfoList = new ArrayList();
        for (GenericIcePanel panel : panels) {
            String className = panel.getClass().getSimpleName();
            String panelName = panel.getName();
            IceFileType fileType = IceFileType.unknown;
            String fileName = "";
            String parentName = "";
            if (panel instanceof IceEditPanel) {
                Resource resource = ((IceEditPanel)panel).getResource();
                parentName = "";
                if (resource != null) {
                    fileName = resource.getName();
                    fileType = resource.getType();
                    if (resource instanceof IceFile) {
                        IceFile parent = null;
                        parent = ((IceFile)resource).getParent();
                        if (parent != null) {
                            parentName = parent.getName();
                        }
                    }
                }
            }
            IcePanelInfo panelInfo = new IcePanelInfo(className, panelName, parentName, fileName, fileType);
            this.panelInfoList.add(panelInfo);
        }
    }
}

