/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.event.communication.DataMessageEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class DataSet {
    private int numPoints = -1;
    protected Map<Integer, Map<String, Double>> data = null;
    protected Map<String, String> header = new HashMap<String, String>();
    private long commandId = 0L;
    private boolean completed = false;
    private Date timestamp;
    private ArrayList<String> messages = null;
    private DataMessageEvent.ScanType scanType;
    private ArrayList<Double> fitPoints = null;
    private ArrayList<String> devices = null;
    private Map<Integer, Date> pointTimestamps;
    private int startPoint;

    public synchronized boolean isCompleted() {
        return this.completed;
    }

    public synchronized void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public DataSet(DataMessageEvent startDataMessage) {
        this.numPoints = startDataMessage.getNumPoints();
        this.devices = startDataMessage.getDevices();
        this.timestamp = startDataMessage.getTimestamp();
        this.data = new TreeMap<Integer, Map<String, Double>>();
        this.messages = new ArrayList(this.numPoints + 3);
        this.pointTimestamps = new TreeMap<Integer, Date>();
        this.commandId = startDataMessage.getCommandId();
        this.header.put("numPoints", String.valueOf(this.numPoints));
        this.header.put("timestamp", DateFormat.getInstance().format(this.timestamp));
        this.header.put("filename", startDataMessage.getFilename());
        this.header.put("instrumentName", startDataMessage.getInstrumentName());
        this.header.put("devices", this.devices.toString());
        this.startPoint = startDataMessage.getStartPoint();
    }

    public Map<String, String> getHeader() {
        return new HashMap<String, String>(this.header);
    }

    public String getHeaderItem(String headerName) {
        return this.header.get(headerName);
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public Map<String, Double> getPointData(int pointNum) {
        return this.data.get(pointNum - 1);
    }

    public Date getPointTimestamp(int pointNum) {
        return this.pointTimestamps.get(pointNum);
    }

    public long getCommandId() {
        return this.commandId;
    }

    public Date getInitTimestamp() {
        return this.timestamp;
    }

    public DataMessageEvent.ScanType getScanType() {
        return this.scanType;
    }

    public ArrayList<Double> getFitParams() {
        return this.fitPoints;
    }

    public String getInstrumentName() {
        return this.header.get("instrumentName");
    }

    public String getFilename() {
        return this.header.get("filename");
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public String getPointMessage(int pointNum) {
        return this.messages.get(pointNum);
    }

    public synchronized void setHeaderData(DataMessageEvent headerMessage) {
    }

    public synchronized boolean addPointData(DataMessageEvent de) {
        if (de.getPointNum() < 0 || (long)de.getCommandId() != this.commandId) {
            return false;
        }
        this.pointTimestamps.put(de.getPointNum() - 1, de.getTimestamp());
        this.data.put(de.getPointNum() - 1, de.getPointMap());
        this.messages.add(de.getMessage());
        return true;
    }

    public synchronized void addFitData(DataMessageEvent de) {
        this.fitPoints = de.getFitPoints();
        this.header.put("fitData", this.fitPoints.toString());
    }

    public synchronized String setHeaderItem(String headerName, String headerText) {
        return this.header.put(headerName, headerText);
    }

    public String toString() {
        String dataSetString = "";
        dataSetString = String.valueOf(dataSetString) + "Header: \n" + this.header.toString() + "\n";
        for (Integer k : this.data.keySet()) {
            dataSetString = String.valueOf(dataSetString) + String.valueOf(k + 1) + ". " + this.data.get(k).toString() + "\n";
        }
        return dataSetString;
    }

    public int getStartPoint() {
        return this.startPoint;
    }
}

