/*
 * Decompiled with CFR 0.152.
 */
package ice.communication.messageHandlers.serverExceptions;

import ice.clientAPI.IceServerException;
import ice.communication.messageHandlers.serverExceptions.ServerExceptionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Vector;
import org.apache.log4j.Logger;

public class IceServerExceptionQueue
implements Queue<IceServerException> {
    private static List<ServerExceptionListener> listeners = new Vector<ServerExceptionListener>();
    private static Map<String, List<ServerExceptionListener>> listenersByDeviceName = new Hashtable<String, List<ServerExceptionListener>>();
    private static Map<String, List<ServerExceptionListener>> listenersByExceptionName = new Hashtable<String, List<ServerExceptionListener>>();
    private static Map<Long, List<ServerExceptionListener>> listenersByCommandId = new Hashtable<Long, List<ServerExceptionListener>>();
    private static Map<Long, List<ServerExceptionListener>> listenersByAbsCommandId = new Hashtable<Long, List<ServerExceptionListener>>();
    protected static Logger logger = Logger.getLogger("NetworkLogger.CommMgrLogger.IceServerExceptionQueueLogger");
    private static final int maxStaticExceptionsToStore = 200;
    protected static final IceServerExceptionQueue exceptionQueue = new IceServerExceptionQueue(200);
    private List<IceServerException> exceptionList;
    private Map<Long, List<IceServerException>> exceptionsByCommandId;
    private Map<String, List<IceServerException>> exceptionsByExceptionName;
    private Map<String, List<IceServerException>> exceptionsByDeviceName;
    private int maxSize;

    public static void receiveExceptionMessage(String message) {
        try {
            IceServerException newExc = IceServerException.parseXml(message);
            if (!exceptionQueue.add(newExc)) {
                if (message == null) {
                    message = "<NULL String>";
                }
                logger.error("Error adding message \"" + message + "\" to exception queue.");
            }
            IceServerExceptionQueue.notifyExceptionListeners(newExc);
        }
        catch (Exception e) {
            if (message == null) {
                message = "<NULL String>";
            }
            logger.error("Error adding message \"" + message + "\" to exception queue.", e);
        }
    }

    private static void notifyExceptionListeners(IceServerException exc) {
        if (exc == null) {
            return;
        }
        for (ServerExceptionListener sel : listeners) {
            try {
                sel.receiveServerException(exc);
            }
            catch (Exception e) {
                logger.error("Error notifying exception listeners listening for all exceptions", e);
            }
        }
        if (listenersByExceptionName.containsKey(exc.getName())) {
            for (ServerExceptionListener sel : listenersByExceptionName.get(exc.getName())) {
                try {
                    sel.receiveServerException(exc);
                }
                catch (Exception e) {
                    logger.error("Error notifying exception listeners by name.", e);
                }
            }
        }
        if (listenersByCommandId.containsKey(exc.getCommandId())) {
            for (ServerExceptionListener sel : listenersByCommandId.get(exc.getCommandId())) {
                try {
                    sel.receiveServerException(exc);
                }
                catch (Exception e) {
                    logger.error("Error notifying exception listeners by command Id.", e);
                }
            }
        }
        if (exc.getDeviceName() != null && exc.getDeviceName() != "" && exc.getDeviceName() != null && listenersByDeviceName.containsKey(exc.getDeviceName().toUpperCase())) {
            for (ServerExceptionListener sel : listenersByDeviceName.get(exc.getDeviceName().toUpperCase())) {
                try {
                    sel.receiveServerException(exc);
                }
                catch (Exception e) {
                    logger.error("Error notifying exception listeners by device name.", e);
                }
            }
        }
        if (exc.getDeviceAlias() != null && exc.getDeviceAlias() != "" && exc.getDeviceAlias() != null && listenersByDeviceName.containsKey(exc.getDeviceAlias().toUpperCase())) {
            for (ServerExceptionListener sel : listenersByDeviceName.get(exc.getDeviceAlias().toUpperCase())) {
                try {
                    sel.receiveServerException(exc);
                }
                catch (Exception e) {
                    logger.error("Error notifying exception listeners by device name for an alias.", e);
                }
            }
        }
    }

    public static void addListenerByCommandId(ServerExceptionListener sl, long commandId) {
        if (listenersByCommandId.containsKey(commandId)) {
            listenersByCommandId.get(commandId).add(sl);
        } else {
            Vector<ServerExceptionListener> newSelList = new Vector<ServerExceptionListener>();
            newSelList.add(sl);
            listenersByCommandId.put(commandId, newSelList);
        }
    }

    public static void addListenerGeneral(ServerExceptionListener sl) {
        if (!listeners.contains(sl)) {
            listeners.add(sl);
        }
    }

    public static void addListenerByAbsCommandId(ServerExceptionListener sl, long commandId) {
        if (listenersByAbsCommandId.containsKey(commandId)) {
            listenersByAbsCommandId.get(commandId).add(sl);
        } else {
            Vector<ServerExceptionListener> newSelList = new Vector<ServerExceptionListener>();
            newSelList.add(sl);
            listenersByAbsCommandId.put(commandId, newSelList);
        }
    }

    public static void addListenerByExceptionName(ServerExceptionListener sl, String exceptionName) {
        if (listenersByExceptionName.containsKey(exceptionName)) {
            listenersByExceptionName.get(exceptionName).add(sl);
        } else {
            Vector<ServerExceptionListener> newSelList = new Vector<ServerExceptionListener>();
            newSelList.add(sl);
            listenersByExceptionName.put(exceptionName, newSelList);
        }
    }

    public static void addListenerByDeviceName(ServerExceptionListener sl, String deviceName) {
        try {
            deviceName = deviceName.toUpperCase();
            if (listenersByDeviceName.containsKey(deviceName)) {
                listenersByDeviceName.get(deviceName).add(sl);
            } else {
                Vector<ServerExceptionListener> newSelList = new Vector<ServerExceptionListener>();
                newSelList.add(sl);
                listenersByDeviceName.put(deviceName, newSelList);
            }
        }
        catch (RuntimeException e) {
            logger.error("IceServerException.addListenerByDeviceName null device name passed " + e);
        }
    }

    public static boolean removeListenerFromAll(ServerExceptionListener sl) {
        boolean itemRemoved = false;
        itemRemoved |= listeners.remove(sl);
        for (List<ServerExceptionListener> listenerList : listenersByAbsCommandId.values()) {
            itemRemoved |= listenerList.remove(sl);
        }
        for (List<ServerExceptionListener> listenerList : listenersByCommandId.values()) {
            itemRemoved |= listenerList.remove(sl);
        }
        for (List<ServerExceptionListener> listenerList : listenersByExceptionName.values()) {
            itemRemoved |= listenerList.remove(sl);
        }
        for (List<ServerExceptionListener> listenerList : listenersByDeviceName.values()) {
            itemRemoved |= listenerList.remove(sl);
        }
        return itemRemoved;
    }

    public static boolean removeListenerGeneral(ServerExceptionListener sl) {
        return listeners.remove(sl);
    }

    public static boolean removeListenerByCommandId(ServerExceptionListener sl, long commandId) {
        if (listenersByCommandId.get(commandId) != null) {
            return listenersByCommandId.get(commandId).remove(sl);
        }
        return false;
    }

    public static boolean removeListenerByAbsCommandId(ServerExceptionListener sl, long commandId) {
        if (listenersByAbsCommandId.get(commandId) != null) {
            return listenersByAbsCommandId.get(commandId).remove(sl);
        }
        return false;
    }

    protected static void removeAllListenersForCommandId(long commandId) {
        listenersByCommandId.remove(commandId);
    }

    public static boolean removeListenerByExceptionName(ServerExceptionListener sl, String exceptionName) {
        if (exceptionName != null && listenersByExceptionName.get(exceptionName) != null) {
            return listenersByExceptionName.get(exceptionName).remove(sl);
        }
        return false;
    }

    public static boolean removeListenerByDeviceName(ServerExceptionListener sl, String deviceName) {
        if (deviceName != null && listenersByDeviceName.get(deviceName.toUpperCase()) != null) {
            boolean returnValue = false;
            List<ServerExceptionListener> selList = listenersByDeviceName.get(deviceName.toUpperCase());
            if (selList != null) {
                returnValue = selList.remove(sl);
            }
            return returnValue;
        }
        return false;
    }

    public static List<IceServerException> getReceivedExceptionsByCommandId(long commandId) {
        return exceptionQueue.getElementsByCommandId(commandId);
    }

    public static List<IceServerException> getReceivedExceptionsByDeviceName(String deviceName) {
        return exceptionQueue.getElementsByDeviceName(deviceName);
    }

    public static List<IceServerException> getReceivedExceptionsByExceptionName(String exceptionName) {
        return exceptionQueue.getElementsByExceptionName(exceptionName);
    }

    public IceServerExceptionQueue(int maxSize) {
        this.maxSize = maxSize;
        this.exceptionList = new Vector<IceServerException>(this.maxSize);
        this.exceptionsByCommandId = new Hashtable<Long, List<IceServerException>>();
        this.exceptionsByExceptionName = new Hashtable<String, List<IceServerException>>();
        this.exceptionsByDeviceName = new Hashtable<String, List<IceServerException>>();
    }

    @Override
    public IceServerException element() {
        try {
            return this.exceptionList.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean offer(IceServerException o) {
        try {
            return this.add(o);
        }
        catch (Exception e) {
            logger.error("Error adding exception to exceptionQueue.", e);
            return false;
        }
    }

    @Override
    public IceServerException peek() {
        try {
            return this.element();
        }
        catch (Exception e) {
            logger.error("Exception encountered in peek method.  null returned.", e);
            return null;
        }
    }

    @Override
    public IceServerException poll() {
        if (this.size() > 0) {
            IceServerException head = this.exceptionList.get(0);
            this.remove(head);
            return head;
        }
        return null;
    }

    @Override
    public IceServerException remove() {
        if (this.size() > 0) {
            IceServerException head = this.exceptionList.get(0);
            this.remove(head);
            return head;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean add(IceServerException o) {
        Vector<IceServerException> newList;
        if (o == null || this.exceptionList.contains(o)) {
            return false;
        }
        if (this.size() == this.maxSize) {
            this.poll();
        }
        this.exceptionList.add(o);
        if (this.exceptionsByCommandId.containsKey(o.getCommandId())) {
            this.exceptionsByCommandId.get(o.getCommandId()).add(o);
        } else {
            newList = new Vector<IceServerException>();
            newList.add(o);
            this.exceptionsByCommandId.put(o.getCommandId(), newList);
        }
        if (this.exceptionsByExceptionName.containsKey(o.getName())) {
            this.exceptionsByExceptionName.get(o.getName()).add(o);
        } else {
            newList = new Vector();
            newList.add(o);
            this.exceptionsByExceptionName.put(o.getName(), newList);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends IceServerException> c) {
        boolean exceptionListChanged = false;
        for (IceServerException iceServerException : c) {
            exceptionListChanged |= this.offer(iceServerException);
        }
        return exceptionListChanged;
    }

    @Override
    public void clear() {
        this.exceptionList = new Vector<IceServerException>(this.size());
        this.exceptionsByCommandId = new Hashtable<Long, List<IceServerException>>();
        this.exceptionsByExceptionName = new Hashtable<String, List<IceServerException>>();
        this.exceptionsByDeviceName = new Hashtable<String, List<IceServerException>>();
    }

    @Override
    public boolean contains(Object o) {
        return this.exceptionList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.exceptionList.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.exceptionList.isEmpty();
    }

    @Override
    public Iterator<IceServerException> iterator() {
        return this.exceptionList.iterator();
    }

    @Override
    public boolean remove(Object o) {
        IceServerException removeTarget = (IceServerException)o;
        boolean objectRemoved = this.exceptionList.remove(removeTarget);
        this.exceptionsByCommandId.get(removeTarget.getCommandId()).remove(removeTarget);
        this.exceptionsByExceptionName.get(removeTarget.getName()).remove(removeTarget);
        this.exceptionsByDeviceName.get(removeTarget.getDeviceName()).remove(removeTarget);
        if (this.exceptionsByCommandId.get(removeTarget.getCommandId()).isEmpty()) {
            this.exceptionsByCommandId.remove(removeTarget.getCommandId());
        }
        return objectRemoved;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean objectRemoved = false;
        for (Object element : c) {
            objectRemoved |= this.remove(element);
        }
        return objectRemoved;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<IceServerException> removeList = new ArrayList<IceServerException>();
        for (IceServerException exc : this.exceptionList) {
            if (c.contains(exc)) continue;
            removeList.add(exc);
        }
        return this.removeAll(removeList);
    }

    @Override
    public int size() {
        return this.exceptionList.size();
    }

    @Override
    public Object[] toArray() {
        return this.exceptionList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.exceptionList.toArray(a);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public List<IceServerException> getElementsByCommandId(long commandId) {
        Vector excList = (Vector)this.exceptionsByCommandId.get(commandId);
        if (excList == null) {
            return null;
        }
        return new Vector<IceServerException>(excList);
    }

    public List<IceServerException> getElementsByDeviceName(String deviceName) {
        Vector excList = (Vector)this.exceptionsByDeviceName.get(deviceName);
        if (excList == null) {
            return null;
        }
        return new Vector<IceServerException>(excList);
    }

    public List<IceServerException> getElementsByExceptionName(String exceptionName) {
        Vector excList = (Vector)this.exceptionsByExceptionName.get(exceptionName);
        if (excList == null) {
            return null;
        }
        return new Vector<IceServerException>(excList);
    }
}

