/*
 * Decompiled with CFR 0.152.
 */
package ice.communication;

import ice.communication.CommunicationManager;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SendQueueManager
implements Runnable {
    protected static Logger loggerInfoToServer = Logger.getLogger("InfoToServerLogger");
    private static Logger logger = Logger.getLogger(SendQueueManager.class);
    private static SendQueueManager instance;
    private LinkedBlockingQueue<Message> sendQueue;
    private CommunicationManager commMgr;
    private boolean keepRunning;

    public static SendQueueManager createInstance(CommunicationManager commMgr) {
        if (instance == null) {
            instance = new SendQueueManager(commMgr);
            return instance;
        }
        throw new UnsupportedOperationException("Instance already exists.");
    }

    public static SendQueueManager getInstance() {
        if (instance != null) {
            return instance;
        }
        throw new UnsupportedOperationException("Instance not created!");
    }

    private SendQueueManager(CommunicationManager commMgr) {
        this.commMgr = commMgr;
        this.sendQueue = new LinkedBlockingQueue();
    }

    public void addMessage(String newMsg) {
        logger.debug("adding message: " + newMsg);
        this.sendQueue.add(new Message(newMsg, true));
    }

    public void addMessage(String newMsg, boolean echoFlag) {
        logger.debug("adding message: " + newMsg);
        this.sendQueue.add(new Message(newMsg, echoFlag));
    }

    public void stopRunning() {
        this.keepRunning = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.keepRunning = true;
        try {
            while (true) {
                if (!this.keepRunning) {
                    return;
                }
                Message msg = this.sendQueue.poll(2L, TimeUnit.SECONDS);
                try {
                    if (msg == null) continue;
                    this.commMgr.sendMessage(msg.cmd, msg.echo);
                    loggerInfoToServer.debug(msg.cmd);
                }
                catch (IOException ioe) {
                    logger.error("Error sending message in comm mgr.  Ignoring:" + ioe);
                }
            }
        }
        catch (InterruptedException ie) {
            logger.error("Interrupted while waiting on queue.  Stopping run(): " + ie);
            return;
        }
        catch (RuntimeException re) {
            System.out.println(re);
        }
    }

    private class Message {
        public boolean echo;
        public String cmd;

        public Message(String cmd, boolean echo) {
            this.echo = echo;
            this.cmd = cmd;
        }
    }
}

