/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.QueuedCommand;

public class ScanDescrToListCommand
extends QueuedCommand {
    private static final String command = "SCAN DESCRTOLIST ";
    private String scanName = null;
    private String scanDescription = null;
    private long commandID = 0L;

    public ScanDescrToListCommand() throws NoClientAPIInstanceException {
    }

    public ScanDescrToListCommand(String scanFileName, String scanDescription) throws NoClientAPIInstanceException {
        super(command + scanFileName + " " + scanDescription);
        this.scanName = scanFileName;
        this.scanDescription = scanDescription;
        this.commandID = this.getCommandId();
        this.generateCommandString();
    }

    public ScanDescrToListCommand(String scanFileName, String scanDescription, ClientAPI clientApiRef) {
        super(command + scanFileName + " " + scanDescription, clientApiRef);
        this.scanName = scanFileName;
        this.scanDescription = scanDescription;
        this.commandID = this.getCommandId();
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString(command + this.scanName + " " + this.scanDescription);
        return command + this.scanName + " " + this.scanDescription;
    }

    public String getScanFileName() {
        return this.scanName;
    }

    public void setScanFileName(String scanFileName) {
        this.scanName = scanFileName;
        this.generateCommandString();
    }

    public String getScanDescription() {
        return this.scanDescription;
    }

    public void setScanDescription(String scanDescription) {
        this.scanDescription = scanDescription;
        this.generateCommandString();
    }

    public void setCommandID(long id) {
        this.commandID = id;
        this.setCommandId(id);
        this.generateCommandString();
    }

    public String getQueueCommandString() {
        return command + this.scanName + " " + this.scanDescription;
    }
}

