/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.IceServerException;
import ice.clientAPI.MessageQueue;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.Command;
import ice.commands.StackAddCommand;
import ice.communication.messageHandlers.serverExceptions.IceServerExceptionQueue;
import ice.communication.messageHandlers.serverExceptions.ServerExceptionListener;
import ice.data.DataSet;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class QueuedCommand
extends Command {
    private StackAddCommand stackAddCmd = null;
    private MessageQueue<String> responseMessageQueue = null;
    private MessageQueue<String> errorMessageQueue = null;
    private DataSet data = null;
    private long commandId = 0L;
    private Logger logger = Logger.getLogger("ICE.Commands.QueuedCommand");
    protected int pollingPeriod = 500;

    public QueuedCommand(String command, ClientAPI clientApiRef) {
        super(clientApiRef);
        this.setCommandString(command);
    }

    public QueuedCommand(String command) throws NoClientAPIInstanceException {
        this.setCommandString(command);
    }

    protected QueuedCommand(ClientAPI clientApiRef) throws NoClientAPIInstanceException {
        super(clientApiRef);
    }

    protected QueuedCommand() throws NoClientAPIInstanceException {
    }

    protected String stripResponseString(String response) {
        Pattern userRegEx = Pattern.compile("User\\s*[^:]*:");
        Pattern commandIDRegEx = Pattern.compile("\\(commandId=([-+]*[0123456789]+)\\)");
        Matcher matcher = userRegEx.matcher(response);
        String actualResponse = response;
        if (matcher.find()) {
            actualResponse = matcher.replaceFirst("");
        }
        matcher = userRegEx.matcher(actualResponse);
        matcher = commandIDRegEx.matcher(actualResponse);
        if (matcher.find()) {
            actualResponse = matcher.replaceFirst("");
        }
        actualResponse = actualResponse.trim();
        return actualResponse;
    }

    protected boolean parseOneLineResponse() {
        MessageQueue<String> messageQueue = this.getResponseMessageQueue();
        MessageQueue<String> commandMessageQueue = messageQueue.getMessagesForAbsCommandId(this.getCommandId());
        if (messageQueue.size() != 1) {
            this.setError(true);
            this.setSuccess(false);
            this.setResponseString(commandMessageQueue.toString());
            return false;
        }
        String firstMessage = commandMessageQueue.remove();
        String responseString = this.stripResponseString(firstMessage);
        if (responseString == null) {
            this.setError(true);
            this.setSuccess(false);
            this.setResponseString(commandMessageQueue.toString());
            return false;
        }
        this.setError(false);
        this.setSuccess(true);
        this.setResponseString(responseString);
        return true;
    }

    @Override
    protected boolean issueAsynchronous() {
        try {
            this.stackAddCmd = new StackAddCommand(this.getCommandString());
            this.stackAddCmd.run();
        }
        catch (NoClientAPIInstanceException e) {
            this.logger.error("Error creating new stack add command.", e);
            return false;
        }
        catch (ICEListenerListExceptionBase e) {
            this.logger.error("Error creating new stack add command.", e);
            return false;
        }
        this.setCommandId(this.stackAddCmd.getCommandID());
        IceServerExceptionQueue.removeListenerFromAll(this);
        this.commandExceptions = new Vector();
        List<IceServerException> existingExceptions = IceServerExceptionQueue.getReceivedExceptionsByCommandId(this.stackAddCmd.getCommandID());
        if (existingExceptions != null) {
            this.commandExceptions.addAll(existingExceptions);
        }
        this.setResponseString(this.stackAddCmd.getResponse());
        return !this.stackAddCmd.isError();
    }

    @Override
    protected boolean issueSynchronous() {
        MessageQueue<String> errorMessagesAfterRun;
        try {
            this.stackAddCmd = new StackAddCommand(this.getCommandString());
            this.stackAddCmd.run();
        }
        catch (NoClientAPIInstanceException e1) {
            this.logger.error("Error creating new stack add command", e1);
            return false;
        }
        catch (ICEListenerListExceptionBase e) {
            this.logger.error("Error creating new stack add command", e);
            return false;
        }
        this.setCommandId(this.stackAddCmd.getCommandID());
        IceServerExceptionQueue.removeListenerFromAll(this);
        this.commandExceptions = new Vector();
        this.getClientApiRef().waitOnCommandId(this.getCommandId());
        this.responseMessageQueue = this.getClientApiRef().getConsoleMessagesForAbsCommandID(this.getCommandId());
        this.errorMessageQueue = this.getClientApiRef().getErrorMessages(this.getCommandId());
        List<IceServerException> existingExceptions = IceServerExceptionQueue.getReceivedExceptionsByCommandId(this.getCommandId());
        if (existingExceptions != null) {
            this.commandExceptions.addAll(existingExceptions);
        }
        if ((errorMessagesAfterRun = this.getClientApiRef().getErrorMessages(this.getCommandId() * -1L)) != null) {
            this.errorMessageQueue.addAll((Collection<String>)errorMessagesAfterRun);
        }
        return true;
    }

    @Override
    public String generateCommandString() {
        return this.getCommandString();
    }

    @Override
    protected void parseSynchronousResponse() {
        this.data = this.getClientApiRef().getDataSetByCommandId(this.stackAddCmd.getCommandID());
        if (!this.errorMessageQueue.isEmpty()) {
            this.setError(true);
            this.setResponseString("ERRORS: \n" + this.errorMessageQueue.toString() + "\nRESPONSE: \n" + this.responseMessageQueue.toString());
        } else {
            this.setSuccess(this.stackAddCmd.isSuccess());
            this.setResponseString(this.responseMessageQueue.toString());
        }
    }

    @Override
    protected void parseAsynchronousResponse() {
        this.setSuccess(this.stackAddCmd.isSuccess());
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.data = null;
        this.errorMessageQueue = null;
        this.responseMessageQueue = null;
        this.stackAddCmd = null;
    }

    protected MessageQueue<String> getErrorMessageQueue() {
        return this.errorMessageQueue;
    }

    protected MessageQueue<String> getResponseMessageQueue() {
        return this.responseMessageQueue;
    }

    public DataSet getData() {
        return this.data;
    }

    public long getCommandId() {
        return this.commandId;
    }

    protected void setCommandId(long commandId) {
        this.commandId = commandId;
    }

    public int getPollingPeriod() {
        return this.pollingPeriod;
    }

    public void setPollingPeriod(int pollingPeriod) {
        this.pollingPeriod = pollingPeriod;
    }

    @Override
    public void receiveServerException(IceServerException e) {
        this.commandExceptions.add(e);
    }

    public boolean registerCommandExceptionListener(ServerExceptionListener sl) {
        if (this.getCommandId() > 0L) {
            IceServerExceptionQueue.addListenerByCommandId(sl, this.getCommandId());
            return true;
        }
        return false;
    }

    public boolean removeCommandListener(ServerExceptionListener sl) {
        return IceServerExceptionQueue.removeListenerByCommandId(sl, this.getCommandId());
    }

    public void listenForServerExceptionsByCommandId() {
        IceServerExceptionQueue.addListenerByCommandId(this, this.getCommandId());
    }

    public boolean stopListeningForServerExceptionsByCommandId() {
        return IceServerExceptionQueue.removeListenerByCommandId(this, this.getCommandId());
    }

    public void listenForServerExceptionsByAbsCommandId() {
        IceServerExceptionQueue.addListenerByAbsCommandId(this, this.getCommandId());
    }

    public boolean stopListeningForServerExceptionsByAbsCommandId() {
        return IceServerExceptionQueue.removeListenerByAbsCommandId(this, this.getCommandId());
    }

    public boolean stopListeningForServerExceptions() {
        return IceServerExceptionQueue.removeListenerFromAll(this);
    }
}

