/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class FileGetCommand
extends ImmediateCommand {
    protected static final String BASE_COMMAND_STRING = "File Get ";
    protected static final String RESPONSE_TAG = "Transfer";
    protected String magicWord = null;
    protected String fileName = null;
    protected String result = null;

    public FileGetCommand(String magicWord, String fileName) throws NoClientAPIInstanceException {
        this.init(magicWord, fileName);
    }

    protected FileGetCommand(String magicWord, String fileName, ClientAPI clientApiRef) {
        super(clientApiRef);
        this.init(magicWord, fileName);
    }

    protected FileGetCommand() throws NoClientAPIInstanceException {
    }

    protected FileGetCommand(ClientAPI clientApiRef) {
        super(clientApiRef);
    }

    protected FileGetCommand(String command, ClientAPI clientApiRef) {
        super(command, clientApiRef);
    }

    protected FileGetCommand(String command) throws NoClientAPIInstanceException {
        super(command);
    }

    protected void init(String magicWord, String fileName) {
        this.magicWord = magicWord == null ? "" : magicWord;
        this.fileName = fileName == null ? "" : fileName;
    }

    @Override
    public synchronized String generateCommandString() {
        String commandString = BASE_COMMAND_STRING;
        if (this.magicWord != null && !this.magicWord.equals("")) {
            commandString = String.valueOf(commandString) + this.magicWord + ":";
        }
        commandString = String.valueOf(commandString) + this.fileName;
        this.setCommandString(commandString);
        return commandString;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        try {
            String response = this.getResponse();
            Object limits = null;
            boolean charSpaceIndex = false;
            boolean success = false;
            response = response.trim();
            success = response.startsWith(RESPONSE_TAG);
            if (success) {
                this.result = response.substring(response.indexOf(" ") + 1);
                this.result = this.result.substring(this.result.indexOf(" ") + 1);
                this.setSuccess(true);
                this.setError(false);
            } else {
                this.result = response;
                this.setSuccess(false);
                this.setError(true);
            }
        }
        catch (Exception notDouble) {
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public String getResult() {
        return this.result;
    }
}

