/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.QueuedCommand;

public class DeviceSetPropertyCommand
extends QueuedCommand {
    private static String command = "Device SetProperty";
    protected ErrorType errorType = ErrorType.UNKNOWN;
    protected String deviceName;
    protected String propertyName;
    protected String propertyValueString;

    public DeviceSetPropertyCommand() throws NoClientAPIInstanceException {
    }

    public DeviceSetPropertyCommand(String deviceName, String propertyName, String propertyValueString, ClientAPI clientApiRef) {
        super("", clientApiRef);
        this.deviceName = deviceName;
        this.propertyName = propertyName;
        this.propertyValueString = propertyValueString;
        this.generateCommandString();
    }

    public DeviceSetPropertyCommand(String deviceName, String propertyName, String propertyValueString) throws NoClientAPIInstanceException {
        this.deviceName = deviceName;
        this.propertyName = propertyName;
        this.propertyValueString = propertyValueString;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString(String.valueOf(command) + " " + this.deviceName + " " + this.propertyName + " " + this.propertyValueString);
        return this.getCommandString();
    }

    @Override
    protected void parseSynchronousResponse() {
        String expectedResponse;
        String response;
        if (this.parseOneLineResponse() && (response = this.getResponse()).compareToIgnoreCase(expectedResponse = String.valueOf(this.propertyName) + " set to " + this.propertyValueString) != 0) {
            this.setError(true);
            this.setSuccess(false);
            this.errorType = ErrorType.UNKNOWN;
            return;
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyValueString() {
        return this.propertyValueString;
    }

    public void setPropertyValueString(String propertyValueString) {
        this.propertyValueString = propertyValueString;
    }

    private static enum ErrorType {
        UNKNOWN;

    }
}

