/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class DeviceGetLimitsCommand
extends ImmediateCommand {
    private static final String command = "DEVICE GETLIMITS ";
    private String deviceName = null;

    public DeviceGetLimitsCommand() throws NoClientAPIInstanceException {
    }

    public DeviceGetLimitsCommand(String deviceName) throws NoClientAPIInstanceException {
        super(command + deviceName);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public DeviceGetLimitsCommand(String deviceName, ClientAPI clientApiRef) {
        super(command + deviceName, clientApiRef);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString(command + this.deviceName);
        return command + this.deviceName;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        try {
            String response = this.getResponse();
            String lowerLimitStr = null;
            String upperLimitStr = null;
            String limits = null;
            int charSpaceIndex = 0;
            double lowerLimitDbl = 0.0;
            double upperLimitDbl = 0.0;
            response = response.trim();
            limits = response.substring(response.indexOf(" "));
            limits = limits.trim();
            charSpaceIndex = limits.indexOf(" ");
            lowerLimitStr = limits.substring(0, charSpaceIndex);
            upperLimitStr = limits.substring(charSpaceIndex, limits.length());
            upperLimitStr = upperLimitStr.trim();
            lowerLimitDbl = Double.parseDouble(lowerLimitStr);
            upperLimitDbl = Double.parseDouble(upperLimitStr);
            this.setSuccess(true);
            this.setError(false);
        }
        catch (NumberFormatException notDouble) {
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public String getImmediateCommandString() {
        return command + this.deviceName;
    }
}

