/*
 * Decompiled with CFR 0.152.
 */
package ice;

import ice.Global;
import ice.communication.CommunicationManager;
import ice.communication.SendQueueManager;
import ice.data.DataManager;
import ice.data.Experiment;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.data.InstalledDevice;
import ice.data.InstalledMagnetDevice;
import ice.data.InstalledMiscDevice;
import ice.data.InstalledPressureDevice;
import ice.data.InstalledTempDevice;
import ice.data.Queue;
import ice.data.Sample;
import ice.data.ScanList;
import ice.data.tas.bt7.Instrument;
import ice.data.tas.bt7.PeakSet;
import ice.data.tas.bt7.UBMatrix;
import ice.event.DeviceEvent;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.ExperimentChangeListener;
import ice.event.FatalErrorEvent;
import ice.event.FatalErrorListener;
import ice.event.InitializationEvent;
import ice.event.InitializationEventListener;
import ice.event.SaveScanEvent;
import ice.event.SaveScanListener;
import ice.event.StartUpEvent;
import ice.event.StartUpListener;
import ice.event.communication.ConnectionEvent;
import ice.event.communication.ConnectionListener;
import ice.event.communication.DeviceChangeEvent;
import ice.event.communication.DeviceChangeListener;
import ice.event.communication.DeviceRemoveEvent;
import ice.event.communication.ExperimentChangeEvent;
import ice.event.communication.FileChangeEvent;
import ice.event.communication.FileChangeListener;
import ice.event.communication.IceFileContentsChangeEvent;
import ice.event.communication.IceFileContentsChangeListener;
import ice.event.communication.InstrumentChangeEvent;
import ice.event.communication.InstrumentChangeListener;
import ice.event.communication.PeakListData;
import ice.event.communication.PeakSetData;
import ice.event.communication.QueueChangeEvent;
import ice.event.communication.QueueChangeListener;
import ice.event.communication.SampleChangeEvent;
import ice.event.communication.SampleChangeListener;
import ice.event.communication.ScanListChangeEvent;
import ice.event.communication.ScanListChangeListener;
import ice.event.communication.StatusChangeEvent;
import ice.event.communication.StatusChangeListener;
import ice.event.communication.UBMatrixChangeEvent;
import ice.event.communication.UBMatrixChangeListener;
import ice.event.request.ChangeInstrReqListener;
import ice.event.request.IceWindowRequest;
import ice.util.FileManager;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class Controller
implements ConnectionListener,
ActionListener,
FatalErrorListener,
StatusChangeListener,
SaveScanListener,
ExperimentChangeListener,
QueueChangeListener,
ScanListChangeListener,
FileChangeListener,
SampleChangeListener,
InstrumentChangeListener,
DeviceChangeListener,
IceFileContentsChangeListener,
UBMatrixChangeListener,
ChangeInstrReqListener {
    private static Logger logger = Logger.getLogger("ControllerLogger");
    private Experiment experiment;
    private ArrayList<ChangeListener> expChangeListeners;
    private Sample sample;
    private ArrayList<ChangeListener> sampleChangeListeners;
    private ArrayList<InitializationEventListener> initializationEventListeners = new ArrayList();
    private ArrayList<FatalErrorListener> fatalErrorListeners = new ArrayList();
    private Queue serverQueue;
    private ScanList serverScanList;
    protected UBMatrix ubMatrix;
    private Instrument instrument;
    private ArrayList<InstalledDevice> deviceList;
    private ArrayList<DeviceListListener> deviceListListeners;
    private FileManager fileInterface;
    private IceFile rootFile;
    private IceFile userFolder;
    private CommunicationManager commMgr;
    private SendQueueManager sendManager;
    private DataManager dataManager;
    private IceFile expFolder;
    private IceFile commonFolder = null;
    private boolean experimentInitialized = false;
    private boolean queueInitialized = false;
    private boolean scanListInitialized = false;
    private boolean userFolderInitialized = true;
    private boolean commonFolderInitialized = true;
    private boolean experimentFolderInitialized = false;
    private boolean sampleInitialized = false;
    private boolean devicesInitialized = false;
    protected boolean ubMatrixInitiliazed = false;
    private boolean instrumentInitialized = false;
    private static Controller reference = null;
    public static String comManagerString = "IceCommunicationManagerThread";
    public static String sendManagerString = "IceQueueSendManagerThread";
    private ICEListenerList<StartUpListener, StartUpEvent> startUpListeners;

    public static Controller getReference() {
        if (reference == null) {
            reference = new Controller();
        }
        return reference;
    }

    private Controller() {
        String username = null;
        String display = null;
        username = System.getProperty("user.name");
        display = System.getenv("DISPLAY");
        if (display == null || display.trim().length() == 0) {
            display = ":99";
        }
        this.instrument = Instrument.getInstance();
        this.experiment = new Experiment();
        this.serverQueue = new Queue(this.instrument);
        this.serverScanList = new ScanList();
        this.expChangeListeners = new ArrayList();
        this.sample = new Sample();
        this.sampleChangeListeners = new ArrayList();
        this.deviceList = new ArrayList();
        this.deviceListListeners = new ArrayList();
        this.rootFile = new IceFile("/", IceFileType.directory);
        this.expFolder = new IceFile("EXPT", IceFileType.directory, true);
        this.commonFolder = new IceFile("COMM", IceFileType.directory, true);
        this.rootFile.add(this.expFolder);
        this.userFolder = new IceFile("USER", IceFileType.directory, true);
        this.rootFile.add(this.userFolder);
        this.rootFile.add(this.commonFolder);
        this.ubMatrix = new UBMatrix();
        this.fileInterface = FileManager.getInstance();
        this.commMgr = new CommunicationManager(username, display);
        this.startUpListeners = new ICEListenerList();
        try {
            this.commMgr.addConnectionListener(this);
            this.commMgr.addStatusListener(this.instrument);
            this.commMgr.addStatusListener(this);
            this.commMgr.addFileChangeListener(this);
            this.commMgr.addExperimentListener(this);
            this.commMgr.addSampleListener(this);
            this.commMgr.addScanListChangeListener(this);
            this.commMgr.addQueueChangeListener(this);
            this.commMgr.addDeviceChangeListener(this);
            this.commMgr.addInstrumentChangeListener(this.instrument);
            this.commMgr.addInstrumentChangeListener(this);
            this.commMgr.addIceFileContentsChangeListener(this);
            this.commMgr.addUBMatrixChangeListener(this);
            this.sendManager = SendQueueManager.createInstance(this.commMgr);
            this.dataManager = new DataManager();
            this.commMgr.addDataMessageListener(this.dataManager);
        }
        catch (Exception e) {
            logger.error("Could not add Listener " + e);
        }
    }

    protected void finalize() {
    }

    @Override
    public void fatalError(FatalErrorEvent fee) {
        if (this.fatalErrorListeners.isEmpty()) {
            System.exit(1);
        } else {
            for (FatalErrorListener fel : this.fatalErrorListeners) {
                fel.fatalError(fee);
            }
        }
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public SendQueueManager getSendManager() {
        return this.sendManager;
    }

    public Queue getServerQueue() {
        return this.serverQueue;
    }

    public CommunicationManager getCommMgr() {
        return this.commMgr;
    }

    public ArrayList<ChangeListener> getExpChangeListeners() {
        return this.expChangeListeners;
    }

    public ScanList getServerScanList() {
        return this.serverScanList;
    }

    public IceFile getRootFile() {
        return this.rootFile;
    }

    public IceFile getExpFolder() {
        return this.expFolder;
    }

    public IceFile getCommonFolder() {
        return this.commonFolder;
    }

    public Sample getSample() {
        return this.sample;
    }

    public UBMatrix getUbMatrix() {
        return this.ubMatrix;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    protected DataManager getDataManager() {
        return this.dataManager;
    }

    public boolean isInstrumentInitialized() {
        return this.instrument.isInitialized();
    }

    public void addSampleChangeListener(ChangeListener scl) {
        this.sampleChangeListeners.add(scl);
    }

    protected void addExpChangeListener(ChangeListener ecl) {
        this.expChangeListeners.add(ecl);
    }

    public void addDeviceListListener(DeviceListListener dl) {
        this.deviceListListeners.add(dl);
    }

    protected void addInitializationEventListener(InitializationEventListener initEventListener) {
        this.initializationEventListeners.add(initEventListener);
    }

    protected void notifyInitializationEventListeners(InitializationEvent initEvent) {
        for (InitializationEventListener initListener : this.initializationEventListeners) {
            initListener.handleInitializationEvent(initEvent);
        }
    }

    @Override
    public synchronized void receiveConnectionEvent(ConnectionEvent ce) {
        block1: {
            ConnectionEvent.ConnectionState state;
            block3: {
                block2: {
                    block0: {
                        state = ce.getConnectionState();
                        logger.debug("connection result: " + (Object)((Object)state));
                        if (state != ConnectionEvent.ConnectionState.RECONNECTION_SUCCESS) break block0;
                        new Thread((Runnable)this.commMgr, comManagerString).start();
                        this.sendManager.addMessage("status -all");
                        break block1;
                    }
                    if (state != ConnectionEvent.ConnectionState.RECONNECTION_FAILURE) break block2;
                    this.commMgr.reconnect();
                    break block1;
                }
                if (state != ConnectionEvent.ConnectionState.INITIAL_CONNECTION_SUCCESS) break block3;
                logger.debug("Connection to server successful.");
                this.sendManager.addMessage("status -all", false);
                new Thread((Runnable)this.commMgr, comManagerString).start();
                new Thread((Runnable)this.sendManager, sendManagerString).start();
                break block1;
            }
            if (state != ConnectionEvent.ConnectionState.INITIAL_CONNECTION_FAILURE) break block1;
            logger.debug("Connection to server failed: " + ce.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String name = ((JComponent)ae.getSource()).getName();
        if (name.equalsIgnoreCase("consoleInputText")) {
            String cmd = ((JTextField)ae.getSource()).getText();
            try {
                this.commMgr.sendMessage(cmd);
            }
            catch (IOException ioe) {
                logger.error("need to catch this better:", ioe);
            }
        }
    }

    @Override
    public void actionPerformed(FileChangeEvent fe) {
        IceFile file;
        String rootName = fe.getMagicWord();
        String absolutePath = fe.getAbsolutePath();
        int dirIndex = this.rootFile.getIndexOfChild(rootName);
        ArrayList<String> files = fe.getFiles();
        ArrayList<String> filesToAdd = new ArrayList<String>();
        ArrayList<IceFile> filesToRemove = new ArrayList<IceFile>();
        if (dirIndex == -1) {
            logger.debug("creating new directory");
            file = new IceFile(rootName, IceFileType.directory);
            this.rootFile.add(file);
            Iterator<String> iterator = files.iterator();
            while (iterator.hasNext()) {
                filesToAdd.add(iterator.next());
            }
        } else {
            logger.debug("updating pre-existing directory");
            file = this.rootFile.getChildAt(dirIndex);
            StringTokenizer tokenizer = new StringTokenizer(absolutePath, "\\");
            while (tokenizer.hasMoreTokens()) {
                String directory = tokenizer.nextToken();
                int subDirIndex = file.getIndexOfChild(directory);
                if (subDirIndex != -1) {
                    file = file.getChildAt(subDirIndex);
                    continue;
                }
                logger.error("Unable to find directory \"" + rootName + ":" + absolutePath + ".  Aborting.  THIS SHOULDN'T HAPPEN!");
            }
            for (String fileName : files) {
                int childIndex = file.getIndexOfChild(fileName);
                if (childIndex != -1) continue;
                logger.debug("adding: " + fileName);
                filesToAdd.add(fileName);
            }
            for (IceFile child : file.getChildren()) {
                int fileIndex = files.indexOf(child.getName());
                if (fileIndex != -1) continue;
                filesToRemove.add(child);
                logger.debug("need to remove " + child.getName());
            }
        }
        for (String fileName : filesToAdd) {
            IceFileType fileType = IceFileType.other;
            if (fileName.toUpperCase().endsWith(IceFileType.scanList.getExtension().toUpperCase())) {
                fileType = IceFileType.scanList;
            } else if (fileName.toUpperCase().endsWith(".SEQ.TXT")) {
                fileType = IceFileType.sequence;
            } else if (fileName.toUpperCase().endsWith(".PY")) {
                fileType = IceFileType.pythonScript;
            } else if (fileName.toUpperCase().endsWith("." + this.instrument.getName())) {
                fileType = IceFileType.data;
            } else if (fileName.toUpperCase().endsWith(IceFileType.xml.getExtension().toUpperCase())) {
                fileType = IceFileType.xml;
            } else if (!fileName.contains(".")) {
                fileType = IceFileType.directory;
            }
            IceFile child = new IceFile(fileName, fileType);
            file.add(child);
        }
        for (IceFile fileToRemove : filesToRemove) {
            logger.debug("result: " + file.remove(fileToRemove));
        }
        file.setInitialized(true);
        logger.debug("rootName: " + rootName);
        if (!this.userFolderInitialized && rootName.equals("USER")) {
            logger.debug("User folder initialized.");
            this.userFolderInitialized = true;
            this.checkForInitialized();
        } else if (!this.commonFolderInitialized && rootName.equals("COMM")) {
            logger.debug("Common folder initialized.");
            this.commonFolderInitialized = true;
            this.checkForInitialized();
        } else if (!this.experimentFolderInitialized && rootName.equals("EXPT")) {
            logger.debug("Experiment folder initialized.");
            this.experimentFolderInitialized = true;
            this.checkForInitialized();
        }
    }

    @Override
    public void scanSaved(SaveScanEvent sse) {
        logger.debug("new scan saved: " + sse.getScanDescription());
        try {
            this.commMgr.sendMessage("scan descrtolist \"" + sse.getScanName() + "\" " + sse.getScanDescription(), true);
        }
        catch (IOException ioe) {
            logger.error("Unable to send scan to server:", ioe);
        }
    }

    @Override
    public void actionPerformed(ExperimentChangeEvent ee) {
        this.experiment.setID(ee.getID());
        this.experiment.setName(ee.getName());
        this.experiment.setParticipants(ee.getParticipants());
        this.experiment.setDetails(ee.getDetails());
        this.experiment.setComments(ee.getComment());
        this.notifyExpListeners();
        if (!this.experimentInitialized) {
            logger.debug("Experiment initialized.");
            this.experimentInitialized = true;
            this.checkForInitialized();
        }
    }

    private void notifyExpListeners() {
        Iterator<ChangeListener> iterator = this.expChangeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(new ChangeEvent(this.experiment));
        }
    }

    @Override
    public void actionPerformed(SampleChangeEvent se) {
        this.sample.setA(se.getA());
        this.sample.setB(se.getB());
        this.sample.setC(se.getC());
        this.sample.setAlpha(se.getAlpha());
        this.sample.setBeta(se.getBeta());
        this.sample.setGamma(se.getGamma());
        this.sample.setH1(se.getH1());
        this.sample.setK1(se.getK1());
        this.sample.setL1(se.getL1());
        this.sample.setH2(se.getH2());
        this.sample.setK2(se.getK2());
        this.sample.setL2(se.getL2());
        this.sample.setThk(se.getThk());
        this.sample.setTrans(se.getTrans());
        this.sample.setApert(se.getApert());
        this.sample.setDescription(se.getDescription());
        this.notifySampleListeners();
        if (!this.sampleInitialized) {
            logger.debug("Sample initialized.");
            this.sampleInitialized = true;
            this.checkForInitialized();
        }
    }

    private void notifySampleListeners() {
        Iterator<ChangeListener> iterator = this.sampleChangeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(new ChangeEvent(this.sample));
        }
    }

    public ArrayList<InstalledDevice> getDeviceList() {
        return this.deviceList;
    }

    public ArrayList<DeviceListListener> getDeviceListeners() {
        return this.deviceListListeners;
    }

    public InstalledDevice getFirstDevice(String deviceName) {
        for (InstalledDevice device : this.deviceList) {
            if (!device.getName().equalsIgnoreCase(deviceName) && !device.getRealName().equalsIgnoreCase(deviceName)) continue;
            return device;
        }
        return null;
    }

    public ArrayList<InstalledDevice> getAllDevices(String deviceName) {
        ArrayList<InstalledDevice> devices = new ArrayList<InstalledDevice>();
        for (InstalledDevice device : this.deviceList) {
            if (!device.getName().equalsIgnoreCase(deviceName) && !device.getRealName().equalsIgnoreCase(deviceName)) continue;
            devices.add(device);
        }
        return devices;
    }

    public ArrayList<InstalledDevice> getEnvDevices() {
        ArrayList<InstalledDevice> envList = new ArrayList<InstalledDevice>();
        for (InstalledDevice device : this.deviceList) {
            if (device.getType() != InstalledDevice.Type.environment) continue;
            envList.add(device);
        }
        return envList;
    }

    public ArrayList<InstalledDevice> getCounterDevices() {
        ArrayList<InstalledDevice> ctrList = new ArrayList<InstalledDevice>();
        for (InstalledDevice device : this.deviceList) {
            if (device.getType() != InstalledDevice.Type.counter) continue;
            ctrList.add(device);
        }
        return ctrList;
    }

    public ArrayList<InstalledDevice> getTempDevices() {
        ArrayList<InstalledDevice> tempList = new ArrayList<InstalledDevice>();
        for (InstalledDevice device : this.deviceList) {
            if (!(device instanceof InstalledTempDevice)) continue;
            tempList.add(device);
        }
        return tempList;
    }

    public ArrayList<InstalledDevice> getMagnetDevices() {
        ArrayList<InstalledDevice> magList = new ArrayList<InstalledDevice>();
        for (InstalledDevice device : this.deviceList) {
            if (!(device instanceof InstalledMagnetDevice)) continue;
            magList.add(device);
        }
        return magList;
    }

    public ArrayList<InstalledDevice> getNonEnvDevices() {
        ArrayList<InstalledDevice> nonEnvList = new ArrayList<InstalledDevice>();
        for (InstalledDevice device : nonEnvList) {
            if (device.getType() == InstalledDevice.Type.environment) continue;
            nonEnvList.add(device);
        }
        return nonEnvList;
    }

    @Override
    public void actionPerformed(DeviceEvent e) {
        DeviceEvent.Type theType = e.getType();
        switch (theType) {
            case ADD: {
                Vector<DeviceChangeEvent> changeEvents = e.getEvents();
                this.deviceChanged(changeEvents);
                break;
            }
            case REMOVE: {
                Vector removeEvents = e.getEvents();
                DeviceRemoveEvent dre = (DeviceRemoveEvent)removeEvents.get(0);
                this.deviceRemoved(dre);
                break;
            }
        }
    }

    @Override
    public void actionPerformed(QueueChangeEvent qce) {
        logger.debug("queue updated");
        this.serverQueue.updateCommands(qce.getCurrCommand(), qce.getCurrOwner(), qce.getFutureCommands());
        if (!this.queueInitialized) {
            logger.debug("Queue initialized.");
            this.queueInitialized = true;
            this.checkForInitialized();
        }
    }

    @Override
    public void actionPerformed(ScanListChangeEvent slce) {
        logger.debug("scanlist changed");
        if (slce.getNewScanList() != null) {
            this.serverScanList.replaceScanList(slce.getNewScanList());
            if (!this.scanListInitialized) {
                logger.debug("Scan list initialized");
                this.scanListInitialized = true;
                this.checkForInitialized();
            }
        } else if (this.scanListInitialized && slce.getChangedScanList() != null) {
            this.serverScanList.updateScanList(slce.getChangedScanList());
        } else if (this.scanListInitialized && slce.getDeletedScanList() != null) {
            this.serverScanList.removeScanList(slce.getDeletedScanList());
        }
    }

    @Override
    public void requestChangeInstrument(IceWindowRequest mwr) {
    }

    public InstalledDevice getDeviceInstance(String deviceName) {
        InstalledDevice device = new InstalledDevice("", "", "");
        for (InstalledDevice aDevice : this.deviceList) {
            String deviceRealName = aDevice.getRealName();
            if (!deviceRealName.equals(deviceName)) continue;
            device = aDevice;
            break;
        }
        return device;
    }

    public InstalledDevice getDeviceParent(String alias2) {
        InstalledDevice device = null;
        for (InstalledDevice aDevice : this.deviceList) {
            String deviceAlias = aDevice.getAlias();
            if (deviceAlias == null || !deviceAlias.equalsIgnoreCase(alias2)) continue;
            device = aDevice;
            break;
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deviceChanged(Collection<DeviceChangeEvent> dces) {
        ArrayList<InstalledDevice> devicesToAdd = new ArrayList<InstalledDevice>();
        ArrayList<InstalledDevice> devicesAdded = new ArrayList<InstalledDevice>();
        Iterator<DeviceChangeEvent> eventIterator = dces.iterator();
        while (eventIterator.hasNext()) {
            InstalledDevice device;
            ArrayList<InstalledDevice> devicesToUpdate = new ArrayList<InstalledDevice>();
            DeviceChangeEvent dce = eventIterator.next();
            if (dce.getType() == InstalledDevice.Type.alias) {
                logger.debug("Searching for " + dce.getParent() + " with channel of " + dce.getChannel());
                device = this.getDevice(dce.getParent(), dce.getChannel());
                if (device == null) {
                    InstalledDevice.Type parentDeviceType = this.getDeviceInstance(dce.getParent()).getType();
                    device = new InstalledDevice(dce.getParent(), dce.getUnits(), dce.getSoftwareValue(), dce.getChannel(), parentDeviceType);
                    logger.debug("adding device for alias: " + device.getRealName() + ", " + dce.getName());
                    devicesToAdd.add(device);
                }
                if (!dce.getName().equals(device.getAlias())) {
                    device.setAlias(dce.getName());
                }
                devicesToUpdate.add(device);
            } else {
                device = this.getDevice(dce.getName());
                if (device == null) {
                    if (dce.getType() == InstalledDevice.Type.environment) {
                        DeviceChangeEvent.EnvType envType = dce.getEnvironmentType();
                        if (envType == DeviceChangeEvent.EnvType.TEMPERATURE) {
                            String name = dce.getName();
                            String units = dce.getUnits();
                            String softValue = dce.getSoftwareValue();
                            Integer sampChannel = dce.getSampleChannel();
                            Integer contChannel = dce.getControlChannel();
                            Integer numChannels = dce.getNumChannels();
                            Double maxTilt = dce.getMaxUpperTilt();
                            Double lowTilt = dce.getMaxLowerTilt();
                            Double timeout = dce.getTimeout();
                            device = new InstalledTempDevice(name, units, softValue, sampChannel, contChannel, numChannels, maxTilt, lowTilt, timeout);
                        } else if (envType == DeviceChangeEvent.EnvType.PRESSURE) {
                            device = new InstalledPressureDevice(dce.getName(), dce.getUnits(), dce.getSoftwareValue());
                        } else if (envType == DeviceChangeEvent.EnvType.MAGNET) {
                            device = new InstalledMagnetDevice(dce.getName(), dce.getUnits(), dce.getSoftwareValue(), dce.getMaxUpperTilt(), dce.getMaxLowerTilt(), dce.getPersistenceMode(), dce.getTimeout());
                        } else if (envType == DeviceChangeEvent.EnvType.MISCELLANEOUS) {
                            device = new InstalledMiscDevice(dce.getName(), dce.getUnits(), dce.getSoftwareValue());
                        } else {
                            logger.error("Unknown environment device type for device " + dce.getName() + ".  THIS SHOULDN'T HAPPEN.  Treating as a misc device.");
                            device = new InstalledMiscDevice(dce.getName(), dce.getUnits(), dce.getSoftwareValue());
                        }
                    } else {
                        device = new InstalledDevice(dce.getName(), dce.getUnits(), dce.getSoftwareValue());
                    }
                    if (device != null) {
                        logger.debug("adding device: " + device.getRealName() + ", " + device.getAlias());
                        devicesToAdd.add(device);
                    }
                }
                if (dce.getType() != device.getType()) {
                    device.setType(dce.getType());
                }
                devicesToUpdate.add(device);
            }
            for (InstalledDevice device2 : devicesToUpdate) {
                if (dce.getUnits() != null && !dce.getUnits().equals(device2.getUnits())) {
                    logger.debug(String.valueOf(device2.getRealName()) + "(" + dce.getName() + ") units changed: " + dce.getUnits());
                    device2.setUnits(dce.getUnits());
                }
                if (!Global.equals(device2.getLowerLimit(), dce.getLowerLimit())) {
                    logger.debug(String.valueOf(device2.getRealName()) + " lower limit changed: " + dce.getLowerLimit());
                    device2.setLowerLimit(dce.getLowerLimit());
                }
                if (!Global.equals(device2.getUpperLimit(), dce.getUpperLimit())) {
                    logger.debug(String.valueOf(device2.getRealName()) + " upper limit changed: " + dce.getUpperLimit());
                    device2.setUpperLimit(dce.getUpperLimit());
                }
                if (dce.isBusy() != null && device2.isBusy() != dce.isBusy().booleanValue()) {
                    logger.debug(String.valueOf(device2.getRealName()) + " busy changed: " + dce.isBusy());
                    device2.setBusy(dce.isBusy());
                }
                if (dce.isBroken() != null && dce.wasBroken() != null) {
                    logger.debug(String.valueOf(device2.getRealName()) + " broken state might have changed: " + dce.isBroken() + dce.wasBroken());
                    device2.setBrokenState(dce.isBroken(), dce.wasBroken());
                }
                if (dce.isFixed() != null && device2.isFixed() != dce.isFixed().booleanValue()) {
                    logger.debug(String.valueOf(device2.getRealName()) + " fixed changed: " + dce.isFixed());
                    device2.setFixed(dce.isFixed());
                }
                if (dce.getSoftwareValue() != null && !dce.getSoftwareValue().equals(device2.getCurrValue())) {
                    logger.debug(String.valueOf(device2.getRealName()) + " curr value changed: " + dce.getSoftwareValue());
                    device2.setCurrValue(dce.getSoftwareValue());
                }
                if (dce.getHardwareValue() != null && !dce.getHardwareValue().equals(device2.getHardwareValue())) {
                    logger.debug(String.valueOf(device2.getRealName()) + " hardware value changed: " + dce.getHardwareValue());
                    device2.setHardwareValue(dce.getHardwareValue());
                }
                if (dce.getTolerance() != null && !Global.equals(device2.getTolerance(), dce.getTolerance())) {
                    logger.debug(String.valueOf(device2.getRealName()) + " tolerance value changed: " + dce.getTolerance());
                    device2.setTolerance(dce.getTolerance());
                }
                if (dce.getAdditionalProperties() != null && !Global.equals(device2.getAdditionalProperties(), dce.getAdditionalProperties())) {
                    logger.debug(String.valueOf(device2.getRealName()) + " additional  values changed: " + dce.getAdditionalProperties());
                    device2.updateAdditionalProperties(dce.getAdditionalProperties());
                }
                if (device2 instanceof InstalledTempDevice) {
                    InstalledTempDevice tempDevice = (InstalledTempDevice)device2;
                    if (dce.getSampleChannel() != null && dce.getSampleChannel().intValue() != tempDevice.getSampleChannel()) {
                        tempDevice.setSampleChannel(dce.getSampleChannel());
                    }
                    if (dce.getControlChannel() != null && dce.getControlChannel().intValue() != tempDevice.getControlChannel()) {
                        tempDevice.setControlChannel(dce.getControlChannel());
                    }
                    if (dce.getMaxUpperTilt() != null && !Global.equals(dce.getMaxUpperTilt(), tempDevice.getMaxUpperTilt())) {
                        tempDevice.setMaxUpperTilt(dce.getMaxUpperTilt());
                    }
                    if (dce.getMaxLowerTilt() != null && !Global.equals(dce.getMaxLowerTilt(), tempDevice.getMaxLowerTilt())) {
                        tempDevice.setMaxLowerTilt(dce.getMaxLowerTilt());
                    }
                    if (dce.getTimeout() == null || Global.equals(dce.getTimeout(), tempDevice.getTimeout())) continue;
                    tempDevice.setTimeout(dce.getTimeout());
                    continue;
                }
                if (!(device2 instanceof InstalledMagnetDevice)) continue;
                InstalledMagnetDevice magnetDevice = (InstalledMagnetDevice)device2;
                if (dce.getMaxUpperTilt() != null && !Global.equals(dce.getMaxUpperTilt(), magnetDevice.getMaxUpperTilt())) {
                    magnetDevice.setMaxUpperTilt(dce.getMaxUpperTilt());
                }
                if (dce.getMaxLowerTilt() != null && !Global.equals(dce.getMaxLowerTilt(), magnetDevice.getMaxLowerTilt())) {
                    magnetDevice.setMaxLowerTilt(dce.getMaxLowerTilt());
                }
                if (dce.getPersistenceMode() != null && dce.getPersistenceMode() != magnetDevice.isPersistenceMode()) {
                    magnetDevice.setPersistenceMode(dce.getPersistenceMode());
                }
                if (dce.getTimeout() == null || Global.equals(dce.getTimeout(), magnetDevice.getTimeout())) continue;
                magnetDevice.setTimeout(dce.getTimeout());
                if (dce.getmagnetPSFlag() == null) continue;
                magnetDevice.setMagnetPSFlag(dce.getmagnetPSFlag());
            }
            Iterator addIterator = devicesToAdd.iterator();
            ArrayList<InstalledDevice> arrayList = this.deviceList;
            synchronized (arrayList) {
                while (addIterator.hasNext()) {
                    InstalledDevice adevice = (InstalledDevice)addIterator.next();
                    this.deviceList.add(adevice);
                    devicesAdded.add(adevice);
                    addIterator.remove();
                }
                Collections.sort(this.deviceList);
            }
        }
        if (!this.devicesInitialized) {
            logger.debug("Devices Initialized.");
            this.devicesInitialized = true;
            this.checkForInitialized();
        }
        if (devicesAdded.size() > 0) {
            logger.debug("notifying listeners of change in device list");
            for (DeviceListListener dll : this.deviceListListeners) {
                dll.deviceListUpdated(new DeviceListEvent(this, new ArrayList<InstalledDevice>(this.deviceList), new ArrayList<InstalledDevice>(devicesAdded), new ArrayList<InstalledDevice>()));
            }
        }
    }

    private InstalledDevice getDevice(String realName, Integer channel) {
        boolean realNameMatch = false;
        boolean channelMatch = false;
        for (InstalledDevice device : this.deviceList) {
            if (realName != device.getRealName() && (realName == null || !realName.equals(device.getRealName()))) continue;
            realNameMatch = true;
            if (channel != device.getChannel() && (channel == null || !channel.equals(device.getChannel()))) continue;
            channelMatch = true;
            if (!realNameMatch || !channelMatch) continue;
            return device;
        }
        return null;
    }

    public InstalledDevice getDevice(String realName) {
        if (realName == null) {
            return null;
        }
        for (InstalledDevice device : this.deviceList) {
            if (!realName.equalsIgnoreCase(device.getRealName()) || device.getChannel() != null) continue;
            return device;
        }
        return null;
    }

    public void deviceRemoved(DeviceRemoveEvent dre) {
        logger.debug("device removed: " + dre.getDeviceName());
        ArrayList<InstalledDevice> devicesRemoved = new ArrayList<InstalledDevice>();
        ArrayList<InstalledDevice> devices = this.getAllDevices(dre.getDeviceName());
        int i = 0;
        while (i < devices.size()) {
            InstalledDevice tempDevice = devices.get(i);
            if (tempDevice.getAlias() != null && tempDevice.getAlias().equals(dre.getDeviceName())) {
                tempDevice.setAlias(null);
            } else {
                this.deviceList.remove(tempDevice);
                devicesRemoved.add(tempDevice);
            }
            ++i;
        }
        if (devicesRemoved.size() > 0) {
            for (DeviceListListener dll : this.deviceListListeners) {
                dll.deviceListUpdated(new DeviceListEvent(this, new ArrayList<InstalledDevice>(this.deviceList), new ArrayList<InstalledDevice>(), new ArrayList<InstalledDevice>(devicesRemoved)));
            }
        }
    }

    private void checkForInitialized() {
        if (this.allComponentsInitialized()) {
            this.notifyInitializationEventListeners(new InitializationEvent(this));
        }
        if (this.experimentInitialized && this.queueInitialized && this.scanListInitialized && this.userFolderInitialized && this.commonFolderInitialized && this.experimentFolderInitialized && this.sampleInitialized && this.devicesInitialized && this.instrument.isInitialized() && this.ubMatrixInitiliazed) {
            logger.debug("all fields have been initialized");
        }
    }

    protected boolean allComponentsInitialized() {
        return this.experimentInitialized && this.queueInitialized && this.scanListInitialized && this.userFolderInitialized && this.commonFolderInitialized && this.experimentFolderInitialized && this.sampleInitialized && this.instrument.isInitialized() && this.devicesInitialized && this.ubMatrixInitiliazed;
    }

    @Override
    public void actionPerformed(IceFileContentsChangeEvent ifce) {
        logger.debug("receiving IceFile contents");
        String filename = ifce.getFilename();
        String parentName = ifce.getParent();
        ArrayList<IceFile> children = null;
        if (parentName == null || parentName.compareTo("") == 0 || parentName.equalsIgnoreCase("expt")) {
            children = this.expFolder.getChildren();
        } else if (parentName.equalsIgnoreCase("comm")) {
            children = this.commonFolder.getChildren();
        }
        int size = children.size();
        int i = 0;
        while (i < size) {
            IceFile file = children.get(i);
            if (filename.equals(file.getName())) {
                logger.debug("file found.  setting contents");
                String contents = ifce.getContents();
                if (contents == null) break;
                file.setContents(contents);
                break;
            }
            ++i;
        }
    }

    @Override
    public void actionPerformed(UBMatrixChangeEvent ubmce) {
        UBMatrixChangeEvent.EventType eventType = ubmce.getEventType();
        UBMatrix.ReferencePlane refPlane = ubmce.getReferencePlane();
        Boolean inputChanged = ubmce.isChangedSinceLastCalc();
        PeakListData pld = ubmce.getPeakListData();
        Integer primaryPeakSetID = null;
        ArrayList<Object> peakSetDataList = new ArrayList();
        if (pld != null) {
            primaryPeakSetID = pld.getPrimaryPeakSetID();
            peakSetDataList = pld.getPeakSetDataList();
        }
        ArrayList<PeakSet> peakSetList = this.ubMatrix.getPeakSetList();
        Iterator psdIterator = peakSetDataList.iterator();
        if (eventType == UBMatrixChangeEvent.EventType.LIST) {
            this.ubMatrix.setReferencePlane(refPlane);
            this.ubMatrix.setInputChangedSinceLastCalc(inputChanged);
            while (psdIterator.hasNext()) {
                boolean duplicatePeakSet = false;
                PeakSetData psd = (PeakSetData)psdIterator.next();
                int i = 0;
                while (i < peakSetList.size()) {
                    if (psd.getID().intValue() == ((PeakSet)peakSetList.get(i)).getId()) {
                        duplicatePeakSet = true;
                        break;
                    }
                    ++i;
                }
                if (duplicatePeakSet) continue;
                boolean included = psd.isIncluded();
                int id = psd.getID();
                double h = psd.getH();
                double k = psd.getK();
                double l = psd.getL();
                double a3 = psd.getA3();
                double a4 = psd.getA4();
                double lTilt = psd.getLTilt();
                double uTilt = psd.getUTilt();
                PeakSet peakSet = new PeakSet(id, included, h, k, l, a3, a4, lTilt, uTilt);
                this.ubMatrix.addPeakSet(peakSet);
                if (primaryPeakSetID == null || peakSet.getId() != primaryPeakSetID.intValue()) continue;
                this.ubMatrix.setPrimaryPeakSet(peakSet);
            }
        } else if (eventType == UBMatrixChangeEvent.EventType.MODIFY) {
            if (refPlane != null && refPlane != UBMatrix.ReferencePlane.UNKNOWN) {
                this.ubMatrix.setReferencePlane(refPlane);
            }
            if (inputChanged != null) {
                this.ubMatrix.setInputChangedSinceLastCalc(inputChanged);
            }
            if (primaryPeakSetID != null) {
                this.ubMatrix.setPrimaryPeakSet(primaryPeakSetID);
            }
            while (psdIterator.hasNext()) {
                PeakSetData psd = (PeakSetData)psdIterator.next();
                PeakSetData.DataType dataType = psd.getDataType();
                int id = psd.getID();
                if (dataType == PeakSetData.DataType.ADD) {
                    Boolean tmpIncluded = psd.isIncluded();
                    boolean included = tmpIncluded != null && tmpIncluded != false;
                    double h = psd.getH();
                    double k = psd.getK();
                    double l = psd.getL();
                    double a3 = psd.getA3();
                    double a4 = psd.getA4();
                    double lTilt = psd.getLTilt();
                    double uTilt = psd.getUTilt();
                    PeakSet peakSet = new PeakSet(id, included, h, k, l, a3, a4, lTilt, uTilt);
                    this.ubMatrix.addPeakSet(peakSet);
                    if (primaryPeakSetID == null || peakSet.getId() != primaryPeakSetID.intValue()) continue;
                    this.ubMatrix.setPrimaryPeakSet(peakSet);
                    continue;
                }
                if (dataType == PeakSetData.DataType.REMOVE) {
                    this.ubMatrix.removePeakSet(id);
                    continue;
                }
                PeakSet peakSetToModify = this.ubMatrix.getPeakSet(id);
                if (peakSetToModify == null) continue;
                Boolean included = psd.isIncluded();
                Double h = psd.getH();
                Double k = psd.getK();
                Double l = psd.getL();
                Double a3 = psd.getA3();
                Double a4 = psd.getA4();
                Double lTilt = psd.getLTilt();
                Double uTilt = psd.getUTilt();
                if (included != null && !included.equals(peakSetToModify.isIncluded())) {
                    peakSetToModify.setIncluded(included);
                }
                if (h != null && !Global.equals(h, peakSetToModify.getH())) {
                    peakSetToModify.setH(h);
                }
                if (k != null && !Global.equals(k, peakSetToModify.getK())) {
                    peakSetToModify.setK(k);
                }
                if (l != null && !Global.equals(l, peakSetToModify.getL())) {
                    peakSetToModify.setL(l);
                }
                if (a3 != null && !Global.equals(a3, peakSetToModify.getA3Value())) {
                    peakSetToModify.setA3Value(a3);
                }
                if (a4 != null && !Global.equals(a4, peakSetToModify.getA4Value())) {
                    peakSetToModify.setA4Value(a4);
                }
                if (lTilt != null && !Global.equals(lTilt, peakSetToModify.getLowerTiltValue())) {
                    peakSetToModify.setLowerTiltValue(lTilt);
                }
                if (uTilt == null || Global.equals(uTilt, peakSetToModify.getUpperTiltValue())) continue;
                peakSetToModify.setUpperTiltValue(uTilt);
            }
        }
        if (!this.ubMatrixInitiliazed) {
            logger.debug("UB Matrix initialized.");
            this.ubMatrixInitiliazed = true;
            this.checkForInitialized();
        }
    }

    @Override
    public void statusChanged(StatusChangeEvent ce) {
        if (!this.instrumentInitialized && this.instrument.isInitialized()) {
            this.instrumentInitialized = true;
            this.checkForInitialized();
        }
    }

    @Override
    public void actionPerformed(InstrumentChangeEvent ice) {
        if (!this.instrumentInitialized && this.instrument.isInitialized()) {
            this.instrumentInitialized = true;
            this.checkForInitialized();
        }
    }

    public IceFile getUserFolder() {
        return this.userFolder;
    }

    public void addStartUpListener(StartUpListener frl) throws ICEListenerListExceptionBase {
        this.startUpListeners.addListener(frl);
    }

    public void removeStartUpListener(StartUpListener frl) {
        this.startUpListeners.removeListener(frl);
    }

    public void notifyStartUpListeners(StartUpEvent event) {
        this.startUpListeners.notifyListeners(event);
    }
}

