/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TLeafC;
import hep.io.root.interfaces.TLeafI;
import hep.io.root.reps.RepConstants;
import java.io.IOException;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.Type;

public abstract class TLeafCRep
extends AbstractRootObject
implements TLeafC,
Constants {
    private Object lastValue;
    private String lastString;
    private TBranch branch;
    private long lastStringIndex;
    private long lastValueIndex;

    public void setBranch(TBranch branch) {
        this.branch = branch;
        this.lastValueIndex = -1L;
        this.lastStringIndex = -1L;
    }

    public String getValue(long index) throws IOException {
        try {
            if (index == this.lastStringIndex) {
                return this.lastString;
            }
            this.lastStringIndex = index;
            RootInput in = this.branch.setPosition(this, this.lastStringIndex);
            this.lastString = in.readString();
            return this.lastString;
        }
        catch (IOException x) {
            this.lastStringIndex = -1L;
            throw x;
        }
    }

    public Object getWrappedValue(long index) throws IOException {
        try {
            if (this.lastValueIndex == index) {
                return this.lastValue;
            }
            this.lastValueIndex = index;
            RootInput in = this.branch.setPosition(this, index);
            int arrayDim = this.getArrayDim();
            if (arrayDim == 0) {
                this.lastValue = in.readString();
                return this.lastValue;
            }
            if (arrayDim == 1) {
                TLeafI count = (TLeafI)this.getLeafCount();
                int len = count == null ? this.getLen() : count.getValue(index);
                String[] array = new String[len];
                for (int i = 0; i < len; ++i) {
                    array[i] = in.readString();
                }
                this.lastValue = array;
                return array;
            }
            this.lastValue = this.readMultiArray(in, RepConstants.stringClass, index);
            return this.lastValue;
        }
        catch (IOException x) {
            this.lastValueIndex = -1L;
            throw x;
        }
    }

    public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, String className) {
        String leafClassName = this.getClass().getName();
        int arrayDim = this.getArrayDim();
        if (arrayDim == 0) {
            il.append(factory.createInvoke(leafClassName, "getValue", Type.STRING, new Type[]{Type.LONG}, (short)182));
        } else {
            il.append(factory.createInvoke(leafClassName, "getWrappedValue", Type.OBJECT, new Type[]{Type.LONG}, (short)182));
        }
    }

    abstract Object[] readMultiArray(RootInput var1, Class var2, long var3);
}

