/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootMember;
import hep.io.root.core.BasicMember;
import hep.io.root.core.ClassBuilder;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.NameMangler;
import hep.io.root.core.RootClassFactory;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TObjArray;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

public class HollowBuilder
implements ClassBuilder,
Constants {
    private static boolean debugRoot = System.getProperty("debugRoot") != null;
    private static NameMangler nameMangler = NameMangler.instance();
    private static final Object SUBOBJECT = new Object();
    private Map lMap;
    private String prefix;
    private TBranch branch;
    private boolean hasSubIndex = false;

    public HollowBuilder(TBranch branch) {
        this.branch = branch;
    }

    public HollowBuilder(TBranch branch, boolean hasSubIndex) {
        this.branch = branch;
        this.hasSubIndex = hasSubIndex;
    }

    public HollowBuilder(TBranch branch, String prefix) {
        this.branch = branch;
        this.prefix = prefix;
    }

    public HollowBuilder(TBranch branch, String prefix, boolean hasSubIndex) {
        this.branch = branch;
        this.prefix = prefix;
        this.hasSubIndex = hasSubIndex;
    }

    public String getStem() {
        return "hep.io.root.hollow";
    }

    public JavaClass build(GenericRootClass klass) {
        Iterator<Object> i;
        String name;
        String className = "hep.io.root.hollow." + klass.getClassName();
        ClassGen cg = new ClassGen(className, "hep/io/root/core/Hollow", "<generated>", 33, new String[]{nameMangler.mangleClass(klass.getClassName())});
        ConstantPoolGen cp = cg.getConstantPool();
        InstructionList il = new InstructionList();
        InstructionFactory factory = new InstructionFactory(cg);
        cg.addEmptyConstructor(1);
        ArrayList<GenericRootClass> sup = new ArrayList<GenericRootClass>();
        RootClass[] superClasses = klass.getSuperClasses();
        this.iterativelyAdd(sup, superClasses);
        sup.add(klass);
        HashMap nameMap = new HashMap();
        TObjArray branches = this.branch.getBranches();
        Iterator j = branches.iterator();
        while (j.hasNext()) {
            TBranch br = (TBranch)j.next();
            TObjArray leaves = br.getLeaves();
            Iterator i2 = leaves.iterator();
            while (i2.hasNext()) {
                Object leaf = i2.next();
                name = ((TLeaf)leaf).getName();
                int pos = name.indexOf(91);
                if (pos > 0) {
                    name = name.substring(0, pos);
                }
                if (name.endsWith("_")) {
                    name = name.substring(0, name.length() - 1);
                }
                if (this.prefix != null) {
                    if (!name.startsWith(this.prefix)) continue;
                    name = name.substring(this.prefix.length());
                }
                if ((pos = name.indexOf(46)) > 0) {
                    name = name.substring(0, pos);
                    leaf = SUBOBJECT;
                }
                nameMap.put(name, leaf);
            }
        }
        this.lMap = new HashMap();
        j = sup.iterator();
        while (j.hasNext()) {
            RootClass k = (RootClass)j.next();
            RootMember[] members = k.getMembers();
            for (int i3 = 0; i3 < members.length; ++i3) {
                Object leaf;
                BasicMember member = (BasicMember)members[i3];
                name = member.getName();
                if (name.endsWith("_")) {
                    name = name.substring(0, name.length() - 1);
                }
                if ((leaf = nameMap.remove(name)) == null) {
                    if (!debugRoot) continue;
                    System.err.println("Warning: no leaf for " + member.getName());
                    continue;
                }
                this.lMap.put(member, leaf);
            }
        }
        if (debugRoot) {
            i = nameMap.keySet().iterator();
            while (i.hasNext()) {
                System.err.println("Warning: unused leaf " + i.next());
            }
        }
        i = sup.iterator();
        while (i.hasNext()) {
            this.generateFields((RootClass)i.next(), cp, cg);
        }
        i = sup.iterator();
        while (i.hasNext()) {
            this.generateMethods((RootClass)i.next(), cp, il, factory, cg, className);
        }
        return cg.getJavaClass();
    }

    public void populateStatics(Class hollowClass, RootClassFactory factory) {
        try {
            Iterator i = this.lMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                BasicMember member = (BasicMember)entry.getKey();
                Object l = entry.getValue();
                if (l == SUBOBJECT) {
                    HollowBuilder builder = new HollowBuilder(this.branch, member.getName() + ".");
                    String name = "hep.io.root.hollow." + member.getType().getClassName();
                    GenericRootClass gc2 = (GenericRootClass)factory.create(member.getType().getClassName());
                    Class subHollowClass = factory.getLoader().loadSpecial(builder, name, gc2);
                    builder.populateStatics(subHollowClass, factory);
                    Field field = hollowClass.getField(member.getName() + "Class");
                    field.set(null, subHollowClass);
                    continue;
                }
                Field field = hollowClass.getField(member.getName());
                field.set(null, l);
            }
        }
        catch (Exception x) {
            throw new RuntimeException("Error while populating statics", x);
        }
    }

    private void generateFields(RootClass k, ConstantPoolGen cp, ClassGen cg) {
        RootMember[] members = k.getMembers();
        for (int i = 0; i < members.length; ++i) {
            BasicMember member = (BasicMember)members[i];
            Object l = this.lMap.get(member);
            if (l == SUBOBJECT) {
                Type type = new ObjectType("java.lang.Class");
                FieldGen fg = new FieldGen(9, type, member.getName() + "Class", cp);
                cg.addField(fg.getField());
                type = member.getJavaType();
                fg = new FieldGen(2, type, member.getName(), cp);
                cg.addField(fg.getField());
                continue;
            }
            if (l == null) continue;
            TLeaf leaf = (TLeaf)l;
            ObjectType type = new ObjectType(leaf.getClass().getName());
            FieldGen fg = new FieldGen(9, type, member.getName(), cp);
            cg.addField(fg.getField());
        }
    }

    private void generateMethods(RootClass k, ConstantPoolGen cp, InstructionList il, InstructionFactory factory, ClassGen cg, String className) {
        RootMember[] members = k.getMembers();
        for (int i = 0; i < members.length; ++i) {
            MethodGen mg;
            BasicMember member = (BasicMember)members[i];
            Type type = member.getJavaType();
            Object l = this.lMap.get(member);
            if (l == SUBOBJECT) {
                mg = new MethodGen(1, type, null, null, nameMangler.mangleMember(member.getName()), className, il, cp);
                il.append(InstructionConstants.ALOAD_0);
                il.append(factory.createGetField(className, member.getName(), type));
                il.append(InstructionConstants.DUP);
                BranchHandle bh = il.append(new IFNONNULL(null));
                il.append(InstructionConstants.POP);
                il.append(InstructionConstants.ALOAD_0);
                il.append(factory.createGetStatic(className, member.getName() + "Class", new ObjectType("java.lang.Class")));
                il.append(factory.createInvoke("java.lang.Class", "newInstance", new ObjectType("java.lang.Object"), Type.NO_ARGS, (short)182));
                il.append(InstructionConstants.DUP);
                il.append(factory.createCast(new ObjectType("java,lang.Object"), new ObjectType("hep.io.root.core.Hollow")));
                il.append(InstructionConstants.ALOAD_0);
                il.append(factory.createGetField("hep.io.root.core.Hollow", "index", Type.LONG));
                il.append(factory.createInvoke("hep.io.root.core.Hollow", "setHollowIndex", Type.VOID, new Type[]{Type.LONG}, (short)182));
                il.append(factory.createCast(new ObjectType("java,lang.Object"), type));
                il.append(InstructionConstants.DUP_X1);
                il.append(factory.createPutField(className, member.getName(), type));
                bh.setTarget(il.append(InstructionFactory.createReturn(type)));
                mg.setMaxStack();
                mg.setMaxLocals();
                cg.addMethod(mg.getMethod());
                il.dispose();
                continue;
            }
            if (l == null) {
                mg = new MethodGen(1, type, null, null, nameMangler.mangleMember(member.getName()), className, il, cp);
                il.append(InstructionFactory.createNull(type));
                il.append(InstructionFactory.createReturn(type));
                mg.setMaxStack();
                mg.setMaxLocals();
                cg.addMethod(mg.getMethod());
                il.dispose();
                continue;
            }
            TLeaf leaf = (TLeaf)l;
            String leafClassName = leaf.getClass().getName();
            MethodGen mg2 = new MethodGen(1, type, null, null, nameMangler.mangleMember(member.getName()), className, il, cp);
            InstructionHandle try_start = il.append(factory.createGetStatic(className, member.getName(), new ObjectType(leafClassName)));
            il.append(InstructionConstants.ALOAD_0);
            il.append(factory.createGetField("hep.io.root.core.Hollow", "index", Type.LONG));
            Type sType = this.hasSubIndex ? new ArrayType(type, 1) : type;
            Type rType = sType instanceof BasicType ? sType : Type.OBJECT;
            leaf.generateReadCode(il, factory, cp, className);
            if (rType != sType) {
                il.append(factory.createCast(rType, sType));
            }
            if (this.hasSubIndex) {
                il.append(InstructionConstants.ALOAD_0);
                il.append(factory.createGetField("hep.io.root.core.Hollow", "subIndex", Type.INT));
                il.append(InstructionFactory.createArrayLoad(type));
            }
            InstructionHandle try_end = il.append(InstructionFactory.createReturn(type));
            InstructionHandle handler = il.append(factory.createNew(new ObjectType("java.lang.RuntimeException")));
            il.append(InstructionConstants.DUP);
            il.append(new PUSH(cp, "IOError while accessing value"));
            il.append(factory.createInvoke("java.lang.RuntimeException", "<init>", Type.VOID, new Type[]{Type.STRING}, (short)183));
            if (System.getProperty("java.version").compareTo("1.4") >= 0) {
                il.append(InstructionConstants.DUP_X1);
                il.append(InstructionConstants.SWAP);
                ObjectType throwableType = new ObjectType("java.lang.Throwable");
                il.append(factory.createInvoke("java.lang.Throwable", "initCause", throwableType, new Type[]{throwableType}, (short)182));
            }
            il.append(InstructionConstants.ATHROW);
            mg2.addExceptionHandler(try_start, try_end, handler, new ObjectType("java.io.IOException"));
            mg2.setMaxStack();
            mg2.setMaxLocals();
            cg.addMethod(mg2.getMethod());
            il.dispose();
        }
    }

    private void iterativelyAdd(List list, RootClass[] superClasses) {
        for (int i = 0; i < superClasses.length; ++i) {
            RootClass[] supsup = superClasses[i].getSuperClasses();
            this.iterativelyAdd(list, supsup);
            list.add(superClasses[i]);
        }
    }
}

