/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.test.AidaTestCase;
import hep.aida.test.TestUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import junit.framework.Assert;

public class TestTree
extends AidaTestCase {
    private String treeName = TestUtils.getFullPath("testTree.aida");
    private ITree tree = null;
    private IAnalysisFactory af;
    private ITreeFactory tf = null;
    private int nDirs;
    private Vector dirVector;

    public TestTree(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.af = IAnalysisFactory.create();
        this.tf = this.af.createTreeFactory();
        this.tree = this.tf.create(this.treeName, null, false, true);
        IHistogramFactory hf = this.af.createHistogramFactory(this.tree);
        ITupleFactory tupf = this.af.createTupleFactory(this.tree);
        this.tree.mkdir("histograms");
        this.tree.cd("/histograms");
        this.tree.mkdir("1D");
        this.tree.mkdir("2D");
        this.tree.mkdir("3D");
        this.tree.cd("1D");
        IHistogram1D h1_1D = hf.createHistogram1D("hist1_1D", 10, -1.0, 1.0);
        IHistogram1D h2_1D = hf.createHistogram1D("hist2_1D", 10, -1.0, 1.0);
        this.tree.cd("../2D");
        IHistogram2D h1_2D = hf.createHistogram2D("hist1_2D", 10, -1.0, 1.0, 10, -1.0, 1.0);
        IHistogram2D h2_2D = hf.createHistogram2D("hist2_2D", 10, -1.0, 1.0, 10, -1.0, 1.0);
        this.tree.cd("../3D");
        IHistogram3D h1_3D = hf.createHistogram3D("hist1_3D", 10, -1.0, 1.0, 10, -1.0, 1.0, 10, -1.0, 1.0);
        IHistogram3D h2_3D = hf.createHistogram3D("hist2_3D", 10, -1.0, 1.0, 10, -1.0, 1.0, 10, -1.0, 1.0);
        this.tree.mkdir("/clouds");
        this.tree.cd("/clouds");
        this.tree.mkdir("1D");
        this.tree.mkdir("2D");
        this.tree.mkdir("3D");
        this.tree.cd("1D");
        ICloud1D c1_1D = hf.createCloud1D("cloud1_1D");
        ICloud1D c2_1D = hf.createCloud1D("cloud2_1D");
        this.tree.cd("../2D");
        ICloud2D c1_2D = hf.createCloud2D("cloud1_2D");
        ICloud2D c2_2D = hf.createCloud2D("cloud2_2D");
        this.tree.cd("../3D");
        ICloud3D c1_3D = hf.createCloud3D("cloud1_3D");
        ICloud3D c2_3D = hf.createCloud3D("cloud2_3D");
        this.tree.mkdir("/profiles");
        this.tree.cd("/profiles");
        this.tree.mkdir("1D");
        this.tree.mkdir("2D");
        this.tree.cd("1D");
        IProfile1D p1_1D = hf.createProfile1D("profile1_1D", 10, -1.0, 1.0);
        IProfile1D p2_1D = hf.createProfile1D("profile2_1D", 10, -1.0, 1.0);
        this.tree.cd("../2D");
        IProfile2D p1_2D = hf.createProfile2D("profile1_2D", 10, -1.0, 1.0, 10, -1.0, 1.0);
        IProfile2D p2_2D = hf.createProfile2D("profile2_2D", 10, -1.0, 1.0, 10, -1.0, 1.0);
        this.tree.mkdir("/tuple");
        this.tree.cd("/tuple");
        ITuple t1 = tupf.create("tuple", "", "int x");
        this.tree.mkdir("/test");
        this.tree.mkdir("/test/dummy1");
        this.tree.mkdir("/test/dummy2");
    }

    public void testStoreName() {
        Assert.assertEquals(this.tree.storeName(), this.treeName);
    }

    public void testFindAndFindPath() {
        this.tree.cd("/");
        IManagedObject hist1D = this.tree.find("/histograms/1D/hist1_1D");
        Assert.assertEquals(this.tree.findPath(hist1D), "/histograms/1D/hist1_1D");
        Assert.assertTrue(hist1D instanceof IHistogram1D);
        this.tree.cd("/test");
        String pwd = this.tree.pwd();
        IManagedObject hist2D = this.tree.find("/histograms/2D/hist1_2D");
        Assert.assertEquals(this.tree.findPath(hist2D), "/histograms/2D/hist1_2D");
        Assert.assertEquals(pwd, this.tree.pwd());
        Assert.assertTrue(hist2D instanceof IHistogram2D);
        this.tree.cd("./dummy1");
        pwd = this.tree.pwd();
        IManagedObject tup = this.tree.find("../../tuple/tuple");
        Assert.assertEquals(this.tree.findPath(tup), "/tuple/tuple");
        Assert.assertEquals(pwd, this.tree.pwd());
        Assert.assertTrue(tup instanceof ITuple);
        try {
            this.tree.find("./2D/hist2_2D");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            this.tree.find("/test");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public void testCd_Pwd() {
        this.tree.cd("/");
        Assert.assertTrue(this.tree.pwd().equals("/"));
        this.tree.cd("/test/dummy1");
        Assert.assertTrue(this.tree.pwd().equals("/test/dummy1"));
        try {
            this.tree.cd("test");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        this.tree.cd("../../histograms/../tuple");
        Assert.assertTrue(this.tree.pwd().equals("/tuple"));
        this.tree.cd("../tuple/../test");
        Assert.assertTrue(this.tree.pwd().equals("/test"));
        try {
            this.tree.cd("../dummy1");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.tree.symlink("/test/dummy1", "/linkToDummy");
        this.tree.cd("/linkToDummy");
        Assert.assertTrue(this.tree.pwd().equals("/test/dummy1"));
    }

    public void testLs() throws FileNotFoundException, IOException {
        String file1Name = "ls1.txt";
        String file2Name = "ls2.txt";
        String file3Name = "ls3.txt";
        String file4Name = "ls4.txt";
        String file5Name = "ls5.txt";
        File file1 = new File(file1Name);
        FileOutputStream file1Os = new FileOutputStream(file1);
        String pwd = this.tree.pwd();
        this.tree.ls("/", false, file1Os);
        Assert.assertEquals(pwd, this.tree.pwd());
        File file2 = new File(file2Name);
        FileOutputStream file2Os = new FileOutputStream(file2);
        this.tree.cd("/histograms");
        pwd = this.tree.pwd();
        this.tree.ls("../", false, file2Os);
        Assert.assertEquals(pwd, this.tree.pwd());
        File file3 = new File(file3Name);
        FileOutputStream file3Os = new FileOutputStream(file3);
        this.tree.cd("/test/dummy1");
        pwd = this.tree.pwd();
        this.tree.ls("../../tuple/../", true, file3Os);
        Assert.assertEquals(pwd, this.tree.pwd());
        File file4 = new File(file4Name);
        FileOutputStream file4Os = new FileOutputStream(file4);
        pwd = this.tree.pwd();
        this.tree.ls("/", true, file4Os);
        Assert.assertEquals(pwd, this.tree.pwd());
        File file5 = new File(file5Name);
        FileOutputStream file5Os = new FileOutputStream(file5);
        pwd = this.tree.pwd();
        this.tree.ls("/histograms/1D/hist1_1D", true, file5Os);
        this.tree.ls("/histograms/3D/hist2_3D", true, file5Os);
        this.tree.ls("/profiles/2D/profile2_2D", true, file5Os);
        Assert.assertEquals(pwd, this.tree.pwd());
        file1Os.close();
        file2Os.close();
        file3Os.close();
        file4Os.close();
        file5Os.close();
        BufferedReader file1In = new BufferedReader(new FileReader(file1Name));
        BufferedReader file2In = new BufferedReader(new FileReader(file2Name));
        String line1 = null;
        int lines12 = 0;
        while ((line1 = file1In.readLine()) != null) {
            String line2 = file2In.readLine();
            ++lines12;
            Assert.assertEquals(line2, ".." + line1);
            Assert.assertTrue(line2.endsWith("/"));
        }
        Assert.assertTrue(lines12 == 5);
        BufferedReader file3In = new BufferedReader(new FileReader(file3Name));
        BufferedReader file4In = new BufferedReader(new FileReader(file4Name));
        String line3 = null;
        int lines34 = 0;
        while ((line3 = file3In.readLine()) != null) {
            String line4 = file4In.readLine();
            ++lines34;
            Assert.assertEquals(line3, "../../tuple/.." + line4);
        }
        Assert.assertEquals(lines34, 32);
        BufferedReader file5In = new BufferedReader(new FileReader(file5Name));
        int lines5 = 0;
        String line5 = null;
        while ((line5 = file5In.readLine()) != null) {
            if (++lines5 == 1) {
                Assert.assertEquals(line5, "/histograms/1D/hist1_1D");
            }
            if (lines5 == 2) {
                Assert.assertEquals(line5, "/histograms/3D/hist2_3D");
            }
            if (lines5 == 3) {
                Assert.assertEquals(line5, "/profiles/2D/profile2_2D");
            }
            if (lines5 != 4) continue;
            Assert.assertTrue(false);
        }
        file1In.close();
        file2In.close();
        file3In.close();
        file4In.close();
        file5In.close();
        file1.delete();
        file2.delete();
        file3.delete();
        file4.delete();
        file5.delete();
        try {
            this.tree.cd("/tuple");
            this.tree.ls("histograms");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public void testListObjectNames_ListObjectTypes() throws FileNotFoundException, IOException {
        String[] names = null;
        String[] types = null;
        this.tree.cd("/");
        String pwd = this.tree.pwd();
        names = this.tree.listObjectNames();
        Assert.assertEquals(pwd, this.tree.pwd());
        types = this.tree.listObjectTypes();
        Assert.assertEquals(pwd, this.tree.pwd());
        Assert.assertEquals(names.length, types.length);
        Assert.assertEquals(names.length, 5);
        String fileName = "ls.txt";
        File file = new File(fileName);
        FileOutputStream fileOs = new FileOutputStream(file);
        this.tree.ls("/", false, fileOs);
        BufferedReader fileIn = new BufferedReader(new FileReader(fileName));
        for (int i = 0; i < names.length; ++i) {
            Assert.assertTrue(names[i].endsWith("/"));
            Assert.assertEquals(types[i], "dir");
            Assert.assertEquals(fileIn.readLine(), names[i]);
        }
        fileOs.close();
        fileIn.close();
        file.delete();
        this.tree.cd("/clouds");
        pwd = this.tree.pwd();
        names = this.tree.listObjectNames("../", true);
        Assert.assertEquals(pwd, this.tree.pwd());
        types = this.tree.listObjectTypes("../", true);
        Assert.assertEquals(pwd, this.tree.pwd());
        Assert.assertEquals(names.length, types.length);
        Assert.assertEquals(names.length, 32);
        file = new File(fileName);
        fileOs = new FileOutputStream(file);
        this.tree.ls("/", true, fileOs);
        fileIn = new BufferedReader(new FileReader(fileName));
        int dirs = 0;
        int objs = 0;
        for (int i = 0; i < names.length; ++i) {
            if (types[i] == "dir") {
                ++dirs;
                Assert.assertTrue(names[i].endsWith("/"));
                Assert.assertEquals(".." + fileIn.readLine(), names[i]);
                continue;
            }
            ++objs;
            IManagedObject obj = this.tree.find(names[i]);
            String objClassName = obj.getClass().getName();
            Assert.assertTrue(objClassName.endsWith(types[i].substring(1)));
            Assert.assertTrue(!names[i].endsWith("/"));
            Assert.assertEquals(".." + fileIn.readLine(), names[i]);
        }
        Assert.assertEquals(dirs, 15);
        Assert.assertEquals(objs, 17);
        fileOs.close();
        fileIn.close();
        file.delete();
        names = this.tree.listObjectNames("/tuple/tuple", true);
        types = this.tree.listObjectTypes("/tuple/tuple", true);
        Assert.assertEquals(types.length, names.length);
        Assert.assertEquals(1, names.length);
        Assert.assertEquals("/tuple/tuple", names[0]);
        Assert.assertEquals("ITuple", types[0]);
        try {
            this.tree.cd("/histograms/1D");
            names = this.tree.listObjectNames("../tuple");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            this.tree.cd("/histograms/1D");
            types = this.tree.listObjectTypes("../tuple");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public void testMkdir() {
        this.tree.cd("/");
        try {
            this.tree.mkdir("histograms");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            this.tree.mkdir("/tuple/tuple");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            this.tree.mkdir("/test/dummy1/test/test");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            this.tree.mkdir("./");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.tree.mkdir("/test/dummy1/test");
        this.tree.cd("/histograms/1D");
        this.tree.mkdir(".././../test/dummy1/test/test");
        this.tree.cd("../../test/dummy1/test/test");
        Assert.assertEquals("/test/dummy1/test/test", this.tree.pwd());
        this.tree.mkdir("./test");
        this.tree.cd("test");
        Assert.assertEquals("/test/dummy1/test/test/test", this.tree.pwd());
    }

    public void testMkdirs() {
        this.tree.cd("/");
        this.tree.mkdirs("histograms");
        try {
            this.tree.mkdirs("/tuple/tuple");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        this.tree.mkdirs("./");
        try {
            this.tree.mkdirs("/histograms/1D/hist1_1D/test");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.tree.cd("/histograms/3D/");
        this.tree.mkdirs(".././../test/crash/test/dummy");
        this.tree.cd("/test/crash/test/dummy/");
        Assert.assertEquals("/test/crash/test/dummy", this.tree.pwd());
    }

    public void testRmdir() {
    }

    public void testRm() {
        this.tree.cd("/");
        IHistogramFactory hf = this.af.createHistogramFactory(this.tree);
        IProfile2D remP = hf.createProfile2D("removableProfile", 10, -1.0, 1.0, 10, -1.0, 1.0);
        this.tree.cd("/tuple");
        Assert.assertEquals("/removableProfile", this.tree.findPath((IManagedObject)((Object)remP)));
        this.tree.rm("../removableProfile");
        try {
            this.tree.find("/removableProfile");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            this.tree.findPath((IManagedObject)((Object)remP));
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMv() throws IOException {
        this.tree.cd("/");
        this.tree.mkdir("fromDir");
        this.tree.cd("/fromDir");
        IHistogramFactory hf = this.af.createHistogramFactory(this.tree);
        IHistogram1D h = hf.createHistogram1D("histToMove", 10, -1.0, 1.0);
        this.tree.mkdir("/toDir");
        this.tree.find("/fromDir/histToMove");
        this.tree.mv("/fromDir/histToMove", "/toDir");
        this.tree.find("/toDir/histToMove");
        try {
            this.tree.find("/fromDir/histToMove");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        this.tree.mv("/toDir/histToMove", "/fromDir/histHasBeenMoved");
        this.tree.find("/fromDir/histHasBeenMoved");
        try {
            this.tree.find("/toDir/histToMove");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        this.tree.cd("/toDir");
        this.tree.mv("/fromDir", ".");
        this.tree.find("/toDir/fromDir/histHasBeenMoved");
        this.tree.mv("/toDir/fromDir", "/fromDirRenamed");
        this.tree.find("/fromDirRenamed/histHasBeenMoved");
        try {
            this.tree.find("/toDir/fromDir/histHasBeenMoved");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            this.tree.mv("/toDir", "/fromDirRenamed/histHasBeenMoved");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCommit() {
        IOException ioe = null;
        try {
            this.tree.commit();
        }
        catch (IOException e1) {
            ioe = e1;
        }
        Assert.assertTrue(ioe == null);
        ioe = null;
        try {
            ITree reloadedTree = this.tf.create(this.treeName, "xml");
        }
        catch (IOException e2) {
            ioe = e2;
        }
        Assert.assertTrue(ioe == null);
    }

    public void testSetOverwrite() {
    }

    public void testCp() {
        this.tree.cd("/");
        this.tree.mkdir("copyDir");
        this.tree.cd("/copyDir");
        IHistogramFactory hf = this.af.createHistogramFactory(this.tree);
        IHistogram1D h = hf.createHistogram1D("histToCopy", 10, -1.0, 1.0);
        this.tree.find("/copyDir/histToCopy");
        this.tree.cp("/copyDir/histToCopy", "/copyDir/histNewCopy");
        this.tree.find("/copyDir/histToCopy");
        this.tree.find("/copyDir/histNewCopy");
        this.tree.mkdir("/newCopyDir");
        this.tree.cp("./histToCopy", "/newCopyDir");
        this.tree.find("/copyDir/histToCopy");
        this.tree.find("/newCopyDir/histToCopy");
        this.tree.cp("/copyDir", "/newCopyDir");
        this.tree.cp("/newCopyDir/histToCopy", "/newCopyDir/copyDir");
        this.tree.find("/copyDir/histToCopy");
        this.tree.find("/newCopyDir/copyDir/histToCopy");
        try {
            this.tree.find("/newCopyDir/copyDir/histToCopy");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        this.tree.cp("/copyDir/histNewCopy", "/newCopyDir/copyDir/histToCopy");
        this.tree.find("/newCopyDir/copyDir/histToCopy");
        this.tree.find("/copyDir/histNewCopy");
        try {
            this.tree.cp("/copyDir", "/newCopyDir/copyDir/histToCopy");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.tree.cp("/newCopyDir", "/recursiveCopyDir", true);
        this.tree.find("/recursiveCopyDir/copyDir/histToCopy");
        this.tree.symlink("/newCopyDir", "/link");
        this.tree.cp("/link", "/newCopyDir/copyOfTheLink");
    }

    public void testSymlink() {
        this.tree.cd("/");
        this.tree.mkdir("linkDir");
        this.tree.cd("/linkDir");
        IHistogramFactory hf = this.af.createHistogramFactory(this.tree);
        IHistogram1D h = hf.createHistogram1D("histToLink", 10, -1.0, 1.0);
        this.tree.find("/linkDir/histToLink");
        this.tree.symlink("/linkDir/histToLink", "./histLinked");
        this.tree.find("/linkDir/histLinked");
        this.tree.mkdirs("../newLinkDir/folder");
        this.tree.symlink("./histLinked", "/newLinkDir/folder");
        this.tree.find("../newLinkDir/folder/histLinked");
        this.tree.symlink("/linkDir", "/linkedDir");
        this.tree.find("/linkedDir/histLinked");
    }

    public void testMountAndUnmount() {
        ITree tree2 = this.tf.create();
        tree2.mkdir("a");
        tree2.cd("a");
        IHistogramFactory hf = this.af.createHistogramFactory(tree2);
        IHistogram1D h1_1D = hf.createHistogram1D("hist1_1D", 10, -1.0, 1.0);
        this.tree.mount("/anotherTree", tree2, "");
        this.tree.cd("/anotherTree/a");
        Assert.assertEquals("/anotherTree/a", this.tree.pwd());
        IManagedObject obj = this.tree.find("hist1_1D");
        Assert.assertEquals(obj, h1_1D);
        this.tree.cd("../../clouds/1D");
        obj = this.tree.find("cloud1_1D");
        Assert.assertTrue(obj instanceof ICloud1D);
        IHistogram1D h2_1D = hf.createHistogram1D("hist2_1D", 10, -1.0, 1.0);
        obj = this.tree.find("/anotherTree/a/hist2_1D");
        Assert.assertEquals(h2_1D, obj);
        Assert.assertEquals("/anotherTree/a/hist1_1D", this.tree.findPath((IManagedObject)((Object)h1_1D)));
        this.tree.unmount("/anotherTree");
        try {
            this.tree.cd("/anotherTree/a");
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException x) {
            // empty catch block
        }
        try {
            this.tree.findPath((IManagedObject)((Object)h1_1D));
            Assert.assertTrue(false);
        }
        catch (IllegalArgumentException x) {
            // empty catch block
        }
    }

    public void testClose() {
    }
}

