/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IEvaluator;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.test.AIDATestSuite;
import hep.aida.test.AidaTestCase;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;

public class TestRoot
extends AidaTestCase {
    protected ITree tree;
    private double relPrecision;

    public TestRoot(String testName) {
        super(testName);
        this.setRelPrecision(1.0E-4);
    }

    protected void setRelPrecision(double relPrecision) {
        this.relPrecision = relPrecision;
    }

    protected void tearDown() throws Exception {
        this.tree.close();
        super.tearDown();
    }

    protected String convertName(int id) {
        return id >= 0 ? "/h" + id : "/h_" + id;
    }

    public void test1DHistogramCopy() {
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory hf = af.createHistogramFactory(null);
        IHistogram1D hist = (IHistogram1D)((Object)this.tree.find(this.convertName(110)));
        IHistogram1D clone = hf.createCopy(((IManagedObject)((Object)hist)).name(), hist);
        AidaTestCase.assertEquals(hist, clone);
    }

    public void test2DHistogramCopy() {
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory hf = af.createHistogramFactory(null);
        IHistogram2D hist = (IHistogram2D)((Object)this.tree.find(this.convertName(210)));
        IHistogram2D clone = hf.createCopy(((IManagedObject)((Object)hist)).name(), hist);
        AidaTestCase.assertEquals(hist, clone);
    }

    public void test1DHistogramAccess() {
        IHistogram1D hist = (IHistogram1D)((Object)this.tree.find(this.convertName(110)));
        Assert.assertNotNull(hist);
        Assert.assertEquals("TEST OF HBOOK1", hist.title().trim());
        Assert.assertEquals(5000, hist.entries());
        Assert.assertEquals(0, hist.extraEntries());
        Assert.assertEquals(0.49817, hist.mean(), this.relPrecision);
        Assert.assertEquals(0.22046, hist.rms(), this.relPrecision);
    }

    public void test2DHistogramAccess() {
        IHistogram2D hist = (IHistogram2D)((Object)this.tree.find(this.convertName(210)));
        Assert.assertNotNull(hist);
        Assert.assertEquals("TEST OF HBOOK2", hist.title().trim());
        Assert.assertEquals(5000, hist.entries());
        Assert.assertEquals(0, hist.extraEntries());
        Assert.assertEquals(0.4806, hist.meanX(), this.relPrecision);
        Assert.assertEquals(0.48094, hist.meanY(), this.relPrecision);
        Assert.assertEquals(0.21781, hist.rmsX(), this.relPrecision);
        Assert.assertEquals(0.21768, hist.rmsY(), this.relPrecision);
    }

    public void testData() throws Exception {
        int[] bin = new int[]{0, 0, 2, 1, 5, 6, 11, 14, 17, 26, 36, 58, 85, 114, 164, 208, 250, 292, 373, 424, 497, 547, 611, 613, 641, 655, 634, 617, 531, 461, 422, 364, 305, 266, 214, 154, 107, 93, 65, 39, 34, 17, 10, 6, 7, 1, 0, 1, 2, 0};
        ITuple tuple = (ITuple)((Object)this.tree.find(this.convertName(30)));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 50, -4.0, 4.0);
        IEvaluator x = tf.createEvaluator("X");
        tuple.project(hist, x);
        Assert.assertEquals(10000, hist.entries());
        Assert.assertEquals(-1.007E-4, hist.mean(), this.relPrecision);
        Assert.assertEquals(0.9941, hist.rms(), this.relPrecision);
        int nBins = hist.axis().bins();
        Assert.assertEquals(50, nBins);
        for (int i = 0; i < nBins; ++i) {
            Assert.assertEquals(bin[i], hist.binEntries(i));
        }
        temp.close();
    }

    public void testFolderAccess() {
        IHistogram1D hist = (IHistogram1D)((Object)this.tree.find("BS" + this.convertName(100)));
        Assert.assertNotNull(hist);
        Assert.assertEquals("BREM P M", hist.title().trim());
        Assert.assertEquals(15896, hist.entries());
        Assert.assertEquals(0, hist.extraEntries());
        Assert.assertEquals(0.28203, 1.0E-4, hist.mean());
        Assert.assertEquals(0.10821, 1.0E-4, hist.rms());
    }

    public void testTuple() {
        ITuple tuple = (ITuple)((Object)this.tree.find(this.convertName(30)));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 40, 0.0, 10.0);
        IEvaluator x = tf.createEvaluator("Z");
        tuple.project(hist, x);
        Assert.assertEquals(9934, hist.entries());
        Assert.assertEquals(1.907, hist.mean(), 1.0E-4);
        Assert.assertEquals(1.8271, hist.rms(), 1.0E-4);
    }

    public void testTupleAge() {
        ITuple tuple = (ITuple)((Object)this.tree.find("STAFF" + this.convertName(10)));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 44, 20.5, 64.5);
        IEvaluator x = tf.createEvaluator("Age");
        tuple.project(hist, x);
        Assert.assertEquals(3354, hist.entries());
        Assert.assertEquals(47.153, hist.mean(), 1.0E-4);
        Assert.assertEquals(8.643, hist.rms(), 1.0E-4);
    }

    public void testTupleNation() {
        ITuple tuple = (ITuple)((Object)this.tree.find("STAFF" + this.convertName(10)));
        int nationIndex = tuple.findColumn("Nation");
        int n = 0;
        tuple.start();
        while (tuple.next()) {
            String nation = tuple.getString(nationIndex);
            if (!nation.equals("CH")) continue;
            ++n;
        }
        Assert.assertEquals(465, n);
    }

    public void testWalkTree() {
        String[] names = this.tree.listObjectNames("/", true);
        Assert.assertEquals(266, names.length);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.openFile();
    }

    protected void openFile() throws IOException {
        File f = AIDATestSuite.getTestFile("pawdemo.root");
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        this.tree = tf.create(f.getAbsolutePath(), "root", true, false, null);
    }
}

