/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IFitParameterSettings;
import hep.aida.IFitResult;
import hep.aida.IFunction;
import hep.aida.IHistogram;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IManagedObject;
import hep.aida.IMeasurement;
import hep.aida.IModelFunction;
import hep.aida.IProfile;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.IRangeSet;
import hep.aida.ITuple;
import hep.aida.test.TestSuite;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public abstract class AidaTestCase
extends TestCase {
    private Random rnd;
    private long rndSeed = System.currentTimeMillis();
    private static double doublePrecision;
    private static float floatPrecision;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$hep$aida$ITuple;
    static /* synthetic */ Class class$java$lang$Object;

    public AidaTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.rnd = new Random(this.rndSeed);
    }

    protected void saveRandomSeed() {
        File outFile = new File(this.getName() + "_" + System.currentTimeMillis() + ".seed");
        try {
            FileWriter out = new FileWriter(outFile);
            out.write(String.valueOf(this.rndSeed));
            out.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    protected void setRandomSeed(long seed) {
        this.rndSeed = seed;
    }

    protected Random getRandomNumberGenerator() {
        return this.rnd;
    }

    public static void assertEquals(IManagedObject obj1, IManagedObject obj2) {
        Assert.assertEquals(obj1.name(), obj2.name());
    }

    public static void assertEquals(IBaseHistogram h1, IBaseHistogram h2) {
        if (h1 instanceof IManagedObject && h2 instanceof IManagedObject) {
            AidaTestCase.assertEquals((IManagedObject)((Object)h1), (IManagedObject)((Object)h2));
        }
        Assert.assertEquals(h1.dimension(), h2.dimension());
        Assert.assertEquals(h1.title(), h2.title());
        Assert.assertEquals(h1.entries(), h2.entries());
        AidaTestCase.assertEquals(h1.annotation(), h2.annotation());
    }

    public static void assertEquals(IHistogram h1, IHistogram h2) {
        AidaTestCase.assertEquals((IBaseHistogram)h1, (IBaseHistogram)h2);
        Assert.assertEquals(h1.allEntries(), h2.allEntries());
        Assert.assertEquals(h1.extraEntries(), h2.extraEntries());
        AidaTestCase.assertEqualsDouble(h1.sumBinHeights(), h2.sumBinHeights(), h1.sumBinHeights());
        AidaTestCase.assertEqualsDouble(h1.sumExtraBinHeights(), h2.sumExtraBinHeights(), h1.sumExtraBinHeights());
        AidaTestCase.assertEqualsDouble(h1.sumAllBinHeights(), h2.sumAllBinHeights(), h1.sumAllBinHeights());
        AidaTestCase.assertEqualsDouble(h1.minBinHeight(), h2.minBinHeight(), h1.minBinHeight());
        AidaTestCase.assertEqualsDouble(h1.maxBinHeight(), h2.maxBinHeight(), h1.maxBinHeight());
    }

    public static void assertEquals(IHistogram1D h1, IHistogram1D h2) {
        AidaTestCase.assertEquals((IHistogram)h1, (IHistogram)h2);
        AidaTestCase.assertEquals(h1.axis(), h2.axis());
        int bins = h1.axis().bins();
        for (int i = -2; i < bins; ++i) {
            double orderX = i == -2 ? Math.abs(h1.axis().binUpperEdge(i)) : Math.abs(h1.axis().binLowerEdge(i));
            if (orderX == 0.0) {
                orderX = h1.axis().binWidth(i);
            }
            AidaTestCase.assertEqualsDouble(h1.binMean(i), h2.binMean(i), orderX, h1.binEntries(i) + 1);
            AidaTestCase.assertEqualsDouble(h1.binHeight(i), h2.binHeight(i), h1.binHeight(i));
            AidaTestCase.assertEqualsDouble(h1.binError(i), h2.binError(i), h1.binError(i));
            Assert.assertEquals(h1.binEntries(i), h2.binEntries(i));
        }
        AidaTestCase.assertEqualsDouble(h1.mean(), h2.mean(), h1.rms(), h1.entries());
    }

    public static void assertEquals(IHistogram2D h1, IHistogram2D h2) {
        AidaTestCase.assertEquals((IHistogram)h1, (IHistogram)h2);
        AidaTestCase.assertEquals(h1.xAxis(), h2.xAxis());
        AidaTestCase.assertEquals(h1.yAxis(), h2.yAxis());
        int xbins = h1.xAxis().bins();
        int ybins = h1.yAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            Assert.assertEquals(h1.binEntriesX(i), h2.binEntriesX(i));
            AidaTestCase.assertEqualsDouble(h1.binHeightX(i), h2.binHeightX(i), h1.binHeightX(i));
            for (int j = -2; j < ybins; ++j) {
                double orderY;
                double orderX;
                if (i == 0) {
                    Assert.assertEquals(h1.binEntriesY(j), h2.binEntriesY(j));
                    AidaTestCase.assertEqualsDouble(h1.binHeightY(j), h2.binHeightY(j), h1.binHeightY(j));
                }
                if ((orderX = i == -2 ? Math.abs(h1.xAxis().binUpperEdge(i)) : Math.abs(h1.xAxis().binLowerEdge(i))) == 0.0) {
                    orderX = h1.xAxis().binWidth(i);
                }
                if ((orderY = j == -2 ? Math.abs(h1.yAxis().binUpperEdge(j)) : Math.abs(h1.yAxis().binLowerEdge(j))) == 0.0) {
                    orderY = h1.yAxis().binWidth(j);
                }
                AidaTestCase.assertEqualsDouble(h1.binMeanX(i, j), h2.binMeanX(i, j), orderX, h1.binEntries(i, j) + 1);
                AidaTestCase.assertEqualsDouble(h1.binMeanY(i, j), h2.binMeanY(i, j), orderY, h1.binEntries(i, j) + 1);
                AidaTestCase.assertEqualsDouble(h1.binHeight(i, j), h2.binHeight(i, j), h1.binHeight(i, j));
                AidaTestCase.assertEqualsDouble(h1.binError(i, j), h2.binError(i, j), h1.binError(i, j));
                Assert.assertEquals(h1.binEntries(i, j), h2.binEntries(i, j));
            }
        }
        AidaTestCase.assertEqualsDouble(h1.meanX(), h2.meanX(), h1.rmsX(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.meanY(), h2.meanY(), h1.rmsY(), h1.entries());
    }

    public static void assertEquals(IHistogram3D h1, IHistogram3D h2) {
        AidaTestCase.assertEquals((IHistogram)h1, (IHistogram)h2);
        AidaTestCase.assertEquals(h1.xAxis(), h2.xAxis());
        AidaTestCase.assertEquals(h1.yAxis(), h2.yAxis());
        AidaTestCase.assertEquals(h1.zAxis(), h2.zAxis());
        AidaTestCase.assertEqualsDouble(h1.meanX(), h2.meanX(), h1.rmsX(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.meanY(), h2.meanY(), h1.rmsY(), h1.entries());
        AidaTestCase.assertEqualsDouble(h1.meanZ(), h2.meanZ(), h1.rmsZ(), h1.entries());
        int xbins = h1.xAxis().bins();
        int ybins = h1.yAxis().bins();
        int zbins = h1.zAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            Assert.assertEquals(h1.binEntriesX(i), h2.binEntriesX(i));
            AidaTestCase.assertEqualsDouble(h1.binHeightX(i), h2.binHeightX(i), h1.binHeightX(i));
            for (int j = -2; j < ybins; ++j) {
                if (i == 0) {
                    Assert.assertEquals(h1.binEntriesY(j), h2.binEntriesY(j));
                    AidaTestCase.assertEqualsDouble(h1.binHeightY(j), h2.binHeightY(j), h1.binHeightY(j));
                }
                for (int k = -2; k < zbins; ++k) {
                    double orderZ;
                    double orderY;
                    double orderX;
                    if (i == 0 && j == 0) {
                        Assert.assertEquals(h1.binEntriesZ(k), h2.binEntriesZ(k));
                        AidaTestCase.assertEqualsDouble(h1.binHeightZ(k), h2.binHeightZ(k), h1.binHeightZ(k));
                    }
                    if ((orderX = i == -2 ? Math.abs(h1.xAxis().binUpperEdge(i)) : Math.abs(h1.xAxis().binLowerEdge(i))) == 0.0) {
                        orderX = h1.xAxis().binWidth(i);
                    }
                    if ((orderY = j == -2 ? Math.abs(h1.yAxis().binUpperEdge(j)) : Math.abs(h1.yAxis().binLowerEdge(j))) == 0.0) {
                        orderY = h1.yAxis().binWidth(j);
                    }
                    if ((orderZ = k == -2 ? Math.abs(h1.zAxis().binUpperEdge(k)) : Math.abs(h1.zAxis().binLowerEdge(k))) == 0.0) {
                        orderZ = h1.zAxis().binWidth(k);
                    }
                    AidaTestCase.assertEqualsDouble(h1.binMeanX(i, j, k), h2.binMeanX(i, j, k), orderX, h1.binEntries(i, j, k) + 1);
                    AidaTestCase.assertEqualsDouble(h1.binMeanY(i, j, k), h2.binMeanY(i, j, k), orderY, h1.binEntries(i, j, k) + 1);
                    AidaTestCase.assertEqualsDouble(h1.binMeanZ(i, j, k), h2.binMeanZ(i, j, k), orderZ, h1.binEntries(i, j, k) + 1);
                    AidaTestCase.assertEqualsDouble(h1.binHeight(i, j, k), h2.binHeight(i, j, k), h1.binHeight(i, j, k));
                    AidaTestCase.assertEqualsDouble(h1.binError(i, j, k), h2.binError(i, j, k), h1.binError(i, j, k));
                    Assert.assertEquals(h1.binEntries(i, j, k), h2.binEntries(i, j, k));
                }
            }
        }
    }

    public static void assertEquals(IAxis a1, IAxis a2) {
        Assert.assertEquals(a1.bins(), a2.bins());
        AidaTestCase.assertEqualsDouble(a1.lowerEdge(), a2.lowerEdge());
        AidaTestCase.assertEqualsDouble(a1.upperEdge(), a2.upperEdge());
        int bins = a1.bins();
        for (int i = 0; i < bins; ++i) {
            AidaTestCase.assertEqualsDouble(a1.binLowerEdge(i), a2.binLowerEdge(i), a2.binLowerEdge(i));
            AidaTestCase.assertEqualsDouble(a1.binUpperEdge(i), a2.binUpperEdge(i), a2.binUpperEdge(i));
            AidaTestCase.assertEqualsDouble(a1.binWidth(i), a2.binWidth(i), a2.binWidth(i), 2);
        }
    }

    public static void assertEquals(IAnnotation a1, IAnnotation a2) {
        if (a1 != null && a2 != null) {
            int size = a1.size();
            Assert.assertEquals(size, a2.size());
            for (int i = 0; i < size; ++i) {
                String key = a1.key(i);
                Assert.assertEquals(key, a2.key(i));
                Assert.assertEquals(a1.value(i), a2.value(i));
                Assert.assertEquals(a1.value(key), a2.value(key));
            }
        } else {
            Assert.assertTrue(false);
        }
    }

    public static void assertEquals(ITuple t1, ITuple t2) {
        if (t1 instanceof IManagedObject && t2 instanceof IManagedObject) {
            AidaTestCase.assertEquals((IManagedObject)((Object)t1), (IManagedObject)((Object)t2));
        }
        Assert.assertEquals(t1.title(), t2.title());
        Assert.assertEquals(t1.rows(), t2.rows());
        Assert.assertEquals(t1.columns(), t2.columns());
        int columns = t1.columns();
        for (int i = 0; i < columns; ++i) {
            Assert.assertEquals(t1.columnName(i), t2.columnName(i));
            Assert.assertEquals(t1.columnType(i).getName(), t2.columnType(i).getName());
            if (t1.columnType(i) == (class$java$lang$String == null ? AidaTestCase.class$("java.lang.String") : class$java$lang$String) || t1.columnType(i) == (class$hep$aida$ITuple == null ? AidaTestCase.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) continue;
            AidaTestCase.assertEqualsDouble(t1.columnMin(i), t2.columnMin(i), 1.0);
            AidaTestCase.assertEqualsDouble(t1.columnMax(i), t2.columnMax(i), 1.0);
            double order = t1.columnRms(i);
            if (Double.isNaN(order) || Double.isInfinite(order)) {
                order = Math.abs(t1.columnMax(i) - t1.columnMin(i));
            }
            AidaTestCase.assertEqualsDouble(t1.columnMean(i), t2.columnMean(i), order, t1.rows());
        }
        t1.start();
        t2.start();
        int countRows = 0;
        while (t1.next() && t2.next()) {
            ++countRows;
            for (int i = 0; i < columns; ++i) {
                Class colType = t1.columnType(i);
                if (colType == Integer.TYPE) {
                    Assert.assertTrue(t1.getInt(i) == t2.getInt(i));
                    continue;
                }
                if (colType == Short.TYPE) {
                    Assert.assertTrue(t1.getShort(i) == t2.getShort(i));
                    continue;
                }
                if (colType == Long.TYPE) {
                    Assert.assertTrue(t1.getLong(i) == t2.getLong(i));
                    continue;
                }
                if (colType == Float.TYPE) {
                    AidaTestCase.assertEqualsFloat(t1.getFloat(i), t2.getFloat(i));
                    continue;
                }
                if (colType == Double.TYPE) {
                    AidaTestCase.assertEqualsDouble(t1.getDouble(i), t2.getDouble(i));
                    continue;
                }
                if (colType == Boolean.TYPE) {
                    Assert.assertTrue(t1.getBoolean(i) == t2.getBoolean(i));
                    continue;
                }
                if (colType == Byte.TYPE) {
                    Assert.assertTrue(t1.getByte(i) == t2.getByte(i));
                    continue;
                }
                if (colType == Character.TYPE) {
                    Assert.assertTrue(t1.getChar(i) == t2.getChar(i));
                    continue;
                }
                if (colType == (class$java$lang$String == null ? AidaTestCase.class$("java.lang.String") : class$java$lang$String)) {
                    Assert.assertEquals(t1.getString(i), t2.getString(i));
                    continue;
                }
                if (colType == (class$hep$aida$ITuple == null ? AidaTestCase.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) {
                    AidaTestCase.assertEquals((ITuple)t1.getObject(i), (ITuple)t2.getObject(i));
                    continue;
                }
                if (colType != (class$java$lang$Object == null ? AidaTestCase.class$("java.lang.Object") : class$java$lang$Object)) continue;
                Assert.assertEquals(t1.getObject(i), t2.getObject(i));
            }
        }
        Assert.assertEquals(countRows, t1.rows());
    }

    public static void assertEquals(ICloud c1, ICloud c2) {
        AidaTestCase.assertEquals((IBaseHistogram)c1, (IBaseHistogram)c2);
        AidaTestCase.assertEqualsDouble(c1.sumOfWeights(), c2.sumOfWeights(), 1.0, c1.entries());
        Assert.assertEquals(c1.isConverted(), c2.isConverted());
    }

    public static void assertEquals(ICloud1D c1, ICloud1D c2) {
        AidaTestCase.assertEquals((ICloud)c1, (ICloud)c2);
        AidaTestCase.assertEqualsDouble(c1.lowerEdge(), c2.lowerEdge());
        AidaTestCase.assertEqualsDouble(c1.upperEdge(), c2.upperEdge());
        AidaTestCase.assertEqualsDouble(c1.mean(), c2.mean(), c1.rms(), c1.entries());
        IHistogram1D h1 = null;
        IHistogram1D h2 = null;
        try {
            h1 = c1.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            h2 = c2.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (h1 != null && h2 != null) {
            AidaTestCase.assertEquals(h1, h2);
        } else if (h1 == null && h2 == null) {
            int entries = c1.entries();
            for (int i = 0; i < entries; ++i) {
                AidaTestCase.assertEqualsDouble(c1.value(i), c2.value(i));
                AidaTestCase.assertEqualsDouble(c1.weight(i), c2.weight(i));
            }
        } else {
            Assert.assertTrue(false);
        }
    }

    public static void assertEquals(ICloud2D c1, ICloud2D c2) {
        AidaTestCase.assertEquals((ICloud)c1, (ICloud)c2);
        AidaTestCase.assertEqualsDouble(c1.lowerEdgeX(), c2.lowerEdgeX());
        AidaTestCase.assertEqualsDouble(c1.upperEdgeX(), c2.upperEdgeX());
        AidaTestCase.assertEqualsDouble(c1.lowerEdgeY(), c2.lowerEdgeY());
        AidaTestCase.assertEqualsDouble(c1.upperEdgeY(), c2.upperEdgeY());
        AidaTestCase.assertEqualsDouble(c1.meanX(), c2.meanX(), c1.rmsX(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.meanY(), c2.meanY(), c1.rmsY(), c1.entries());
        IHistogram2D h1 = null;
        IHistogram2D h2 = null;
        try {
            h1 = c1.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            h2 = c2.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (h1 != null && h2 != null) {
            AidaTestCase.assertEquals(h1, h2);
        } else if (h1 == null && h2 == null) {
            int entries = c1.entries();
            for (int i = 0; i < entries; ++i) {
                AidaTestCase.assertEqualsDouble(c1.valueX(i), c2.valueX(i));
                AidaTestCase.assertEqualsDouble(c1.valueY(i), c2.valueY(i));
                AidaTestCase.assertEqualsDouble(c1.weight(i), c2.weight(i));
            }
        } else {
            Assert.assertTrue(false);
        }
    }

    public static void assertEquals(ICloud3D c1, ICloud3D c2) {
        AidaTestCase.assertEquals((ICloud)c1, (ICloud)c2);
        AidaTestCase.assertEqualsDouble(c1.lowerEdgeX(), c2.lowerEdgeX());
        AidaTestCase.assertEqualsDouble(c1.upperEdgeX(), c2.upperEdgeX());
        AidaTestCase.assertEqualsDouble(c1.lowerEdgeY(), c2.lowerEdgeY());
        AidaTestCase.assertEqualsDouble(c1.upperEdgeY(), c2.upperEdgeY());
        AidaTestCase.assertEqualsDouble(c1.lowerEdgeZ(), c2.lowerEdgeZ());
        AidaTestCase.assertEqualsDouble(c1.upperEdgeZ(), c2.upperEdgeZ());
        AidaTestCase.assertEqualsDouble(c1.meanX(), c2.meanX(), c1.rmsX(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.meanY(), c2.meanY(), c1.rmsY(), c1.entries());
        AidaTestCase.assertEqualsDouble(c1.meanZ(), c2.meanZ(), c1.rmsZ(), c1.entries());
        IHistogram3D h1 = null;
        IHistogram3D h2 = null;
        try {
            h1 = c1.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            h2 = c2.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (h1 != null && h2 != null) {
            AidaTestCase.assertEquals(h1, h2);
        } else if (h1 == null && h2 == null) {
            int entries = c1.entries();
            for (int i = 0; i < entries; ++i) {
                AidaTestCase.assertEqualsDouble(c1.valueX(i), c2.valueX(i));
                AidaTestCase.assertEqualsDouble(c1.valueY(i), c2.valueY(i));
                AidaTestCase.assertEqualsDouble(c1.valueZ(i), c2.valueZ(i));
                AidaTestCase.assertEqualsDouble(c1.weight(i), c2.weight(i));
            }
        } else {
            Assert.assertTrue(false);
        }
    }

    public static void assertEquals(IProfile p1, IProfile p2) {
        AidaTestCase.assertEquals((IBaseHistogram)p1, (IBaseHistogram)p2);
        Assert.assertEquals(p1.allEntries(), p2.allEntries());
        Assert.assertEquals(p1.extraEntries(), p2.extraEntries());
        AidaTestCase.assertEqualsDouble(p1.sumBinHeights(), p2.sumBinHeights(), p1.sumBinHeights());
        AidaTestCase.assertEqualsDouble(p1.sumExtraBinHeights(), p2.sumExtraBinHeights(), p1.sumExtraBinHeights());
        AidaTestCase.assertEqualsDouble(p1.sumAllBinHeights(), p2.sumAllBinHeights(), p1.sumAllBinHeights());
        AidaTestCase.assertEqualsDouble(p1.minBinHeight(), p2.minBinHeight(), p2.minBinHeight());
        AidaTestCase.assertEqualsDouble(p1.maxBinHeight(), p2.maxBinHeight(), p2.maxBinHeight());
    }

    public static void assertEquals(IProfile1D p1, IProfile1D p2) {
        AidaTestCase.assertEquals((IProfile)p1, (IProfile)p2);
        AidaTestCase.assertEquals(p1.axis(), p2.axis());
        int bins = p1.axis().bins();
        for (int i = -2; i < bins; ++i) {
            AidaTestCase.assertEqualsDouble(p1.binMean(i), p2.binMean(i), p1.binRms(i), p1.binEntries(i));
            AidaTestCase.assertEqualsDouble(p1.binHeight(i), p2.binHeight(i), p1.binHeight(i));
            AidaTestCase.assertEqualsDouble(p1.binError(i), p2.binError(i), p1.binError(i));
            Assert.assertEquals(p1.binEntries(i), p2.binEntries(i));
        }
        AidaTestCase.assertEqualsDouble(p1.mean(), p2.mean(), p1.rms(), p1.entries());
    }

    public static void assertEquals(IProfile2D p1, IProfile2D p2) {
        AidaTestCase.assertEquals((IProfile)p1, (IProfile)p2);
        AidaTestCase.assertEquals(p1.xAxis(), p2.xAxis());
        AidaTestCase.assertEquals(p1.yAxis(), p2.yAxis());
        int xbins = p1.xAxis().bins();
        int ybins = p1.yAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            Assert.assertEquals(p1.binEntriesX(i), p2.binEntriesX(i));
            AidaTestCase.assertEqualsDouble(p1.binHeightX(i), p2.binHeightX(i), p1.binHeightX(i));
            for (int j = -2; j < ybins; ++j) {
                if (i == 0) {
                    Assert.assertEquals(p1.binEntriesY(j), p2.binEntriesY(j));
                    AidaTestCase.assertEqualsDouble(p1.binHeightY(j), p2.binHeightY(j), p1.binHeightY(j));
                }
                AidaTestCase.assertEqualsDouble(p1.binMeanX(i, j), p2.binMeanX(i, j), p1.binRms(i, j), p1.binEntries(i, j));
                AidaTestCase.assertEqualsDouble(p1.binMeanY(i, j), p2.binMeanY(i, j), p1.binRms(i, j), p1.binEntries(i, j));
                AidaTestCase.assertEqualsDouble(p1.binHeight(i, j), p2.binHeight(i, j), p1.binHeight(i, j));
                AidaTestCase.assertEqualsDouble(p1.binError(i, j), p2.binError(i, j), p1.binError(i, j));
                Assert.assertEquals(p1.binEntries(i, j), p2.binEntries(i, j));
            }
        }
        AidaTestCase.assertEqualsDouble(p1.meanX(), p2.meanX(), p1.rmsX(), p1.entries());
        AidaTestCase.assertEqualsDouble(p1.meanY(), p2.meanY(), p1.rmsY(), p1.entries());
    }

    public static void assertEquals(IDataPointSet d1, IDataPointSet d2) {
        if (d1 instanceof IManagedObject && d2 instanceof IManagedObject) {
            AidaTestCase.assertEquals((IManagedObject)((Object)d1), (IManagedObject)((Object)d2));
        }
        AidaTestCase.assertEquals(d1.annotation(), d2.annotation());
        Assert.assertEquals(d1.title(), d2.title());
        Assert.assertEquals(d1.dimension(), d2.dimension());
        Assert.assertEquals(d1.size(), d2.size());
        for (int i = 0; i < d1.size(); ++i) {
            AidaTestCase.assertEquals(d1.point(i), d2.point(i));
            for (int j = 0; j < d1.dimension(); ++j) {
                AidaTestCase.assertEqualsDouble(d1.lowerExtent(j), d2.lowerExtent(j), 0.0);
                AidaTestCase.assertEqualsDouble(d1.upperExtent(j), d2.upperExtent(j), 0.0);
            }
        }
    }

    public static void assertEquals(IDataPoint p1, IDataPoint p2) {
        Assert.assertEquals(p1.dimension(), p2.dimension());
        for (int i = 0; i < p1.dimension(); ++i) {
            AidaTestCase.assertEquals(p1.coordinate(i), p2.coordinate(i));
        }
    }

    public static void assertEquals(IMeasurement m1, IMeasurement m2) {
        AidaTestCase.assertEqualsDouble(m1.value(), m2.value(), 0.0);
        AidaTestCase.assertEqualsDouble(m1.errorPlus(), m2.errorPlus(), 0.0);
        AidaTestCase.assertEqualsDouble(m1.errorMinus(), m2.errorMinus(), 0.0);
    }

    public static void assertEquals(IFunction f1, IFunction f2) {
        AidaTestCase.assertEquals(f1, f2, true);
    }

    public static void assertEquals(IFunction f1, IFunction f2, boolean checkAnnotation) {
        if (f1 instanceof IManagedObject && f2 instanceof IManagedObject) {
            AidaTestCase.assertEquals((IManagedObject)((Object)f1), (IManagedObject)((Object)f2));
        }
        Assert.assertEquals(f1.codeletString(), f2.codeletString());
        Assert.assertEquals(f1.title(), f2.title());
        if (checkAnnotation) {
            AidaTestCase.assertEquals(f1.annotation(), f2.annotation());
        }
        Assert.assertEquals(f1.dimension(), f2.dimension());
        for (int i = 0; i < f1.dimension(); ++i) {
            Assert.assertTrue(f1.variableName(i).equals(f2.variableName(i)));
        }
        Assert.assertTrue(f1.providesGradient() == f1.providesGradient());
        Assert.assertEquals(f1.numberOfParameters(), f2.numberOfParameters());
        String[] parNames = f1.parameterNames();
        for (int i = 0; i < f1.numberOfParameters(); ++i) {
            Assert.assertEquals(f1.indexOfParameter(parNames[i]), f2.indexOfParameter(parNames[i]));
            AidaTestCase.assertEqualsDouble(f1.parameter(parNames[i]), f2.parameter(parNames[i]), 0.0);
        }
        AidaTestCase.assertEqualsDouble(f1.parameters(), f2.parameters());
        if (f1 instanceof IModelFunction && f2 instanceof IModelFunction) {
            AidaTestCase.assertEqualsModelFunction((IModelFunction)f1, (IModelFunction)f2);
        }
    }

    private static void assertEqualsModelFunction(IModelFunction f1, IModelFunction f2) {
        Assert.assertTrue(f1.providesNormalization() == f2.providesNormalization());
        if (f1.providesNormalization()) {
            Assert.assertTrue(f1.isNormalized() == f2.isNormalized());
        }
        Assert.assertTrue(f1.providesParameterGradient() == f2.providesParameterGradient());
        int dim = f1.dimension();
        for (int i = 0; i < dim; ++i) {
            AidaTestCase.assertEquals(f1.normalizationRange(i), f2.normalizationRange(i));
        }
    }

    public static void assertEquals(IRangeSet r1, IRangeSet r2) {
        Assert.assertEquals(r1.size(), r2.size());
        AidaTestCase.assertEqualsDouble(r1.lowerBounds(), r2.lowerBounds());
        AidaTestCase.assertEqualsDouble(r1.upperBounds(), r2.upperBounds());
    }

    public static void assertEquals(IFitResult f1, IFitResult f2) {
        Assert.assertEquals(f1.engineName(), f2.engineName());
        Assert.assertEquals(f1.fitMethodName(), f2.fitMethodName());
        Assert.assertTrue(f1.isValid() == f2.isValid());
        Assert.assertEquals(f1.fitStatus(), f2.fitStatus());
        Assert.assertEquals(f1.dataDescription(), f2.dataDescription());
        Assert.assertEquals(f1.ndf(), f2.ndf());
        AidaTestCase.assertEqualsDouble(f1.quality(), f2.quality(), 0.0);
        if (f1.fittedFunction() != null && f2.fittedFunction() != null) {
            AidaTestCase.assertEquals(f1.fittedFunction(), f2.fittedFunction(), false);
        } else {
            Assert.assertFalse(f1.fittedFunction() == null && f2.fittedFunction() != null || f1.fittedFunction() != null && f2.fittedFunction() == null);
        }
        String[] parNames1 = f1.fittedParameterNames();
        String[] parNames2 = f2.fittedParameterNames();
        if (parNames1 != null && parNames2 != null) {
            Assert.assertEquals(parNames1.length, parNames2.length);
            for (int i = 0; i < parNames1.length; ++i) {
                Assert.assertEquals(parNames1[i], parNames2[i]);
                AidaTestCase.assertEqualsDouble(f1.fittedParameter(parNames1[i]), f1.fittedParameter(parNames1[i]), 0.0);
                AidaTestCase.assertEquals(f1.fitParameterSettings(parNames1[i]), f2.fitParameterSettings(parNames1[i]));
                for (int j = 0; j < parNames1.length; ++j) {
                    AidaTestCase.assertEqualsDouble(f1.covMatrixElement(i, j), f2.covMatrixElement(i, j), 0.0);
                }
            }
        } else {
            Assert.assertFalse(parNames1 == null && parNames2 != null || parNames1 != null && parNames2 == null);
        }
        AidaTestCase.assertEqualsDouble(f1.fittedParameters(), f2.fittedParameters());
        AidaTestCase.assertEqualsDouble(f1.errors(), f2.errors());
        AidaTestCase.assertEqualsDouble(f1.errorsPlus(), f2.errorsPlus());
        AidaTestCase.assertEqualsDouble(f1.errorsMinus(), f2.errorsMinus());
        String[] con1 = f1.constraints();
        String[] con2 = f2.constraints();
        if (con1 != null && con2 != null) {
            Assert.assertEquals(con1.length, con2.length);
            for (int i = 0; i < con1.length; ++i) {
                Assert.assertEquals(con1[i], con2[i]);
            }
        } else {
            Assert.assertFalse(con1 == null && con2 != null || con1 != null && con2 == null);
        }
    }

    public static void assertEquals(IFitParameterSettings f1, IFitParameterSettings f2) {
        Assert.assertEquals(f1.name(), f2.name());
        Assert.assertTrue(f1.isBound() == f2.isBound());
        Assert.assertTrue(f1.isFixed() == f2.isFixed());
        AidaTestCase.assertEqualsDouble(f1.lowerBound(), f2.lowerBound(), 0.0);
        AidaTestCase.assertEqualsDouble(f1.upperBound(), f2.upperBound(), 0.0);
        AidaTestCase.assertEqualsDouble(f1.stepSize(), f2.stepSize(), 0.0);
    }

    public static void assertEqualsDouble(double[] d1, double[] d2) {
        if (d1 != null && d2 != null) {
            Assert.assertEquals(d1.length, d2.length);
            for (int i = 0; i < d1.length; ++i) {
                AidaTestCase.assertEqualsDouble(d1[i], d2[i]);
            }
        } else {
            Assert.assertFalse(d1 == null && d2 != null || d1 != null && d2 == null);
        }
    }

    public static void assertEqualsDouble(double[] d1, double[] d2, double prec) {
        if (d1 != null && d2 != null) {
            Assert.assertEquals(d1.length, d2.length);
            for (int i = 0; i < d1.length; ++i) {
                AidaTestCase.assertEqualsDouble(d1[i], d2[i]);
            }
        } else {
            Assert.assertFalse(d1 == null && d2 != null || d1 != null && d2 == null);
        }
    }

    public static void assertEqualsDouble(double v1, double v2) {
        if (v1 == v2) {
            return;
        }
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            return;
        }
        Assert.assertTrue(!(Double.isNaN(v1) && !Double.isNaN(v2) || !Double.isNaN(v1) && Double.isNaN(v2)));
    }

    public static void assertEqualsFloat(float v1, float v2) {
        if (v1 == v2) {
            return;
        }
        if (Float.isNaN(v1) && Float.isNaN(v2)) {
            return;
        }
        Assert.assertTrue(!(Float.isNaN(v1) && !Float.isNaN(v2) || !Float.isNaN(v1) && Float.isNaN(v2)));
    }

    public static void assertEqualsDouble(double v1, double v2, double orderOfAddend) {
        AidaTestCase.assertEqualsDouble(v1, v2, orderOfAddend, 1, 1.0);
    }

    public static void assertEqualsDouble(double v1, double v2, double orderOfAddend, int numberOfSums) {
        AidaTestCase.assertEqualsDouble(v1, v2, orderOfAddend, numberOfSums, 1.0);
    }

    public static void assertEqualsFloat(float v1, float v2, float orderOfAddend) {
        AidaTestCase.assertEqualsFloat(v1, v2, orderOfAddend, 1);
    }

    public static void assertEqualsFloat(float v1, float v2, float orderOfAddend, int numberOfSums) {
        AidaTestCase.assertEqualsFloat(v1, v2, orderOfAddend, numberOfSums, 1.0f);
    }

    public static void assertEqualsFloat(float v1, float v2, float orderOfAddend, int numberOfSums, float orderOfDividend) {
        if (v1 == v2) {
            return;
        }
        if (Float.isNaN(v1) && Float.isNaN(v2)) {
            return;
        }
        Assert.assertTrue(!(Float.isNaN(v1) && !Float.isNaN(v2) || !Float.isNaN(v1) && Float.isNaN(v2)));
        if (Float.isInfinite(orderOfAddend) || Float.isNaN(orderOfAddend)) {
            throw new IllegalArgumentException("Incorrect value for orderOfAddend");
        }
        if (Float.isInfinite(numberOfSums) || Float.isNaN(numberOfSums)) {
            throw new IllegalArgumentException("Incorrect value for numberOfSums");
        }
        if (Float.isInfinite(orderOfDividend) || Float.isNaN(orderOfDividend)) {
            throw new IllegalArgumentException("Incorrect value for orderOfDividend");
        }
        if (orderOfAddend == 0.0f) {
            orderOfAddend = 1.0f;
        }
        float delta = Math.abs(floatPrecision * orderOfAddend * (float)numberOfSums / orderOfDividend);
        float actualdelta = Math.abs(v1 - v2);
        float r = delta / actualdelta;
        TestSuite.cloud1d().fill(delta);
        TestSuite.cloud2d().fill(delta, v1);
        if ((double)r < 0.01) {
            Assert.assertTrue("\nassertEqualsFloat: Allowed Delta <" + delta + "> Actual Delta <" + (v1 - v2) + "> \nassertEqualsFloat: " + numberOfSums + " " + orderOfAddend + " " + orderOfDividend, false);
        }
    }

    public static void assertEqualsDouble(double v1, double v2, double orderOfAddend, int numberOfSums, double orderOfDividend) {
        if (v1 == v2) {
            return;
        }
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            return;
        }
        Assert.assertTrue(!(Double.isNaN(v1) && !Double.isNaN(v2) || !Double.isNaN(v1) && Double.isNaN(v2)));
        if (Double.isInfinite(orderOfAddend) || Double.isNaN(orderOfAddend)) {
            throw new IllegalArgumentException("Incorrect value for orderOfAddend");
        }
        if (Double.isInfinite(numberOfSums) || Double.isNaN(numberOfSums)) {
            throw new IllegalArgumentException("Incorrect value for numberOfSums");
        }
        if (Double.isInfinite(orderOfDividend) || Double.isNaN(orderOfDividend)) {
            throw new IllegalArgumentException("Incorrect value for orderOfDividend");
        }
        if (orderOfAddend == 0.0) {
            orderOfAddend = 1.0;
        }
        double delta = Math.abs(doublePrecision * orderOfAddend * (double)numberOfSums / orderOfDividend);
        double actualdelta = Math.abs(v1 - v2);
        double r = delta / actualdelta;
        TestSuite.cloud1d().fill(delta);
        TestSuite.cloud2d().fill(delta, v1);
        if (r < 0.01) {
            Assert.assertTrue("\nassertEqualsDouble: Allowed Delta <" + delta + "> Actual Delta <" + (v1 - v2) + "> \nassertEqualsDouble: " + numberOfSums + " " + orderOfAddend + " " + orderOfDividend, false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        double dstart;
        double tol = dstart = 1.0;
        while (tol + dstart != dstart) {
            tol /= 2.0;
        }
        doublePrecision = tol;
        float fstart = 1.0f;
        float ftol = 0.0f;
        ftol = fstart;
        while (ftol + fstart != fstart) {
            ftol /= 2.0f;
        }
        floatPrecision = ftol;
    }
}

