/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml.converters;

import hep.aida.ref.xml.ascii.AidaAsciiXMLWriter;
import hep.aida.ref.xml.binary.AidaWBXML;
import hep.aida.ref.xml.binary.AidaWBXMLConverter;
import hep.aida.ref.xml.binary.AidaWBXMLLookup;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.freehep.wbxml.WBXMLTagWriter;
import org.freehep.wbxml.WBXMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class FromAsciiHandler
implements ContentHandler,
EntityResolver {
    private WBXMLTagWriter writer;

    void convert(InputStream in, OutputStream out, boolean binary) throws SAXException, ParserConfigurationException, IOException {
        this.writer = binary ? new WBXMLWriter(out, AidaWBXML.attributes.length - 1) : new AidaAsciiXMLWriter(new BufferedWriter(new OutputStreamWriter(out)));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setContentHandler(this);
        parser.setEntityResolver(this);
        parser.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException ex) throws SAXException {
                throw ex;
            }

            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            public void warning(SAXParseException ex) throws SAXException {
            }
        });
        parser.parse(new InputSource(in));
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.writer.referToDTD("aida", systemId);
        return null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String content = new String(ch).substring(start, start + length);
            this.writer.print(content);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.closeDoc();
            this.writer.close();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        int tag = AidaWBXMLLookup.getTag(name);
        if (tag < 0) {
            throw new SAXException("Closing Unknown tag '" + name + "'");
        }
        if (AidaWBXMLLookup.isTagEmpty(tag)) {
            return;
        }
        try {
            this.writer.closeTag();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        try {
            this.writer.openDoc();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        String attName = null;
        String value = null;
        try {
            int tag = AidaWBXMLLookup.getTag(name);
            if (tag < 0) {
                throw new SAXException("Unknown tag '" + name + "'");
            }
            block18: for (int i = 0; i < atts.getLength(); ++i) {
                attName = atts.getQName(i);
                value = atts.getValue(i);
                int att = AidaWBXMLLookup.getAttribute(attName);
                if (att == -1) {
                    throw new SAXException("Unknown attribute '" + attName + "' in tag '" + name + "'");
                }
                int type = -1;
                if (att == -2) {
                    try {
                        Double.parseDouble(value);
                        type = 3;
                    }
                    catch (NumberFormatException e1) {
                        try {
                            Integer.parseInt(value);
                            type = 5;
                        }
                        catch (NumberFormatException e2) {
                            type = 8;
                        }
                    }
                } else {
                    type = AidaWBXMLLookup.getAttributeType(att);
                }
                if (type == -1) {
                    throw new SAXException("Unknown type for attribute '" + attName + "' in tag '" + name + "'");
                }
                switch (type) {
                    case 0: {
                        if (att == -2) {
                            att = 4;
                        }
                        this.writer.setAttribute(att, AidaWBXMLConverter.toBoolean(tag, att, value));
                        continue block18;
                    }
                    case 1: {
                        if (att == -2) {
                            att = 5;
                        }
                        this.writer.setAttribute(att, Byte.parseByte(value));
                        continue block18;
                    }
                    case 2: {
                        if (att == -2) {
                            att = 6;
                        }
                        this.writer.setAttribute(att, value.charAt(0));
                        continue block18;
                    }
                    case 3: {
                        if (att == -2) {
                            att = 7;
                        }
                        this.writer.setAttribute(att, AidaWBXMLConverter.toDouble(tag, att, value));
                        continue block18;
                    }
                    case 4: {
                        if (att == -2) {
                            att = 8;
                        }
                        this.writer.setAttribute(att, AidaWBXMLConverter.toFloat(tag, att, value));
                        continue block18;
                    }
                    case 5: {
                        if (att == -2) {
                            att = 9;
                        }
                        this.writer.setAttribute(att, AidaWBXMLConverter.toInt(tag, att, value));
                        continue block18;
                    }
                    case 6: {
                        if (att == -2) {
                            att = 10;
                        }
                        this.writer.setAttribute(att, Long.parseLong(value));
                        continue block18;
                    }
                    case 7: {
                        if (att == -2) {
                            att = 11;
                        }
                        this.writer.setAttribute(att, Short.parseShort(value));
                        continue block18;
                    }
                    case 8: {
                        if (att == -2) {
                            att = 12;
                        }
                        this.writer.setAttribute(att, value);
                        continue block18;
                    }
                    default: {
                        throw new SAXException("Type '" + type + "' not handled for attribute '" + attName + "' in tag '" + name + "'");
                    }
                }
            }
            boolean empty = AidaWBXMLLookup.isTagEmpty(tag);
            if (empty) {
                this.writer.printTag(tag);
            } else {
                this.writer.openTag(tag);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (NumberFormatException e) {
            throw new SAXException("Exception for tag '" + name + "', attribute '" + attName + "' value '" + value + "'", e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

