/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tree;

import hep.aida.IAnalysisFactory;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPointSet;
import hep.aida.IFunction;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IManagedObject;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.dev.IDevManagedObject;
import hep.aida.dev.IDevTree;
import hep.aida.dev.IOnDemandStore;
import hep.aida.dev.IStore;
import hep.aida.dev.IStoreFactory;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.event.AIDAObservable;
import hep.aida.ref.event.Connectable;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.event.TreeEvent;
import hep.aida.ref.tree.Folder;
import hep.aida.ref.tree.Link;
import hep.aida.ref.tree.MountPoint;
import hep.aida.ref.tree.Path;
import hep.aida.ref.tree.TreeObjectAlreadyExistException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public class Tree
extends AIDAObservable
implements IDevTree,
IsObservable {
    private Object lock = null;
    private Folder root;
    private Path currentPath;
    private String separatorChar = "/";
    private IStore aidaStore;
    private String storeName;
    private boolean readOnly;
    private boolean readOnlyUserDefined;
    private boolean createNew;
    private String storeType = null;
    private Map optionsMap;
    private Hashtable manObjHash = new Hashtable();
    private Hashtable pathHash = new Hashtable();
    private ArrayList mountList = new ArrayList();
    private int mountCount = 0;
    private boolean isClosed = false;
    private boolean overwrite = true;
    private String name = null;
    private IAnalysisFactory analysisFactory;

    protected Tree(IAnalysisFactory analysisFactory) {
        this.root = new Folder("/");
        this.currentPath = new Path();
        this.setIsValidAfterNotify(true);
        this.aidaStore = null;
        this.analysisFactory = analysisFactory;
    }

    protected Tree(IAnalysisFactory analysisFactory, String name, String storeName, String storeType, int mode, String options) throws IOException {
        this.root = new Folder("/");
        this.currentPath = new Path();
        this.setIsValidAfterNotify(true);
        this.aidaStore = null;
        this.analysisFactory = analysisFactory;
        this.name = name;
        this.init(storeName, storeType, mode, options);
    }

    public String name() {
        return this.name;
    }

    public String storeName() {
        return this.storeName;
    }

    public String storeType() {
        return this.storeType;
    }

    public void setLock(Object lock) {
        this.lock = lock;
    }

    public Object getLock() {
        return this.lock;
    }

    IStore getStore() {
        return this.aidaStore;
    }

    public boolean hasStore() {
        return this.aidaStore != null;
    }

    public IManagedObject findObject(String path) throws IllegalArgumentException {
        Path p = new Path(this.currentPath, path);
        if (p.toString().equals("/")) {
            return this.root;
        }
        Folder folder = this.checkAndFillFolderFromStore(p.parent());
        if (folder == null) {
            throw new IllegalArgumentException("Can not find Folder: " + p.parent());
        }
        IManagedObject obj = folder.getChild(p.getName());
        return obj;
    }

    public IManagedObject find(String path) throws IllegalArgumentException {
        IManagedObject obj = this.findObject(path);
        if (obj == null || obj instanceof Folder) {
            throw new IllegalArgumentException("The path " + path + " does not correspond to an IManagedObject");
        }
        if (obj instanceof Link) {
            obj = this.find(((Link)obj).path().toString());
        }
        Path p = new Path(this.currentPath, path);
        this.registerManagedObject(obj, p);
        return obj;
    }

    public ITree findTree(String path) throws IllegalArgumentException {
        IManagedObject mp = this.findObject(path);
        if (!(mp instanceof MountPoint)) {
            throw new IllegalArgumentException("The given path " + path + " does not correspond to a mount point.");
        }
        return ((MountPoint)mp).getTree();
    }

    public void close() throws IOException {
        if (this.aidaStore != null) {
            this.aidaStore.close();
            this.aidaStore = null;
        }
        boolean wasClosed = this.isClosed;
        this.isClosed = true;
        if (!wasClosed) {
            this.fireStateChanged(new TreeEvent((Object)this, 5, new String[]{"/"}, null, 1));
        }
    }

    public void cd(String path) throws IllegalArgumentException {
        Path newPath = new Path(this.currentPath, path);
        IManagedObject obj = this.findObject(newPath.toString());
        if (obj == null) {
            throw new IllegalArgumentException("Wrong path " + path);
        }
        if (obj instanceof Link) {
            newPath = ((Link)obj).path();
            obj = this.findObject(((Link)obj).path().toString());
        }
        if (!(obj instanceof Folder)) {
            throw new IllegalArgumentException("Path: " + path + " is not a folder");
        }
        Folder folder = (Folder)obj;
        this.currentPath = newPath;
        if (this.isValid) {
            this.fireStateChanged(new TreeEvent((Object)this, 4, this.currentPath.toArray(), null, 1));
        }
    }

    public String pwd() {
        return this.currentPath.toString();
    }

    public void ls() throws IllegalArgumentException {
        this.ls(".", false, null);
    }

    public void ls(String path) throws IllegalArgumentException {
        this.ls(path, false, null);
    }

    public void ls(String path, boolean recursive) throws IllegalArgumentException {
        this.ls(path, recursive, null);
    }

    public void ls(String path, boolean recursive, OutputStream os2) throws IllegalArgumentException {
        Path p;
        IManagedObject obj;
        if (os2 == null) {
            os2 = System.out;
        }
        if ((obj = this.checkAndFillFolder(p = new Path(this.currentPath, path))) == null) {
            throw new IllegalArgumentException("Wrong path " + path);
        }
        if (obj instanceof Folder && !path.endsWith(this.separatorChar)) {
            path = path + this.separatorChar;
        }
        PrintWriter pw = new PrintWriter(os2, true);
        if (obj instanceof Folder) {
            int childNumb = ((Folder)obj).getChildCount();
            for (int i = 0; i < childNumb; ++i) {
                IManagedObject child = ((Folder)obj).getChild(i);
                if (child instanceof Folder) {
                    pw.println(path + AidaUtils.modifyName(AidaUtils.modifyName(child.name())) + this.separatorChar);
                    if (!recursive) continue;
                    this.ls(path + AidaUtils.modifyName(child.name()), recursive, os2);
                    continue;
                }
                if (child instanceof Link) {
                    pw.println(path + AidaUtils.modifyName(child.name()) + " -> " + ((Link)child).path().toString());
                    continue;
                }
                pw.println(path + AidaUtils.modifyName(child.name()));
            }
        } else if (obj instanceof Link) {
            pw.println(path + " -> " + ((Link)obj).path().toString());
        } else {
            pw.println(path);
        }
    }

    public String[] listObjectNames() throws IllegalArgumentException {
        return this.listObjectNames(this.currentPath.getName());
    }

    public String[] listObjectNames(String path) throws IllegalArgumentException {
        return this.listObjectNames(path, false);
    }

    public String[] listObjectNames(String path, boolean recursive) throws IllegalArgumentException {
        int i;
        Path p = new Path(this.currentPath, path);
        IManagedObject obj = this.checkAndFillFolder(p);
        if (obj == null) {
            throw new IllegalArgumentException("Wrong path " + path);
        }
        if (obj instanceof Folder && !path.endsWith(this.separatorChar)) {
            path = path + this.separatorChar;
        }
        Vector<String> names = new Vector<String>();
        if (obj instanceof Folder) {
            int childNumb = ((Folder)obj).getChildCount();
            for (i = 0; i < childNumb; ++i) {
                IManagedObject child = ((Folder)obj).getChild(i);
                if (child instanceof Folder) {
                    names.add(path + AidaUtils.modifyName(child.name()) + this.separatorChar);
                    if (!recursive) continue;
                    String[] childNames = this.listObjectNames(path + AidaUtils.modifyName(child.name()), recursive);
                    for (int j = 0; j < childNames.length; ++j) {
                        names.add(childNames[j]);
                    }
                    continue;
                }
                names.add(path + AidaUtils.modifyName(child.name()));
            }
        } else {
            names.add(path);
        }
        String[] objNames = new String[names.size()];
        for (i = 0; i < names.size(); ++i) {
            objNames[i] = (String)names.get(i);
        }
        return objNames;
    }

    public String[] listObjectTypes() throws IllegalArgumentException {
        return this.listObjectTypes(this.currentPath.getName());
    }

    public String[] listObjectTypes(String path) throws IllegalArgumentException {
        return this.listObjectTypes(path, false);
    }

    public String[] listObjectTypes(String path, boolean recursive) throws IllegalArgumentException {
        int i;
        Path p;
        IManagedObject obj;
        if (!path.endsWith(this.separatorChar)) {
            path = path + this.separatorChar;
        }
        if ((obj = this.checkAndFillFolder(p = new Path(this.currentPath, path))) == null) {
            throw new IllegalArgumentException("Wrong path " + path);
        }
        Vector<String> types = new Vector<String>();
        if (obj instanceof Folder) {
            int childNumb = ((Folder)obj).getChildCount();
            for (i = 0; i < childNumb; ++i) {
                IManagedObject child = ((Folder)obj).getChild(i);
                types.add(child.type());
                if (!(child instanceof Folder) || !recursive) continue;
                String[] childTypes = this.listObjectTypes(path + AidaUtils.modifyName(child.name()), recursive);
                for (int j = 0; j < childTypes.length; ++j) {
                    types.add(childTypes[j]);
                }
            }
        } else {
            types.add(obj.type());
        }
        String[] objTypes = new String[types.size()];
        for (i = 0; i < types.size(); ++i) {
            objTypes[i] = (String)types.get(i);
        }
        return objTypes;
    }

    public void mkdir(String path) throws IllegalArgumentException {
        IManagedObject[] mo;
        Path p = new Path(this.currentPath, path);
        Path parentPath = p.parent();
        if (path.endsWith(this.separatorChar)) {
            path = path.substring(0, path.length() - 1);
        }
        if ((mo = this.findAlreadyCreatedObjects(p))[mo.length - 1] != null) {
            throw new TreeObjectAlreadyExistException("mkdir: Directory already exists: " + path);
        }
        IManagedObject obj = mo[mo.length - 2];
        if (obj == null) {
            throw new IllegalArgumentException("Cannot create directory, no parent " + path);
        }
        if (obj instanceof Folder) {
            int imp2 = this.indexOfTopMountPoint(mo);
            if (imp2 > -1) {
                MountPoint mp = (MountPoint)mo[imp2];
                String newPath = p.toString(imp2, p.size());
                mp.getTree().mkdir(newPath);
                return;
            }
            Folder parent = (Folder)obj;
            if (parent.getChild(p.getName()) != null) {
                throw new IllegalArgumentException(p.getName() + " already exists");
            }
            Folder child = new Folder(p.getName());
            parent.add(child);
            if (this.isValid && parent.isBeingWatched()) {
                this.fireStateChanged(new TreeEvent((Object)this, 1, p.toArray(), child.getClass(), 1));
            }
        } else {
            throw new IllegalArgumentException("Cannot create directory " + path);
        }
    }

    public void mkdirs(String path) throws IllegalArgumentException {
        Path p = new Path(this.currentPath, path);
        IManagedObject[] mo = this.findAlreadyCreatedObjects(p);
        int imp2 = this.indexOfTopMountPoint(mo);
        if (imp2 > -1) {
            MountPoint mp = (MountPoint)mo[imp2];
            String newPath = p.toString(imp2, p.size());
            mp.getTree().mkdirs(newPath);
            return;
        }
        IManagedObject child = mo[mo.length - 1];
        if (child == null) {
            Folder folder = null;
            for (int i = 0; i < mo.length - 1; ++i) {
                if (!(mo[i] instanceof Folder)) {
                    throw new IllegalArgumentException("Path: " + path + " contains not Folder, i=" + i + ", name=" + mo[i].name() + ", mo=" + mo[i]);
                }
                folder = (Folder)mo[i];
                child = mo[i + 1];
                if (child != null) continue;
                child = new Folder(p.toString(i, i).substring(1));
                folder.add(child);
                mo[i + 1] = child;
                if (!this.isValid || !folder.isBeingWatched()) continue;
                this.fireStateChanged(new TreeEvent((Object)this, 1, p.toArray(), child.getClass(), 1));
            }
        } else if (!(child instanceof Folder)) {
            throw new IllegalArgumentException(path + " is not a folder");
        }
    }

    public void rmdir(String path) throws IllegalArgumentException {
        Path p = new Path(this.currentPath, path);
        IManagedObject[] mo = this.findAlreadyCreatedObjects(p);
        IManagedObject target = mo[mo.length - 1];
        if (target == null) {
            throw new IllegalArgumentException("Directory does not exist: " + path);
        }
        if (!(target instanceof Folder)) {
            throw new IllegalArgumentException(path + " is not a folder");
        }
        if (target == this.root) {
            throw new IllegalArgumentException("Cannot delete root");
        }
        Folder folder = (Folder)mo[mo.length - 2];
        int imp2 = this.indexOfTopMountPoint(mo);
        if (imp2 > -1) {
            MountPoint mp = (MountPoint)mo[imp2];
            String newPath = p.toString(imp2, p.size());
            mp.getTree().rmdir(newPath);
            return;
        }
        folder.remove(target);
        if (this.isValid && folder.isBeingWatched()) {
            this.fireStateChanged(new TreeEvent((Object)this, 2, p.toArray(), null, 1));
        }
    }

    public void rm(String path) throws IllegalArgumentException {
        Path p = new Path(this.currentPath, path);
        IManagedObject[] mo = this.findAlreadyCreatedObjects(p);
        IManagedObject target = mo[mo.length - 1];
        if (target == null) {
            throw new IllegalArgumentException("Object does not exist: " + path);
        }
        if (target instanceof Folder) {
            throw new IllegalArgumentException(path + " is a folder");
        }
        if (target == this.root) {
            throw new IllegalArgumentException("Cannot delete root");
        }
        Folder folder = (Folder)mo[mo.length - 2];
        int imp2 = this.indexOfTopMountPoint(mo);
        if (imp2 > -1) {
            MountPoint mp = (MountPoint)mo[imp2];
            String newPath = p.toString(imp2, p.size());
            mp.getTree().rm(newPath);
            return;
        }
        folder.remove(target);
        if (!(target instanceof Folder)) {
            this.unRegisterManagedObject(target);
        }
        if (this.isValid && folder.isBeingWatched()) {
            this.fireStateChanged(new TreeEvent((Object)this, 2, p.toArray(), null, 0));
        }
    }

    public String findPath(IManagedObject object) throws IllegalArgumentException {
        String path = this.getPathForObject(object);
        if (path != null) {
            return path;
        }
        throw new IllegalArgumentException("Object " + object + " could not be found in tree");
    }

    private String getPathForObject(IManagedObject object) {
        Object path = this.pathHash.get(object);
        if (path != null) {
            return ((Path)path).toString();
        }
        for (int i = 0; i < this.mountList.size(); ++i) {
            Path mountPath = new Path(this.currentPath, (String)this.mountList.get(i));
            IManagedObject[] mo = this.findAlreadyCreatedObjects(mountPath);
            MountPoint mountPoint = (MountPoint)mo[mo.length - 1];
            String obj = mountPoint.getTree().getPathForObject(object);
            if (obj == null) continue;
            return mountPath.toString() + obj;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mv(String oldPath, String newPath) throws IllegalArgumentException {
        IManagedObject objToMove;
        Folder fromFolder;
        Path fromPath = new Path(this.currentPath, oldPath);
        try {
            fromFolder = (Folder)this.findObject(fromPath.parent().toString());
            objToMove = this.findObject(fromPath.toString());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Illegal \"from\"-path " + oldPath + "; it does not correspond to an IManagedObejct.");
        }
        if (objToMove == null) {
            throw new IllegalArgumentException("Cannot move. Path " + fromPath.toString() + " corresponds to a null object.");
        }
        Path toPath = new Path(this.currentPath, newPath);
        IManagedObject destinationObject = null;
        try {
            destinationObject = this.findObject(toPath.toString());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        String newName = null;
        if (destinationObject != null) {
            if (!(destinationObject instanceof Folder)) {
                if (objToMove instanceof Folder) {
                    throw new IllegalArgumentException("Cannot move a folder on an existing IManagedObject that is not a folder.");
                }
                if (!this.overwrite) throw new IllegalArgumentException("Cannot move. An object exists in the final path and the overwrite flag is set to false.");
                newName = AidaUtils.modifyName(destinationObject.name());
                this.rm(toPath.toString());
            }
        } else {
            newName = toPath.getName();
        }
        Path destinationFolderPath = destinationObject != null && destinationObject instanceof Folder ? toPath : toPath.parent();
        fromFolder.remove(objToMove);
        if (newName != null) {
            ((IDevManagedObject)objToMove).setName(newName);
        }
        try {
            this.add(destinationFolderPath.toString(), objToMove, this.overwrite, false, false);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Illegal \"to\"-path " + newPath + ". Cannot move the object to this path.");
        }
        Folder destinationFolder = (Folder)this.findObject(destinationFolderPath.toString());
        if (!this.isValid || !fromFolder.isBeingWatched() && !destinationFolder.isBeingWatched()) return;
        this.fireStateChanged(new TreeEvent((Object)this, 7, toPath.toArray(), null, fromPath.toArray()));
    }

    public void commit() throws IOException {
        if (this.aidaStore == null) {
            if (!this.createNew || this.storeName == null || this.storeName.length() == 0) {
                throw new IOException("There is not store to commit to");
            }
            this.createStore();
        }
        if (this.aidaStore.isReadOnly()) {
            throw new IOException("Cannot commit readonly store");
        }
        if (this.createNew && !this.optionsMap.containsKey("createNew")) {
            if (this.optionsMap == Collections.EMPTY_MAP) {
                this.optionsMap = new HashMap();
            }
            this.optionsMap.put(new String("createNew"), Boolean.toString(this.createNew));
        }
        this.aidaStore.commit(this, this.optionsMap);
    }

    public void setOverwrite() {
        this.setOverwrite(true);
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void cp(String oldPath, String newPath) throws IllegalArgumentException {
        this.cp(oldPath, newPath, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cp(String oldPath, String newPath, boolean recursive) throws IllegalArgumentException {
        IManagedObject objToCopy;
        Path fromPath = new Path(this.currentPath, oldPath);
        try {
            objToCopy = this.findObject(fromPath.toString());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Illegal \"from\"-path " + oldPath + "; it does not correspond to an IManagedObejct.");
        }
        if (objToCopy == null) {
            throw new IllegalArgumentException("Cannot copy. Path " + fromPath.toString() + " corresponds to a null object.");
        }
        Path toPath = new Path(this.currentPath, newPath);
        IManagedObject destinationObject = null;
        try {
            destinationObject = this.findObject(toPath.toString());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        if (destinationObject != null) {
            if (!(destinationObject instanceof Folder)) {
                if (objToCopy instanceof Folder) {
                    throw new IllegalArgumentException("Cannot copy a folder on an existing IManagedObject that is not a folder.");
                }
                if (!this.overwrite) throw new IllegalArgumentException("Cannot copy. An object exists in the final path and the overwrite flag is set to false.");
                this.rm(toPath.toString());
            } else {
                toPath = new Path(toPath, AidaUtils.modifyName(objToCopy.name()));
            }
        }
        this.copyIManagedObject(toPath.toString(), objToCopy);
        if (!recursive || !(objToCopy instanceof Folder)) return;
        String fromPathString = fromPath.toString();
        String[] objsToCopy = this.listObjectNames(fromPathString);
        for (int i = 0; i < objsToCopy.length; ++i) {
            String objRelName = objsToCopy[i].substring(fromPathString.length() + 1);
            Path endPath = new Path(toPath, objRelName);
            this.cp(objsToCopy[i], endPath.toString(), recursive);
        }
    }

    public void symlink(String path, String alias2) throws IllegalArgumentException {
        IManagedObject objToLink;
        Path fromPath = new Path(this.currentPath, path);
        try {
            objToLink = this.findObject(fromPath.toString());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Illegal \"from\"-path " + path + "; it does not correspond to an IManagedObejct.");
        }
        if (objToLink == null) {
            throw new IllegalArgumentException("Cannot copy. Path " + fromPath.toString() + " corresponds to a null object.");
        }
        Path toPath = new Path(this.currentPath, alias2);
        IManagedObject aliasObj = null;
        Folder aliasFolder = null;
        try {
            aliasObj = this.findObject(toPath.toString());
            aliasFolder = (Folder)this.findObject(toPath.parent().toString());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        if (aliasObj != null) {
            if (!(aliasObj instanceof Folder)) {
                throw new IllegalArgumentException("There is already an object, other than a directory, in the \"alias\" location " + alias2);
            }
            toPath = new Path(toPath, fromPath.getName());
            aliasFolder = (Folder)aliasObj;
        } else if (aliasFolder == null) {
            throw new IllegalArgumentException("Illegal \"alias\" " + alias2);
        }
        this.checkForCircularLink(fromPath, toPath);
        Link link = new Link(toPath.getName(), fromPath);
        aliasFolder.add(link);
        if (this.isValid && aliasFolder.isBeingWatched()) {
            this.fireStateChanged(new TreeEvent((Object)this, 6, toPath.toArray(), objToLink.getClass(), fromPath.toArray()));
        }
    }

    private void checkForCircularLink(Path from, Path to) {
        if (from.toString().equals(to.toString())) {
            throw new IllegalArgumentException("Circular link " + from.toString() + " -> " + to.toString());
        }
        IManagedObject fromObj = null;
        try {
            fromObj = this.findObject(from.toString());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("The link chain somewhere is broken");
        }
        if (fromObj == null) {
            throw new IllegalArgumentException("The link chain somewhere is broken");
        }
        if (fromObj instanceof Link) {
            this.checkForCircularLink(((Link)fromObj).path(), to);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mount(String path, ITree tree, String treePath) throws IllegalArgumentException {
        if (!(tree instanceof Tree)) throw new UnsupportedOperationException();
        Path p = new Path(this.currentPath, path);
        IManagedObject[] mo = this.findAlreadyCreatedObjects(p);
        IManagedObject obj = mo[mo.length - 1];
        if (obj != null) {
            throw new IllegalArgumentException(path + " already exists");
        }
        IManagedObject f = mo[mo.length - 2];
        if (f == null) {
            f = this.checkAndFillFolder(p);
        }
        if (f == null) {
            throw new IllegalArgumentException("Folder does not exist: " + p.parent());
        }
        Folder parent = (Folder)f;
        Tree t = (Tree)tree;
        Path mountPath = new Path(new Path(), treePath);
        IManagedObject mountPoint = t.checkAndFillFolder(mountPath);
        if (mountPoint == null) {
            throw new IllegalArgumentException("Can not find Mount Point: " + treePath);
        }
        if (!(mountPoint instanceof Folder)) throw new IllegalArgumentException(treePath + " does not point to a folder");
        int imp2 = this.indexOfTopMountPoint(mo);
        if (imp2 > -1) {
            MountPoint mp = (MountPoint)mo[imp2];
            String newPath = p.toString(imp2, p.size());
            mp.getTree().mount(newPath, tree, treePath);
            return;
        }
        MountPoint mp = new MountPoint(this, p, t, (Folder)mountPoint, mountPath);
        mp.setFilled(((Folder)mountPoint).isFilled());
        parent.add(mp);
        t.incrementMountCount();
        this.mountList.add(p.toString());
        if (!this.isValid || !parent.isBeingWatched()) return;
        this.fireStateChanged(new TreeEvent((Object)this, 1, p.toArray(), mp.getClass(), 1));
    }

    public void unmount(String path) throws IllegalArgumentException {
        MountPoint mp;
        Path p = new Path(this.currentPath, path);
        IManagedObject[] mo = this.findAlreadyCreatedObjects(p);
        IManagedObject obj = mo[mo.length - 1];
        if (obj == null) {
            throw new IllegalArgumentException("Path does not exist: " + p.parent());
        }
        if (mo[mo.length - 2] == null) {
            throw new IllegalArgumentException("Folder does not exist: " + p.parent());
        }
        if (obj instanceof MountPoint) {
            int imp2 = this.indexOfTopMountPoint(mo);
            if (imp2 > -1 && imp2 < mo.length - 1) {
                MountPoint mp2 = (MountPoint)mo[imp2];
                String newPath = p.toString(imp2, p.size());
                mp2.getTree().unmount(newPath);
                return;
            }
            mp = (MountPoint)obj;
            Folder parent = (Folder)mo[mo.length - 2];
            parent.remove(mp);
            this.mountList.remove(p.toString());
            IManagedObject[] manObjs = this.getAllManagedObjectsInPath(p);
            for (int i = 0; i < manObjs.length; ++i) {
                if (!this.manObjHash.containsValue(manObjs[i])) continue;
                this.unRegisterManagedObject(manObjs[i]);
            }
            if (this.isValid && parent.isBeingWatched()) {
                this.fireStateChanged(new TreeEvent((Object)this, 2, p.toArray(), null, 1));
            }
        } else {
            throw new IllegalArgumentException("Not a mount point");
        }
        mp.unmount();
    }

    public void init(String storeName, String storeType, int mode, String options) throws IOException {
        this.storeName = storeName;
        this.storeType = storeType;
        this.readOnly = false;
        this.createNew = false;
        this.readOnlyUserDefined = false;
        if (mode == 1) {
            this.createNew = true;
        }
        if (mode == 2) {
            this.createNew = true;
        }
        if (mode == 3) {
            this.readOnly = true;
            this.readOnlyUserDefined = true;
        }
        if (mode == 4) {
            this.readOnly = false;
            this.readOnlyUserDefined = true;
        }
        this.init(storeName, this.readOnly, this.createNew, storeType, options, this.readOnlyUserDefined);
    }

    public void init(String storeName, boolean readOnly, boolean createNew, String storeType, String options, boolean readOnlyUserDefined) throws IOException {
        this.storeName = storeName;
        this.readOnly = readOnly;
        this.readOnlyUserDefined = readOnlyUserDefined;
        this.createNew = createNew;
        this.storeType = storeType;
        if (readOnly && createNew) {
            throw new IllegalArgumentException("readOnly and createNew not allowed");
        }
        this.optionsMap = AidaUtils.parseOptions(options);
        if (storeName != null && storeName.length() > 0 && !createNew) {
            this.createStore().read(this, this.optionsMap, readOnly, createNew);
        }
    }

    private IStore createStore() throws IOException {
        if (this.aidaStore == null) {
            if (this.storeType == null || this.storeType.length() == 0) {
                this.storeType = "xml";
            }
            Lookup.Template template = new Lookup.Template(IStoreFactory.class);
            Lookup.Result result = FreeHEPLookup.instance().lookup(template);
            Iterator i = result.allInstances().iterator();
            while (i.hasNext()) {
                IStoreFactory factory = (IStoreFactory)i.next();
                if (!factory.supportsType(this.storeType)) continue;
                this.aidaStore = factory.createStore();
                if (!this.readOnlyUserDefined && this.aidaStore.isReadOnly()) {
                    this.readOnly = true;
                }
                if (this.aidaStore.isReadOnly() && !this.isReadOnly()) {
                    throw new IllegalArgumentException("When opening a read-only file, the associated tree must be read-only. Please correct the options with which you created the tree.");
                }
                return this.aidaStore;
            }
            throw new IOException("Unknown store type: " + this.storeType);
        }
        return this.aidaStore;
    }

    public void hasBeenFilled(String path) throws IllegalArgumentException {
        Path p = new Path(this.currentPath, path);
        IManagedObject[] mo = this.findAlreadyCreatedObjects(p);
        IManagedObject obj = mo[mo.length - 1];
        if (obj == null || !(obj instanceof Folder)) {
            throw new IllegalArgumentException("Invalid path: " + p);
        }
        Folder folder = (Folder)obj;
        folder.setFilled(true);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void add(String path, IManagedObject child) {
        this.add(path, child, false, true);
    }

    public void addFromFactory(String path, IManagedObject child) {
        Path fullPath = new Path(this.currentPath, path);
        this.add(fullPath.toString(), child, true, false);
        AidaUtils.fillPath(this, child);
    }

    void add(String path, IManagedObject child, boolean overwrite, boolean createNewDirs) {
        this.add(path, child, overwrite, createNewDirs, true);
    }

    void add(String path, IManagedObject child, boolean overwrite, boolean createNewDirs, boolean sendEvent) {
        int imp2;
        Path folderPath = new Path(this.currentPath, path);
        Path objectPath = new Path(this.currentPath, path + this.separatorChar + AidaUtils.modifyName(child.name()));
        IManagedObject[] mo = this.findAlreadyCreatedObjects(objectPath);
        if (mo == null || mo.length < 1) {
            throw new IllegalArgumentException("Invalid path: +" + objectPath.toString());
        }
        IManagedObject o = mo[mo.length - 1];
        if (o != null) {
            if (overwrite) {
                this.rm(objectPath.toString());
            } else {
                return;
            }
        }
        if (mo[mo.length - 2] != null && !(mo[mo.length - 2] instanceof Folder)) {
            throw new IllegalArgumentException("Illegal path for add: " + path);
        }
        if (mo[mo.length - 2] == null) {
            if (createNewDirs) {
                this.mkdirs(path);
                mo = this.findAlreadyCreatedObjects(objectPath);
            } else {
                throw new RuntimeException("Some directories in the given path " + folderPath + " do not exist");
            }
        }
        if ((imp2 = this.indexOfTopMountPoint(mo)) > -1) {
            MountPoint mp = (MountPoint)mo[imp2];
            String newPath = folderPath.toString(imp2, folderPath.size());
            mp.getTree().add(newPath, child, overwrite, createNewDirs, sendEvent);
            return;
        }
        Folder f = (Folder)mo[mo.length - 2];
        f.add(child);
        this.registerManagedObject(child, new Path(folderPath, AidaUtils.modifyName(child.name())));
        if (sendEvent && this.isValid && f.isBeingWatched()) {
            this.fireStateChanged(new TreeEvent((Object)this, 1, folderPath.toArray(AidaUtils.modifyName(child.name())), child.getClass(), 0));
        }
    }

    protected IManagedObject[] getAllManagedObjectsInPath(Path path) {
        ArrayList list = new ArrayList();
        Enumeration e = this.manObjHash.keys();
        while (e.hasMoreElements()) {
            String fullPath = (String)e.nextElement();
            if (!fullPath.startsWith(path.toString())) continue;
            list.add(this.manObjHash.get(fullPath));
        }
        IManagedObject[] manObjs = new IManagedObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            manObjs[i] = (IManagedObject)list.get(i);
        }
        return manObjs;
    }

    protected void registerManagedObject(IManagedObject obj, Path path) {
        this.manObjHash.put(path.toString(), obj);
        this.pathHash.put(obj, path);
    }

    protected void unRegisterManagedObject(IManagedObject obj) {
        this.manObjHash.remove(this.findPath(obj));
        this.pathHash.remove(obj);
    }

    private List ls(IManagedObject obj, boolean recursive) {
        ArrayList<IManagedObject> list = new ArrayList<IManagedObject>();
        if (obj instanceof Folder) {
            int childNumb = ((Folder)obj).getChildCount();
            for (int i = 0; i < childNumb; ++i) {
                IManagedObject child = ((Folder)obj).getChild(i);
                list.add(child);
                if (!(child instanceof Folder) || !recursive) continue;
                list.addAll(this.ls((Folder)child, recursive));
            }
        } else {
            list.add(obj);
        }
        return list;
    }

    private int indexOfTopMountPoint(IManagedObject[] mo) {
        int index = -1;
        if (mo != null) {
            for (int i = 0; i < mo.length; ++i) {
                if (!(mo[i] instanceof MountPoint)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    IManagedObject[] findAlreadyCreatedObjects(String pathString) {
        Path p = new Path(this.currentPath, pathString);
        return this.findAlreadyCreatedObjects(p);
    }

    private IManagedObject[] findAlreadyCreatedObjects(Path path) {
        int size = path.size();
        IManagedObject[] mo = new IManagedObject[size + 1];
        int depth = 0;
        mo[0] = this.root;
        Folder here = this.root;
        IManagedObject obj = null;
        Iterator i = path.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            obj = here.getChild(name);
            mo[++depth] = obj instanceof Link ? this.findObject(((Link)obj).path().toString()) : obj;
            if (obj == null || !(obj instanceof Folder)) break;
            here = (Folder)obj;
        }
        return mo;
    }

    private Folder checkAndFillFolderFromStore(Path path) throws IllegalArgumentException {
        Folder folder = null;
        IManagedObject[] mo = this.findAlreadyCreatedObjects(path);
        if (mo == null || mo.length == 0) {
            throw new IllegalArgumentException("Invalid path: +" + path.toString());
        }
        IManagedObject obj = mo[mo.length - 1];
        if (obj != null && !(obj instanceof Folder)) {
            throw new IllegalArgumentException("Path does not point to a directory: " + path.toString());
        }
        if (obj != null && (folder = (Folder)obj).isFilled()) {
            return folder;
        }
        MountPoint mp = null;
        String currentPath = path.toString();
        int depth = 0;
        int mountDepth = 0;
        for (depth = 0; depth < mo.length && mo[depth] != null; ++depth) {
            if (!(mo[depth] instanceof MountPoint)) continue;
            mp = (MountPoint)mo[depth];
            mountDepth = depth;
        }
        Tree currentTree = this;
        if (mp != null) {
            currentTree = mp.getTree();
            currentPath = path.toString(mountDepth, path.size());
        }
        try {
            IStore currentStore = currentTree.getStore();
            if (currentStore == null) {
                return folder;
            }
            if (currentStore instanceof IOnDemandStore) {
                ((IOnDemandStore)currentStore).read(currentTree, currentPath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Something is wrong with reading from the Store", e);
        }
        if (folder != null) {
            return folder;
        }
        mo = this.findAlreadyCreatedObjects(path);
        if (mo == null || mo.length == 0) {
            throw new IllegalArgumentException("Invalid path: +" + path.toString());
        }
        obj = mo[mo.length - 1];
        if (obj != null && !(obj instanceof Folder)) {
            throw new IllegalArgumentException("Path does not point to a directory: +" + path.toString());
        }
        if (obj != null) {
            folder = (Folder)obj;
        }
        return folder;
    }

    private IManagedObject checkAndFillFolder(Path path) throws IllegalArgumentException {
        IManagedObject[] mo = this.findAlreadyCreatedObjects(path);
        if (mo == null || mo.length == 0) {
            throw new IllegalArgumentException("Invalid path: +" + path.toString());
        }
        IManagedObject obj = mo[mo.length - 1];
        if (obj != null && !(obj instanceof Folder)) {
            return obj;
        }
        Folder f = this.checkAndFillFolderFromStore(path);
        return f;
    }

    public void fireConnectionEvent(String pathString, boolean connect) {
        boolean isFolder = true;
        IManagedObject[] mo = this.findAlreadyCreatedObjects(pathString);
        IManagedObject obj = mo[mo.length - 1];
        if (obj == null) {
            return;
        }
        if (obj instanceof Folder) {
            this.fireConnectionEvent((Folder)obj, connect);
        } else if (obj instanceof Connectable) {
            isFolder = false;
            ((Connectable)((Object)obj)).setConnected(connect);
        }
        String[] path = AidaUtils.stringToArray(pathString);
        int id = connect ? 11 : 12;
        int flags = isFolder ? 1 : 0;
        Class<?> clazz = obj.getClass();
        TreeEvent te = new TreeEvent((Object)this, id, path, clazz, flags);
        this.fireStateChanged(te);
    }

    void fireConnectionEvent(Folder folder, boolean connect) {
        if (folder instanceof Connectable) {
            folder.setConnected(connect);
        }
        int size = folder.getChildCount();
        for (int i = 0; i < size; ++i) {
            IManagedObject mo = folder.getChild(i);
            if (mo instanceof Folder) {
                this.fireConnectionEvent((Folder)mo, connect);
                continue;
            }
            if (!(mo instanceof Connectable)) continue;
            ((Connectable)((Object)mo)).setConnected(connect);
        }
    }

    void fireStateChanged(TreeEvent te) {
        super.fireStateChanged(te);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForChildren(String path) {
        Path p = new Path(this.currentPath, path);
        IManagedObject obj = this.checkAndFillFolder(p);
        if (obj instanceof Folder) {
            Folder folder;
            Folder folder2 = folder = (Folder)obj;
            synchronized (folder2) {
                for (int i = 0; i < folder.getChildCount(); ++i) {
                    IManagedObject child = folder.getChild(i);
                    int mask = child instanceof Folder ? 1 : 0;
                    TreeEvent te = new TreeEvent((Object)this, 1, p.toArray(AidaUtils.modifyName(child.name())), child.getClass(), mask);
                    this.fireStateChanged(te);
                }
                folder.setIsBeingWatched(true);
            }
        }
    }

    public void setFolderIsWatched(String path, boolean state) {
        Path p = new Path(this.currentPath, path);
        IManagedObject obj = this.checkAndFillFolder(p);
        if (obj instanceof Folder) {
            Folder folder = (Folder)obj;
            folder.setIsBeingWatched(state);
        }
    }

    public Map getOptions() {
        return this.optionsMap;
    }

    private int getMountCount() {
        return this.mountCount;
    }

    private int incrementMountCount() {
        ++this.mountCount;
        return this.mountCount;
    }

    protected int decrementMountCount() {
        --this.mountCount;
        return this.mountCount;
    }

    private void copyIManagedObject(String path, IManagedObject obj) {
        if (obj instanceof IHistogram1D) {
            this.analysisFactory.createHistogramFactory(this).createCopy(path, (IHistogram1D)((Object)obj));
        } else if (obj instanceof IHistogram2D) {
            this.analysisFactory.createHistogramFactory(this).createCopy(path, (IHistogram2D)((Object)obj));
        } else if (obj instanceof IHistogram3D) {
            this.analysisFactory.createHistogramFactory(this).createCopy(path, (IHistogram3D)((Object)obj));
        } else if (obj instanceof ICloud1D) {
            this.analysisFactory.createHistogramFactory(this).createCopy(path, (ICloud1D)((Object)obj));
        } else if (obj instanceof ICloud2D) {
            this.analysisFactory.createHistogramFactory(this).createCopy(path, (ICloud2D)((Object)obj));
        } else if (obj instanceof ICloud3D) {
            this.analysisFactory.createHistogramFactory(this).createCopy(path, (ICloud3D)((Object)obj));
        } else if (obj instanceof IProfile1D) {
            this.analysisFactory.createHistogramFactory(this).createCopy(path, (IProfile1D)((Object)obj));
        } else if (obj instanceof IProfile2D) {
            this.analysisFactory.createHistogramFactory(this).createCopy(path, (IProfile2D)((Object)obj));
        } else if (obj instanceof IDataPointSet) {
            this.analysisFactory.createDataPointSetFactory(this).createCopy(path, (IDataPointSet)((Object)obj));
        } else if (obj instanceof IFunction) {
            this.analysisFactory.createFunctionFactory(this).cloneFunction(path, (IFunction)((Object)obj));
        } else if (obj instanceof ITuple) {
            this.analysisFactory.createTupleFactory(this).createFiltered(path, (ITuple)((Object)obj), null);
        } else if (obj instanceof Folder) {
            this.mkdirs(path);
        } else if (obj instanceof Link) {
            Path newPath = new Path(this.currentPath, path);
            Link link = new Link(newPath.getName(), ((Link)obj).path());
            this.add(newPath.parent().toString(), link, true, false);
        } else {
            throw new IllegalArgumentException("Cannot copy IManagedObject " + obj);
        }
    }
}

