/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.test.jaida;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import java.util.Random;
import junit.framework.TestCase;

public class AbstractTestFitting
extends TestCase {
    private IAnalysisFactory af;
    private ITree tree;
    private IHistogram1D hist;
    private String fitter;

    public AbstractTestFitting(String name, String fitter) {
        super(name);
        this.fitter = fitter;
    }

    public void testScriptedFunction() {
        IFunctionFactory functionfact = this.af.createFunctionFactory(this.tree);
        IFunction f = functionfact.createFunctionFromScript("gauss", 1, "b*lambda*exp(-x[0]*lambda)+a*exp(-(x[0]-mean)*(x[0]-mean)/sigma/sigma)", "b,lambda,a,mean,sigma", "Gaussian+Exponential");
        AbstractTestFitting.assertEquals(1, f.dimension());
        AbstractTestFitting.assertEquals(5, f.parameters().length);
        f.setParameter("b", 1800.0);
        f.setParameter("lambda", 0.3);
        f.setParameter("a", 70.0);
        f.setParameter("mean", 10.0);
        f.setParameter("sigma", 1.5);
        this.testFunction(this.fitter, f);
    }

    public void testBuiltinFunction() {
        IFunctionFactory functionfact = this.af.createFunctionFactory(this.tree);
        IFunction f = functionfact.createFunctionByName("e+g", "e+g");
        AbstractTestFitting.assertEquals(1, f.dimension());
        AbstractTestFitting.assertEquals(5, f.parameters().length);
        f.setParameter("amplitude", 600.0);
        f.setParameter("exponent", -0.3);
        f.setParameter("amplitude_1", 80.0);
        f.setParameter("mean", 10.0);
        f.setParameter("sigma", 1.0);
        this.testFunction(this.fitter, f);
    }

    private void testFunction(String fitter, IFunction f) {
        IFitFactory ff = this.af.createFitFactory();
        IFitter minuit = ff.createFitter("Chi2", fitter);
        IFitResult result = minuit.fit((IBaseHistogram)this.hist, f);
        AbstractTestFitting.assertTrue(result.isValid());
        AbstractTestFitting.assertEquals(5, result.fittedParameterNames().length);
        int status = result.fitStatus();
        AbstractTestFitting.assertTrue(status > 0 && status < 6);
        AbstractTestFitting.assertTrue(result.quality() < 1.5);
    }

    protected void setUp() throws Exception {
        int i;
        this.af = IAnalysisFactory.create();
        this.tree = this.af.createTreeFactory().create();
        IHistogramFactory hf = this.af.createHistogramFactory(this.tree);
        Random r = new Random();
        this.hist = hf.createHistogram1D("hist", 100, 0.0, 20.0);
        for (i = 0; i < 10000; ++i) {
            this.hist.fill(-Math.log(r.nextDouble()) / 0.3);
        }
        for (i = 0; i < 1000; ++i) {
            this.hist.fill(r.nextGaussian() + 10.0);
        }
    }
}

