/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.ref.remote.interfaces.AidaUpdatable;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteUpdatableQueue
extends Thread {
    private List updatables = new ArrayList(100);
    private List events = new ArrayList(100);
    private boolean keepRunning = true;
    private Logger remoteLogger = Logger.getLogger("hep.aida.ref.remote");

    public RemoteUpdatableQueue() {
        this.remoteLogger.fine("UpdatableQueue: START");
        this.start();
    }

    public synchronized void close() {
        this.keepRunning = false;
        this.updatables.clear();
        this.events.clear();
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Object source, AidaUpdateEvent event) {
        if (!this.keepRunning) {
            return;
        }
        this.remoteLogger.finest("RemoteUpdatableQueue.schedule: id=" + event.id() + ",  nodeType=" + event.nodeType() + ",  path=" + event.path());
        RemoteUpdatableQueue remoteUpdatableQueue = this;
        synchronized (remoteUpdatableQueue) {
            this.updatables.add(source);
            this.events.add(event);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Object source, AidaUpdateEvent[] evts) {
        if (!this.keepRunning) {
            return;
        }
        RemoteUpdatableQueue remoteUpdatableQueue = this;
        synchronized (remoteUpdatableQueue) {
            if (evts == null || evts.length == 0) {
                return;
            }
            for (int i = 0; i < evts.length; ++i) {
                AidaUpdateEvent event = evts[i];
                this.remoteLogger.finest("RemoteUpdatableQueue.schedule: id=" + event.id() + ",  nodeType=" + event.nodeType() + ",  path=" + event.path());
                this.updatables.add(source);
                this.events.add(event);
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.keepRunning) {
            Object obj = null;
            AidaUpdatable source = null;
            AidaUpdateEvent event = null;
            int size = 0;
            try {
                RemoteUpdatableQueue remoteUpdatableQueue = this;
                synchronized (remoteUpdatableQueue) {
                    if (this.updatables.size() == 0) {
                        this.wait();
                    }
                    if ((size = this.updatables.size()) > 0) {
                        obj = this.updatables.remove(0);
                        event = (AidaUpdateEvent)this.events.remove(0);
                    }
                }
                this.remoteLogger.finest("RemoteUpdatableQueue.run *** Start for event: " + event + ", object: " + obj);
                if (event == null) {
                    this.remoteLogger.fine("RemoteUpdatableQueue.run event=null for object: " + obj);
                    continue;
                }
                if (obj == null) {
                    this.remoteLogger.fine("RemoteUpdatableQueue.run object=null for event: id=" + event.id() + ",  nodeType=" + event.nodeType() + ",  path=" + event.path());
                    continue;
                }
                if (obj instanceof AidaUpdatable) {
                    source = obj;
                    source.stateChanged(event);
                    this.remoteLogger.finest("RemoteUpdatableQueue.run *** Finished for event: id=" + event.id() + ",  nodeType=" + event.nodeType() + ",  path=" + event.path() + ", object: " + obj);
                    continue;
                }
                this.remoteLogger.fine("RemoteUpdatableQueue.run object is not AidaUpdatable: " + obj);
            }
            catch (InterruptedException e2) {
                this.remoteLogger.log(Level.INFO, "RemoteUpdatableQueue InterruptedException: \n\t" + e2.getMessage());
                this.remoteLogger.log(Level.FINE, "", e2.getStackTrace());
            }
            catch (Exception e3) {
                this.remoteLogger.log(Level.INFO, "Exception in RemoteUpdatableQueue: \n\t" + e3.getMessage());
                this.remoteLogger.log(Level.FINE, "", e3.getStackTrace());
            }
        }
    }
}

