/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IManagedObject;
import hep.aida.dev.IDevMutableStore;
import hep.aida.dev.IDevTree;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.Annotation;
import hep.aida.ref.remote.RemoteClient;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.RemoteTree;
import hep.aida.ref.remote.RemoteUnavailableObject;
import hep.aida.ref.remote.RemoteUpdateEvent;
import hep.aida.ref.remote.interfaces.AidaUpdatable;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import hep.aida.ref.tree.Tree;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RemoteMutableStore
implements AidaUpdatable,
IDevMutableStore {
    protected IDevTree tree;
    protected RemoteClient client;
    protected boolean initDone;
    protected boolean recursive;
    protected RemoteUpdateEvent[] events;
    protected Logger remoteLogger;
    protected boolean acceptEvents = true;
    protected boolean hurry;

    public RemoteMutableStore() {
        this(false);
    }

    public RemoteMutableStore(boolean hurry) {
        this(null, null, hurry);
    }

    public RemoteMutableStore(IDevTree tree) {
        this(tree, null, false);
    }

    public RemoteMutableStore(IDevTree tree, boolean hurry) {
        this(tree, null, hurry);
    }

    private RemoteMutableStore(IDevTree tree, RemoteClient client, boolean hurry) {
        this.tree = tree;
        this.client = client;
        this.hurry = hurry;
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        this.init();
    }

    TreeEntry getEntries(IDevTree t, String path, boolean rec, boolean check) throws IOException {
        TreeEntry entries = new TreeEntry();
        boolean wrong = true;
        String[] names = t.listObjectNames(path, rec);
        String[] types = t.listObjectTypes(path, rec);
        while (check && wrong) {
            int l1 = names.length;
            int l2 = types.length;
            this.remoteLogger.fine("RemoteMutableStore.getEntries Tree l1=" + l1 + ", l2=" + l2 + ", recursive=" + rec + ", path=" + path);
            boolean bl = wrong = l1 != l2;
            if (wrong) {
                try {
                    Thread.sleep(200L);
                    names = t.listObjectNames(path, rec);
                    types = t.listObjectTypes(path, rec);
                }
                catch (Exception ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.getEntries: \n\t" + ex.getMessage());
                    this.remoteLogger.log(Level.FINE, "", ex);
                }
                continue;
            }
            entries.entryNames = names;
            entries.entryTypes = types;
        }
        return entries;
    }

    TreeEntry getEntries(RemoteClient t, String path, boolean rec, boolean check) throws IOException {
        TreeEntry entries = new TreeEntry();
        boolean wrong = true;
        String[] names = t.listObjectNames(path, rec);
        String[] types = t.listObjectTypes(path, rec);
        while (check && wrong) {
            int l1 = names.length;
            int l2 = types.length;
            this.remoteLogger.fine("RemoteMutableStore.getEntries Client l1=" + l1 + ", l2=" + l2 + ", recursive=" + rec + ", path=" + path);
            boolean bl = wrong = l1 != l2;
            if (wrong) {
                try {
                    Thread.sleep(400L);
                    names = t.listObjectNames(path, rec);
                    types = t.listObjectTypes(path, rec);
                }
                catch (Exception ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.getEntries: \n\t" + ex.getMessage());
                    this.remoteLogger.log(Level.FINE, "", ex);
                }
                continue;
            }
            entries.entryNames = names;
            entries.entryTypes = types;
        }
        return entries;
    }

    void setRecursive(boolean b) {
        this.recursive = b;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void init() {
        this.recursive = true;
        this.events = new RemoteUpdateEvent[1];
        this.initDone = false;
        this.acceptEvents = true;
    }

    public void setHurry(boolean hurry) {
        this.hurry = hurry;
        this.remoteLogger.fine("RemoteMutableStore.setHurry  to " + hurry);
    }

    public void handleDataUpdate(IManagedObject mo, String path, String type) throws IllegalArgumentException {
        this.handleDataUpdate(mo, path, type, this.hurry);
    }

    public void handleDataUpdate(IManagedObject mo, String path, String type, boolean hurryUp) throws IllegalArgumentException {
        if (hurryUp) {
            RemoteUpdateEvent evt = new RemoteUpdateEvent(10, path, type);
            AidaUpdateEvent[] eventArray = new RemoteUpdateEvent[]{evt};
            if (this.client != null) {
                this.client.stateChanged(eventArray);
                if (mo instanceof RemoteManagedObject) {
                    ((RemoteManagedObject)mo).setDataValid(true);
                }
            } else {
                this.updateData(path, type);
            }
        } else {
            this.updateData(path, type);
        }
    }

    protected abstract RemoteClient createClient(Map var1);

    public abstract void updateData(String var1, String var2) throws IllegalArgumentException;

    public abstract IManagedObject createObject(String var1, String var2) throws IllegalArgumentException;

    public void close() throws IOException {
        this.acceptEvents = false;
        if (this.tree instanceof Tree) {
            ((Tree)this.tree).fireConnectionEvent("/", false);
        }
        if (this.client != null) {
            this.client.disconnect();
        }
        this.client = null;
        this.tree = null;
        this.events = null;
    }

    public void commit(IDevTree tree, Map options) throws IOException {
        throw new UnsupportedOperationException("Can not commit changes to the Read-Only Store");
    }

    public boolean isReadOnly() {
        return true;
    }

    public void reloadFolder(String path) throws IllegalArgumentException, IOException {
        this.reloadFolder(path, this.isRecursive());
    }

    public void reloadFolder(String path, boolean localRec) throws IllegalArgumentException, IOException {
        this.remoteLogger.fine("RemoteMutableStore.reloadFolder: path=" + path + ", recursive=" + localRec);
        if (!this.client.isConnected()) {
            throw new IOException("Can not read from the Store: client is not connected!");
        }
        long t0 = System.currentTimeMillis();
        TreeEntry entries = this.getEntries(this.client, path, localRec, true);
        String[] names = entries.entryNames;
        String[] types = entries.entryTypes;
        long t1 = System.currentTimeMillis();
        IDevTree localTree = this.tree;
        TreeEntry localEntries = this.getEntries(localTree, path, localRec, true);
        String[] oldNames = localEntries.entryNames;
        String[] oldTypes = localEntries.entryTypes;
        long t2 = System.currentTimeMillis();
        if (names != null && types != null) {
            int id;
            for (int i = 0; i < names.length; ++i) {
                String typeString;
                id = 11;
                String pathString = names[i];
                String type = typeString = types[i];
                String xType = "double";
                int indexT = typeString.lastIndexOf(":");
                if (indexT > 0) {
                    type = typeString.substring(0, indexT);
                    String tmpType = typeString.substring(indexT + 1);
                    if (tmpType != null && !tmpType.equals("")) {
                        xType = tmpType;
                    }
                }
                try {
                    int index = AidaUtils.findInArray(names[i], oldNames);
                    if (index < 0) {
                        id = 11;
                    } else if (type.equals(oldTypes[index]) || typeString.equals(oldTypes[index])) {
                        oldNames[index] = null;
                        oldTypes[index] = null;
                        id = 0;
                        if (type.equalsIgnoreCase("dir") || type.equalsIgnoreCase("mnt")) {
                            continue;
                        }
                    } else {
                        oldNames[index] = null;
                        oldTypes[index] = null;
                        id = 2;
                        this.executeStateChanged(id, pathString, type, xType);
                        id = 11;
                    }
                    this.executeStateChanged(id, pathString, type, xType);
                    if (!localRec || !type.equalsIgnoreCase("dir") && !type.equalsIgnoreCase("mnt")) continue;
                    this.tree.hasBeenFilled(pathString);
                    continue;
                }
                catch (Exception e) {
                    this.remoteLogger.log(Level.FINE, "Exception in RemoteMutableStore.reloadFolder: " + path + "\n\t" + e.getMessage());
                    this.remoteLogger.log(Level.FINEST, "Exception in RemoteMutableStore.reloadFolder: " + path, e);
                }
            }
            String xType = "double";
            id = 2;
            for (int i = 0; i < oldNames.length; ++i) {
                if (oldNames[i] == null) continue;
                try {
                    this.executeStateChanged(id, oldNames[i], oldTypes[i], xType);
                    continue;
                }
                catch (Exception e) {
                    this.remoteLogger.log(Level.FINE, "Exception in RemoteMutableStore.reloadFolder: " + path + "\n\t" + e.getMessage());
                    this.remoteLogger.log(Level.FINEST, "Exception in RemoteMutableStore.reloadFolder: " + path, e);
                }
            }
        }
        long t3 = System.currentTimeMillis();
        long dt1 = t1 - t0;
        long dt2 = t2 - t1;
        long dt3 = t3 - t0;
        this.remoteLogger.fine("RemoteMutableStore.reloadFolder: Client time: " + dt1 + ", Tree time: " + dt2 + ", Total: " + dt3 + ", path=" + path + ", recursive=" + localRec);
    }

    public void read(IDevTree tree, String path) throws IllegalArgumentException, IOException {
        if (this.tree == null) {
            this.tree = tree;
        }
        if (!this.client.isConnected()) {
            throw new IOException("Can not read from the Store: client is not connected!");
        }
        this.remoteLogger.fine("RemoteMutableStore.read: path=" + path + ", recursive=" + this.isRecursive());
        String[] names = null;
        String[] types = null;
        TreeEntry entries = this.getEntries(this.client, path, this.isRecursive(), true);
        names = entries.entryNames;
        types = entries.entryTypes;
        if (names != null && types != null) {
            String pathString = "";
            for (int i = 0; i < names.length; ++i) {
                try {
                    String typeString;
                    int id = 11;
                    pathString = names[i];
                    String type = typeString = types[i];
                    String xType = "double";
                    int indexT = typeString.lastIndexOf(":");
                    if (indexT > 0) {
                        type = typeString.substring(0, indexT);
                        String tmpType = typeString.substring(indexT + 1);
                        if (tmpType != null && !tmpType.equals("")) {
                            xType = tmpType;
                        }
                    }
                    this.executeStateChanged(id, pathString, type, xType);
                    if (!this.isRecursive() || !type.equalsIgnoreCase("dir") && !type.equalsIgnoreCase("mnt")) continue;
                    tree.hasBeenFilled(pathString);
                    continue;
                }
                catch (Exception e) {
                    this.remoteLogger.log(Level.FINE, "Exception in RemoteMutableStore.read: " + pathString + "\n\t" + e.getMessage());
                    this.remoteLogger.log(Level.FINEST, "Exception in RemoteMutableStore.read: " + pathString, e);
                }
            }
            tree.hasBeenFilled(path);
        }
    }

    public void read(IDevTree tree, Map options, boolean readOnly, boolean createNew) throws IOException {
        if (this.tree == null) {
            this.tree = tree;
        }
        if (this.client == null) {
            this.client = this.createClient(options);
        }
        if (!this.client.isConnected()) {
            this.client.connect();
        }
        boolean rec = options.containsKey("recursive");
        this.setRecursive(rec);
        this.initDone = false;
        this.remoteLogger.fine("RemoteMutableStore.read: initial read for the top directory, recursive=" + this.isRecursive());
        this.read(tree, "/");
        this.initDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(AidaUpdateEvent event) {
        if (!this.acceptEvents) {
            return;
        }
        Object lock = this.tree.getLock();
        this.remoteLogger.finest("RemoteMutableStore.stateChanged for EVENT:: id=" + event.id() + ", path=" + event.path() + ",  type=" + event.nodeType());
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                this.executeStateChanged(event);
            }
        } else {
            this.executeStateChanged(event);
        }
    }

    protected void executeStateChanged(AidaUpdateEvent event) {
        String tmp;
        String typeString;
        int id = event.id();
        String path = event.path();
        String type = typeString = event.nodeType();
        String xType = "double";
        int indexT = typeString.lastIndexOf(":");
        if (indexT > 0) {
            type = typeString.substring(0, indexT);
            String tmpType = typeString.substring(indexT + 1);
            if (tmpType != null && !tmpType.equals("")) {
                xType = tmpType;
            }
        } else if (event instanceof RemoteUpdateEvent && (tmp = ((RemoteUpdateEvent)event).getXAxisType()) != null && !tmp.equals("")) {
            xType = tmp;
        }
        this.executeStateChanged(id, path, type, xType);
        this.remoteLogger.finest("RemoteMutableStore.executeStateChanged for EVENT:: id=" + id + ", path=" + path + ",  type=" + type + ", xAxisType=" + xType);
        if (this.tree instanceof RemoteTree && id != 0) {
            ((RemoteTree)this.tree).submitEventToListeners(event);
        }
    }

    protected void executeStateChanged(int id, String path, String type, String xType) {
        block83: {
            Object lock = this.tree.getLock();
            this.remoteLogger.finest("RemoteMutableStore.executeStateChanged:: id=" + id + ", path=" + path + ",  type=" + type + ", xAxisType=" + xType + ",  acceptEvents=" + this.acceptEvents + ",  lock=" + lock);
            if (!this.acceptEvents) {
                return;
            }
            if (id == 1 || id == 11) {
                try {
                    if (type.equalsIgnoreCase("dir") || type.equalsIgnoreCase("mnt")) {
                        if (this.tree instanceof RemoteTree) {
                            ((RemoteTree)this.tree).addFolder(path);
                        } else {
                            this.tree.mkdirs(path);
                        }
                        try {
                            if (id != 11 && this.isRecursive()) {
                                this.read(this.tree, path);
                            }
                            break block83;
                        }
                        catch (Exception e) {
                            this.remoteLogger.log(Level.INFO, "RemoteMutableStore.executeStateChanged: Exception while adding node: " + type + ", " + path + ", Skip this.\n\t", e.getMessage());
                            this.remoteLogger.log(Level.FINEST, "RemoteMutableStore.executeStateChanged: Exception while adding node: " + type + ", " + path + ", Skip this.", e.getStackTrace());
                        }
                        break block83;
                    }
                    if (path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    if (path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    String name = AidaUtils.parseName(path);
                    String objDir = AidaUtils.parseDirName(path);
                    IManagedObject h = null;
                    if (this.tree instanceof RemoteTree) {
                        ((RemoteTree)this.tree).addFolder(objDir);
                    } else {
                        this.tree.mkdirs(objDir);
                    }
                    h = type.equals("RemoteUnavailableObject") ? new RemoteUnavailableObject(name) : this.createObject(name, type);
                    if (h instanceof RemoteManagedObject) {
                        RemoteManagedObject r = h;
                        r.setFillable(true);
                        if (h instanceof IBaseHistogram) {
                            Annotation a = (Annotation)((IBaseHistogram)((Object)h)).annotation();
                            a.setFillable(true);
                            try {
                                a.setValue("xAxisType", xType);
                            }
                            catch (IllegalArgumentException e) {
                                a.addItem("xAxisType", xType);
                            }
                            a.setFillable(false);
                        } else if (h instanceof IDataPointSet) {
                            Annotation a = (Annotation)((IDataPointSet)((Object)h)).annotation();
                            a.setFillable(true);
                            try {
                                a.setValue("xAxisType", xType);
                            }
                            catch (IllegalArgumentException e) {
                                a.addItem("xAxisType", xType);
                            }
                            a.setFillable(false);
                        }
                        r.setFillable(false);
                    }
                    if (this.tree instanceof RemoteTree) {
                        ((RemoteTree)this.tree).addObject(objDir, h);
                    } else {
                        this.tree.add(objDir, h);
                    }
                    if (h instanceof RemoteManagedObject) {
                        ((RemoteManagedObject)h).setTreeFolder(objDir);
                        if (h instanceof RemoteUnavailableObject) {
                            ((RemoteManagedObject)h).setDataValid(true);
                        } else {
                            ((RemoteManagedObject)h).setDataValid(false);
                        }
                        break block83;
                    }
                    this.handleDataUpdate(h, path, type);
                }
                catch (IllegalArgumentException ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.executeStateChanged: IllegalArgumentException while ADDING node: " + type + ", " + path + ", Skip this: \n\t" + ex.getMessage());
                    this.remoteLogger.log(Level.FINE, "", ex);
                }
            } else if (id == 5) {
                if (type.equalsIgnoreCase("dir")) {
                    this.tree.hasBeenFilled(path);
                }
            } else if (id == 2) {
                try {
                    if (type.equalsIgnoreCase("dir")) {
                        if (this.tree instanceof RemoteTree) {
                            ((RemoteTree)this.tree).removeFolder(path);
                        } else {
                            this.tree.rmdir(path);
                        }
                        break block83;
                    }
                    if (this.tree instanceof RemoteTree) {
                        ((RemoteTree)this.tree).removeObject(path);
                        break block83;
                    }
                    this.tree.rm(path);
                }
                catch (IllegalArgumentException ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.executeStateChanged: IllegalArgumentException while DELETING node: " + type + ", " + path + ", Skip this.\n\t", ex.getMessage());
                    this.remoteLogger.log(Level.FINE, "", ex);
                }
            } else if (id == 0) {
                try {
                    IManagedObject h = null;
                    h = this.tree instanceof RemoteTree ? ((RemoteTree)this.tree).executeFind(path) : this.tree.find(path);
                    if (h instanceof RemoteManagedObject) {
                        ((RemoteManagedObject)h).setDataValid(false);
                        break block83;
                    }
                    this.handleDataUpdate(h, path, type);
                }
                catch (IllegalArgumentException ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.executeStateChanged: IllegalArgumentException while UPDATING node: " + type + ", " + path + ", Skip this.\n\t", ex.getMessage());
                    this.remoteLogger.log(Level.FINE, "", ex);
                }
            } else if (id == 10) {
                this.updateData(path, type);
            } else if (id == 3) {
                this.remoteLogger.info("***** Got TREE_CLOSED event from Remote AIDA Server.");
                this.remoteLogger.info("***** Connection to the Remote AIDA Server is Lost");
                this.acceptEvents = false;
                try {
                    this.close();
                }
                catch (Exception ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.executeStateChanged: Exception while closing tree", ex);
                    this.remoteLogger.log(Level.FINE, "", ex);
                }
            } else if (id == 20) {
                this.remoteLogger.finest("RemoteMutableStore.executeStateChanged:: id=" + id + ", path=" + path + ",  type=" + type + ", xAxisType=" + xType + ",  lock=" + lock + ", Tree=" + this.tree.storeName());
                try {
                    if (this.tree instanceof RemoteTree) {
                        if (type.equalsIgnoreCase("dir")) {
                            ((RemoteTree)this.tree).removeFolder(path);
                        } else {
                            ((RemoteTree)this.tree).removeObject(path);
                        }
                    } else if (this.tree instanceof Tree) {
                        ((Tree)this.tree).fireConnectionEvent(path, false);
                    }
                }
                catch (IllegalArgumentException ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.executeStateChanged: IllegalArgumentException while NODE_TEMPORARY_UNAVAILABLE operation: " + type + ", " + path + ", Skip this.\n\t", ex.getMessage());
                    this.remoteLogger.log(Level.FINE, "", ex);
                }
                if (this.tree instanceof RemoteTree) {
                    String name = AidaUtils.parseName(path);
                    String objDir = AidaUtils.parseDirName(path);
                    RemoteUnavailableObject h = new RemoteUnavailableObject(name);
                    ((RemoteTree)this.tree).addObject(objDir, h);
                    h.setTreeFolder(objDir);
                    h.setDataValid(true);
                    this.reloadWebPage();
                }
            } else if (id == 21) {
                this.remoteLogger.finest("RemoteMutableStore.executeStateChanged:: id=" + id + ", path=" + path + ",  type=" + type + ", xAxisType=" + xType + ",  lock=" + lock + ", Tree=" + this.tree.storeName());
                try {
                    IManagedObject obj = null;
                    if (this.tree instanceof RemoteTree) {
                        obj = ((RemoteTree)this.tree).executeFind(path);
                        if (obj != null) {
                            ((RemoteTree)this.tree).removeObject(path);
                        }
                    } else if (this.tree instanceof Tree && (obj = ((Tree)this.tree).findObject(path)).type().equalsIgnoreCase("RemoteUnavailableObject")) {
                        this.tree.rm(path);
                    }
                }
                catch (IllegalArgumentException ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.executeStateChanged: IllegalArgumentException while NODE_IS_AVAILABLE_AGAIN operation: " + type + ", " + path + ",  Skip this.\n\t", ex.getMessage());
                    this.remoteLogger.log(Level.FINE, "", ex);
                }
                try {
                    RemoteUpdateEvent evt;
                    if (this.tree instanceof RemoteTree) {
                        if (type.equalsIgnoreCase("dir")) {
                            ((RemoteTree)this.tree).addFolder(path);
                            if (this.isRecursive()) {
                                try {
                                    this.read(this.tree, path);
                                }
                                catch (Exception ioe) {
                                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.executeStateChanged: Exception while updating PATH: " + type + ", " + path, ioe);
                                    this.remoteLogger.log(Level.FINE, "", ioe.getStackTrace());
                                }
                            }
                        } else {
                            evt = new RemoteUpdateEvent(1, path, type);
                            AidaUpdateEvent[] eventArray = new RemoteUpdateEvent[]{evt};
                            if (this.client != null) {
                                this.client.stateChanged(eventArray);
                            }
                        }
                        break block83;
                    }
                    if (!(this.tree instanceof Tree)) break block83;
                    if (type.equalsIgnoreCase("dir")) {
                        this.tree.mkdirs(path);
                        this.reloadFolder(path);
                        ((Tree)this.tree).fireConnectionEvent(path, true);
                        break block83;
                    }
                    evt = new RemoteUpdateEvent(1, path, type);
                    AidaUpdateEvent[] eventArray = new RemoteUpdateEvent[]{evt};
                    if (this.client != null) {
                        this.client.stateChanged(eventArray);
                    }
                    ((Tree)this.tree).fireConnectionEvent(path, true);
                }
                catch (Exception e) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.executeStateChanged: IllegalArgumentException while NODE_IS_AVAILABLE_AGAIN operation: " + type + ", " + path + ", Skip this.\n\t", e.getMessage());
                    this.remoteLogger.log(Level.FINE, "", e);
                }
            } else if (id == 101) {
                this.remoteLogger.info("***** Got REMOTE_CONNECTION_EXCEPTION event from Remote AIDA Server.");
                this.remoteLogger.info("***** Connection to the Remote AIDA Server is Lost");
                this.acceptEvents = false;
                try {
                    this.close();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            } else {
                this.remoteLogger.log(Level.INFO, "RemoteMutableStore.executeStateChanged: Wrong ID=" + id + ", path=" + path + ",  type=" + type);
            }
        }
    }

    protected void reloadWebPage() {
    }

    public class ReadThread
    extends Thread {
        private String readPath;
        private long wait;

        public ReadThread(String readPath) {
            this(readPath, 0L);
        }

        public ReadThread(String readPath, long wait) {
            this.readPath = readPath;
            this.wait = wait;
        }

        public void run() {
            try {
                if (this.wait > 0L) {
                    Thread.sleep(this.wait);
                }
                RemoteMutableStore.this.read(RemoteMutableStore.this.tree, this.readPath);
            }
            catch (InterruptedException e2) {
                RemoteMutableStore.this.remoteLogger.log(Level.INFO, "RemoteMutableStore InterruptedException: " + e2);
                RemoteMutableStore.this.remoteLogger.log(Level.FINE, "RemoteMutableStore InterruptedException: ", e2);
            }
            catch (Exception e3) {
                RemoteMutableStore.this.remoteLogger.log(Level.INFO, "Exception in RemoteMutableStore: " + e3);
                RemoteMutableStore.this.remoteLogger.log(Level.FINE, "Exception in RemoteMutableStore: ", e3);
            }
        }
    }

    public class TreeEntry {
        public String[] entryNames = null;
        public String[] entryTypes = null;
    }
}

