/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.remote.RemoteConnectionException;
import hep.aida.ref.remote.RemoteServant;
import hep.aida.ref.remote.RemoteUpdatableQueue;
import hep.aida.ref.remote.RemoteUpdateEvent;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaTreeServer;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RemoteClient
implements AidaTreeClient,
Runnable {
    protected AidaTreeServer server;
    protected AidaTreeServant servant;
    protected IDevMutableStore store;
    protected RemoteUpdatableQueue queue;
    protected boolean duplex;
    protected boolean blocking = false;
    protected boolean isConnected;
    protected long updateInterval;
    protected boolean keepUpdating;
    protected String clientID;
    protected int connectionExceptions = 0;
    protected Logger remoteLogger;
    private AidaTreeServer testServer;

    public RemoteClient(IDevMutableStore store) {
        this(store, true);
    }

    public RemoteClient(IDevMutableStore store, boolean duplex) {
        this.init();
        this.store = store;
        this.duplex = duplex;
        this.keepUpdating = !duplex;
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
    }

    RemoteClient(IDevMutableStore store, boolean duplex, AidaTreeServer server) {
        this.init();
        this.store = store;
        this.duplex = duplex;
        this.keepUpdating = !duplex;
        this.testServer = server;
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
    }

    protected void init() {
        this.server = null;
        this.servant = null;
        this.isConnected = false;
        this.blocking = false;
        this.updateInterval = 2000L;
        this.clientID = "AidaTreeClient";
    }

    public void setBlocking(boolean b) {
        this.blocking = b;
        if (this.servant instanceof RemoteServant) {
            ((RemoteServant)this.servant).setBlocking(this.blocking);
        }
        if (this.blocking && this.clientID.indexOf("blocking") < 0) {
            this.clientID = this.clientID + "_blocking";
        }
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    protected abstract AidaTreeServer getServer();

    public synchronized void setUpdateTime(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    public synchronized void setDuplex(boolean duplex) {
        if (this.isConnected) {
            this.remoteLogger.info("WARNING: Client is connected, can not change DUPLEX settings. Please disconnect first");
            return;
        }
        this.duplex = duplex;
        this.keepUpdating = !duplex;
    }

    protected void connectDuplex() throws RemoteConnectionException {
        this.servant = this.server.connectDuplex(this);
        if (this.servant == null) {
            throw new RemoteConnectionException("Can not retrieve non-Duplex AidaTreeServant from: " + this.server.treeName());
        }
        this.isConnected = true;
    }

    protected void connectNonDuplex() throws RemoteConnectionException {
        this.servant = this.server.connectNonDuplex(this.clientID);
        if (this.servant == null) {
            throw new RemoteConnectionException("Can not retrieve non-Duplex AidaTreeServant from: " + this.server.treeName());
        }
        if (this.servant instanceof RemoteServant) {
            ((RemoteServant)this.servant).setBlocking(this.blocking);
        }
        new Thread(this).start();
        this.isConnected = true;
    }

    public String[] listObjectNames(String path, boolean recursive) throws IllegalArgumentException {
        if (!this.isConnected) {
            this.remoteLogger.info("WARNING: Client is not connected.");
            return null;
        }
        String[] names = this.servant.listObjectNames(path, recursive);
        return names;
    }

    public String[] listObjectTypes(String path, boolean recursive) throws IllegalArgumentException {
        if (!this.isConnected) {
            this.remoteLogger.info("WARNING: Client is not connected.");
            return null;
        }
        String[] types = this.servant.listObjectTypes(path, recursive);
        return types;
    }

    public Object find(String path) throws IllegalArgumentException {
        this.remoteLogger.finest("RemoteClient.find: for path=" + path);
        if (!this.isConnected) {
            this.remoteLogger.info("WARNING: Client is not connected.");
            return null;
        }
        Object obj = this.servant.find(path);
        this.remoteLogger.finest("RemoteClient.find: AFTER find for path=" + path);
        if (this.servant != null) {
            this.servant.setValid(new String[]{path});
        }
        this.remoteLogger.finest("RemoteClient.find: for path=" + path + ", obj=" + obj);
        return obj;
    }

    public void stateChanged(AidaUpdateEvent[] events) {
        if (events != null && events.length > 0) {
            this.remoteLogger.finest("RemoteClient.stateChanged: #events=" + events.length);
            this.queue.schedule((Object)this.store, events);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean connect() throws RemoteConnectionException {
        if (this.isConnected) {
            String name = "null";
            if (this.server != null) {
                name = this.server.treeName();
            }
            this.remoteLogger.info("WARNING: Already connected to AidaTreeServer: " + name);
            return false;
        }
        this.queue = new RemoteUpdatableQueue();
        this.server = this.getServer();
        this.remoteLogger.fine("Connecting:  duplex=" + this.duplex);
        if (this.server == null) {
            throw new RemoteConnectionException("Can not get reference to AidaTreeServer.");
        }
        try {
            if (this.duplex) {
                boolean supportsDuplex = this.server.supportDuplexMode();
                if (!supportsDuplex) {
                    this.remoteLogger.info("Warning: AidaTreeServer \"" + this.server.treeName() + "\" does not support DUPLEX mode. \nWill try to connect using non-DUPLEX mode.");
                    this.duplex = false;
                    this.keepUpdating = !this.duplex;
                    this.connectNonDuplex();
                } else {
                    this.connectDuplex();
                }
            } else {
                this.connectNonDuplex();
            }
        }
        catch (RemoteConnectionException ae) {
            throw ae;
        }
        catch (Exception e) {
            String name = "null";
            if (this.server != null) {
                name = this.server.treeName();
            }
            throw new RemoteConnectionException("Can not connect to AidaTreeServer: " + name, e);
        }
        return true;
    }

    public boolean disconnect() {
        this.remoteLogger.finest("\nRemoteClient.disconnect: for Client=" + this.clientID + " ... ");
        this.keepUpdating = false;
        if (this.queue != null) {
            this.queue.close();
        }
        if (!this.isConnected) {
            this.server = null;
            this.servant = null;
            return true;
        }
        boolean status = true;
        this.keepUpdating = false;
        if (this.server != null) {
            try {
                status = this.duplex ? this.server.disconnectDuplex(this) : this.server.disconnectNonDuplex(this.clientID);
            }
            catch (Exception e) {
                this.remoteLogger.log(Level.FINE, "RemoteClient.disconnect Exception: ", e);
            }
        }
        this.server = null;
        this.servant = null;
        return status;
    }

    public void run() {
        while (this.keepUpdating) {
            AidaUpdateEvent[] events;
            try {
                if (this.isConnected) {
                    this.remoteLogger.finest("RemoteClient.updates");
                    events = this.servant.updates();
                    this.connectionExceptions = 0;
                    this.remoteLogger.finest("RemoteClient.updates BEFORE stateChanged");
                    if (this.keepUpdating && events != null && events.length > 0) {
                        this.stateChanged(events);
                    }
                    this.remoteLogger.finest("RemoteClient.updates AFTER stateChanged blocking=" + this.blocking);
                }
                if (!this.blocking) {
                    Thread.sleep(this.updateInterval);
                }
            }
            catch (InterruptedException ie) {
                this.remoteLogger.log(Level.INFO, "RemoteClient non-DUPLEX Update Thread InterruptedException. blocking=" + this.blocking, ie);
                this.remoteLogger.log(Level.FINE, "", ie.getStackTrace());
            }
            catch (Exception ex) {
                this.remoteLogger.log(Level.INFO, "RemoteClient non-DUPLEX Update Thread: Exception. blocking=" + this.blocking, ex);
                this.remoteLogger.log(Level.FINE, "", ex.getStackTrace());
                ++this.connectionExceptions;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie2) {
                    ie2.printStackTrace();
                }
            }
            if (this.connectionExceptions <= 6) continue;
            events = new AidaUpdateEvent[]{new RemoteUpdateEvent(101, "/", "dir")};
            this.stateChanged(events);
        }
        this.remoteLogger.fine("RemoteClient run: " + this.clientID + " ... Exiting");
    }

    public static void main(String[] args) {
    }
}

