/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IAnnotation;
import hep.aida.ref.event.ObserverAdapter;
import hep.aida.ref.remote.RemoteDataPointSet;
import jas.hist.ExtendedStatistics;
import jas.hist.HasStatistics;
import jas.hist.HistogramUpdate;
import jas.hist.Statistics;
import jas.hist.XYDataSource;
import java.util.Vector;

public class RemoteAIDADataPointSetAdapter
extends ObserverAdapter
implements XYDataSource,
HasStatistics {
    private int axisType = 1;
    private RemoteDataPointSet dpSet;
    private RemoteDataPointSetStatistics st;
    private int dimension;
    private double[] x;
    private double[] y;
    private double[] ep;
    private double[] em;
    private static final HistogramUpdate hr = new HistogramUpdate(14, false);

    public RemoteAIDADataPointSetAdapter(RemoteDataPointSet dps) {
        super(dps);
        this.dpSet = dps;
        this.st = new RemoteDataPointSetStatistics(this.dpSet);
        this.dimension = this.dpSet.dimension();
        try {
            String xType = dps.annotation().value("xAxisType");
            if (xType != null && xType.equalsIgnoreCase("date")) {
                this.axisType = 3;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.update = hr;
    }

    public void setAxisType(int type) {
        this.axisType = type;
    }

    public int getAxisType() {
        return this.axisType;
    }

    public double getMinusError(int i) {
        return this.dpSet.errorMinus(i);
    }

    public double getPlusError(int i) {
        return this.dpSet.errorPlus(i);
    }

    public double getX(int i) {
        double x = 0.0;
        x = this.dimension == 1 ? (double)i : this.dpSet.getX(i);
        return x;
    }

    public double getY(int i) {
        return this.dpSet.getY(i);
    }

    public int getNPoints() {
        this.setValid();
        return this.dpSet.size();
    }

    public Statistics getStatistics() {
        return this.st;
    }

    public String getTitle() {
        return this.dpSet.title();
    }

    static {
        hr.setAxis(RemoteAIDADataPointSetAdapter.hr.HORIZONTAL_AXIS);
        hr.setAxis(RemoteAIDADataPointSetAdapter.hr.VERTICAL_AXIS);
    }

    class RemoteDataPointSetStatistics
    implements ExtendedStatistics {
        private RemoteDataPointSet dps;
        private final String statName = "Entries";

        RemoteDataPointSetStatistics(RemoteDataPointSet dps) {
            this.dps = dps;
        }

        public double getStatistic(String str) {
            if (str.equals("Entries")) {
                return this.dps.size();
            }
            return 0.0;
        }

        public String[] getStatisticNames() {
            IAnnotation an = this.dps.annotation();
            if (an == null) {
                return new String[]{"Entries"};
            }
            int n = an.size();
            Vector<String> keys = new Vector<String>();
            keys.add("Entries");
            for (int i = 0; i < n; ++i) {
                try {
                    String key = an.key(i);
                    if (!key.toLowerCase().startsWith("stat.")) continue;
                    keys.add(key.substring(5));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            String[] tmp = new String[keys.size()];
            keys.toArray(tmp);
            return tmp;
        }

        public Object getExtendedStatistic(String name) {
            if (name.equals("Entries")) {
                return null;
            }
            IAnnotation an = this.dps.annotation();
            if (an == null) {
                return null;
            }
            String v = null;
            try {
                v = an.value("stat." + name);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            return v;
        }
    }
}

