/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import com.l2fprod.common.propertysheet.PropertySheetPanel;
import hep.aida.IBaseStyle;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.BaseStyle;
import hep.aida.ref.plotter.PlotterStyle;
import hep.aida.ref.plotter.style.editor.StylePropertyEditorRegistry;
import hep.aida.ref.plotter.style.editor.StylePropertyTable;
import hep.aida.ref.plotter.style.editor.StylePropertyTableModel;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class StyleTreeNode
implements TreeNode {
    private IBaseStyle style;
    private TreePath path;
    private PropertySheetPanel stylePanel;
    private Vector children;
    private int nChildren;
    private boolean recursive;
    private boolean hasBeenFilled = false;
    private StyleTreeNode parent;
    private TreePath parentPath;

    public StyleTreeNode(IPlotterStyle style) {
        this(style, true);
    }

    public StyleTreeNode(IPlotterStyle style, boolean recursive) {
        this(style, null, null, recursive);
    }

    public StyleTreeNode(IBaseStyle style, StyleTreeNode parent, TreePath parentPath) {
        this(style, parent, parentPath, true);
    }

    public StyleTreeNode(IBaseStyle style, StyleTreeNode parent, TreePath parentPath, boolean recursive) {
        this.style = style;
        this.parent = parent;
        this.parentPath = parentPath;
        String nodeName = null;
        try {
            if (style instanceof IPlotterStyle && ((BaseStyle)style).isParameterSet("plotterStyleName", false)) {
                nodeName = ((IPlotterStyle)style).parameterValue("plotterStyleName");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (nodeName == null || nodeName.trim().equals("")) {
            nodeName = style.name();
        }
        this.path = parentPath == null ? new TreePath(nodeName) : parentPath.pathByAddingChild(nodeName);
        this.createChildren();
        this.createPanel();
    }

    public String toString() {
        String nodeName = null;
        if (this.style != null) {
            nodeName = this.style.name();
        }
        if (this.path != null) {
            nodeName = this.path.getLastPathComponent().toString();
        }
        return nodeName;
    }

    public IBaseStyle getStyle() {
        return this.style;
    }

    public JComponent getStylePanel() {
        return this.stylePanel;
    }

    private void createChildren() {
        List list;
        IBaseStyle[] ch = this.style.children();
        if (ch == null || ch.length == 0) {
            this.nChildren = 0;
            this.children = new Vector();
            this.hasBeenFilled = true;
            return;
        }
        this.nChildren = ch.length;
        if (this.style instanceof PlotterStyle && (list = ((PlotterStyle)this.style).parentList()) != null) {
            this.nChildren += list.size();
        }
        if (this.recursive) {
            this.fillChildren();
        }
    }

    private void fillChildren() {
        List list;
        IBaseStyle[] ch;
        if (this.children == null) {
            this.children = new Vector();
        }
        if ((ch = this.style.children()) == null) {
            return;
        }
        for (int i = 0; i < ch.length; ++i) {
            StyleTreeNode childNode = new StyleTreeNode(ch[i], this, this.path, this.recursive);
            this.children.add(childNode);
        }
        if (this.style instanceof PlotterStyle && (list = ((PlotterStyle)this.style).parentList()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                if (!(obj instanceof IPlotterStyle)) continue;
                StyleTreeNode childNode = new StyleTreeNode((IPlotterStyle)obj, this, this.path, this.recursive);
                this.children.add(childNode);
            }
        }
        this.hasBeenFilled = true;
    }

    private void createPanel() {
        StylePropertyTable pt = new StylePropertyTable(new StylePropertyTableModel(this.style));
        pt.setEditorFactory(new StylePropertyEditorRegistry());
        this.stylePanel = new PropertySheetPanel(pt){

            public void propertyChange(PropertyChangeEvent evt) {
                super.propertyChange(evt);
            }
        };
        this.stylePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.path.toString()));
    }

    public Enumeration children() {
        if (!this.hasBeenFilled) {
            this.fillChildren();
        }
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return this.nChildren > 0;
    }

    public TreeNode getChildAt(int childIndex) {
        if (!this.hasBeenFilled) {
            this.fillChildren();
        }
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.nChildren;
    }

    public int getIndex(TreeNode node) {
        if (!this.hasBeenFilled) {
            this.fillChildren();
        }
        return this.children.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.nChildren == 0;
    }
}

