/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IHistogram2D;
import hep.aida.ref.plotter.adapter.AIDAHistogramAdapter;
import hep.aida.ref.plotter.adapter.AIDAHistogramStatistics2D;
import jas.hist.HasStatistics;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.Statistics;

public class AIDAHistogramAdapter2D
extends AIDAHistogramAdapter
implements Rebinnable2DHistogramData,
HasStatistics {
    protected IHistogram2D h2d;

    AIDAHistogramAdapter2D(IHistogram2D histo) {
        super(histo);
        this.h2d = histo;
        String tmp = null;
        try {
            tmp = this.h2d.annotation().value("xAxisType");
            if (tmp != null && tmp.equalsIgnoreCase("date")) {
                this.xAxisType = 3;
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            tmp = this.h2d.annotation().value("yAxisType");
            if (tmp != null && tmp.equalsIgnoreCase("date")) {
                this.xAxisType = 3;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public double[][][] rebin(int xbins, double xmin, double xmax, int ybins, double ymin, double ymax, boolean wantErrors, boolean hurry, boolean overflow) {
        double[][][] data = new double[2][this.h2d.xAxis().bins()][this.h2d.yAxis().bins()];
        for (int i = 0; i < this.h2d.xAxis().bins(); ++i) {
            for (int j = 0; j < this.h2d.yAxis().bins(); ++j) {
                data[0][i][j] = this.h2d.binHeight(i, j);
                if (Double.isInfinite(data[0][i][j])) {
                    data[0][i][j] = Double.NaN;
                }
                data[1][i][j] = this.h2d.binError(i, j);
            }
        }
        this.setValid();
        return data;
    }

    public double getXMin() {
        return this.h2d.xAxis().lowerEdge();
    }

    public double getXMax() {
        return this.h2d.xAxis().upperEdge();
    }

    public double getYMin() {
        return this.h2d.yAxis().lowerEdge();
    }

    public double getYMax() {
        return this.h2d.yAxis().upperEdge();
    }

    public int getXBins() {
        return this.h2d.xAxis().bins();
    }

    public int getYBins() {
        return this.h2d.yAxis().bins();
    }

    public boolean isRebinnable() {
        return false;
    }

    public int getXAxisType() {
        return this.xAxisType;
    }

    public int getYAxisType() {
        return this.yAxisType;
    }

    public void setXAxisType(int type) {
        this.xAxisType = type;
    }

    public void setYAxisType(int type) {
        this.yAxisType = type;
    }

    public String[] getXAxisLabels() {
        return null;
    }

    public String[] getYAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.h2d.title();
    }

    public Statistics getStatistics() {
        return new AIDAHistogramStatistics2D(this.h2d);
    }
}

