/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IBaseStyle;
import hep.aida.ref.plotter.AbstractStyleParameter;
import hep.aida.ref.plotter.BooleanStyleParameter;
import hep.aida.ref.plotter.RevolvingStyleParameter;
import hep.aida.ref.plotter.StringStyleParameter;
import hep.aida.ref.plotter.StyleListener;
import hep.aida.ref.plotter.WeakStyleListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class BaseStyle
extends WeakStyleListener
implements IBaseStyle {
    private Hashtable internalParameterHash = new Hashtable();
    private Hashtable parameterHash = new Hashtable();
    private Hashtable baseStyles = new Hashtable();
    private List parentList = new ArrayList();
    private String name = "plotter";

    protected BaseStyle() {
        this.initializeBaseStyle();
        this.addParameter(new BooleanStyleParameter("isVisible", true));
    }

    protected BaseStyle(BaseStyle style) {
        this();
        this.copyStyle(this, style);
        List pl = style.parentList();
        this.setParentList(pl);
    }

    private void copyStyle(BaseStyle newStyle, BaseStyle oldStyle) {
        Collection pars = oldStyle.parameters();
        Iterator iter = pars.iterator();
        while (iter.hasNext()) {
            AbstractStyleParameter oldPar = (AbstractStyleParameter)iter.next();
            String[] av = oldPar.allowedValues();
            if (!oldPar.isParameterValueSet()) {
                newStyle.setParameter(oldPar.name());
                continue;
            }
            newStyle.setParameter(oldPar.name(), oldPar.parameterValue(), av);
        }
        String[] names = newStyle.baseStyleNames();
        for (int i = 0; i < names.length; ++i) {
            this.copyStyle(newStyle.baseStyle(names[i]), oldStyle.baseStyle(names[i]));
        }
    }

    protected abstract void initializeBaseStyle();

    protected void setName(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Class type() {
        return this.getClass().getInterfaces()[0];
    }

    public IBaseStyle child(String name) {
        return (IBaseStyle)this.baseStyles.get(name);
    }

    public IBaseStyle[] children() {
        IBaseStyle[] children = new IBaseStyle[this.baseStyles.size()];
        Set keys = this.baseStyles.keySet();
        Iterator i = keys.iterator();
        int count = 0;
        while (i.hasNext()) {
            children[count++] = (IBaseStyle)this.baseStyles.get(i.next());
        }
        return children;
    }

    public boolean setVisible(boolean visible) {
        return this.setParameter("isVisible", String.valueOf(visible));
    }

    public boolean isVisible() {
        String isVisible = this.parameterValue("isVisible");
        return Boolean.valueOf(isVisible);
    }

    public void setParent(IBaseStyle style) {
        if (style == null) {
            return;
        }
        ArrayList<IBaseStyle> list = new ArrayList<IBaseStyle>(1);
        list.add(style);
        this.setParentList(list);
    }

    public void setParentList(List list) {
        if (this.parentList != null && this.parentList.size() > 0) {
            int size = this.parentList.size();
            Object[] tmpArray = this.parentList.toArray();
            for (int i = 0; i < size; ++i) {
                Object obj = tmpArray[i];
                if (!(obj instanceof IBaseStyle)) continue;
                this.removeParent((IBaseStyle)obj, false);
            }
            this.parentList.clear();
        }
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof IBaseStyle)) continue;
            this.addParent((IBaseStyle)obj, false);
        }
        this.notifyStyleChanged();
    }

    public void removeAllParents() {
        this.setParentList(null);
    }

    public void removeParent(IBaseStyle style) {
        this.removeParent(style, true);
    }

    void removeParent(IBaseStyle style, boolean sendNotification) {
        if (style instanceof BaseStyle) {
            ((BaseStyle)style).removeStyleListener(this);
        }
        if (!this.isMyParent(style)) {
            return;
        }
        this.parentList.remove(style);
        IBaseStyle[] parentChildren = style.children();
        for (int i = 0; i < parentChildren.length; ++i) {
            String name = parentChildren[i].name();
            BaseStyle localChild = this.baseStyle(name);
            if (localChild == null) continue;
            localChild.removeParent(parentChildren[i]);
        }
        if (sendNotification) {
            this.notifyStyleChanged();
        }
    }

    public void addParent(IBaseStyle style) {
        this.addParent(style, true);
    }

    void addParent(IBaseStyle style, boolean sendNotification) {
        if (this.isMyParent(style)) {
            return;
        }
        if (style == this) {
            System.out.println("***** SELF-Parent :: skip :: " + style.name());
            return;
        }
        if (this.parentList == null) {
            this.parentList = new ArrayList();
        }
        this.parentList.add(style);
        if (style instanceof BaseStyle) {
            ((BaseStyle)style).addStyleListener(this);
        }
        IBaseStyle[] parentChildren = style.children();
        for (int i = 0; i < parentChildren.length; ++i) {
            String name = parentChildren[i].name();
            BaseStyle localChild = this.baseStyle(name);
            if (localChild == null) continue;
            localChild.addParent(parentChildren[i]);
        }
        if (sendNotification) {
            this.notifyStyleChanged();
        }
    }

    public void addParentList(List pl) {
        if (pl == null || pl.size() == 0) {
            return;
        }
        if (this.parentList == null) {
            this.parentList = new ArrayList();
        }
        for (int i = 0; i < pl.size(); ++i) {
            Object obj = pl.get(i);
            if (!(obj instanceof IBaseStyle)) continue;
            this.addParent((IBaseStyle)obj, false);
        }
        this.notifyStyleChanged();
    }

    public boolean isMyParent(IBaseStyle style) {
        if (style == null || this.parentList == null || this.parentList.size() == 0) {
            return false;
        }
        return this.parentList.contains(style);
    }

    public List parentList() {
        return this.parentList;
    }

    protected boolean addBaseStyle(IBaseStyle baseStyle, String name) {
        BaseStyle bs = (BaseStyle)baseStyle;
        bs.setName(name);
        if (this.baseStyles.get(bs.name()) != null) {
            ((BaseStyle)this.baseStyles.get(bs.name())).removeStyleListener(this);
        }
        this.baseStyles.put(bs.name(), baseStyle);
        bs.addStyleListener(this);
        this.notifyStyleChanged();
        return true;
    }

    private BaseStyle baseStyle(String name) {
        return (BaseStyle)this.child(name);
    }

    private String[] baseStyleNames() {
        String[] names = new String[this.baseStyles.size()];
        Enumeration e = this.baseStyles.keys();
        int count = 0;
        while (e.hasMoreElements()) {
            names[count++] = (String)e.nextElement();
        }
        return names;
    }

    protected void addParameter(AbstractStyleParameter styleParameter) {
        this.addParameter(styleParameter, true);
    }

    private void addParameter(AbstractStyleParameter styleParameter, boolean isInternal) {
        String name = styleParameter.name();
        if (this.isRegisteredParameter(name)) {
            throw new IllegalArgumentException("Parameter " + styleParameter.name() + " already belongs to this style.");
        }
        if (isInternal) {
            this.internalParameterHash.put(name, styleParameter);
        }
        this.parameterHash.put(name, styleParameter);
    }

    private boolean isInternalParameter(String parameterName) {
        return this.internalParameterHash.containsKey(parameterName);
    }

    private boolean isExternalParameter(String parameterName) {
        return !this.internalParameterHash.containsKey(parameterName) && this.parameterHash.containsKey(parameterName);
    }

    private boolean isRegisteredParameter(String parameterName) {
        return this.parameterHash.containsKey(parameterName);
    }

    public AbstractStyleParameter parameter(String parName) {
        if (!this.isRegisteredParameter(parName)) {
            throw new IllegalArgumentException("Parameter with name " + parName + " does not belong to this style.");
        }
        return (AbstractStyleParameter)this.parameterHash.get(parName);
    }

    public AbstractStyleParameter deepestSetParameter(String parameterName) {
        if (this.parameter(parameterName).isParameterValueSet() || this.parentList == null || this.parentList.size() == 0) {
            return this.parameter(parameterName);
        }
        Iterator it = this.parentList().iterator();
        BaseStyle pbs = null;
        while (it.hasNext()) {
            pbs = (BaseStyle)it.next();
            if (pbs == null || !pbs.isParameterSet(parameterName)) continue;
            return pbs.deepestSetParameter(parameterName);
        }
        return pbs == null ? this.parameter(parameterName) : pbs.parameter(parameterName);
    }

    protected int numberOfParameters() {
        return this.parameterHash.size();
    }

    protected Collection parameters() {
        return this.parameterHash.values();
    }

    public boolean isParameterSet(String parameterName) {
        return this.isParameterSet(parameterName, true);
    }

    public boolean isParameterSet(String parameterName, boolean recursive) {
        if (this.parameter(parameterName).isParameterValueSet() || !recursive || this.parentList == null || this.parentList.size() == 0) {
            return this.parameter(parameterName).isParameterValueSet();
        }
        boolean isSet = false;
        Iterator it = this.parentList().iterator();
        while (it.hasNext()) {
            BaseStyle pbs = (BaseStyle)it.next();
            if (pbs == null || !pbs.isParameterSet(parameterName, recursive)) continue;
            isSet = true;
            break;
        }
        return isSet;
    }

    public String[] availableParameterOptions(String parameterName) {
        AbstractStyleParameter par = this.parameter(parameterName);
        return par.allowedValues();
    }

    public String[] availableParameters() {
        int size = this.numberOfParameters();
        String[] pars = new String[size];
        Collection parameters = this.parameters();
        Iterator iter = parameters.iterator();
        int count = 0;
        while (iter.hasNext()) {
            pars[count++] = ((AbstractStyleParameter)iter.next()).name();
        }
        return pars;
    }

    public String parameterValue(String parameterName) {
        AbstractStyleParameter par = this.deepestSetParameter(parameterName);
        return par.parameterValue();
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean sendNotification) {
        this.removeAllParents();
        Enumeration parKeys = this.parameterHash.keys();
        while (parKeys.hasMoreElements()) {
            this.parameter((String)parKeys.nextElement()).reset();
        }
        Enumeration keys = this.baseStyles.keys();
        while (keys.hasMoreElements()) {
            this.baseStyle((String)keys.nextElement()).reset(false);
        }
        if (sendNotification) {
            this.notifyStyleChanged();
        }
    }

    public boolean setParameter(String parameterName) {
        boolean result = false;
        if (this.isRegisteredParameter(parameterName)) {
            result = this.parameter(parameterName).setParameter();
            if (!this.isInternalParameter(parameterName)) {
                result = false;
            }
        } else {
            StringStyleParameter styleParameter = new StringStyleParameter(parameterName, null);
            this.addParameter(styleParameter, false);
        }
        this.notifyStyleChanged();
        return result;
    }

    public boolean setParameter(String parameterName, String parValue) {
        String[] oldAv;
        String[] av = null;
        if (this.isRegisteredParameter(parameterName) && this.parameter(parameterName) instanceof RevolvingStyleParameter && ((oldAv = this.parameter(parameterName).allowedValues()) == null || oldAv.length == 0)) {
            av = new String[]{parValue};
        }
        return this.setParameter(parameterName, parValue, av);
    }

    public boolean setParameter(String parameterName, String parValue, String[] parAllowedValues) {
        boolean result = false;
        if (this.isRegisteredParameter(parameterName)) {
            if (parAllowedValues != null) {
                this.parameter(parameterName).setAllowedValues(parAllowedValues);
            }
            result = this.parameter(parameterName).setParameter(parValue);
            if (!this.isInternalParameter(parameterName)) {
                result = false;
            }
        } else {
            StringStyleParameter styleParameter = new StringStyleParameter(parameterName, null);
            this.addParameter(styleParameter, false);
            if (parAllowedValues != null) {
                styleParameter.setAllowedValues(parAllowedValues);
            }
            styleParameter.setValue(parValue);
        }
        this.notifyStyleChanged();
        return result;
    }

    public void setParameterDefault(String parameterName, String parDefaultValue) {
        if (!this.isRegisteredParameter(parameterName)) {
            throw new IllegalArgumentException("Parameter " + parameterName + " does not exist ");
        }
        this.parameter(parameterName).setDefaultValue(parDefaultValue);
        this.notifyStyleChanged();
    }

    public void styleChanged(BaseStyle style) {
        this.notifyStyleChanged();
    }

    void notifyStyleChanged() {
        StyleListener[] tmp = this.getValidStyleListeners();
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i].styleChanged(this);
        }
    }
}

