/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.ui;

import java.awt.Color;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class Prompt
extends JPanel
implements ComponentListener {
    private static final String l1 = "&gt;&gt;&gt; ";
    private static final String ln = "<br>... ";
    private JTextPane txtCmd;
    private JLabel label;

    public Prompt(JTextPane txtCmd) {
        this.setOpaque(true);
        this.label = new JLabel();
        this.label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.showNLines(1);
        this.txtCmd = txtCmd;
        txtCmd.addComponentListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.label);
        this.add(Box.createVerticalGlue());
    }

    public void showNLines(int nbLines) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append(l1);
        while (nbLines-- > 1) {
            buffer.append(ln);
        }
        buffer.append("</html>");
        this.label.setText(buffer.toString());
    }

    public void setColor(Color fg, Color bg) {
        this.setBackground(bg);
        this.label.setForeground(fg);
    }

    public void updateLineView() {
        LineNumberReader lnr = new LineNumberReader(new StringReader(this.txtCmd.getText()));
        try {
            while (lnr.readLine() != null) {
            }
            this.showNLines(lnr.getLineNumber() + 1);
            lnr.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.updateLineView();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.updateLineView();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateLineView();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.updateLineView();
    }
}

