/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.ui;

import com.artenum.gui.tk.ToolBox;
import com.artenum.jyconsole.JyConsole;
import com.artenum.jyconsole.io.InteractiveCommandLine;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CompletionWindow
extends JWindow
implements KeyListener,
ListSelectionListener,
MouseMotionListener,
MouseListener,
FocusListener {
    private JList list;
    private MethodeModel model;
    private JyConsole console;
    private JScrollPane scroll;
    private InteractiveCommandLine cmdOrigine;
    private int maxHeight = -1;
    private JPanel resize;
    private Dimension size;

    public CompletionWindow(JyConsole console) {
        super(ToolBox.getParentFrame(console));
        this.console = console;
        this.resize = new JPanel();
        this.resize.setMinimumSize(new Dimension(10, 10));
        this.resize.addMouseMotionListener(this);
        this.resize.addMouseListener(this);
        this.model = new MethodeModel();
        this.list = new JList(this.model);
        this.list.addFocusListener(this);
        this.list.addListSelectionListener(this);
        this.scroll = new JScrollPane(this.list, 22, 32);
        this.scroll.setCorner("LOWER_RIGHT_CORNER", this.resize);
        this.getContentPane().add(this.scroll);
        this.setSize(300, 100);
        this.list.addKeyListener(this);
        this.list.getInputMap().clear();
        this.scroll.getInputMap().clear();
        this.maxHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        this.cmdOrigine = console.getInteractiveCommandLine();
    }

    public MethodeModel getModel() {
        return this.model;
    }

    public void showWindow() {
        Point p = this.console.getCompletionWindowLocation();
        if ((double)(p.y + this.getHeight()) > Toolkit.getDefaultToolkit().getScreenSize().getHeight()) {
            p.y = (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - (double)this.getHeight());
        }
        this.setLocation(p);
        this.setVisible(true);
        if (System.getProperty("os.name").toLowerCase().indexOf("linux") == -1) {
            this.showOnWindows();
        } else if (System.getProperty("java.vm.version").startsWith("1.4")) {
            this.showOnLinux();
        } else {
            this.showOnLinux15();
        }
    }

    private void showOnWindows() {
        if (this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        } else {
            this.list.grabFocus();
        }
    }

    private void showOnLinux15() {
        if (this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
        this.list.grabFocus();
    }

    private void showOnLinux() {
        int i = 0;
        while (i < 3) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!CompletionWindow.this.list.hasFocus() || !CompletionWindow.this.hasFocus()) {
                        CompletionWindow.this.setVisible(true);
                        CompletionWindow.this.requestFocus();
                        CompletionWindow.this.list.grabFocus();
                        if (CompletionWindow.this.list.getModel().getSize() > 0) {
                            CompletionWindow.this.list.setSelectedIndex(0);
                        }
                    }
                }
            });
            ++i;
        }
    }

    private void selectMethodeWhichStartWith(String start) {
        this.model.setFilter(start);
        this.list.setSelectedIndex(0);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            String selectedMethode = (String)this.list.getSelectedValue();
            if (this.cmdOrigine.askForDictionnary()) {
                if (this.cmdOrigine.getCompletionCmd().equals(this.cmdOrigine.getFilterCmd())) {
                    this.cmdOrigine.setCompletionCmd(selectedMethode);
                } else {
                    this.cmdOrigine.setFilteredCmd(selectedMethode);
                }
            } else if (selectedMethode != null && selectedMethode.toLowerCase().startsWith(this.cmdOrigine.getFilterCmd().toLowerCase()) && !selectedMethode.equals(this.cmdOrigine.getFilterCmd())) {
                if (selectedMethode.indexOf("(") == -1 || selectedMethode.endsWith("()")) {
                    this.cmdOrigine.setFilteredCmd(selectedMethode);
                } else {
                    this.cmdOrigine.setFilteredCmd(selectedMethode.substring(0, selectedMethode.lastIndexOf("(") + 1));
                }
            }
            this.setVisible(false);
            this.cmdOrigine.getFocus();
        } else if (e.getKeyCode() != 32) {
            if (e.getKeyCode() == 27) {
                this.setVisible(false);
                this.cmdOrigine.getFocus();
            } else if (e.getKeyCode() == 40) {
                if (this.model.getSize() > 0) {
                    this.list.setSelectedIndex(this.list.getSelectedIndex() % this.model.getSize());
                }
            } else if (e.getKeyCode() == 38) {
                if (this.model.getSize() > 0) {
                    this.list.setSelectedIndex((this.model.getSize() + this.list.getSelectedIndex()) % this.model.getSize());
                }
            } else if (e.getKeyCode() == 8) {
                if (this.cmdOrigine.getFilterCmd().length() > 0) {
                    this.cmdOrigine.backSpace();
                    this.selectMethodeWhichStartWith(this.cmdOrigine.getFilterCmd());
                } else {
                    this.setVisible(false);
                    this.cmdOrigine.getFocus();
                }
            } else if (e.getKeyChar() != '\uffff') {
                this.cmdOrigine.append("" + e.getKeyChar());
                this.selectMethodeWhichStartWith(this.cmdOrigine.getFilterCmd());
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.resize((int)(this.size.getWidth() + (double)e.getX()), (int)(this.size.getHeight() + (double)e.getY()));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.validate();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.size = this.getSize();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setVisible(false);
    }

    public class MethodeModel
    extends AbstractListModel {
        private ArrayList data = new ArrayList();
        private ArrayList filteredData = new ArrayList();
        private String filter;

        @Override
        public Object getElementAt(int index) {
            return this.filter != null ? this.filteredData.get(index) : this.data.get(index);
        }

        @Override
        public int getSize() {
            return this.filter != null ? this.filteredData.size() : this.data.size();
        }

        public void setFilter(String filter) {
            if (filter == null || filter != null && filter.length() == 0) {
                this.filter = null;
            } else {
                this.filter = filter;
                this.filteredData.clear();
                for (String currentLine : this.data) {
                    if (!currentLine.toLowerCase().startsWith(filter.toLowerCase())) continue;
                    this.filteredData.add(currentLine);
                }
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void updateData(Collection list) {
            Object[] sort = list.toArray();
            Arrays.sort(sort);
            this.data.clear();
            int i = 0;
            while (i < sort.length) {
                this.data.add(sort[i].toString());
                ++i;
            }
            this.setFilter(null);
        }

        public void updateData(Method[] methodList) {
            this.data.clear();
            int i = 0;
            while (i < methodList.length) {
                StringBuffer buffer = new StringBuffer(methodList[i].getName());
                buffer.append("( ");
                int j = 0;
                while (j < methodList[i].getParameterTypes().length) {
                    buffer.append(" ");
                    buffer.append(methodList[i].getParameterTypes()[j].getName());
                    buffer.append(" ,");
                    ++j;
                }
                this.data.add(String.valueOf(buffer.substring(0, buffer.length() - 1)) + ")");
                ++i;
            }
            Object[] sort = this.data.toArray();
            Arrays.sort(sort);
            this.data.clear();
            int i2 = 0;
            while (i2 < sort.length) {
                this.data.add(sort[i2]);
                ++i2;
            }
            this.setFilter(null);
        }
    }
}

